/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SetAttributeSchemaChoiceValues
extends SchemaCommand {
    private static final String ARGUMENT_ADD = "add";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeName = this.getStringOptionValue("attributename");
        String datafile = this.getStringOptionValue("datafile");
        List choiceValues = rc.getOption("choicevalues");
        boolean toAdd = this.isOptionSet(ARGUMENT_ADD);
        if (datafile == null && choiceValues == null) {
            throw new CLIException(this.getResourceString("missing-choicevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, choiceValues);
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeName};
        if (toAdd) {
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_ATTRIBUTE_SCHEMA_CHOICE_VALUES", params);
        } else {
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_ATTRIBUTE_SCHEMA_CHOICE_VALUES", params);
        }
        try {
            AttributeSchema attrSchema = ss.getAttributeSchema(attributeName);
            if (attrSchema == null) {
                String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, "attribute schema does not exist"};
                this.attributeSchemaNoExist(attributeName, toAdd ? "FAILED_ADD_ATTRIBUTE_SCHEMA_CHOICE_VALUES" : "FAILED_SET_ATTRIBUTE_SCHEMA_CHOICE_VALUES", args);
            }
            if (toAdd) {
                this.addChoiceValues(attrSchema, attributeValues);
                this.writeLog(0, Level.INFO, "SUCCEED_ADD_ATTRIBUTE_SCHEMA_CHOICE_VALUES", params);
            } else {
                this.setChoiceValues(attrSchema, attributeValues);
                this.writeLog(0, Level.INFO, "SUCCEED_SET_ATTRIBUTE_SCHEMA_CHOICE_VALUES", params);
            }
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-set-choice-value-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("SetAttributeSchemaChoiceValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, toAdd ? "FAILED_ADD_ATTRIBUTE_SCHEMA_CHOICE_VALUES" : "FAILED_SET_ATTRIBUTE_SCHEMA_CHOICE_VALUES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("SetAttributeSchemaChoiceValues.handleRequest", e);
            this.writeLog(1, Level.INFO, toAdd ? "FAILED_ADD_ATTRIBUTE_SCHEMA_CHOICE_VALUES" : "FAILED_SET_ATTRIBUTE_SCHEMA_CHOICE_VALUES", args);
            throw new CLIException(e, 127);
        }
    }

    private void addChoiceValues(AttributeSchema attrSchema, Map i18nKeyToValues) throws CLIException, SMSException, SSOException {
        for (String i18nKey : i18nKeyToValues.keySet()) {
            String value = (String)((Set)i18nKeyToValues.get(i18nKey)).iterator().next();
            attrSchema.addChoiceValue(value, i18nKey);
        }
    }

    private void setChoiceValues(AttributeSchema attrSchema, Map i18nKeyToValues) throws CLIException, SMSException, SSOException {
        for (String i18nKey : i18nKeyToValues.keySet()) {
            String value = (String)((Set)i18nKeyToValues.get(i18nKey)).iterator().next();
            attrSchema.removeChoiceValue(value);
            attrSchema.addChoiceValue(value, i18nKey);
        }
    }
}

