/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetServiceSchemaPropertiesViewBeanURL
extends SchemaCommand {
    static final String ARGUMENT_URL = "url";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String url = this.getStringOptionValue(ARGUMENT_URL);
        ServiceSchemaManager ssm = this.getServiceSchemaManager();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, url};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_SERVICE_SCHEMA_PROPERTIES_VIEW_BEAN_URL", params);
            ssm.setPropertiesViewBeanURL(url);
            this.writeLog(0, Level.INFO, "SUCCEED_SET_SERVICE_SCHEMA_PROPERTIES_VIEW_BEAN_URL", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("service-schema-set-properties-view-bean-url-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, url, e.getMessage()};
            this.debugError("SetServiceSchemaPropertiesViewBeanURL.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_SCHEMA_PROPERTIES_VIEW_BEAN_URL", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, url, e.getMessage()};
            this.debugError("SetServiceSchemaPropertiesViewBeanURL.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVICE_SCHEMA_PROPERTIES_VIEW_BEAN_URL", args);
            throw new CLIException(e, 127);
        }
    }
}

