/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config;

import com.sun.identity.config.Configurator;
import com.sun.identity.config.pojos.AgentType;
import com.sun.identity.config.pojos.AuthenticationStore;
import com.sun.identity.config.pojos.CircleTrust;
import com.sun.identity.config.pojos.FederalProtocol;
import com.sun.identity.config.pojos.IdentityProvider;
import com.sun.identity.config.pojos.LDAPStore;
import com.sun.identity.config.pojos.Realm;
import com.sun.identity.config.pojos.RealmRole;
import com.sun.identity.config.pojos.RealmUser;
import com.sun.identity.config.pojos.ServiceProvider;
import com.sun.identity.config.pojos.UrlPattern;
import com.sun.identity.config.pojos.condition.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.click.Page;

public class DummyConfigurator
implements Configurator {
    private static final List agentGroups = new ArrayList();
    private static final List agentProfiles = new ArrayList();
    private static final List urlPatterns = new ArrayList();
    private static final List conditions = new ArrayList();
    private static final List circlesOfTrust = new ArrayList();
    private static final Map serviceProviders = new HashMap();
    private static final Map identityProviders = new HashMap();
    public static final String PASSWORD_SET_KEY = "passwordSet";
    private Page page = null;

    public DummyConfigurator(Page page) {
        this.page = page;
    }

    public boolean isNewInstall() {
        return this.page.getContext().getRequest().getParameter("upgrade") == null;
    }

    public boolean isPasswordUpdateRequired() {
        return this.page.getContext().getSessionAttribute(PASSWORD_SET_KEY) == null;
    }

    public void setPassword(String username, String password) {
        this.page.getContext().setSessionAttribute(PASSWORD_SET_KEY, (Object)"true");
    }

    public void testHost(LDAPStore store) {
    }

    public void testBaseDN(LDAPStore store) {
    }

    public void testLoginId(LDAPStore store) {
    }

    public void testLoadBalancer(String host, int port) {
    }

    public void writeConfiguration() {
    }

    public void writeConfiguration(String newInstanceUrl, LDAPStore configStor, LDAPStore userStore, String loadBalancerHost, int loadBalancerPort) {
    }

    public List getExistingConfigurations() {
        ArrayList<String> existing = new ArrayList<String>(3);
        existing.add("http://fam.company.com:8080/fam/");
        existing.add("http://fam.sun.com:8080/fam/");
        existing.add("http://some.other.server.com:8080/opensso/");
        return existing;
    }

    public void writeConfiguration(List configStringUrls) {
    }

    public void testNewInstanceUrl(String url) {
    }

    public void pushConfiguration(String instanceUrl) {
    }

    public void upgrade() {
    }

    public void coexist() {
    }

    public void olderUpgrade() {
    }

    public List getRealms() {
        ArrayList<Realm> realms = new ArrayList<Realm>();
        for (int i = 0; i < 8; ++i) {
            Realm realm = new Realm();
            realm.setName("Realm_" + (i + 1));
            realms.add(realm);
        }
        return realms;
    }

    public Realm getRealm(String name) {
        Realm realm = null;
        if (!name.equals("Jeff realm")) {
            realm = new Realm();
            realm.setName("Realm_1");
        }
        return realm;
    }

    public List getUsers(Realm realm, String filter) {
        ArrayList<RealmUser> users = new ArrayList<RealmUser>();
        int maxUsers = filter.equals("*") ? 503 : 7;
        for (int i = 0; i < maxUsers; ++i) {
            RealmUser realmUser = new RealmUser();
            realmUser.setFirstName("FirstName" + (i + 1));
            realmUser.setLastName("LastName" + (i + 1));
            users.add(realmUser);
        }
        return users;
    }

    public List getAdministrators(Realm realm, RealmRole role) {
        ArrayList<RealmUser> realmAdmins = new ArrayList<RealmUser>();
        for (int i = 0; i < 5; ++i) {
            RealmUser realmUser = new RealmUser();
            realmUser.setFirstName("FirstName" + (i + 1));
            realmUser.setLastName("LastName" + (i + 1));
            realmUser.setRealmRole(new RealmRole());
            realmAdmins.add(realmUser);
        }
        return realmAdmins;
    }

    public void assignAdministrators(Realm realm, List administrators) {
    }

    public void removeAdministrators(Realm realm, List administrators) {
    }

    public void addAuthenticationStore(AuthenticationStore authenticationStore) {
        this.page.getContext().setSessionAttribute("AuthenticationStore", (Object)authenticationStore);
    }

    public List getAgentGroups() {
        return agentGroups;
    }

    public void deleteAgentGroup(String group) {
        agentGroups.remove(group);
    }

    public void createAgentGroup(String group) {
        if (!agentGroups.contains(group)) {
            agentGroups.add(group);
        }
    }

    public List getAgentProfiles() {
        return agentProfiles;
    }

    public void deleteAgentProfile(String profile) {
        agentProfiles.remove(profile);
    }

    public void createAgentProfile(String profile) {
        if (!agentProfiles.contains(profile)) {
            agentProfiles.add(profile);
        }
    }

    public void createRole(RealmRole realmRole) {
        this.page.getContext().setSessionAttribute("RealmRole", (Object)realmRole);
    }

    public List getRoles() {
        ArrayList<RealmRole> result = new ArrayList<RealmRole>();
        for (int i = 0; i < 5; ++i) {
            RealmRole realmRole = new RealmRole();
            realmRole.setName("Role_" + (i + 1));
            result.add(realmRole);
        }
        return result;
    }

    public List getAgentTypes() {
        ArrayList<AgentType> agentTypes = new ArrayList<AgentType>();
        AgentType agentType = new AgentType();
        agentType.setId(new Integer(1));
        agentType.setName("Local File");
        agentTypes.add(agentType);
        agentType = new AgentType();
        agentType.setId(new Integer(2));
        agentType.setName("FAM Server");
        agentTypes.add(agentType);
        return agentTypes;
    }

    public boolean checkFAMServerURL(String url) {
        return url != null;
    }

    public boolean checkCredentials(String profileName, String profilePassword) {
        return profileName != null && profilePassword != null;
    }

    public List getUrlPatterns() {
        return urlPatterns;
    }

    public void removeUrlPattern(UrlPattern urlPattern) {
        for (UrlPattern up : urlPatterns) {
            if (!urlPattern.equals(up)) continue;
            urlPatterns.remove(urlPattern);
            break;
        }
    }

    public void removeUrlPatterns(UrlPattern[] urlPatterns) {
        for (int idx = 0; idx < urlPatterns.length; ++idx) {
            this.removeUrlPattern(urlPatterns[idx]);
        }
    }

    public void addUrlPattern(UrlPattern urlPattern) {
        urlPattern.setId(new Integer(urlPatterns.size() + 1));
        urlPatterns.add(urlPattern);
    }

    public List getExistentConditions() {
        return conditions;
    }

    public void removeCondition(Condition condition) {
        for (Condition c : conditions) {
            if (!condition.equals(c)) continue;
            conditions.remove(condition);
            break;
        }
    }

    public void removeConditions(Condition[] conditions) {
        for (int idx = 0; idx < conditions.length; ++idx) {
            this.removeCondition(conditions[idx]);
        }
    }

    public void addCondition(Condition condition) {
        condition.setId(new Integer(conditions.size() + 1));
        conditions.add(condition);
    }

    public List getFederalProtocols() {
        ArrayList<FederalProtocol> result = new ArrayList<FederalProtocol>();
        result.add(new FederalProtocol("SAML 1.0"));
        result.add(new FederalProtocol("SAML 1.1"));
        result.add(new FederalProtocol("SAML 2.0"));
        result.add(new FederalProtocol("ID-FF"));
        result.add(new FederalProtocol("WSFederation"));
        return result;
    }

    public List getCirclesOfTrust() {
        if (circlesOfTrust.isEmpty()) {
            circlesOfTrust.add(new CircleTrust("sun > us", this.getRealm("cot1")));
            circlesOfTrust.add(new CircleTrust("sun > uk", this.getRealm("cot2")));
            circlesOfTrust.add(new CircleTrust("sun > asia", this.getRealm("cot3")));
        }
        return circlesOfTrust;
    }

    public void createServiceProvider(ServiceProvider serviceProvider) {
        int serviceProviderId = (int)Math.random() * 100;
        serviceProvider.setServiceProviderId(serviceProviderId);
        serviceProviders.put(new Integer(serviceProviderId), serviceProvider);
    }

    public void createServiceProvider(IdentityProvider identityProvider, ServiceProvider serviceProvider) {
        identityProvider.setRemoteServiceProvider(serviceProvider);
    }

    public ServiceProvider getServiceProvider(int serviceProviderId) {
        return (ServiceProvider)serviceProviders.get(new Integer(serviceProviderId));
    }

    public void createCircleOfTrust(CircleTrust circleTrust) {
        List circlesOfTrust = this.getCirclesOfTrust();
        circlesOfTrust.add(circleTrust);
    }

    public void deleteCircleOfTrust(String circleName) {
        CircleTrust circleTrust = this.getCircleOfTrust(circleName);
        if (circleTrust != null) {
            this.getCirclesOfTrust().remove(circleTrust);
        }
    }

    public CircleTrust getCircleOfTrust(String circleName) {
        CircleTrust circleTrust = null;
        boolean found = false;
        List circlesOfTrust = this.getCirclesOfTrust();
        for (int i = 0; i < circlesOfTrust.size() && !(found = (circleTrust = (CircleTrust)circlesOfTrust.get(i)).getName().equals(circleName)); ++i) {
        }
        if (!found) {
            circleTrust = null;
        }
        return circleTrust;
    }

    public FederalProtocol getFederalProtocol(String protocolName) {
        return new FederalProtocol(protocolName);
    }

    public void createIdentityProvider(ServiceProvider serviceProvider, IdentityProvider identityProvider) {
        ServiceProvider storedServiceProvider = this.getServiceProvider(serviceProvider.getServiceProviderId());
        storedServiceProvider.setRemoteIdentityProvider(identityProvider);
    }

    public void createIdentityProvider(IdentityProvider identityProvider) {
        int providerId = (int)Math.random() * 100;
        identityProvider.setIdentityProviderId(providerId);
        identityProviders.put(new Integer(providerId), identityProvider);
    }

    public IdentityProvider getIdentityProvider(int providerId) {
        return (IdentityProvider)identityProviders.get(new Integer(providerId));
    }

    public boolean validateHostName(String hostName) {
        return hostName.equals("hostname");
    }

    public boolean resolveHostName(String hostName) {
        return this.validateHostName(hostName);
    }

    static {
        UrlPattern pattern = new UrlPattern();
        pattern.setId(new Integer(1));
        pattern.setPattern("http://someoneserver.com/admin");
        urlPatterns.add(pattern);
        pattern = new UrlPattern();
        pattern.setId(new Integer(2));
        pattern.setPattern("http://someoneserver.com/HR");
        urlPatterns.add(pattern);
        Condition condition = new Condition();
        condition.setId(new Integer(1));
        condition.setName("some condition");
        conditions.add(condition);
        condition = new Condition();
        condition.setId(new Integer(2));
        condition.setName("another condition");
        conditions.add(condition);
    }
}

