/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.util;

import com.sun.identity.config.Configurator;
import com.sun.identity.config.DummyConfigurator;
import com.sun.identity.config.SessionAttributeNames;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.click.Page;
import net.sf.click.control.ActionLink;

public abstract class AjaxPage
extends Page {
    public ActionLink checkPasswordsLink = new ActionLink("checkPasswords", (Object)this, "checkPasswords");
    public ActionLink validateInputLink = new ActionLink("validateInput", (Object)this, "validateInput");
    public ActionLink resetSessionAttributesLink = new ActionLink("resetSessionAttributes", (Object)this, "resetSessionAttributes");
    public static final String RESPONSE_TEMPLATE = "{\"valid\":\"${valid}\", \"body\":\"${body}\"}";
    public static final String OLD_RESPONSE_TEMPLATE = "{\"isValid\":${isValid}, \"errorMessage\":\"${errorMessage}\"}";
    private Configurator configurator = null;
    private static int MIN_PASSWORD_SIZE = 8;
    private boolean rendering = false;
    private String hostName;
    protected java.util.Locale configLocale = null;
    protected ResourceBundle rb = null;
    protected static final String RB_NAME = "amConfigurator";
    public String responseString = "true";
    public static Debug debug = Debug.getInstance((String)"amConfigurator");

    public void onInit() {
        super.onInit();
        this.initializeResourceBundle();
        this.addModel("page", (Object)this);
    }

    public boolean isRendering() {
        return this.rendering;
    }

    protected Configurator getConfigurator() {
        if (this.configurator == null) {
            this.configurator = new DummyConfigurator(this);
        }
        return this.configurator;
    }

    protected String toString(String paramName) {
        String value = this.getContext().getRequest().getParameter(paramName);
        value = value != null ? value.trim() : null;
        value = "".equals(value) ? null : value;
        return value;
    }

    protected boolean toBoolean(String paramName) {
        String value = this.toString(paramName);
        return value != null && value.toLowerCase().equals("true");
    }

    protected int toInt(String paramName) {
        int intValue = 0;
        String value = this.toString(paramName);
        if (value != null) {
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return intValue;
    }

    protected void writeValid() {
        this.writeValid(null);
    }

    protected void writeValid(String message) {
        String out = message != null ? message : "";
        this.writeJsonResponse(true, out);
    }

    protected void writeInvalid(String message) {
        String out = message != null ? message : "";
        this.writeJsonResponse(false, out);
    }

    protected void writeJsonResponse(String valid, String responseBody) {
        String response = RESPONSE_TEMPLATE;
        response = response.replaceFirst("\\$\\{valid\\}", valid);
        response = response.replaceFirst("\\$\\{body\\}", responseBody);
        this.writeToResponse(response);
    }

    protected void writeJsonResponse(boolean valid, String responseBody) {
        String response = RESPONSE_TEMPLATE;
        response = response.replaceFirst("\\$\\{valid\\}", String.valueOf(valid));
        response = response.replaceFirst("\\$\\{body\\}", responseBody);
        this.writeToResponse(response);
    }

    protected void writeToResponse(String text) {
        try {
            this.getContext().getResponse().getWriter().write(text);
            this.rendering = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void initializeResourceBundle() {
        HttpServletRequest req = this.getContext().getRequest();
        HttpServletResponse res = this.getContext().getResponse();
        this.setLocale(req);
        res.setContentType("text/html; charset=UTF-8");
    }

    private void setLocale(HttpServletRequest request) {
        if (request != null) {
            String acceptLangHeader;
            String superLocale = request.getParameter("locale");
            this.configLocale = superLocale != null && superLocale.length() > 0 ? Locale.getLocaleObjFromAcceptLangHeader((String)superLocale) : ((acceptLangHeader = request.getHeader("Accept-Language")) != null && acceptLangHeader.length() > 0 ? Locale.getLocaleObjFromAcceptLangHeader((String)acceptLangHeader) : java.util.Locale.getDefault());
            try {
                this.rb = ResourceBundle.getBundle(RB_NAME, this.configLocale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public String getLocalizedString(String i18nKey) {
        if (this.rb == null) {
            this.initializeResourceBundle();
        }
        String localizedValue = null;
        try {
            localizedValue = Locale.getString((ResourceBundle)this.rb, (String)i18nKey, (Debug)debug);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return localizedValue == null ? i18nKey : localizedValue;
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = this.getContext().getRequest().getServerName();
        }
        return this.hostName;
    }

    public String getBaseDir(HttpServletRequest req) {
        String basedir = AMSetupServlet.getPresetConfigDir();
        if (basedir == null || basedir.length() == 0) {
            String uri;
            int idx;
            String tmp = System.getProperty("user.home");
            if (File.separatorChar == '\\') {
                tmp = tmp.replace('\\', '/');
            }
            if ((idx = (uri = req.getRequestURI()).indexOf("/", 1)) != -1) {
                uri = uri.substring(0, idx);
            }
            basedir = tmp.endsWith("/") ? tmp.substring(0, tmp.length() - 1) : tmp;
            basedir = basedir + uri;
        }
        return basedir;
    }

    public String getCookieDomain() {
        String cookieDomain = "";
        String hostname = this.getHostName();
        int idx1 = hostname.lastIndexOf(".");
        if (idx1 != -1 && idx1 != hostname.length() - 1) {
            String topLevelDomain = hostname.substring(idx1 + 1);
            int idx2 = hostname.lastIndexOf(".", idx1 - 1);
            if (idx2 != -1 && idx2 != idx1 - 1) {
                String subDomain = hostname.substring(idx2 + 1, idx1);
                try {
                    Integer.parseInt(topLevelDomain);
                }
                catch (NumberFormatException e) {
                    try {
                        Integer.parseInt(subDomain);
                    }
                    catch (NumberFormatException e1) {
                        cookieDomain = "." + subDomain + "." + topLevelDomain;
                    }
                }
            }
        }
        return cookieDomain;
    }

    public boolean validateInput() {
        String key = this.toString("key");
        String value = this.toString("value");
        if (value == null) {
            this.responseString = "missing.required.field";
        } else {
            this.getContext().setSessionAttribute(key, (Object)value);
        }
        this.writeToResponse(this.getLocalizedString(this.responseString));
        this.setPath(null);
        return false;
    }

    public boolean resetSessionAttributes() {
        try {
            Field[] fields = SessionAttributeNames.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    this.getContext().removeSessionAttribute((String)fields[i].get(null));
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        catch (SecurityException e) {
            this.writeToResponse(e.getMessage());
        }
        this.setPath(null);
        return false;
    }

    public String getAttribute(String attr, String defaultValue) {
        String value = (String)this.getContext().getSessionAttribute(attr);
        return value != null ? value : defaultValue;
    }

    public String getAvailablePort(int portNumber) {
        return Integer.toString(AMSetupServlet.getUnusedPort(this.getHostName(), portNumber, 1000));
    }

    public boolean checkPasswords() {
        String confirm = this.toString("confirm");
        String password = this.toString("password");
        String otherPassword = this.toString("otherPassword");
        String type = this.toString("type");
        if (password == null) {
            this.responseString = this.getLocalizedString("missing.password");
        } else if (password.length() < MIN_PASSWORD_SIZE) {
            this.responseString = this.getLocalizedString("password.size.invalid");
        } else if (confirm == null) {
            this.responseString = this.getLocalizedString("missing.confirm.password");
        } else if (confirm.length() < MIN_PASSWORD_SIZE) {
            this.responseString = this.getLocalizedString("password.size.invalid");
        } else if (!password.equals(confirm)) {
            this.responseString = this.getLocalizedString("password.dont.match");
        } else if (otherPassword != null && otherPassword.equals(password)) {
            this.responseString = this.getLocalizedString("agent.admin.password.same");
        } else {
            type = type.equals("agent") ? "AMLDAPUSERPASSWD" : "ADMIN_PWD";
            this.getContext().setSessionAttribute(type, (Object)password);
        }
        this.writeToResponse(this.responseString);
        this.setPath(null);
        return false;
    }
}

