/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.console.agentconfig.AgentsViewBean;
import com.sun.identity.console.base.AMShowMenuEntry;
import com.sun.identity.console.base.AMTabEntry;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.BlankTabViewBean;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AccessControlModelImpl;
import com.sun.identity.console.idm.EntitiesViewBean;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AMViewConfig {
    private static final AMViewConfig instance = new AMViewConfig();
    private static final String CONFIG_FILENAME = "amConsoleConfig.xml";
    private List tabs = new ArrayList();
    private Map profileTabs = new HashMap();
    private Map showMenus = new HashMap();
    private Map services = new HashMap();
    private static final String TABS = "tabs";
    private static final String TAB_ENTRY = "tab";
    private static final String PROFILE_TABS = "profiletabs";
    private static final String SERVICES_CONFIG = "servicesconfig";
    private static final String HIDDEN_SERVICES = "hidden";
    private static final String CONSOLE_SERVICE = "consoleservice";
    private static final String REALM_ENABLE_HIDE_ATTRS = "realmEnableHideAttrName";
    private static final String IDENTITY_SERVICE = "identityservice";
    private static final String AGENT_SERVICE = "agentservice";
    private static final String COMBINE_AGENT = "combineagent";
    private Map combineAgent = new HashMap();

    private AMViewConfig() {
        Document doc = this.parseDocument(CONFIG_FILENAME);
        this.configTabs(doc);
        this.configMenus(doc);
        this.configProfileTabs(doc);
        this.configServices(doc);
    }

    public static AMViewConfig getInstance() {
        return instance;
    }

    public CCTabsModel getTabsModel(String realmName, HttpServletRequest req) {
        return this.getTabsModel(TABS, realmName, req);
    }

    public CCTabsModel getTabsModel(String type, String realmName, HttpServletRequest req) {
        CCTabsModel tabModel = new CCTabsModel();
        AccessControlModelImpl model = new AccessControlModelImpl(req);
        List tabs = this.getTabList(type);
        if (tabs == null || tabs.isEmpty()) {
            return null;
        }
        for (AMTabEntry entry : tabs) {
            CCNavNode navNode = entry.getNavNode(model, realmName);
            if (navNode == null) continue;
            tabModel.addNode((CCNavNodeInterface)navNode);
        }
        return tabModel;
    }

    public CCTabsModel getSAMLv2TabsModel(String type, String realmName, HttpServletRequest req, List tabsToDisplay) {
        CCTabsModel tabModel = new CCTabsModel();
        AccessControlModelImpl model = new AccessControlModelImpl(req);
        List tabs = this.getTabList(type);
        if (tabs == null || tabs.isEmpty()) {
            return null;
        }
        for (AMTabEntry entry : tabs) {
            for (String roletoDisplay : tabsToDisplay) {
                CCNavNode navNode;
                if (!entry.getViewBean().contains(roletoDisplay) || (navNode = entry.getNavNode(model, realmName)) == null) continue;
                tabModel.addNode((CCNavNodeInterface)navNode);
            }
        }
        return tabModel;
    }

    public boolean addEntityTabs(CCTabsModel tabModel, String realmName, AMModel model) {
        CCNavNode subjectNode;
        boolean added = false;
        List supported = this.getSupportedEntityTypes(realmName, model);
        if (!supported.isEmpty() && (subjectNode = (CCNavNode)tabModel.getNodeById(17)) != null) {
            for (String t : supported) {
                subjectNode.addChild((CCNavNodeInterface)new CCNavNode(t.hashCode(), t, t, t));
            }
            added = true;
        }
        return added;
    }

    public CCNavNode addAgentTabs(CCTabsModel tabModel, AMModel model, int idx) {
        CCNavNode agentNode;
        CCNavNode selected = null;
        Map mapSupported = this.getSupportedAgentTypesMap(model);
        List supported = this.getSupportedAgentTypes(model);
        if (!supported.isEmpty() && (agentNode = (CCNavNode)tabModel.getNodeById(18)) != null) {
            for (int i = 0; i < supported.size(); ++i) {
                String t = (String)supported.get(i);
                int nodeId = Integer.parseInt("18" + i);
                String i18nKey = (String)mapSupported.get(t);
                if (i18nKey == null) {
                    i18nKey = "agenttype." + t;
                }
                CCNavNode n = new CCNavNode(nodeId, i18nKey, t, t);
                if (nodeId == idx) {
                    selected = n;
                }
                agentNode.addChild((CCNavNodeInterface)n);
            }
        }
        return selected;
    }

    public String getCombineAgentType(String type) {
        String cName = null;
        Iterator i = this.combineAgent.keySet().iterator();
        while (i.hasNext() && cName == null) {
            String name = (String)i.next();
            Set set = (Set)this.combineAgent.get(name);
            if (!set.contains(type)) continue;
            cName = name;
        }
        return cName;
    }

    public boolean isCombineAgentType(String type) {
        return this.combineAgent.keySet().contains(type);
    }

    public Set getCombineAgentTypes(String type) {
        return (Set)this.combineAgent.get(type);
    }

    public List getSupportedAgentTypes(AMModel model) {
        Map supported = this.getSupportedAgentTypesMap(model);
        ArrayList ordered = null;
        if (supported != null && !supported.isEmpty()) {
            ordered = new ArrayList(supported.size());
            HashSet basket = new HashSet();
            basket.addAll(supported.keySet());
            List predefinedOrder = (List)this.services.get(AGENT_SERVICE);
            for (String wildcard : predefinedOrder) {
                List matched = this.matchIdentityType(basket, wildcard, model);
                if (matched.isEmpty()) continue;
                ordered.addAll(matched);
            }
            if (!basket.isEmpty()) {
                ordered.addAll(AMFormatUtils.sortItems(basket, model.getUserLocale()));
            }
        }
        if (ordered != null && !ordered.isEmpty()) {
            HashSet<String> alreadyAddedCName = new HashSet<String>();
            ArrayList<String> newList = new ArrayList<String>(ordered.size());
            for (String name : ordered) {
                String cName = this.getCombineAgentType(name);
                if (cName != null) {
                    if (alreadyAddedCName.contains(cName)) continue;
                    newList.add(cName);
                    alreadyAddedCName.add(cName);
                    continue;
                }
                newList.add(name);
            }
            return newList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getSupportedEntityTypes(String realmName, AMModel model) {
        Map supported = this.getSupportedEntityTypesMap(realmName, model);
        ArrayList ordered = null;
        if (supported != null && !supported.isEmpty()) {
            ordered = new ArrayList(supported.size());
            HashSet basket = new HashSet();
            basket.addAll(supported.keySet());
            List predefinedOrder = this.getIdentityDisplayOrder();
            for (String wildcard : predefinedOrder) {
                List matched = this.matchIdentityType(basket, wildcard, model);
                if (matched.isEmpty()) continue;
                ordered.addAll(matched);
            }
            if (!basket.isEmpty()) {
                ordered.addAll(AMFormatUtils.sortItems(basket, model.getUserLocale()));
            }
        }
        return ordered == null ? Collections.EMPTY_LIST : ordered;
    }

    private List matchIdentityType(Set basket, String wildcard, AMModel model) {
        HashSet<String> matched = new HashSet<String>();
        Iterator i = basket.iterator();
        while (i.hasNext()) {
            String type = (String)i.next();
            if (!DisplayUtils.wildcardMatch(type, wildcard)) continue;
            matched.add(type);
            i.remove();
        }
        return AMFormatUtils.sortItems(matched, model.getUserLocale());
    }

    public Map getSupportedAgentTypesMap(AMModel model) {
        Map supported = model.getSupportedAgentTypes();
        return supported == null ? Collections.EMPTY_MAP : supported;
    }

    public Map getSupportedEntityTypesMap(String realmName, AMModel model) {
        Map supported = null;
        AccessControlModelImpl accessModel = new AccessControlModelImpl(model.getUserSSOToken());
        HashSet<String> permission = new HashSet<String>(2);
        permission.add("sunIdentityRepositoryService");
        if (accessModel.canView(permission, null, realmName, false)) {
            supported = model.getSupportedEntityTypes(realmName);
        }
        return supported == null ? Collections.EMPTY_MAP : supported;
    }

    public void setTabViews(int parentID, List items) {
        AMTabEntry parent = null;
        try {
            parent = this.getTabEntry(parentID);
            parent.removeChildren();
        }
        catch (AMConsoleException a) {
            AMModelBase.debug.error("couldn't get the parent tab ");
            return;
        }
        int id = 1;
        for (Map tab : items) {
            parent.addChild(this.createTabEntry(id, tab));
            ++id;
        }
    }

    private AMTabEntry createTabEntry(int id, Map data) {
        String label = (String)data.get("label");
        String tooltip = (String)data.get("tooltip");
        String status = (String)data.get("status");
        String url = (String)data.get("url");
        String permissions = (String)data.get("permissions");
        String viewbean = (String)data.get("viewbean");
        AMTabEntry child = new AMTabEntry(id, label, tooltip, status, url, AMAdminUtils.getDelimitedValues(permissions, ","), viewbean);
        return child;
    }

    public String getDefaultViewBeanURL(String realmName, HttpServletRequest req) {
        return this.getDefaultViewBeanURL(TABS, realmName, req);
    }

    public String getDefaultViewBeanURL(String type, String realmName, HttpServletRequest req) {
        AccessControlModelImpl model = new AccessControlModelImpl(req);
        List list = this.getTabList(type);
        String url = null;
        Iterator i = list.iterator();
        while (i.hasNext() && url == null) {
            AMTabEntry entry = (AMTabEntry)i.next();
            url = entry.getURL(model, realmName);
        }
        return url;
    }

    public int getDefaultTabId(String realmName, HttpServletRequest req) {
        return this.getDefaultTabId(TABS, realmName, req);
    }

    public int getDefaultTabId(String type, String realmName, HttpServletRequest req) {
        AccessControlModelImpl model = new AccessControlModelImpl(req);
        List list = this.getTabList(type);
        int id = -1;
        Iterator i = this.tabs.iterator();
        while (i.hasNext() && id == -1) {
            AMTabEntry entry = (AMTabEntry)i.next();
            id = entry.getID(model, realmName);
        }
        return id;
    }

    public AMViewBeanBase getTabViewBean(AMViewBeanBase vb, String realmName, AMModel model, int idx, int childIdx) throws AMConsoleException {
        return this.getTabViewBean(vb, realmName, model, TABS, idx, childIdx);
    }

    public AMViewBeanBase getTabViewBean(AMViewBeanBase vb, String realmName, AMModel model, String type, int idx, int childIdx) throws AMConsoleException {
        Class clazz = this.getTabViewBeanClass(vb, realmName, model, type, idx, childIdx);
        return (AMViewBeanBase)vb.getViewBean(clazz);
    }

    private Class getTabViewBeanClass(AMViewBeanBase vb, String realmName, AMModel model, String type, int idx, int childIdx) throws AMConsoleException {
        List list = this.getTabList(type);
        Class clazz = null;
        AccessControlModelImpl accessModel = new AccessControlModelImpl(model.getUserSSOToken());
        Iterator i = list.iterator();
        block3: while (i.hasNext() && clazz == null) {
            AMTabEntry entry = (AMTabEntry)i.next();
            if (!entry.canView(accessModel, realmName)) continue;
            clazz = idx == -1 ? entry.getTabClass() : entry.getTabClass(idx);
            if (clazz == null) {
                clazz = this.getEntityTypeClass(vb, idx, realmName, model);
                if (clazz != null) continue;
                clazz = this.getAgentTypeClass(vb, idx, model);
                continue;
            }
            if (!BlankTabViewBean.class.equals((Object)clazz)) continue;
            switch (childIdx) {
                case -1: {
                    clazz = null;
                    continue block3;
                }
            }
            clazz = this.getTabViewBeanClass(vb, realmName, model, type, childIdx, -1);
        }
        if (clazz == null) {
            throw new AMConsoleException("AMViewConfig.getTabClass: no action class for node ID, " + idx);
        }
        return clazz;
    }

    private Class getEntityTypeClass(AMViewBeanBase vb, int idx, String realmName, AMModel model) {
        Class<EntitiesViewBean> clazz = null;
        Map supported = model.getSupportedEntityTypes(realmName);
        Iterator i = supported.keySet().iterator();
        while (i.hasNext() && clazz == null) {
            String t = (String)i.next();
            if (idx != t.hashCode()) continue;
            clazz = EntitiesViewBean.class;
            vb.setPageSessionAttribute("entitytype", (Serializable)((Object)t));
        }
        return clazz;
    }

    private Class getAgentTypeClass(AMViewBeanBase vb, int idx, AMModel model) {
        Class<AgentsViewBean> clazz = null;
        Map supported = model.getSupportedAgentTypes();
        Iterator i = supported.keySet().iterator();
        while (i.hasNext() && clazz == null) {
            String t = (String)i.next();
            if (idx != t.hashCode()) continue;
            clazz = AgentsViewBean.class;
            vb.setPageSessionAttribute("agenttype", (Serializable)((Object)t));
        }
        return clazz;
    }

    public AMTabEntry getTabEntry(int idx) throws AMConsoleException {
        return this.getTabEntry(TABS, idx);
    }

    private AMTabEntry getTabEntry(String type, int idx) throws AMConsoleException {
        List list = this.getTabList(type);
        AMTabEntry entry = null;
        Iterator iter = list.iterator();
        while (iter.hasNext() && entry == null) {
            AMTabEntry e = (AMTabEntry)iter.next();
            entry = e.matchedID(idx);
        }
        if (entry == null) {
            throw new AMConsoleException("AMViewConfig.getTabEntry: not found, id = " + idx);
        }
        return entry;
    }

    public OptionList getShowMenus(String name) {
        OptionList optList = new OptionList();
        List list = (List)this.showMenus.get(name);
        if (list != null && !list.isEmpty()) {
            for (AMShowMenuEntry menu : list) {
                optList.add(menu.getLabel(), menu.getID());
            }
        }
        return optList;
    }

    public Class getShowMenuClass(String name, String idx) throws AMConsoleException {
        Class<?> clazz = null;
        List list = (List)this.showMenus.get(name);
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext() && clazz == null) {
                AMShowMenuEntry menu = (AMShowMenuEntry)iter.next();
                if (!menu.getID().equals(idx)) continue;
                try {
                    clazz = Class.forName(menu.getViewBean());
                }
                catch (ClassNotFoundException e) {
                    throw new AMConsoleException(e.getMessage());
                }
            }
        }
        if (clazz == null) {
            throw new AMConsoleException("AMViewConfig.getShowMenuClass: not action class for ID, " + idx);
        }
        return clazz;
    }

    public boolean isServiceVisible(String serviceName) {
        Set hidden = (Set)this.services.get(HIDDEN_SERVICES);
        return !hidden.contains(serviceName);
    }

    public Set getRealmEnableHiddenConsoleAttrNames() {
        return (Set)this.services.get(REALM_ENABLE_HIDE_ATTRS);
    }

    public List getIdentityDisplayOrder() {
        return (List)this.services.get(IDENTITY_SERVICE);
    }

    private Document parseDocument(String fileName) {
        Document document = null;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            dbFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new DefaultHandler());
            document = documentBuilder.parse(is);
        }
        catch (UnsupportedEncodingException e) {
            AMModelBase.debug.error("AMViewConfig.parseDocument", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            AMModelBase.debug.error("AMViewConfig.parseDocument", (Throwable)e);
        }
        catch (SAXException e) {
            AMModelBase.debug.error("AMViewConfig.parseDocument", (Throwable)e);
        }
        catch (IOException e) {
            AMModelBase.debug.error("AMViewConfig.parseDocument", (Throwable)e);
        }
        return document;
    }

    private void configTabs(Document doc) {
        NodeList nodes = doc.getElementsByTagName(TABS);
        if (nodes != null && nodes.getLength() == 1) {
            Node root = nodes.item(0);
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equalsIgnoreCase(TAB_ENTRY)) continue;
                try {
                    AMTabEntry entry = new AMTabEntry(child);
                    this.tabs.add(entry);
                    continue;
                }
                catch (AMConsoleException e) {
                    AMModelBase.debug.error("AMViewConfig.configTabs", (Throwable)e);
                }
            }
        } else {
            AMModelBase.debug.error("AMViewConfig.configTabs TabConfig.xml is incorrect.");
        }
    }

    private List getProfileTabs(Node parent) {
        ArrayList<AMTabEntry> entries = new ArrayList<AMTabEntry>();
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase(TAB_ENTRY)) continue;
            try {
                AMTabEntry entry = new AMTabEntry(child);
                entries.add(entry);
                continue;
            }
            catch (AMConsoleException e) {
                AMModelBase.debug.error("AMViewConfig.getProfileTabs", (Throwable)e);
            }
        }
        return entries;
    }

    private void configServices(Document doc) {
        Node root;
        NodeList children;
        NodeList nodes = doc.getElementsByTagName(SERVICES_CONFIG);
        if (nodes != null && nodes.getLength() == 1 && (children = (root = nodes.item(0)).getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                String order;
                ArrayList<String> list;
                StringTokenizer st;
                String names;
                HashSet<String> set;
                Node child = children.item(i);
                if (child.getNodeName().equals(HIDDEN_SERVICES)) {
                    try {
                        set = new HashSet<String>();
                        names = this.getAttribute(child, "names");
                        st = new StringTokenizer(names, ",");
                        while (st.hasMoreTokens()) {
                            set.add(st.nextToken().trim());
                        }
                        this.services.put(HIDDEN_SERVICES, set);
                    }
                    catch (AMConsoleException e) {
                        AMModelBase.debug.error("AMViewConfig.configServices", (Throwable)e);
                    }
                    continue;
                }
                if (child.getNodeName().equals(CONSOLE_SERVICE)) {
                    try {
                        set = new HashSet();
                        names = this.getAttribute(child, REALM_ENABLE_HIDE_ATTRS);
                        st = new StringTokenizer(names, ",");
                        while (st.hasMoreTokens()) {
                            set.add(st.nextToken().trim());
                        }
                        this.services.put(REALM_ENABLE_HIDE_ATTRS, set);
                    }
                    catch (AMConsoleException e) {
                        AMModelBase.debug.error("AMViewConfig.configServices", (Throwable)e);
                    }
                    continue;
                }
                if (child.getNodeName().equals(IDENTITY_SERVICE)) {
                    list = new ArrayList<String>();
                    this.services.put(IDENTITY_SERVICE, list);
                    try {
                        order = this.getAttribute(child, "order");
                        st = new StringTokenizer(order, ",");
                        while (st.hasMoreTokens()) {
                            list.add(st.nextToken().trim());
                        }
                        continue;
                    }
                    catch (AMConsoleException e) {
                        AMModelBase.debug.error("AMViewConfig.configServices", (Throwable)e);
                        continue;
                    }
                }
                if (child.getNodeName().equals(AGENT_SERVICE)) {
                    list = new ArrayList();
                    this.services.put(AGENT_SERVICE, list);
                    try {
                        order = this.getAttribute(child, "order");
                        st = new StringTokenizer(order, ",");
                        while (st.hasMoreTokens()) {
                            list.add(st.nextToken().trim());
                        }
                        continue;
                    }
                    catch (AMConsoleException e) {
                        AMModelBase.debug.error("AMViewConfig.configServices", (Throwable)e);
                        continue;
                    }
                }
                if (!child.getNodeName().equals(COMBINE_AGENT)) continue;
                try {
                    String order2 = this.getAttribute(child, "pairs");
                    StringTokenizer st2 = new StringTokenizer(order2, "|");
                    while (st2.hasMoreElements()) {
                        String token = st2.nextToken();
                        int idx = token.indexOf("=");
                        if (idx == -1) continue;
                        String vType = token.substring(0, idx);
                        String suffix = token.substring(idx + 1);
                        StringTokenizer st1 = new StringTokenizer(suffix, ",");
                        HashSet<String> set2 = new HashSet<String>();
                        this.combineAgent.put(vType, set2);
                        while (st1.hasMoreElements()) {
                            set2.add(st1.nextToken());
                        }
                    }
                    continue;
                }
                catch (AMConsoleException e) {
                    AMModelBase.debug.error("AMViewConfig.configServices", (Throwable)e);
                }
            }
        }
    }

    private void configProfileTabs(Document doc) {
        NodeList nodes = doc.getElementsByTagName(PROFILE_TABS);
        if (nodes != null && nodes.getLength() == 1) {
            Node root = nodes.item(0);
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equalsIgnoreCase("profile")) continue;
                try {
                    String id = this.getAttribute(child, "id");
                    if (id == null || id.length() <= 0) continue;
                    this.profileTabs.put(id, this.getProfileTabs(child));
                    continue;
                }
                catch (AMConsoleException e) {
                    AMModelBase.debug.error("AMViewConfig.configMenus", (Throwable)e);
                }
            }
        } else {
            AMModelBase.debug.warning("AMViewConfig.configProfileTabs, config xml is incorrect.");
        }
    }

    private void configMenus(Document doc) {
        NodeList nodes = doc.getElementsByTagName("showmenus");
        if (nodes != null && nodes.getLength() == 1) {
            Node root = nodes.item(0);
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equalsIgnoreCase("showmenu")) continue;
                try {
                    String id = this.getAttribute(child, "id");
                    if (id == null || id.length() <= 0) continue;
                    this.showMenus.put(id, this.getShowMenus(child));
                    continue;
                }
                catch (AMConsoleException e) {
                    AMModelBase.debug.error("AMViewConfig.configMenus", (Throwable)e);
                }
            }
        }
    }

    private List getShowMenus(Node node) throws AMConsoleException {
        ArrayList<AMShowMenuEntry> list = new ArrayList<AMShowMenuEntry>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase("menu")) continue;
            try {
                list.add(new AMShowMenuEntry(child));
                continue;
            }
            catch (AMConsoleException e) {
                AMModelBase.debug.error("AMViewConfig.getShowMenus", (Throwable)e);
            }
        }
        return list;
    }

    private String getAttribute(Node node, String attrName) throws AMConsoleException {
        String value = null;
        NamedNodeMap attrs = node.getAttributes();
        Node nodeID = attrs.getNamedItem(attrName);
        if (nodeID != null) {
            value = nodeID.getNodeValue();
            value = value.trim();
        }
        return value;
    }

    private List getTabList(String type) {
        List tmp = null;
        tmp = type.equals(TABS) ? this.tabs : (List)this.profileTabs.get(type);
        return tmp;
    }

    public void addTabEntries(String type, List entries, boolean newSet) {
        ArrayList<AMTabEntry> tabList = null;
        tabList = !newSet ? this.getTabList(type) : new ArrayList<AMTabEntry>(entries.size() * 2);
        int id = tabList.size() + 1;
        for (Map entry : entries) {
            tabList.add(this.createTabEntry(id++, entry));
        }
        this.profileTabs.put(type, tabList);
    }
}

