/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.console.base.PageTrail;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import sun.misc.BASE64Encoder;

public class PageTrailManager
implements SSOTokenListener {
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static PageTrailManager instance = new PageTrailManager();
    private Map mapTokenIDs = new HashMap(100);
    private static BASE64Encoder encoder = new BASE64Encoder();
    private static Random random = new Random();

    private PageTrailManager() {
    }

    public static PageTrailManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerTrail(SSOToken token, PageTrail pageTrail) {
        String randomStr = "";
        try {
            String key = ((Object)token.getTokenID()).toString();
            Map map = this.mapTokenIDs;
            synchronized (map) {
                HashMap<String, PageTrail> map2 = (HashMap<String, PageTrail>)this.mapTokenIDs.get(key);
                if (map2 == null) {
                    map2 = new HashMap<String, PageTrail>(10);
                    token.addSSOTokenListener(this);
                }
                randomStr = PageTrailManager.getRandomString();
                map2.put(randomStr, pageTrail);
                this.mapTokenIDs.put(key, map2);
            }
        }
        catch (SSOException ssoe) {
            debug.warning("PageTrailManager.registerTrail()", (Throwable)((Object)ssoe));
            randomStr = "";
        }
        return randomStr;
    }

    public PageTrail getTrail(SSOToken token, String cacheID) {
        Map map = (Map)this.mapTokenIDs.get(((Object)token.getTokenID()).toString());
        return map != null ? (PageTrail)map.get(cacheID) : null;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int type = evt.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    SSOToken token = evt.getToken();
                    this.clearAllTrails(token.getTokenID());
                }
            }
        }
        catch (SSOException ssoe) {
            debug.warning("PageTrailManager.ssoTokenChanged()", (Throwable)((Object)ssoe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllTrails(SSOTokenID tokenID) {
        boolean removed = false;
        String key = ((Object)tokenID).toString();
        Map map = this.mapTokenIDs;
        synchronized (map) {
            removed = this.mapTokenIDs.remove(key) != null;
        }
    }

    private static String getRandomString() {
        StringBuffer sb = new StringBuffer(30);
        byte[] keyRandom = new byte[5];
        random.nextBytes(keyRandom);
        sb.append(System.currentTimeMillis());
        sb.append(encoder.encode(keyRandom));
        return sb.toString();
    }
}

