/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import java.util.Locale;

public class AMI18NUtils {
    public static final String KEY_CLIENT_TYPE = "clientType";
    private static AMClientDetector clientDt = new AMClientDetector();
    private static Debug debug = Debug.getInstance((String)"amConsole");

    public static String getClientType(SSOToken ssoToken) {
        String clientType = "";
        try {
            clientType = ssoToken.getProperty(KEY_CLIENT_TYPE);
        }
        catch (SSOException ssoe) {
            debug.error("AMI18NUtils.getClientType", (Throwable)((Object)ssoe));
        }
        return clientType;
    }

    public static String getCharset(String clientType, Locale loc) {
        String charset;
        if (clientDt.isDetectionEnabled()) {
            try {
                Client client = ClientsManager.getInstance(clientType);
                charset = client != null ? client.getCharset(loc) : "ISO-8859-1";
            }
            catch (ClientException ce) {
                debug.warning("AMI18NUtils.getCharset - couldn't retrieve the client charset, reverting to default.");
                charset = "ISO-8859-1";
            }
        } else {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public static String getContentType(String clientType) {
        String contentType;
        if (clientDt.isDetectionEnabled()) {
            try {
                Client client = ClientsManager.getInstance(clientType);
                contentType = client != null ? client.getProperty("contentType") : "genericHTML";
            }
            catch (ClientException ce) {
                debug.warning("AMI18NUtils.getContentType - couldn't retrieve the content type, reverting to default.");
                contentType = "genericHTML";
            }
        } else {
            contentType = "genericHTML";
        }
        return contentType;
    }
}

