/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMSystemConfig;
import com.sun.identity.console.dm.GeneralPropertiesBase;
import com.sun.identity.console.dm.UserViewBean;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.identity.console.dm.model.UserModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.text.MessageFormat;

public abstract class UserPropertiesBase
extends GeneralPropertiesBase {
    private static final String PROFILE_TAB = "users";
    public CCPageTitleModel ptModel = null;
    public UserModel model = null;
    private String userName = null;

    public UserPropertiesBase(String name) {
        super(name);
    }

    protected void registerChildren() {
        this.registerChild("tabCommon", CCTabs.class);
        super.registerChildren();
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean(PROFILE_TAB, nodeID);
            String tmp = (String)this.getPageSessionAttribute("currentOrganization");
            vb.setPageSessionAttribute("currentOrganization", (Serializable)((Object)tmp));
            tmp = (String)this.getPageSessionAttribute("CurrentProfileView");
            vb.setPageSessionAttribute("CurrentProfileView", (Serializable)((Object)tmp));
            tmp = (String)this.getPageSessionAttribute("PreviousTabID");
            vb.setPageSessionAttribute("PreviousTabID", (Serializable)((Object)tmp));
            this.unlockPageTrailForSwapping();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            debug.error("UserPropertiesBase.nodeClicked", (Throwable)e);
            this.forwardTo();
        }
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected void createTabModel() {
        if (this.tabModel == null) {
            AMViewConfig amconfig = AMViewConfig.getInstance();
            String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
            this.tabModel = amconfig.getTabsModel(PROFILE_TAB, realmName, this.getRequestContext().getRequest());
        }
    }

    protected void forwardToUserView(RequestInvocationEvent event) {
        String tmp = (String)this.getPageSessionAttribute("currentOrganization");
        this.setPageSessionAttribute("currentOrganization", (Serializable)((Object)tmp));
        tmp = (String)this.getPageSessionAttribute("PreviousTabID");
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)tmp));
        UserViewBean vb = (UserViewBean)this.getViewBean(UserViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void setPageTitle(String title) {
        String name = (String)this.getPageSessionAttribute("CurrentProfileView");
        if (name == null || name.length() == 0) {
            name = AMSystemConfig.defaultOrg;
        }
        this.model = (UserModel)this.getModel();
        Object[] tmp = new String[]{AMFormatUtils.DNToName(this.model, name)};
        this.ptModel.setPageTitleText(MessageFormat.format(this.model.getLocalizedString(title), tmp));
    }

    protected String getUserName() {
        if (this.userName == null) {
            this.userName = (String)this.getPageSessionAttribute("CurrentProfileView");
            if (this.userName == null) {
                return "";
            }
        }
        return this.userName;
    }

    protected AMModel getModelInternal() {
        if (this.model == null) {
            RequestContext rc = RequestManager.getRequestContext();
            this.model = new UserModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        }
        return this.model;
    }

    protected String getBreadCrumbDisplayName() {
        UserModel model = (UserModel)this.getModel();
        String name = (String)this.getPageSessionAttribute("CurrentProfileView");
        Object[] arg = new String[]{AMFormatUtils.DNToName(model, name)};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.directorymanager.user.edit"), arg);
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        UserViewBean vb = (UserViewBean)this.getViewBean(UserViewBean.class);
        String tmp = (String)this.getPageSessionAttribute("PreviousTabID");
        this.setPageSessionAttribute(this.getTrackingTabIDName(), (Serializable)((Object)tmp));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("breadcrumbs.directorymanager.user");
    }

    protected boolean startPageTrail() {
        return false;
    }
}

