/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.sun.identity.console.base.AMPostViewBean;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.idm.EntitiesViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.console.idm.model.EntitiesModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;

public abstract class EntityOpViewBeanBase
extends AMPrimaryMastHeadViewBean {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String ENTITY_NAME = "tfEntityName";
    public static final String ENTITY_TYPE = "entityTypeName";
    public static final String ENTITY_AGENT_TYPE = "entityAgentType";
    public static final String ENTITY_TYPE_NAME = "tfEntityTypeName";
    protected CCPageTitleModel ptModel;
    protected AMPropertySheetModel propertySheetModel;
    protected boolean hasNoAttributeToDisplay;
    protected boolean submitCycle;

    public EntityOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name);
        this.setDefaultDisplayURL(defaultDisplayURL);
    }

    protected void initialize() {
        if (!this.initialized) {
            this.initialized = this.createPropertyModel();
            if (this.initialized) {
                super.initialize();
                this.createPageTitleModel();
                this.registerChildren();
                this.registerChild("dynLink", HREF.class);
            }
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new EntitiesModelImpl(req, this.getPageSessionAttributes());
    }

    protected boolean createPropertyModel() {
        boolean created = false;
        String type = (String)this.getPageSessionAttribute(ENTITY_TYPE);
        if (type != null && type.trim().length() > 0) {
            AMPropertySheetModel psModel = this.createPropertySheetModel(type);
            if (psModel != null) {
                this.propertySheetModel = psModel;
                this.propertySheetModel.clear();
            }
            created = true;
        }
        return created;
    }

    protected AMPropertySheetModel createPropertySheetModel(String type) {
        AMPropertySheetModel psModel = null;
        EntitiesModel model = (EntitiesModel)this.getModel();
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        String agentType = (String)this.getPageSessionAttribute(ENTITY_AGENT_TYPE);
        try {
            psModel = new AMPropertySheetModel(model.getPropertyXMLString(realmName, type, agentType, this.isCreateViewBean(), ((Object)((Object)this)).getClass().getName()));
        }
        catch (AMConsoleException e) {
            psModel = this.handleNoAttributeToDisplay(e);
        }
        return psModel;
    }

    protected AMPropertySheetModel handleNoAttributeToDisplay(AMConsoleException e) {
        this.hasNoAttributeToDisplay = true;
        this.setInlineAlertMessage("info", "message.information", e.getMessage());
        return new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyBlank.xml"));
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild("tabCommon", CCTabs.class);
        if (this.propertySheetModel != null) {
            this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
            this.propertySheetModel.registerChildren((ContainerViewBase)this);
        }
    }

    protected View createChild(String name) {
        Object view = null;
        view = this.ptModel != null && this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel != null && this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (name.equals("dynLink") ? new HREF((ContainerView)this, name, (Object)"") : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (!this.submitCycle) {
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            EntitiesModel model = (EntitiesModel)this.getModel();
            try {
                String entityType = (String)this.getPageSessionAttribute(ENTITY_TYPE);
                this.setDefaultValues(entityType);
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    protected void forwardToEntitiesViewBean() {
        EntitiesViewBean vb = (EntitiesViewBean)this.getViewBean(EntitiesViewBean.class);
        String entityType = (String)this.getPageSessionAttribute(ENTITY_TYPE);
        String tabId = Integer.toString(entityType.hashCode());
        this.setPageSessionAttribute(super.getTrackingTabIDName(), (Serializable)((Object)tabId));
        this.setPageSessionAttribute("CCTabs.SelectedTabId", (Serializable)((Object)tabId));
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardToEntitiesViewBean();
    }

    protected abstract void createPageTitleModel();

    protected abstract void setDefaultValues(String var1) throws AMConsoleException;

    protected abstract boolean isCreateViewBean();

    public void handleDynLinkRequest(RequestInvocationEvent event) {
        HttpServletRequest req = this.getRequestContext().getRequest();
        String url = req.getParameter("propviewbean");
        AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.setTargetViewBeanURL(url);
        vb.forwardTo(this.getRequestContext());
    }
}

