/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyUtils;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.view.addremove.CCAddRemove;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class IdentityMembershipHelper {
    private static IdentityMembershipHelper instance = new IdentityMembershipHelper();

    private IdentityMembershipHelper() {
    }

    public static IdentityMembershipHelper getInstance() {
        return instance;
    }

    public static void setSelectedIdentities(CCAddRemove child, SSOToken token, Locale userLocale, AMViewBeanBase viewBean, Map values) {
        Set setValues;
        if (values != null && !values.isEmpty() && (setValues = (Set)values.get("amIdentityName")) != null && !setValues.isEmpty()) {
            CCAddRemoveModel addRemoveModel = (CCAddRemoveModel)child.getModel();
            OptionList optList = IdentityMembershipHelper.createOptionList(token, userLocale, viewBean, setValues);
            addRemoveModel.setSelectedOptionList(optList);
        }
    }

    public static Map getSelectedIdentities(CCAddRemove child) {
        HashMap map = new HashMap(2);
        child.restoreStateData();
        CCAddRemoveModel addRemoveModel = (CCAddRemoveModel)child.getModel();
        OptionList selected = addRemoveModel.getSelectedOptionList();
        HashSet<String> setValues = new HashSet<String>();
        for (int i = 0; i < selected.size(); ++i) {
            Option opt = selected.get(i);
            setValues.add(opt.getValue());
        }
        map.put("amIdentityName", setValues);
        return map;
    }

    public static OptionList createOptionList(SSOToken token, Locale userLocale, AMViewBeanBase viewBean, Collection values) {
        OptionList optList = new OptionList();
        if (values != null && !values.isEmpty()) {
            Collection amIdentity = values.iterator().next() instanceof String ? IdentityMembershipHelper.getAMIdentity(token, values) : values;
            HashMap<String, String> entries = new HashMap<String, String>(values.size() * 2);
            for (AMIdentity identity : amIdentity) {
                entries.put(IdUtils.getUniversalId(identity), PolicyUtils.getDNDisplayString(identity.getName()));
            }
            optList = AMViewBeanBase.createOptionList(entries, userLocale);
        }
        return optList;
    }

    public static Set getAMIdentityNames(SSOToken token, Collection ids) {
        Set identities = IdentityMembershipHelper.getAMIdentity(token, ids);
        HashSet<String> names = new HashSet<String>(identities.size() * 2);
        for (AMIdentity amid : identities) {
            names.add(PolicyUtils.getDNDisplayString(amid.getName()));
        }
        return names;
    }

    public static Set getAMIdentity(SSOToken token, Collection ids) {
        HashSet<AMIdentity> values = new HashSet<AMIdentity>(ids.size() * 2);
        for (String id : ids) {
            try {
                AMIdentity amid = IdUtils.getIdentity(token, id);
                values.add(amid);
            }
            catch (IdRepoException e) {}
        }
        return values;
    }
}

