/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.QueryResults;
import com.sun.identity.console.policy.SelectTypeViewBeanBase;
import com.sun.identity.console.policy.SubjectAddViewBean;
import com.sun.identity.console.policy.SubjectNoneAddViewBean;
import com.sun.identity.console.policy.SubjectProxyViewBean;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.Syntax;
import java.io.Serializable;
import java.util.Map;

public class SelectSubjectTypeViewBean
extends SelectTypeViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/SelectSubjectType.jsp";
    private static final String ATTR_SUBJECT_NAME = "tfSubjectName";
    private static final String ATTR_SUBJECT_TYPE = "radioSubjectType";
    public static final String CALLING_VIEW_BEAN = "SelectSubjectTypeViewBeanCallingVB";

    public SelectSubjectTypeViewBean() {
        super("SelectSubjectType", DEFAULT_DISPLAY_URL);
    }

    protected String getTypeOptionsChildName() {
        return ATTR_SUBJECT_TYPE;
    }

    protected OptionList getTypeOptions() {
        String curRealm;
        PolicyModel model = (PolicyModel)this.getModel();
        QueryResults qr = model.getActiveSubjectTypes(curRealm = (String)this.getPageSessionAttribute("currentRealm"));
        String strError = qr.getStrError();
        if (strError != null && strError.length() > 0) {
            this.setInlineAlertMessage("error", "message.error", strError);
        }
        return SelectSubjectTypeViewBean.createOptionList((Map)qr.getResults(), model.getUserLocale());
    }

    protected String getPropertyXMLFileName() {
        return "com/sun/identity/console/propertyPMSelectSubjectType.xml";
    }

    protected String getCallingViewBeanPgSessionName() {
        return CALLING_VIEW_BEAN;
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String subjectType = (String)this.propertySheetModel.getValue(ATTR_SUBJECT_TYPE);
        this.setPageSessionAttribute("SubjectOpViewBeanBaseCallingVB", (Serializable)((Object)((String)this.getPageSessionAttribute(CALLING_VIEW_BEAN))));
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        String viewBeanURL = model.getSubjectViewBeanURL(realmName, subjectType);
        this.unlockPageTrailForSwapping();
        if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
            this.forwardToURL(viewBeanURL, subjectType, realmName);
        } else {
            this.forwardToViewBean(model, subjectType, realmName);
        }
    }

    private void forwardToURL(String url, String subjectType, String realmName) {
        SubjectProxyViewBean vb = (SubjectProxyViewBean)this.getViewBean(SubjectProxyViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.setURL(url, "add");
        vb.setDisplayFieldValue("sbjType", subjectType);
        if (realmName == null || realmName.trim().length() == 0) {
            realmName = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        vb.setDisplayFieldValue("locDN", realmName);
        vb.setDisplayFieldValue("cachedID", (String)this.getPageSessionAttribute("policyCacheID"));
        vb.setDisplayFieldValue("tfOp", "add");
        vb.forwardTo(this.getRequestContext());
    }

    private void forwardToViewBean(PolicyModel model, String subjectType, String realmName) {
        Syntax syntax = model.getSubjectSyntax(realmName, subjectType);
        int displaySyntax = AMDisplayType.getDisplaySyntax(syntax);
        SubjectAddViewBean vb = null;
        switch (displaySyntax) {
            case 0: 
            case 10: 
            case 11: {
                vb = (SubjectAddViewBean)this.getViewBean(SubjectAddViewBean.class);
                break;
            }
            default: {
                vb = (SubjectNoneAddViewBean)this.getViewBean(SubjectNoneAddViewBean.class);
            }
        }
        this.setPageSessionAttribute("subjectType", (Serializable)((Object)subjectType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.selectSubjectType";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

