/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.property;

import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.AttributeSchemaComparator;
import com.sun.identity.console.property.PropertyTemplate;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public abstract class PropertyXMLBuilderBase
implements PropertyTemplate {
    public static Debug debug = Debug.getInstance((String)"amConsole");
    protected static ResourceBundle properties = ResourceBundle.getBundle("amProperty");
    protected static Map mapSchemaTypeToName = new HashMap(8);
    protected static List orderDisplaySchemaType = new ArrayList(4);
    protected static Map mapUITypeToName = new HashMap(8);
    protected static Map mapTypeToName = new HashMap(8);
    protected static Map mapSyntaxToName = new HashMap(20);
    private static String platformDefaultEncoding;
    protected ServiceSchemaManager svcSchemaManager;
    protected AMModel model;
    protected boolean supportSubConfig;
    protected String viewBeanName;
    protected ResourceBundle serviceBundle;
    protected Map mapTypeToAttributeSchema;
    protected String serviceName;
    protected boolean allAttributesReadonly;
    protected String currentRealm;

    static String getTagClassName(AttributeSchema as) {
        AttributeSchema.Syntax syntax;
        String valSyntax;
        String tagClassName = null;
        AttributeSchema.UIType uitype = as.getUIType();
        if (uitype != null) {
            String val = (String)mapUITypeToName.get(uitype);
            try {
                tagClassName = properties.getString(val);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        AttributeSchema.Type type = as.getType();
        String valType = (String)mapTypeToName.get(type);
        if (tagClassName == null && valType != null) {
            try {
                tagClassName = properties.getString(valType);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (tagClassName == null && (valSyntax = (String)mapSyntaxToName.get(syntax = as.getSyntax())) != null) {
            try {
                tagClassName = properties.getString(valType + "." + valSyntax);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (tagClassName == null) {
            try {
                tagClassName = properties.getString(valType + ".whatever");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (tagClassName != null && tagClassName.trim().length() == 0) {
            tagClassName = null;
        }
        return tagClassName;
    }

    public static void filterHiddenAttributes(Set attributeSchemas) {
        PropertyXMLBuilderBase.removeAttributeSchemaWithoutI18nKey(attributeSchemas);
        Iterator iter = attributeSchemas.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = (AttributeSchema)iter.next();
            String any = as.getAny();
            if (!(PropertyXMLBuilderBase.hasAnyAttribute(any, "required") || PropertyXMLBuilderBase.hasAnyAttribute(any, "display") || PropertyXMLBuilderBase.hasAnyAttribute(any, "adminDisplay"))) {
                iter.remove();
                continue;
            }
            if (PropertyXMLBuilderBase.getTagClassName(as) != null) continue;
            iter.remove();
        }
    }

    public static void removeAttributeSchemaWithoutI18nKey(Set attributeSchemas) {
        Iterator iter = attributeSchemas.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = (AttributeSchema)iter.next();
            String i18n = as.getI18NKey();
            if (i18n != null && i18n.trim().length() != 0) continue;
            iter.remove();
        }
    }

    public static void filterAttributes(Set attributeSchemas, String[] a) {
        PropertyXMLBuilderBase.removeAttributeSchemaWithoutI18nKey(attributeSchemas);
        int size = a.length;
        Iterator iter = attributeSchemas.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = (AttributeSchema)iter.next();
            String any = as.getAny();
            boolean found = false;
            for (int x = 0; x < size && !found; ++x) {
                found = PropertyXMLBuilderBase.hasAnyAttribute(any, a[x]);
            }
            if (found && PropertyXMLBuilderBase.getTagClassName(as) != null) continue;
            iter.remove();
        }
    }

    public static boolean hasAnyAttribute(String any, String attribute) {
        boolean has = false;
        if (any != null && any.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(any, "|");
            while (st.hasMoreTokens() && !has) {
                String token = st.nextToken();
                has = token.equals(attribute);
            }
        }
        return has;
    }

    public static String swapXMLProperty(String xml, String propertyName, String propertyXML) {
        int end;
        String ccHead = "<cc name=\"" + propertyName + "\"";
        int start = xml.indexOf(ccHead);
        if (start != -1 && (end = xml.indexOf("</property>", start = xml.lastIndexOf("<property ", start))) != -1) {
            xml = xml.substring(0, start) + propertyXML + xml.substring(end + 11);
        }
        return xml;
    }

    public static String insertXML(String xml, String insertXML, String marker, boolean afterMarker) {
        int idx = xml.indexOf(marker);
        if (idx != -1) {
            int start = afterMarker ? idx + marker.length() : idx;
            xml = xml.substring(0, start) + insertXML + xml.substring(start);
        }
        return xml;
    }

    public static String insertXML(String xml, String insertXML, String marker) {
        int idx = xml.indexOf(marker);
        if (idx != -1) {
            xml = xml.substring(0, idx) + insertXML + xml.substring(idx + marker.length() + 1);
        }
        return xml;
    }

    public boolean isSubConfigSupported() {
        return this.supportSubConfig;
    }

    public void setSupportSubConfig(boolean state) {
        this.supportSubConfig = state;
    }

    public void setViewBeanName(String name) {
        this.viewBeanName = name;
    }

    public String getViewBeanName() {
        return this.viewBeanName;
    }

    protected void getServiceResourceBundle() {
        String rbName = this.svcSchemaManager.getI18NFileName();
        try {
            this.serviceBundle = ResourceBundle.getBundle(rbName, this.model.getUserLocale());
        }
        catch (MissingResourceException e) {
            debug.warning("PropertyXMLBuilderBase.getServiceResourceBundle " + e.getMessage());
        }
    }

    public Set getAttributeSchemas() {
        Collection values = this.mapTypeToAttributeSchema.values();
        HashSet set = new HashSet();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            set.addAll((Set)iter.next());
        }
        return set;
    }

    protected void getServiceResourceBundle(ServiceSchema ss) {
        String rbName = ss.getI18NFileName();
        try {
            this.serviceBundle = ResourceBundle.getBundle(rbName, this.model.getUserLocale());
        }
        catch (MissingResourceException e) {
            debug.warning("PropertyXMLBuilderBase.getServiceResourceBundle", (Throwable)e);
        }
    }

    protected void buildReadonlyXML(AttributeSchema as, StringBuffer xml, AMModel model, ResourceBundle serviceBundle) {
        String name = this.getAttributeNameForPropertyXML(as);
        xml.append("<property >\n");
        this.addLabel(as, xml, serviceBundle);
        Object[] param = new Object[]{name};
        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\">\n", param));
        xml.append("</cc>\n");
        String tagClassName = PropertyXMLBuilderBase.getTagClassName(as);
        if (tagClassName.equals("com.sun.web.ui.taglib.html.CCPasswordTag")) {
            param[0] = name + "__AM_PASSWORD_TAG__";
            xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\">\n", param));
            xml.append("</cc>\n");
        }
        this.getInlineHelp(as, xml, serviceBundle);
        xml.append("</property>\n");
    }

    protected void buildAttributeSchemaTypeXML(AttributeSchema as, StringBuffer xml, AMModel model, ResourceBundle serviceBundle) {
        String tagClassName = PropertyXMLBuilderBase.getTagClassName(as);
        if (tagClassName != null) {
            boolean listTyped;
            String name = this.getAttributeNameForPropertyXML(as);
            boolean editableList = tagClassName.equals("com.sun.web.ui.taglib.editablelist.CCEditableListTag");
            boolean orderedList = tagClassName.equals("com.sun.identity.console.ui.taglib.CCOrderedListTag");
            boolean unorderedList = tagClassName.equals("com.sun.identity.console.ui.taglib.CCUnOrderedListTag");
            boolean mapList = tagClassName.equals("com.sun.identity.console.ui.taglib.CCMapListTag");
            boolean globalMapList = tagClassName.equals("com.sun.identity.console.ui.taglib.CCGlobalMapListTag");
            AttributeSchema.Type type = as.getType();
            AttributeSchema.UIType uitype = as.getUIType();
            boolean addremovelist = type.equals(AttributeSchema.Type.MULTIPLE_CHOICE) && uitype != null && uitype.equals(AttributeSchema.UIType.ADDREMOVELIST);
            boolean bl = listTyped = editableList || orderedList || unorderedList || mapList || globalMapList || addremovelist;
            if (listTyped) {
                xml.append("<subsection name=\"dummy\" defaultValue=\"\">");
            }
            if (PropertyXMLBuilderBase.needRequiredTag(as)) {
                xml.append("<property required=\"true\">\n");
            } else {
                xml.append("<property >\n");
            }
            this.addLabel(as, xml, serviceBundle);
            if (addremovelist) {
                xml.append("<ccgroup>").append("<property >\n");
                this.appendAddRemoveListComponent(as, xml, serviceBundle);
                addremovelist = true;
            } else {
                if (tagClassName.equals("com.sun.web.ui.taglib.html.CCButtonTag")) {
                    String editString = model.getLocalizedString("label.edit");
                    Object[] pLink = new Object[]{"'" + name + "'", editString};
                    xml.append(MessageFormat.format("<cc name=\"dynLink\" tagclass=\"com.sun.web.ui.taglib.html.CCButtonTag\">\n<attribute name=\"onClick\" value=\"openNewWindow(); submitButton(this, {0});\" /><attribute name=\"defaultValue\" value=\"{1}\" />\n", pLink));
                } else if (tagClassName.equals("com.sun.web.ui.taglib.html.CCHrefTag")) {
                    String editString = model.getLocalizedString("label.edit");
                    Object[] pLink = new Object[]{"attrname=" + name + "&amp;" + "propviewbean" + "=" + as.getPropertiesViewBeanURL(), "linkLabel" + name, editString};
                    xml.append(MessageFormat.format("<cc name=\"dynLink\" tagclass=\"com.sun.web.ui.taglib.html.CCHrefTag\">\n<attribute name=\"onClick\" value=\"openNewWindow();\" /><attribute name=\"queryParams\" value=\"{0}\" /><attribute name=\"target\" value=\"newwindow\" /><cc name=\"{1}\" tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\">\n<attribute name=\"defaultValue\" value=\"{2}\" /></cc>\n", pLink));
                } else if (tagClassName.equals("com.sun.web.ui.taglib.html.CCCheckBoxTag")) {
                    Object[] param = new Object[]{name, tagClassName, model.getLocalizedString("label.Enable")};
                    xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"{1}\">\n<attribute name=\"label\" value=\"{2}\"/>\n", param));
                } else if (listTyped) {
                    Object[] param = new Object[]{name, model.getLocalizedString("label.current.value"), model.getLocalizedString("label.new.value")};
                    xml.append("<ccgroup>").append("<property >\n");
                    if (editableList) {
                        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.web.ui.taglib.editablelist.CCEditableListTag\"> <attribute name=\"listboxLabel\" value=\"{1}\" /><attribute name=\"textboxLabel\" value=\"{2}\" />", param));
                    } else if (orderedList) {
                        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.identity.console.ui.taglib.CCOrderedListTag\">", param));
                    } else if (unorderedList) {
                        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.identity.console.ui.taglib.CCUnOrderedListTag\"> <attribute name=\"listboxLabel\" value=\"{1}\" /><attribute name=\"textboxLabel\" value=\"{2}\" />", param));
                    } else if (mapList) {
                        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.identity.console.ui.taglib.CCMapListTag\"> <attribute name=\"listboxLabel\" value=\"{1}\" /><attribute name=\"textboxLabel\" value=\"{2}\" />", param));
                    } else if (globalMapList) {
                        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.identity.console.ui.taglib.CCGlobalMapListTag\"> <attribute name=\"listboxLabel\" value=\"{1}\" /><attribute name=\"textboxLabel\" value=\"{2}\" />", param));
                    }
                } else {
                    Object[] param = new Object[]{name, tagClassName};
                    xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"{1}\">\n", param));
                    if (tagClassName.equals("com.sun.web.ui.taglib.html.CCTextFieldTag")) {
                        Object[] pSize = new Object[]{this.getStringFieldSize(as)};
                        xml.append(MessageFormat.format("<attribute name=\"size\" value=\"{0}\" />\n", pSize));
                        xml.append("<attribute name=\"localizeDisplayFieldValue\" value=\"false\" />\n");
                        xml.append("<attribute name=\"autoSubmit\" value=\"false\" />\n");
                    } else if (tagClassName.equals("com.sun.web.ui.taglib.html.CCTextAreaTag")) {
                        xml.append("<attribute name=\"localizeDisplayFieldValue\" value=\"false\" />\n");
                    } else if (tagClassName.equals("com.sun.web.ui.taglib.html.CCPasswordTag")) {
                        xml.append("<attribute name=\"autoSubmit\" value=\"false\" />\n");
                    }
                    this.appendChoiceValues(as, xml, model, serviceBundle);
                }
                xml.append("</cc>\n");
            }
            if (type.equals(AttributeSchema.Type.MULTIPLE_CHOICE) && (uitype == null || !uitype.equals(AttributeSchema.UIType.ADDREMOVELIST))) {
                this.appendMultipleChoiceCheckboxes(as, xml, serviceBundle);
            }
            this.appendDateMarker(as, xml);
            this.getInlineHelp(as, xml, serviceBundle);
            xml.append("</property>\n");
            if (listTyped) {
                xml.append("</ccgroup>").append("&lt;p>").append("</property>\n").append("</subsection>");
            }
        }
    }

    private String getStringFieldSize(AttributeSchema as) {
        String size = "";
        AttributeSchema.Syntax syntax = as.getSyntax();
        String valSyntax = (String)mapSyntaxToName.get(syntax);
        if (valSyntax != null) {
            try {
                if (valSyntax.equals("number_range")) {
                    String tmp = as.getEndRange();
                    size = Integer.toString(tmp.length());
                } else {
                    size = properties.getString("textfield." + valSyntax);
                }
            }
            catch (MissingResourceException e) {
                size = properties.getString("textfield.default");
            }
        }
        return size;
    }

    private void appendDateMarker(AttributeSchema as, StringBuffer xml) {
        AttributeSchema.Syntax syntax = as.getSyntax();
        if (syntax.equals(AttributeSchema.Syntax.DATE)) {
            Object[] arg = new Object[]{as.getName()};
            xml.append(MessageFormat.format("<cc name=\"dateMarker{0}\" tagclass=\"com.sun.web.ui.taglib.html.CCHiddenTag\"><attribute name=\"defaultValue\" value=\"true\" /></cc>", arg));
        }
    }

    protected void buildConfirmPasswordXML(AttributeSchema as, StringBuffer xml, AMModel model, ResourceBundle serviceBundle) {
        String name = this.getAttributeNameForPropertyXML(as);
        if (PropertyXMLBuilderBase.needRequiredTag(as)) {
            xml.append("<property required=\"true\">\n");
        } else {
            xml.append("<property >\n");
        }
        this.addPasswordConfirmLabel(as, xml, serviceBundle, model);
        Object[] param = new Object[]{name};
        xml.append(MessageFormat.format("<cc name=\"{0}_confirm\" tagclass=\"com.sun.web.ui.taglib.html.CCPasswordTag\">\n", param));
        xml.append("</cc>\n");
        xml.append("</property>\n");
    }

    private void addLabel(AttributeSchema as, StringBuffer xml, ResourceBundle serviceBundle) {
        String name = this.getAttributeNameForPropertyXML(as);
        Object[] params = new Object[]{name, this.escapeSpecialChars(Locale.getString((ResourceBundle)serviceBundle, (String)as.getI18NKey(), (Debug)debug)), name};
        xml.append(MessageFormat.format("<label name=\"lbl{0}\" defaultValue=\"{1}\" labelFor=\"{2}\" />\n", params));
    }

    private void addPasswordConfirmLabel(AttributeSchema as, StringBuffer xml, ResourceBundle serviceBundle, AMModel model) {
        String name = as.getName();
        Object[] labelParam = new Object[]{this.escapeSpecialChars(Locale.getString((ResourceBundle)serviceBundle, (String)as.getI18NKey(), (Debug)debug))};
        String label = MessageFormat.format(model.getLocalizedString("password.confirm.label"), labelParam);
        Object[] params = new Object[]{name, label, name};
        xml.append(MessageFormat.format("<label name=\"lbl{0}\" defaultValue=\"{1}\" labelFor=\"{2}\" />\n", params));
    }

    private void getInlineHelp(AttributeSchema as, StringBuffer xml, ResourceBundle serviceBundle) {
        String i18nKey = as.getI18NKey();
        if (i18nKey == null || i18nKey.length() < 1) {
            return;
        }
        try {
            String helpString = serviceBundle.getString(i18nKey + ".help");
            Object[] params = new Object[]{as.getName(), this.escapeSpecialChars(helpString)};
            xml.append(MessageFormat.format(" <fieldhelp name=\"help{0}\" defaultValue=\"{1}\" />\n", params));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }

    public String escapeSpecialChars(String text) {
        String escaped = null;
        if (text != null && text.trim().length() > 0) {
            StringBuffer sb = new StringBuffer(text.length());
            int len = text.length();
            block6: for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '&': {
                        sb.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            escaped = sb.toString();
        } else {
            escaped = text;
        }
        return escaped;
    }

    private void appendChoiceValues(AttributeSchema as, StringBuffer xml, AMModel model, ResourceBundle serviceBundle) {
        AttributeSchema.Type type = as.getType();
        if (type.equals(AttributeSchema.Type.SINGLE)) {
            AttributeSchema.UIType uitype = as.getUIType();
            if (uitype != null && uitype.equals(AttributeSchema.UIType.RADIO)) {
                Object[] p1 = new Object[]{model.getLocalizedString("label.Yes"), "true"};
                xml.append(MessageFormat.format("<option label=\"{0}\" value=\"{1}\" />\n", p1));
                Object[] p2 = new Object[]{model.getLocalizedString("label.No"), "false"};
                xml.append(MessageFormat.format("<option label=\"{0}\" value=\"{1}\" />\n", p2));
            }
        } else if (type.equals(AttributeSchema.Type.SINGLE_CHOICE)) {
            this.appendChoiceValueForSelectableComponent(as, xml, serviceBundle);
        }
    }

    private void appendMultipleChoiceCheckboxes(AttributeSchema as, StringBuffer xml, ResourceBundle serviceBundle) {
        HashMap map = new HashMap();
        Set sorted = this.getSortedChoiceValues(as, map, serviceBundle);
        String name = this.getAttributeNameForPropertyXML(as);
        Object[] nameArg = new Object[]{name};
        xml.append(MessageFormat.format("<cc name=\"__DYN_GUI_MULTIPLE_LIST_CHECKBOX_MARKER_{0}\" tagclass=\"com.sun.web.ui.taglib.html.CCHiddenTag\"><attribute name=\"defaultValue\" value=\"true\" /></cc>", nameArg));
        for (String localizedName : sorted) {
            Object[] params = new Object[]{name, (String)map.get(localizedName), localizedName};
            xml.append(MessageFormat.format("<cc name=\"__DYN_GUI_MULTIPLE_LIST_CHECKBOX_{0}_{1}\" tagclass=\"com.sun.web.ui.taglib.html.CCCheckBoxTag\"><attribute name=\"label\" value=\"{2}\" /></cc><cc name=\"multiplelistsep\" tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\"><attribute name=\"defaultValue\" value=\"&lt;br>\" /><attribute name=\"escape\" value=\"false\"/></cc>", params));
        }
    }

    private void appendAddRemoveListComponent(AttributeSchema as, StringBuffer xml, ResourceBundle serviceBundle) {
        HashMap map = new HashMap();
        Set sorted = this.getSortedChoiceValues(as, map, serviceBundle);
        String name = as.getName();
        Object[] nameArg = new Object[]{name};
        xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"com.sun.web.ui.taglib.addremove.CCAddRemoveTag\"><attribute name=\"showMoveUpDownButtons\" value=\"false\" /><attribute name=\"labelLocation\" value=\"LABEL_ABOVE\" />", nameArg));
        for (String localizedName : sorted) {
            Object[] params = new Object[]{localizedName, (String)map.get(localizedName)};
            xml.append(MessageFormat.format("<option label=\"{0}\" value=\"{1}\" />\n", params));
        }
        xml.append("</cc>\n");
    }

    public static String getMultipleChoiceCheck(String attrName, Set choices) {
        StringBuffer xml = new StringBuffer();
        TreeSet sorted = new TreeSet();
        if (choices != null && !choices.isEmpty()) {
            Iterator iter = choices.iterator();
            while (iter.hasNext()) {
                sorted.add(iter.next());
            }
            for (String choice : sorted) {
                Object[] params = new Object[]{attrName, choice, choice};
                xml.append(MessageFormat.format("<cc name=\"__DYN_GUI_MULTIPLE_LIST_CHECKBOX_{0}_{1}\" tagclass=\"com.sun.web.ui.taglib.html.CCCheckBoxTag\"><attribute name=\"label\" value=\"{2}\" /></cc><cc name=\"multiplelistsep\" tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\"><attribute name=\"defaultValue\" value=\"&lt;br>\" /><attribute name=\"escape\" value=\"false\"/></cc>", params));
            }
        }
        return xml.toString();
    }

    protected void setCurrentRealm(String value) {
        this.currentRealm = value;
    }

    protected String getCurrentRealm() {
        return this.currentRealm != null ? this.currentRealm : this.model.getLocationDN();
    }

    private Set getSortedChoiceValues(AttributeSchema as, Map values, ResourceBundle serviceBundle) {
        TreeSet<String> sorted = new TreeSet<String>();
        HashMap<String, String> tmp = new HashMap<String, String>(2);
        tmp.put("organization_name", this.getCurrentRealm());
        String[] choices = as.getChoiceValues(tmp);
        if (choices != null && choices.length > 0) {
            for (int i = 0; i < choices.length; ++i) {
                String val = choices[i];
                String i18nKey = as.getChoiceValueI18NKey(val);
                String localizedName = null;
                localizedName = i18nKey == null || i18nKey.trim().length() == 0 ? val : Locale.getString((ResourceBundle)serviceBundle, (String)i18nKey, (Debug)debug);
                values.put(localizedName, val);
                sorted.add(localizedName);
            }
        }
        return sorted;
    }

    private void appendChoiceValueForSelectableComponent(AttributeSchema as, StringBuffer xml, ResourceBundle serviceBundle) {
        HashMap map = new HashMap();
        boolean defaultValue = false;
        Set sorted = this.getSortedChoiceValues(as, map, serviceBundle);
        for (String localizedName : sorted) {
            String value = (String)map.get(localizedName);
            Object[] params = new Object[]{localizedName, value};
            if (!defaultValue) {
                xml.append("<attribute name=\"defaultValue\" value=\"").append(value).append("\" />");
                defaultValue = true;
            }
            xml.append(MessageFormat.format("<option label=\"{0}\" value=\"{1}\" />\n", params));
        }
    }

    public static String removeSubSection(String original, String attribute, String insert) {
        int mark = original.indexOf(attribute);
        String start = original.substring(0, mark);
        int index = start.lastIndexOf("<subsection");
        if (index == -1) {
            return original;
        }
        start = start.substring(0, index);
        String end = original.substring(mark);
        index = end.indexOf("</subsection>") + 13;
        if (index == -1) {
            return original;
        }
        end = end.substring(index);
        return start + insert + end;
    }

    public static String prependXMLProperty(String xml, String propertyXML) {
        int idx = xml.indexOf("<propertysheet>\n");
        return xml.substring(0, idx += "<propertysheet>\n".length()) + propertyXML + xml.substring(idx);
    }

    public static String appendXMLProperty(String xml, String propertyXML) {
        int idx = xml.lastIndexOf("</section>\n");
        if (idx != -1) {
            xml = xml.substring(0, idx) + propertyXML + xml.substring(idx);
        }
        return xml;
    }

    public ServiceSchemaManager getServiceSchemaManager() {
        return this.svcSchemaManager;
    }

    protected void buildSchemaTypeXML(String schemaTypeName, Set attributeSchemas, StringBuffer xml, AMModel model, ResourceBundle serviceBundle, Set readonly) {
        String label = "lbl" + schemaTypeName.replace('.', '_');
        Object[] params = new Object[]{label, schemaTypeName};
        xml.append(MessageFormat.format("<section name=\"{0}\" defaultValue=\"{1}\">\n", params));
        ArrayList sorted = new ArrayList(attributeSchemas);
        Collections.sort(sorted, new AttributeSchemaComparator(null));
        for (AttributeSchema as : sorted) {
            if (this.allAttributesReadonly || readonly.contains(as.getName())) {
                this.buildReadonlyXML(as, xml, model, serviceBundle);
                continue;
            }
            this.buildAttributeSchemaTypeXML(as, xml, model, serviceBundle);
            String tagClassName = PropertyXMLBuilderBase.getTagClassName(as);
            if (!tagClassName.equals("com.sun.web.ui.taglib.html.CCPasswordTag")) continue;
            this.buildConfirmPasswordXML(as, xml, model, serviceBundle);
        }
        xml.append("</section>\n");
    }

    public static String formPropertySheetXML(String properties) {
        return PropertyXMLBuilderBase.formPropertySheetXML(properties, false);
    }

    public static String formPropertySheetXML(String properties, boolean addSection) {
        return addSection ? PropertyXMLBuilderBase.getXMLDefinitionHeader() + "<propertysheet>\n" + "<section name=\"dummy\" defaultValue=\"blank.header\" >" + properties + "</section>\n" + "</propertysheet>\n" : PropertyXMLBuilderBase.getXMLDefinitionHeader() + "<propertysheet>\n" + properties + "</propertysheet>\n";
    }

    public void setAllAttributeReadOnly(boolean flag) {
        this.allAttributesReadonly = flag;
    }

    protected String getAttributeNameForPropertyXML(AttributeSchema as) {
        return as.getName();
    }

    protected String tagSwap(String template, String tag, String value) {
        int valLen = value.length();
        int tagLen = tag.length();
        int idx = template.indexOf(tag);
        while (idx != -1) {
            template = template.substring(0, idx) + value + template.substring(idx + tagLen);
            idx = template.indexOf(tag, idx + valLen);
        }
        return template;
    }

    private static boolean needRequiredTag(AttributeSchema as) {
        return PropertyXMLBuilderBase.hasAnyAttribute(as.getAny(), "required") || as.getValidator() != null && as.getValidator().equals("RequiredValueValidator");
    }

    private static void getDefaultEncoding() {
        platformDefaultEncoding = Charset.defaultCharset().toString();
    }

    public static String getXMLDefinitionHeader() {
        Object[] param = new Object[]{platformDefaultEncoding};
        return MessageFormat.format("<?xml version=\"1.0\" encoding=\"{0}\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n", param);
    }

    static {
        PropertyXMLBuilderBase.getDefaultEncoding();
        mapSchemaTypeToName.put(SchemaType.GLOBAL, "schemaType.global");
        mapSchemaTypeToName.put(SchemaType.ORGANIZATION, "schemaType.organization");
        mapSchemaTypeToName.put(SchemaType.USER, "schemaType.user");
        mapSchemaTypeToName.put(SchemaType.DYNAMIC, "schemaType.dynamic");
        orderDisplaySchemaType.add(SchemaType.GLOBAL);
        orderDisplaySchemaType.add(SchemaType.ORGANIZATION);
        orderDisplaySchemaType.add(SchemaType.USER);
        orderDisplaySchemaType.add(SchemaType.DYNAMIC);
        mapUITypeToName.put(AttributeSchema.UIType.BUTTON, "button");
        mapUITypeToName.put(AttributeSchema.UIType.LINK, "link");
        mapUITypeToName.put(AttributeSchema.UIType.ADDREMOVELIST, "addremove");
        mapUITypeToName.put(AttributeSchema.UIType.NAME_VALUE_LIST, "namevaluelist");
        mapUITypeToName.put(AttributeSchema.UIType.RADIO, "radio");
        mapUITypeToName.put(AttributeSchema.UIType.UNORDEREDLIST, "unorderedlist");
        mapUITypeToName.put(AttributeSchema.UIType.ORDEREDLIST, "orderedlist");
        mapUITypeToName.put(AttributeSchema.UIType.MAPLIST, "maplist");
        mapUITypeToName.put(AttributeSchema.UIType.GLOBALMAPLIST, "globalmaplist");
        mapTypeToName.put(AttributeSchema.Type.LIST, "list");
        mapTypeToName.put(AttributeSchema.Type.MULTIPLE_CHOICE, "multiple_choice");
        mapTypeToName.put(AttributeSchema.Type.SINGLE_CHOICE, "single_choice");
        mapTypeToName.put(AttributeSchema.Type.SINGLE, "single");
        mapSyntaxToName.put(AttributeSchema.Syntax.BOOLEAN, "boolean");
        mapSyntaxToName.put(AttributeSchema.Syntax.PASSWORD, "password");
        mapSyntaxToName.put(AttributeSchema.Syntax.ENCRYPTED_PASSWORD, "password");
        mapSyntaxToName.put(AttributeSchema.Syntax.PARAGRAPH, "paragraph");
        mapSyntaxToName.put(AttributeSchema.Syntax.XML, "xml");
        mapSyntaxToName.put(AttributeSchema.Syntax.STRING, "string");
        mapSyntaxToName.put(AttributeSchema.Syntax.NUMERIC, "numeric");
        mapSyntaxToName.put(AttributeSchema.Syntax.NUMBER_RANGE, "number_range");
        mapSyntaxToName.put(AttributeSchema.Syntax.NUMBER, "number");
        mapSyntaxToName.put(AttributeSchema.Syntax.DN, "dn");
        mapSyntaxToName.put(AttributeSchema.Syntax.URL, "url");
    }
}

