/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.service.SMG11NViewBean;
import com.sun.identity.console.service.model.LocaleSupportedCharsetsEntry;
import com.sun.identity.console.service.model.SMG11NModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class G11NSupportedCharsetsViewBeanBase
extends AMPrimaryMastHeadViewBean {
    private static final String PGTITLE = "pgtitle";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    static final String ATTR_LOCALE = "locale";
    static final String ATTR_CHARSETS = "charsets";
    protected CCPageTitleModel ptModel;
    protected AMPropertySheetModel propertySheetModel;

    public G11NSupportedCharsetsViewBeanBase(String pageName, String defaultDisplayURL) {
        super(pageName);
        this.setDefaultDisplayURL(defaultDisplayURL);
    }

    protected void initialize() {
        if (!this.initialized) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE, CCPageTitle.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name))));
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setPageTitleText(this.getPageTitleText());
        this.ptModel.setValue("button1", (Object)this.getButtonlLabel());
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    protected abstract String getButtonlLabel();

    protected abstract String getPageTitleText();

    protected void createPropertyModel() {
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyG11NSupportedCharsets.xml"));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        SMG11NModelImpl model = null;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        try {
            model = new SMG11NModelImpl(req, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return model;
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        SMG11NViewBean vb = (SMG11NViewBean)this.getViewBean(SMG11NViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected void setValues(String value) {
        LocaleSupportedCharsetsEntry entry = new LocaleSupportedCharsetsEntry(value);
        this.propertySheetModel.setValue(ATTR_LOCALE, entry.strLocale);
        this.propertySheetModel.setValue(ATTR_CHARSETS, entry.strCharsets);
    }

    private String getValues(Map map) {
        String locale = (String)this.propertySheetModel.getValue(ATTR_LOCALE);
        String charsets = (String)this.propertySheetModel.getValue(ATTR_CHARSETS);
        locale = locale.trim();
        charsets = charsets.trim();
        map.put(ATTR_LOCALE, locale);
        map.put(ATTR_CHARSETS, charsets);
        String errorMsg = null;
        if (locale.length() == 0) {
            errorMsg = "globalization.service.SupportedCharsets.missing.locale.message";
        } else if (charsets.length() == 0) {
            errorMsg = "globalization.service.SupportedCharsets.missing.charsets.message";
        }
        return errorMsg;
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        HashMap values = new HashMap(6);
        String errorMsg = this.getValues(values);
        if (errorMsg != null) {
            this.setInlineAlertMessage("error", "message.error", errorMsg);
            this.forwardTo();
        } else {
            this.handleButton1Request(values);
        }
    }

    protected abstract void handleButton1Request(Map var1);
}

