/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.service.ServerEditViewBeanBase;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.web.ui.view.html.CCDropDownMenu;
import java.util.Set;

public class ServerEditGeneralViewBean
extends ServerEditViewBeanBase {
    private static final String PARENT_SITE = "singleChoiceSite";
    private static final String DEFAULT_DISPLAY_URL = "/console/service/ServerEditGeneral.jsp";

    public ServerEditGeneralViewBean() {
        super("ServerEditGeneral", DEFAULT_DISPLAY_URL);
    }

    protected String getPropertyXML() {
        return "com/sun/identity/console/propertyServerEditGeneral.xml";
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            this.getParentSites(serverName, model);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void getParentSites(String serverName, ServerSiteModel model) throws AMConsoleException {
        Set sites = model.getSiteNames();
        OptionList choices = this.createOptionList(sites);
        choices.add(0, new Option(model.getLocalizedString("none.site"), ""));
        String parentSite = model.getServerSite(serverName);
        if (parentSite == null) {
            parentSite = "";
        }
        CCDropDownMenu cb = (CCDropDownMenu)this.getChild(PARENT_SITE);
        cb.resetStateData();
        cb.setValue((Object)parentSite);
        cb.setOptions(choices);
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        String parentSite = serverName.equals("server-default") ? null : (String)this.getDisplayFieldValue(PARENT_SITE);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            model.modifyServer(serverName, parentSite, this.getAttributeValues());
            this.setInlineAlertMessage("info", "message.information", "serverconfig.updated");
        }
        catch (UnknownPropertyNameException e) {
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    protected String removeParentSiteBlob(String xml) {
        int idx;
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        if (serverName.equals("server-default") && (idx = xml.indexOf(PARENT_SITE)) != -1) {
            int start = xml.lastIndexOf("<section name=\"secSite\" defaultValue=", idx);
            int end = xml.indexOf("</section>", start);
            xml = xml.substring(0, start) + xml.substring(end + 11);
        }
        return xml;
    }
}

