/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPostViewBean;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.service.model.SubConfigModel;
import com.sun.identity.console.service.model.SubConfigModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SubConfigAddViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/service/SubConfigAdd.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String ATTR_SUBCONFIG_NAME = "tfSubConfigName";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private boolean init;
    private boolean submitCycle;

    public SubConfigAddViewBean() {
        super("SubConfigAdd");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String serviceName;
        if (!this.init && (serviceName = (String)this.getPageSessionAttribute("serviceName")) != null && serviceName.trim().length() > 0) {
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
            this.init = true;
        }
    }

    protected void registerChildren() {
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.add");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        try {
            String schemaName = (String)this.getPageSessionAttribute("subSchemaName");
            SubConfigModel model = (SubConfigModel)this.getModel();
            this.propertySheetModel = new AMPropertySheetModel(model.getAddConfigPropertyXML(schemaName));
            this.propertySheetModel.clear();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected AMModel getModelInternal() {
        SubConfigModelImpl model = null;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        List parentIds = (List)this.getPageSessionAttribute("subConfigIds");
        String parentId = AMAdminUtils.getString(parentIds, "/", true);
        try {
            model = new SubConfigModelImpl(req, serviceName, parentId, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            debug.error("SubConfigAddViewBean.getModelInternal", (Throwable)e);
        }
        return model;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        Set subconfigNames;
        super.beginDisplay(event);
        SubConfigModel model = (SubConfigModel)this.getModel();
        String schemaName = (String)this.getPageSessionAttribute("subSchemaName");
        if (!this.submitCycle) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            this.propertySheetModel.clear();
            try {
                ps.setAttributeValues(model.getServiceSchemaDefaultValues(schemaName), model);
            }
            catch (AMConsoleException a) {
                this.setInlineAlertMessage("warning", "message.warning", "noproperties.message");
            }
        }
        if ((subconfigNames = model.getSelectableConfigNames(schemaName)) != null && !subconfigNames.isEmpty()) {
            CCDropDownMenu menu = (CCDropDownMenu)this.getChild(ATTR_SUBCONFIG_NAME);
            OptionList optList = this.createOptionList(subconfigNames);
            menu.setOptions(optList);
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.backToProfileViewBean();
    }

    private void backToProfileViewBean() {
        List urls = (List)this.getPageSessionAttribute("subConfigProfileViewBeans");
        String url = (String)urls.remove(0);
        AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.setTargetViewBeanURL(url);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        String subConfigName = (String)this.getDisplayFieldValue(ATTR_SUBCONFIG_NAME);
        SubConfigModel model = (SubConfigModel)this.getModel();
        try {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            String schemaName = (String)this.getPageSessionAttribute("subSchemaName");
            Map values = ps.getAttributeValues(model.getAttributeNames(schemaName));
            model.createSubConfig(subConfigName, schemaName, values);
            this.backToProfileViewBean();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.services.subconfig.add";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

