/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPostViewBean;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.base.model.SMSubConfig;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.service.SubConfigAddViewBean;
import com.sun.identity.console.service.SubSchemaTypeSelectViewBean;
import com.sun.identity.console.service.model.SubConfigModel;
import com.sun.identity.console.service.model.SubConfigModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SubConfigEditViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/service/SubConfigEdit.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String ATTR_SUBCONFIG_NAME = "tfSubConfigName";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private boolean init;
    private boolean submitCycle;
    private boolean populatedSubConfigTable;

    public SubConfigEditViewBean() {
        super("SubConfigEdit");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String serviceName;
        if (!this.init && (serviceName = (String)this.getPageSessionAttribute("serviceName")) != null && serviceName.trim().length() > 0) {
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
            this.init = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild("szCache", SerializedField.class);
    }

    protected View createChild(String name) {
        if (!this.populatedSubConfigTable && name.equals("tblSubConfig")) {
            this.populatedSubConfigTable = true;
            SubConfigModel model = (SubConfigModel)this.getModel();
            if (model.hasGlobalSubSchema()) {
                SerializedField szCache = (SerializedField)this.getChild("szCache");
                this.populateTableModel((List)szCache.getSerializedObj());
            }
        }
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    private void populateTableModel(List subconfig) {
        CCActionTable tbl = (CCActionTable)this.getChild("tblSubConfig");
        CCActionTableModel tblModel = (CCActionTableModel)tbl.getModel();
        tblModel.clearAll();
        if (subconfig != null) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            ArrayList<SMSubConfig> cache = new ArrayList<SMSubConfig>(subconfig.size());
            if (!subconfig.isEmpty()) {
                tblModel.clearAll();
                boolean firstEntry = true;
                Iterator iter = subconfig.iterator();
                while (iter.hasNext()) {
                    if (firstEntry) {
                        firstEntry = false;
                    } else {
                        tblModel.appendRow();
                    }
                    SMSubConfig conf = (SMSubConfig)iter.next();
                    tblModel.setValue("tblSubConfigDataName", (Object)conf.getName());
                    tblModel.setValue("tblSubConfigHrefName", (Object)conf.getName());
                    tblModel.setValue("tblSubConfigDataType", (Object)conf.getType());
                    cache.add(conf);
                }
            }
            szCache.setValue(cache);
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        try {
            SubConfigModel model = (SubConfigModel)this.getModel();
            this.propertySheetModel = new AMPropertySheetModel(model.getEditConfigPropertyXML(((Object)((Object)this)).getClass().getName()));
            this.propertySheetModel.clear();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected AMModel getModelInternal() {
        SubConfigModelImpl model = null;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        String parentId = this.getParentId();
        try {
            model = new SubConfigModelImpl(req, serviceName, parentId, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            // empty catch block
        }
        return model;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        SubConfigModel model = (SubConfigModel)this.getModel();
        if (!this.submitCycle) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            this.propertySheetModel.clear();
            try {
                ps.setAttributeValues(model.getSubConfigAttributeValues(), model);
            }
            catch (AMConsoleException a) {
                this.setInlineAlertMessage("warning", "message.warning", "noproperties.message");
            }
        }
        if (model.hasGlobalSubSchema()) {
            if (!this.submitCycle) {
                this.populateTableModel(model.getSubConfigurations());
            }
            this.resetButtonState("tblSubConfigButtonDelete");
            Map createable = model.getCreateableSubSchemaNames();
            if (createable.isEmpty()) {
                this.resetButtonState("tblSubConfigButtonAdd");
            }
        }
        List parentIds = (List)this.getPageSessionAttribute("subConfigIds");
        String parentId = (String)parentIds.get(0);
        Object[] param = new String[]{parentId};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString("page.title.services.edit.subconfig"), param));
    }

    private String getParentId() {
        List parentIds = (List)this.getPageSessionAttribute("subConfigIds");
        List escapeParentIds = AMAdminUtils.replaceString(parentIds, "%", "%25");
        escapeParentIds = AMAdminUtils.replaceString(escapeParentIds, "/", "%2F");
        return AMAdminUtils.getString(escapeParentIds, "/", true);
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backToProfileViewBean();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    private void backToProfileViewBean() {
        List urls = (List)this.getPageSessionAttribute("subConfigProfileViewBeans");
        String url = (String)urls.remove(0);
        List parentIds = (List)this.getPageSessionAttribute("subConfigIds");
        parentIds.remove(0);
        AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.setTargetViewBeanURL(url);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        SubConfigModel model = (SubConfigModel)this.getModel();
        AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        try {
            Map orig = model.getSubConfigAttributeValues();
            Map values = ps.getAttributeValues(orig, true, true, model);
            model.setSubConfigAttributeValues(values);
            this.backToProfileViewBean();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    public void handleTblSubConfigButtonAddRequest(RequestInvocationEvent event) {
        SubConfigModel model = (SubConfigModel)this.getModel();
        Map createable = model.getCreateableSubSchemaNames();
        if (!createable.isEmpty()) {
            if (createable.size() > 1) {
                SubSchemaTypeSelectViewBean vb = (SubSchemaTypeSelectViewBean)this.getViewBean(SubSchemaTypeSelectViewBean.class);
                this.addViewBeanClassToPageSession();
                this.unlockPageTrail();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            } else {
                String subSchema = (String)createable.keySet().iterator().next();
                this.setPageSessionAttribute("subSchemaName", (Serializable)((Object)subSchema));
                SubConfigAddViewBean vb = (SubConfigAddViewBean)this.getViewBean(SubConfigAddViewBean.class);
                this.addViewBeanClassToPageSession();
                this.unlockPageTrail();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
        } else {
            this.forwardTo();
        }
    }

    private void addViewBeanClassToPageSession() {
        ArrayList<String> urls = (ArrayList<String>)this.getPageSessionAttribute("subConfigProfileViewBeans");
        if (urls == null) {
            urls = new ArrayList<String>();
            this.setPageSessionAttribute("subConfigProfileViewBeans", urls);
        }
        urls.add(0, "../service/SubConfigEdit.jsp");
    }

    public void handleTblSubConfigButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        CCActionTable tbl = (CCActionTable)this.getChild("tblSubConfig");
        tbl.restoreStateData();
        CCActionTableModel tblModel = (CCActionTableModel)tbl.getModel();
        Integer[] selected = tblModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            SMSubConfig sc = (SMSubConfig)list.get(selected[i]);
            names.add(sc.getName());
        }
        try {
            SubConfigModel model = (SubConfigModel)this.getModel();
            model.deleteSubConfigurations(names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "subconfig.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "subconfig.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.submitCycle = false;
        this.forwardTo();
    }

    public void handleTblSubConfigHrefNameRequest(RequestInvocationEvent event) {
        String configName = (String)this.getDisplayFieldValue("tblSubConfigHrefName");
        ArrayList<String> subConfigNames = (ArrayList<String>)this.getPageSessionAttribute("subConfigIds");
        if (subConfigNames == null) {
            subConfigNames = new ArrayList<String>();
            subConfigNames.add("/");
            this.setPageSessionAttribute("subConfigIds", subConfigNames);
        }
        subConfigNames.add(0, configName);
        this.addViewBeanClassToPageSession();
        AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.setTargetViewBeanURL("../service/SubConfigEdit");
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.services.subconfig.edit";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

