/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLookupCondition
implements EntitlementCondition {
    public static final String MACRO_USER = "$USER";
    public static final String MACRO_RESOURCE = "$RES";
    private String key;
    private String value;
    private String pConditionName = "";

    public AttributeLookupCondition() {
    }

    public AttributeLookupCondition(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.key = jo.optString("key");
            this.value = jo.optString("value");
            this.pConditionName = jo.optString("pConditionName");
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("AttributeLookupCondition.setState", (Throwable)e);
        }
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        String evalVal;
        String evalKey = null;
        int idxUserMacro = this.key.indexOf(MACRO_USER);
        if (idxUserMacro != -1) {
            String attrName = this.key.substring(MACRO_USER.length() + 1);
            evalKey = this.getAttributeFromSubject(subject, attrName);
        } else {
            evalKey = this.key;
        }
        String searchKey = this.value.replace(MACRO_RESOURCE, resourceName);
        Set<String> evalValues = environment.get(searchKey);
        String string = evalVal = evalValues == null || evalValues.isEmpty() ? null : evalValues.iterator().next();
        if (evalKey == null && evalVal != null) {
            return this.getFailedDecision(this.key, evalVal);
        }
        if (evalVal == null && evalKey != null) {
            return this.getFailedDecision(this.value, evalKey);
        }
        if (evalVal == null && evalKey == null) {
            return this.getFailedDecision(this.key, this.value);
        }
        return new ConditionDecision(evalValues.contains(evalKey), Collections.EMPTY_MAP);
    }

    private ConditionDecision getFailedDecision(String prefix, String suffix) {
        HashMap<String, Set<String>> advices = new HashMap<String, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        set.add(prefix + "=" + suffix);
        advices.put(this.getClass().getName(), set);
        return new ConditionDecision(false, advices);
    }

    private String getAttributeFromSubject(Subject subject, String attrName) {
        Set<Object> publicCreds = subject.getPublicCredentials();
        String attrValue = null;
        Iterator<Object> i = publicCreds.iterator();
        while (i.hasNext() && attrValue == null) {
            String v;
            Object o = i.next();
            if (!(o instanceof String) || !(v = (String)o).startsWith(attrName + "=")) continue;
            attrValue = v.substring(attrName.length() + 1);
        }
        return attrValue;
    }

    public String getKey() {
        return this.key;
    }

    public String getPConditionName() {
        return this.pConditionName;
    }

    public String getValue() {
        return this.value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPConditionName(String pConditionName) {
        this.pConditionName = pConditionName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("key", (Object)this.key);
        jo.put("value", (Object)this.value);
        jo.put("pConditionName", (Object)this.pConditionName);
        return jo;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AttributeLookupCondition object = (AttributeLookupCondition)obj;
        if (this.key == null ? object.key != null : !this.key.equals(object.key)) {
            return false;
        }
        if (this.value == null ? object.value != null : !this.value.equals(object.value)) {
            return false;
        }
        return !(this.pConditionName == null ? object.pConditionName != null : !this.pConditionName.equals(object.pConditionName));
    }

    public int hashCode() {
        int code = 0;
        if (this.key != null) {
            code += this.key.hashCode();
        }
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.pConditionName != null) {
            code += this.pConditionName.hashCode();
        }
        return code;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("AttributeLookupCondition.setState", (Throwable)e);
        }
        return s;
    }
}

