/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSNameCondition
implements EntitlementCondition {
    public static final String DNS_NAME = "DnsName";
    public static final String REQUEST_DNS_NAME = "requestDnsName";
    private String domainNameMask;
    private String pConditionName;

    public DNSNameCondition() {
    }

    public DNSNameCondition(String domainNameMask) {
        this.domainNameMask = domainNameMask.toLowerCase();
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.domainNameMask = jo.optString("domainNameMask");
            this.pConditionName = jo.optString("pConditionName");
        }
        catch (JSONException joe) {
            PrivilegeManager.debug.error("DNSNameCondition.setState", (Throwable)joe);
        }
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        boolean allowed = true;
        Set<String> reqDnsNames = environment.get(REQUEST_DNS_NAME);
        if (reqDnsNames != null && !reqDnsNames.isEmpty()) {
            Iterator<String> names = reqDnsNames.iterator();
            while (names.hasNext() && allowed) {
                allowed = this.isAllowedByDns(names.next());
            }
        }
        return new ConditionDecision(allowed, Collections.EMPTY_MAP);
    }

    private boolean isAllowedByDns(String dnsName) throws EntitlementException {
        boolean allowed = false;
        dnsName = dnsName.toLowerCase();
        if (this.domainNameMask.equals("*")) {
            allowed = true;
        } else {
            int starIndex = this.domainNameMask.indexOf("*");
            if (starIndex != -1) {
                String dnsWildSuffix = this.domainNameMask.substring(1);
                if (dnsName.endsWith(dnsWildSuffix)) {
                    allowed = true;
                }
            } else if (this.domainNameMask.equalsIgnoreCase(dnsName)) {
                allowed = true;
            }
        }
        return allowed;
    }

    public String getDomainNameMask() {
        return this.domainNameMask;
    }

    public void setDomainNameMask(String domainNameMask) {
        this.domainNameMask = domainNameMask.toLowerCase();
    }

    public String getPConditionName() {
        return this.pConditionName;
    }

    public void setPConditionName(String pConditionName) {
        this.pConditionName = pConditionName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("domainNameMask", (Object)this.domainNameMask);
        jo.put("pConditionName", (Object)this.pConditionName);
        return jo;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DNSNameCondition object = (DNSNameCondition)obj;
        if (this.getDomainNameMask() == null ? object.getDomainNameMask() != null : !this.domainNameMask.equals(object.getDomainNameMask())) {
            return false;
        }
        return !(this.getPConditionName() == null ? object.getPConditionName() != null : !this.pConditionName.equals(object.getPConditionName()));
    }

    public int hashCode() {
        int code = 0;
        if (this.domainNameMask != null) {
            code += this.domainNameMask.hashCode();
        }
        if (this.pConditionName != null) {
            code += this.pConditionName.hashCode();
        }
        return code;
    }

    public String toString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("DNSNameCondition.toString()", (Throwable)e);
        }
        return s;
    }
}

