/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalCondition
implements EntitlementCondition {
    private Set<EntitlementCondition> eConditions;
    private String pConditionName;

    public LogicalCondition() {
    }

    public LogicalCondition(Set<EntitlementCondition> eConditions) {
        this.setEConditions(eConditions);
    }

    public LogicalCondition(Set<EntitlementCondition> eConditions, String pConditionName) {
        this.pConditionName = pConditionName;
        this.setEConditions(eConditions);
    }

    @Override
    public void setState(String state) {
        try {
            JSONObject jo = new JSONObject(state);
            this.pConditionName = jo.has("pConditionName") ? jo.optString("pConditionName") : null;
            JSONArray memberConditions = jo.optJSONArray("memberECondition");
            if (memberConditions != null) {
                this.eConditions = new HashSet<EntitlementCondition>();
                int len = memberConditions.length();
                for (int i = 0; i < len; ++i) {
                    JSONObject memberCondition = memberConditions.getJSONObject(i);
                    String className = memberCondition.getString("className");
                    Class<?> cl = Class.forName(className);
                    EntitlementCondition ec = (EntitlementCondition)cl.newInstance();
                    ec.setState(memberCondition.getString("state"));
                    this.eConditions.add(ec);
                }
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("LogicalCondition.setState", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("LogicalCondition.setState", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("LogicalCondition.setState", (Throwable)ex);
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("LogicalCondition.setState", (Throwable)ex);
        }
    }

    @Override
    public String getState() {
        return this.toString();
    }

    @Override
    public abstract ConditionDecision evaluate(String var1, Subject var2, String var3, Map<String, Set<String>> var4) throws EntitlementException;

    public void setEConditions(Set<EntitlementCondition> eConditions) {
        this.eConditions = new HashSet<EntitlementCondition>();
        if (eConditions != null) {
            this.eConditions.addAll(eConditions);
        }
    }

    public Set<EntitlementCondition> getEConditions() {
        return this.eConditions;
    }

    public void setPConditionName(String pConditionName) {
        this.pConditionName = pConditionName;
    }

    public String getPConditionName() {
        return this.pConditionName;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("pConditionName", (Object)this.pConditionName);
        if (this.eConditions != null && !this.eConditions.isEmpty()) {
            for (EntitlementCondition eCondition : this.eConditions) {
                JSONObject subjo = new JSONObject();
                subjo.put("className", (Object)eCondition.getClass().getName());
                subjo.put("state", (Object)eCondition.getState());
                jo.append("memberECondition", (Object)subjo);
            }
        }
        return jo;
    }

    public String toString() {
        String s = null;
        try {
            JSONObject jo = this.toJSONObject();
            s = jo == null ? super.toString() : jo.toString(2);
        }
        catch (JSONException e) {
            PrivilegeManager.debug.error("LogicalCondition.toString()", (Throwable)e);
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        LogicalCondition object = (LogicalCondition)obj;
        if (this.eConditions == null) {
            if (object.getEConditions() != null) {
                return false;
            }
        } else {
            if (object.getEConditions() == null) {
                return false;
            }
            if (!this.eConditions.containsAll(object.getEConditions())) {
                equalled = false;
            } else if (!object.getEConditions().containsAll(this.eConditions)) {
                return false;
            }
        }
        if (this.pConditionName == null ? object.getPConditionName() != null : !this.pConditionName.equals(object.getPConditionName())) {
            return false;
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.eConditions != null) {
            for (EntitlementCondition eCondition : this.eConditions) {
                code += eCondition.hashCode();
            }
        }
        if (this.pConditionName != null) {
            code += this.pConditionName.hashCode();
        }
        return code;
    }
}

