/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.NoSubject;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.PrivilegeType;
import com.sun.identity.entitlement.ResourceAttribute;
import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.SubjectDecision;
import com.sun.identity.entitlement.util.JSONUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Privilege
implements IPrivilege {
    public static final String CREATED_BY_ATTRIBUTE = "createdby";
    public static final String LAST_MODIFIED_BY_ATTRIBUTE = "lastmodifiedby";
    public static final String CREATION_DATE_ATTRIBUTE = "creationdate";
    public static final String LAST_MODIFIED_DATE_ATTRIBUTE = "lastmodifieddate";
    public static final String NAME_ATTRIBUTE = "ou";
    public static final String RESOURCE_MACRO_SELF = "$SELF";
    public static final String RESOURCE_MACRO_ATTRIBUTE = "$ATTR";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    private static Class privilegeClass;
    public static final NoSubject NOT_SUBJECT;
    private boolean active = true;
    private String name;
    private String description;
    private Entitlement entitlement;
    private EntitlementSubject eSubject;
    private EntitlementCondition eCondition;
    private Set<ResourceAttribute> eResourceAttributes;
    private String createdBy;
    private String lastModifiedBy;
    private long creationDate;
    private long lastModifiedDate;

    public static Privilege getNewInstance() throws EntitlementException {
        if (privilegeClass == null) {
            throw new EntitlementException(2);
        }
        try {
            return (Privilege)privilegeClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new EntitlementException(1, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new EntitlementException(1, (Throwable)ex);
        }
    }

    void validateResourceNames(Subject adminSubject, String realm) throws EntitlementException {
        this.entitlement.validateResourceNames(adminSubject, realm);
    }

    public void setSubject(EntitlementSubject eSubject) throws EntitlementException {
        this.validateSubject(eSubject);
        this.eSubject = eSubject;
    }

    void validateSubject(EntitlementSubject sbj) throws EntitlementException {
        if (sbj == null) {
            sbj = NOT_SUBJECT;
        } else if (!sbj.isIdentity()) {
            Object[] params = new Object[]{this.name};
            throw new EntitlementException(310, params);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EntitlementSubject getSubject() {
        return this.eSubject;
    }

    public EntitlementCondition getCondition() {
        return this.eCondition;
    }

    public Set<ResourceAttribute> getResourceAttributes() {
        return this.eResourceAttributes;
    }

    public Entitlement getEntitlement() {
        return this.entitlement;
    }

    public PrivilegeType getType() {
        return PrivilegeType.UNKNOWN;
    }

    @Override
    public abstract List<Entitlement> evaluate(Subject var1, String var2, Subject var3, String var4, String var5, Set<String> var6, Map<String, Set<String>> var7, boolean var8) throws EntitlementException;

    public String toString() {
        String s = null;
        try {
            JSONObject jo = this.toJSONObject();
            s = jo == null ? super.toString() : jo.toString(2);
        }
        catch (JSONException joe) {
            PrivilegeManager.debug.error("Entitlement.toString()", (Throwable)joe);
        }
        return s;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject subjo;
        JSONObject jo = new JSONObject();
        jo.put("className", (Object)this.getClass().getName());
        jo.put("name", (Object)this.name);
        jo.put("active", (Object)Boolean.toString(this.active));
        if (this.description != null) {
            jo.put(DESCRIPTION_ATTRIBUTE, (Object)this.description);
        }
        if (this.createdBy != null) {
            jo.put("createdBy", (Object)this.createdBy);
        }
        if (this.lastModifiedBy != null) {
            jo.put("lastModifiedBy", (Object)this.lastModifiedBy);
        }
        jo.put("lastModifiedDate", this.lastModifiedDate);
        jo.put("creationDate", this.creationDate);
        if (this.entitlement != null) {
            jo.put("entitlement", (Object)this.entitlement.toJSONObject());
        }
        if (this.eSubject != null) {
            subjo = new JSONObject();
            subjo.put("className", (Object)this.eSubject.getClass().getName());
            subjo.put("state", (Object)this.eSubject.getState());
            jo.put("eSubject", (Object)subjo);
        }
        if (this.eCondition != null) {
            subjo = new JSONObject();
            subjo.put("className", (Object)this.eCondition.getClass().getName());
            subjo.put("state", (Object)this.eCondition.getState());
            jo.put("eCondition", (Object)subjo);
        }
        if (this.eResourceAttributes != null && !this.eResourceAttributes.isEmpty()) {
            for (ResourceAttribute r : this.eResourceAttributes) {
                JSONObject subjo2 = new JSONObject();
                subjo2.put("className", (Object)r.getClass().getName());
                subjo2.put("state", (Object)r.getState());
                jo.append("eResourceAttributes", (Object)subjo2);
            }
        }
        return jo;
    }

    protected abstract void init(JSONObject var1);

    public static Privilege getInstance(JSONObject jo) {
        String className = jo.optString("className");
        try {
            Class<?> clazz = Class.forName(className);
            Privilege privilege = (Privilege)clazz.newInstance();
            privilege.name = jo.optString("name");
            privilege.active = Boolean.parseBoolean(jo.optString("active"));
            privilege.description = jo.optString(DESCRIPTION_ATTRIBUTE);
            privilege.createdBy = jo.optString("createdBy");
            privilege.lastModifiedBy = jo.optString("lastModifiedBy");
            privilege.creationDate = JSONUtils.getLong(jo, "creationDate");
            privilege.lastModifiedDate = JSONUtils.getLong(jo, "lastModifiedDate");
            if (jo.has("entitlement")) {
                privilege.entitlement = new Entitlement(jo.getJSONObject("entitlement"));
            }
            privilege.eSubject = Privilege.getESubject(jo);
            privilege.eCondition = Privilege.getECondition(jo);
            privilege.eResourceAttributes = Privilege.getResourceAttributes(jo);
            privilege.init(jo);
            return privilege;
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("Privilege.getInstance", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("Privilege.getInstance", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("Privilege.getInstance", (Throwable)ex);
        }
        catch (JSONException ex) {
            PrivilegeManager.debug.error("Privilege.getInstance", (Throwable)ex);
        }
        return null;
    }

    private static Set<ResourceAttribute> getResourceAttributes(JSONObject jo) throws JSONException {
        if (!jo.has("eResourceAttributes")) {
            return null;
        }
        JSONArray array = jo.getJSONArray("eResourceAttributes");
        HashSet<ResourceAttribute> results = new HashSet<ResourceAttribute>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject json = (JSONObject)array.get(i);
            try {
                Class<?> clazz = Class.forName(json.getString("className"));
                ResourceAttribute ra = (ResourceAttribute)clazz.newInstance();
                ra.setState(json.getString("state"));
                results.add(ra);
                continue;
            }
            catch (InstantiationException ex) {
                PrivilegeManager.debug.error("Privilege.getResourceAttributes", (Throwable)ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                PrivilegeManager.debug.error("Privilege.getResourceAttributes", (Throwable)ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                PrivilegeManager.debug.error("Privilege.getResourceAttributes", (Throwable)ex);
            }
        }
        return results;
    }

    private static EntitlementSubject getESubject(JSONObject jo) throws JSONException {
        if (!jo.has("eSubject")) {
            return new NoSubject();
        }
        JSONObject sbj = jo.getJSONObject("eSubject");
        try {
            Class<?> clazz = Class.forName(sbj.getString("className"));
            EntitlementSubject eSubject = (EntitlementSubject)clazz.newInstance();
            eSubject.setState(sbj.getString("state"));
            return eSubject;
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("Privilege.getESubject", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("Privilege.getESubject", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("Privilege.getESubject", (Throwable)ex);
        }
        return null;
    }

    private static EntitlementCondition getECondition(JSONObject jo) throws JSONException {
        if (!jo.has("eCondition")) {
            return null;
        }
        JSONObject sbj = jo.getJSONObject("eCondition");
        try {
            Class<?> clazz = Class.forName(sbj.getString("className"));
            EntitlementCondition eCondition = (EntitlementCondition)clazz.newInstance();
            eCondition.setState(sbj.getString("state"));
            return eCondition;
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("Privilege.getECondition", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("Privilege.getECondition", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("Privilege.getECondition", (Throwable)ex);
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Privilege object = (Privilege)obj;
        if (this.name == null) {
            if (object.getName() != null) {
                return false;
            }
        } else {
            if (object.getName() == null) {
                return false;
            }
            if (!this.name.equals(object.getName())) {
                return false;
            }
        }
        if (this.active != object.active) {
            return false;
        }
        if (this.entitlement == null) {
            if (object.getEntitlement() != null) {
                return false;
            }
        } else {
            if (object.getEntitlement() == null) {
                return false;
            }
            if (!this.entitlement.equals(object.getEntitlement())) {
                return false;
            }
        }
        if (this.eSubject == null) {
            if (object.getSubject() != null) {
                return false;
            }
        } else {
            if (object.getSubject() == null) {
                return false;
            }
            if (!this.eSubject.equals(object.getSubject())) {
                return false;
            }
        }
        if (this.eResourceAttributes == null) {
            if (object.getResourceAttributes() != null) {
                return false;
            }
        } else {
            if (object.getResourceAttributes() == null) {
                return false;
            }
            if (!((Object)this.eResourceAttributes).equals(object.getResourceAttributes())) {
                return false;
            }
        }
        if (this.eCondition == null) {
            if (object.getCondition() != null) {
                return false;
            }
        } else {
            if (object.getCondition() == null) {
                return false;
            }
            if (!this.eCondition.equals(object.getCondition())) {
                return false;
            }
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.name != null) {
            code += this.name.hashCode();
        }
        if (this.entitlement != null) {
            code += this.entitlement.hashCode();
        }
        if (this.eSubject != null) {
            code += this.eSubject.hashCode();
        }
        if (this.eCondition != null) {
            code += this.eCondition.hashCode();
        }
        if (this.eResourceAttributes != null) {
            code += ((Object)this.eResourceAttributes).hashCode();
        }
        return code;
    }

    protected boolean doesSubjectMatch(String realm, Map<String, Set<String>> resultAdvices, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        if (this.getSubject() == null) {
            return true;
        }
        SubjectAttributesManager mgr = SubjectAttributesManager.getInstance(subject);
        SubjectDecision sDecision = this.getSubject().evaluate(realm, mgr, subject, resourceName, environment);
        if (!sDecision.isSatisfied()) {
            Map<String, Set<String>> advices = sDecision.getAdvices();
            if (advices != null) {
                resultAdvices.putAll(advices);
            }
            return false;
        }
        return true;
    }

    protected boolean doesConditionMatch(String realm, Map<String, Set<String>> resultAdvices, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        if (this.eCondition == null) {
            return true;
        }
        ConditionDecision decision = this.eCondition.evaluate(realm, subject, resourceName, environment);
        if (!decision.isSatisfied()) {
            Map<String, Set<String>> advices = decision.getAdvices();
            if (advices != null) {
                resultAdvices.putAll(advices);
            }
            return false;
        }
        return true;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void canonicalizeResources(Subject adminSubject, String realm) throws EntitlementException {
        this.entitlement.canonicalizeResources(adminSubject, realm);
    }

    @Override
    public ResourceSaveIndexes getResourceSaveIndexes(Subject adminSubject, String realm) {
        return this.entitlement != null ? this.entitlement.getResourceSaveIndexes(adminSubject, realm) : null;
    }

    public void setName(String name) throws EntitlementException {
        if (name == null || name.trim().length() == 0) {
            throw new EntitlementException(3);
        }
        this.name = name;
    }

    public void setEntitlement(Entitlement entitlement) throws EntitlementException {
        if (entitlement == null) {
            throw new EntitlementException(4);
        }
        this.entitlement = entitlement;
    }

    public void setCondition(EntitlementCondition condition) {
        this.eCondition = condition;
    }

    public void setResourceAttributes(Set<ResourceAttribute> set) {
        if (set == null) {
            this.eResourceAttributes = null;
        } else {
            this.eResourceAttributes = new HashSet<ResourceAttribute>();
            this.eResourceAttributes.addAll(set);
        }
    }

    protected Map<String, Set<String>> getAttributes(Subject adminSubject, String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        HashMap result = null;
        if (this.eResourceAttributes != null && !this.eResourceAttributes.isEmpty()) {
            result = new HashMap();
            for (ResourceAttribute e : this.eResourceAttributes) {
                Map<String, Set<String>> values = e.evaluate(adminSubject, realm, subject, resourceName, environment);
                for (String k : values.keySet()) {
                    HashSet v = (HashSet)result.get(k);
                    if (v == null) {
                        v = new HashSet();
                        result.put(k, v);
                    }
                    v.addAll(values.get(k));
                }
            }
        }
        return result;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    static {
        NOT_SUBJECT = new NoSubject();
        try {
            privilegeClass = Class.forName("com.sun.identity.entitlement.opensso.OpenSSOPrivilege");
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("Privilege.<init>", (Throwable)ex);
        }
    }
}

