/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.util.PrivilegeSearchFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrivilegeIndexStore {
    private static Class clazz;
    private Subject adminSubject;
    private String realm;

    protected PrivilegeIndexStore(Subject adminSubject, String realm) {
        this.adminSubject = adminSubject;
        this.realm = realm;
    }

    protected Subject getAdminSubject() {
        return this.adminSubject;
    }

    protected String getRealm() {
        return this.realm;
    }

    public static PrivilegeIndexStore getInstance(Subject adminSubject, String realm) {
        if (clazz == null) {
            return null;
        }
        Class[] parameterTypes = new Class[]{Subject.class, String.class};
        try {
            Constructor constructor = clazz.getConstructor(parameterTypes);
            Object[] args = new Object[]{adminSubject, realm};
            return (PrivilegeIndexStore)constructor.newInstance(args);
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
        }
        catch (SecurityException ex) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.getInstance", (Throwable)ex);
        }
        return null;
    }

    public abstract void add(Set<IPrivilege> var1) throws EntitlementException;

    public abstract void delete(Set<IPrivilege> var1) throws EntitlementException;

    public abstract void delete(String var1) throws EntitlementException;

    public abstract void deleteReferral(String var1) throws EntitlementException;

    public abstract String deleteReferral(String var1, boolean var2) throws EntitlementException;

    public abstract String delete(String var1, boolean var2) throws EntitlementException;

    public abstract Iterator<IPrivilege> search(String var1, ResourceSearchIndexes var2, Set<String> var3, boolean var4) throws EntitlementException;

    public abstract Set<String> searchPrivilegeNames(Set<PrivilegeSearchFilter> var1, boolean var2, int var3, boolean var4, boolean var5) throws EntitlementException;

    public abstract Set<String> searchReferralPrivilegeNames(Set<PrivilegeSearchFilter> var1, boolean var2, int var3, boolean var4, boolean var5) throws EntitlementException;

    public abstract Set<String> getReferredResources(String var1) throws EntitlementException;

    static {
        try {
            clazz = Class.forName("com.sun.identity.entitlement.opensso.OpenSSOIndexStore");
        }
        catch (ClassNotFoundException e) {
            PrivilegeManager.debug.error("PrivilegeIndexStore.static<init>", (Throwable)e);
        }
    }
}

