/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.GroupSubject;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.SubjectDecision;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSOGroupSubject
extends GroupSubject {
    public OpenSSOGroupSubject() {
    }

    public OpenSSOGroupSubject(String group) {
        super(group);
    }

    public OpenSSOGroupSubject(String group, String pSubjectName) {
        super(group, pSubjectName);
    }

    @Override
    public SubjectDecision evaluate(String realm, SubjectAttributesManager mgr, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        boolean satified = false;
        if (mgr.isGroupMembershipSearchIndexEnabled()) {
            Set<Object> publicCreds = subject.getPublicCredentials();
            if (publicCreds != null && !publicCreds.isEmpty()) {
                Map attributes = (Map)publicCreds.iterator().next();
                Set values = (Set)attributes.get("membership:" + IdType.GROUP.getName());
                satified = values != null ? values.contains(this.getID()) : false;
            }
        } else {
            try {
                SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                AMIdentity idGroup = IdUtils.getIdentity(adminToken, this.getID());
                Set supportedType = IdType.GROUP.canHaveMembers();
                for (IdType type : supportedType) {
                    if (!this.isMember(subject, type, idGroup)) continue;
                    satified = true;
                    break;
                }
            }
            catch (IdRepoException e) {
                PrivilegeManager.debug.error("GroupSubject.evaluate", (Throwable)e);
            }
            catch (SSOException e) {
                PrivilegeManager.debug.error("GroupSubject.evaluate", (Throwable)((Object)e));
            }
        }
        return new SubjectDecision(satified, Collections.EMPTY_MAP);
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        SubjectAttributesManager sam = this.getSubjectAttributesManager();
        if (sam != null) {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
            if (sam.isGroupMembershipSearchIndexEnabled()) {
                HashSet<String> set = new HashSet<String>();
                set.add(this.getID());
                map.put("membership:" + IdType.GROUP.getName(), set);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add("all");
                map.put("identity:", set);
            }
            return map;
        }
        return super.getSearchIndexAttributes();
    }

    @Override
    public Set<String> getRequiredAttributeNames() {
        SubjectAttributesManager sam = this.getSubjectAttributesManager();
        if (sam != null) {
            if (sam.isGroupMembershipSearchIndexEnabled()) {
                HashSet<String> set = new HashSet<String>(2);
                set.add("membership:" + IdType.GROUP.getName());
                return set;
            }
            return Collections.EMPTY_SET;
        }
        return super.getRequiredAttributeNames();
    }

    private boolean isMember(Subject subject, IdType type, AMIdentity idGroup) throws IdRepoException, SSOException {
        Set members = idGroup.getMembers(type);
        for (AMIdentity amid : members) {
            if (!this.hasPrincipal(subject, amid.getUniversalId())) continue;
            return true;
        }
        return false;
    }

    private SubjectAttributesManager getSubjectAttributesManager() {
        String uuid = this.getID();
        if (uuid == null) {
            return null;
        }
        try {
            AMIdentity amid = new AMIdentity(null, uuid);
            String realm = amid.getRealm();
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            return SubjectAttributesManager.getInstance(SubjectUtils.createSubject(adminToken), realm);
        }
        catch (IdRepoException idex) {
            if (PrivilegeManager.debug.messageEnabled()) {
                PrivilegeManager.debug.message("OpenSSOGroupSubject.getSubjectAttributesManager:", (Throwable)idex);
            }
            return null;
        }
    }
}

