/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.AndCondition;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.AuthenticatedESubject;
import com.sun.identity.entitlement.Entitlement;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubject;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.OrCondition;
import com.sun.identity.entitlement.OrSubject;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ReferralPrivilege;
import com.sun.identity.entitlement.ResourceAttribute;
import com.sun.identity.entitlement.RoleSubject;
import com.sun.identity.entitlement.StaticAttributes;
import com.sun.identity.entitlement.UserAttributes;
import com.sun.identity.entitlement.UserSubject;
import com.sun.identity.entitlement.opensso.OpenSSOGroupSubject;
import com.sun.identity.entitlement.opensso.OpenSSOPrivilege;
import com.sun.identity.entitlement.opensso.PolicyCondition;
import com.sun.identity.entitlement.opensso.PolicyPrivilegeManager;
import com.sun.identity.entitlement.opensso.PolicySubject;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.entitlement.xacml3.XACMLPrivilegeUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.AMIdentitySubject;
import com.sun.identity.policy.plugins.AuthenticatedUsers;
import com.sun.identity.policy.plugins.IDRepoResponseProvider;
import com.sun.identity.policy.plugins.PrivilegeCondition;
import com.sun.identity.policy.plugins.PrivilegeSubject;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.DNMapper;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegeUtils {
    private static Random random = new Random();
    private static ServiceTypeManager svcTypeManager;

    private PrivilegeUtils() {
    }

    public static Set<IPrivilege> policyToPrivileges(Object policyObject) throws SSOException, PolicyException, EntitlementException {
        if (policyObject == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<IPrivilege> privileges = new HashSet<IPrivilege>();
        if (policyObject instanceof com.sun.identity.entitlement.xacml3.core.Policy) {
            Privilege p = XACMLPrivilegeUtils.policyToPrivilege((com.sun.identity.entitlement.xacml3.core.Policy)policyObject);
            privileges.add(p);
        } else if (policyObject instanceof Policy) {
            PrivilegeUtils.policyToPrivileges((Policy)policyObject, privileges);
        }
        return privileges;
    }

    public static void policyToPrivileges(Policy policy, Set<IPrivilege> privileges) throws SSOException, PolicyException, EntitlementException {
        String policyName = policy.getName();
        if (policy.isReferralPolicy()) {
            Map<String, Set<String>> resources = PrivilegeUtils.getResources(policy);
            Set<String> referredRealms = PrivilegeUtils.getReferrals(policy);
            ReferralPrivilege rp = new ReferralPrivilege(policyName, resources, referredRealms);
            rp.setDescription(policy.getDescription());
            rp.setCreationDate(policy.getCreationDate());
            rp.setCreatedBy(policy.getCreatedBy());
            rp.setLastModifiedBy(policy.getLastModifiedBy());
            rp.setLastModifiedDate(policy.getLastModifiedDate());
            rp.setActive(policy.isActive());
            privileges.add(rp);
        } else {
            Set<Entitlement> entitlements = PrivilegeUtils.rulesToEntitlement(policy);
            EntitlementSubject eSubject = PrivilegeUtils.toEntitlementSubject(policy);
            EntitlementCondition eCondition = PrivilegeUtils.toEntitlementCondition(policy);
            Set<ResourceAttribute> resourceAttributesSet = PrivilegeUtils.toResourceAttributes(policy);
            if (entitlements.size() == 1) {
                privileges.add(PrivilegeUtils.createPrivilege(policyName, policyName, entitlements.iterator().next(), eSubject, eCondition, resourceAttributesSet, policy));
            } else {
                for (Entitlement e : entitlements) {
                    String pName = policyName + "_" + e.getName();
                    privileges.add(PrivilegeUtils.createPrivilege(pName, policyName, e, eSubject, eCondition, resourceAttributesSet, policy));
                }
            }
        }
    }

    private static Privilege createPrivilege(String name, String policyName, Entitlement e, EntitlementSubject eSubject, EntitlementCondition eCondition, Set<ResourceAttribute> resourceAttributesSet, Policy policy) throws EntitlementException {
        OpenSSOPrivilege privilege = new OpenSSOPrivilege();
        privilege.setName(name);
        privilege.setEntitlement(e);
        privilege.setSubject(eSubject);
        privilege.setCondition(eCondition);
        privilege.setResourceAttributes(resourceAttributesSet);
        privilege.setPolicyName(policyName);
        privilege.setDescription(policy.getDescription());
        privilege.setCreatedBy(policy.getCreatedBy());
        privilege.setLastModifiedBy(policy.getLastModifiedBy());
        privilege.setCreationDate(policy.getCreationDate());
        privilege.setLastModifiedDate(policy.getLastModifiedDate());
        privilege.setActive(policy.isActive());
        return privilege;
    }

    private static EntitlementSubject toEntitlementSubject(Policy policy) throws PolicyException {
        Set subjectNames = policy.getSubjectNames();
        HashSet<EntitlementSubject> entitlementSubjects = new HashSet<EntitlementSubject>();
        if (subjectNames != null) {
            for (String subjectName : subjectNames) {
                EntitlementSubject sbj;
                Subject subject = policy.getSubject(subjectName);
                boolean exclusive = policy.isSubjectExclusive(subjectName);
                boolean dealtWith = false;
                if (dealtWith || (sbj = PrivilegeUtils.mapGenericSubject(subjectName, subject, exclusive)) == null) continue;
                entitlementSubjects.add(sbj);
            }
        }
        if (entitlementSubjects.isEmpty()) {
            return null;
        }
        return entitlementSubjects.size() == 1 ? (EntitlementSubject)entitlementSubjects.iterator().next() : new OrSubject(entitlementSubjects);
    }

    private static Set<EntitlementSubject> toEntitlementSubject(AMIdentitySubject sbj, boolean exclusive) {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            HashSet<EntitlementSubject> result = new HashSet<EntitlementSubject>();
            Set values = sbj.getValues();
            for (String uuid : values) {
                AMIdentity amid = IdUtils.getIdentity(adminToken, uuid);
                IdType type = amid.getType();
                if (type.equals(IdType.GROUP)) {
                    OpenSSOGroupSubject grp = new OpenSSOGroupSubject(uuid);
                    grp.setExclusive(exclusive);
                    result.add(grp);
                    continue;
                }
                if (type.equals(IdType.ROLE)) {
                    RoleSubject role = new RoleSubject(uuid);
                    role.setExclusive(exclusive);
                    result.add(role);
                    continue;
                }
                if (type.equals(IdType.USER)) {
                    UserSubject user = new UserSubject(uuid);
                    user.setExclusive(exclusive);
                    result.add(user);
                    continue;
                }
                return Collections.EMPTY_SET;
            }
            return result;
        }
        catch (IdRepoException ex) {
            return Collections.EMPTY_SET;
        }
    }

    private static Set<EntitlementSubject> toEntitlementSubject(AuthenticatedUsers sbj, boolean exclusive) {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        HashSet<EntitlementSubject> result = new HashSet<EntitlementSubject>();
        result.add(new AuthenticatedESubject());
        return result;
    }

    private static EntitlementCondition toEntitlementCondition(Policy policy) throws PolicyException {
        Set conditionNames = policy.getConditionNames();
        HashSet<Object[]> nConditions = new HashSet<Object[]>();
        for (Object conditionNameObj : conditionNames) {
            String conditionName = (String)conditionNameObj;
            Condition condition = policy.getCondition(conditionName);
            Object[] nCondition = new Object[]{conditionName, condition};
            nConditions.add(nCondition);
        }
        return PrivilegeUtils.nConditionsToECondition(nConditions);
    }

    private static Set<ResourceAttribute> toResourceAttributes(Policy policy) throws PolicyException, EntitlementException {
        Set rpNames = policy.getResponseProviderNames();
        HashSet<Object[]> nrps = new HashSet<Object[]>();
        for (Object rpNameObj : rpNames) {
            String rpName = (String)rpNameObj;
            ResponseProvider rp = policy.getResponseProvider(rpName);
            Object[] nrp = new Object[]{rpName, rp};
            nrps.add(nrp);
        }
        return PrivilegeUtils.nrpsToResourceAttributes(nrps);
    }

    private static Set<Rule> getRules(Policy policy) throws NameNotFoundException {
        Set ruleNames = policy.getRuleNames();
        HashSet<Rule> rules = new HashSet<Rule>();
        for (Object ruleNameObj : ruleNames) {
            String ruleName = (String)ruleNameObj;
            Rule rule = policy.getRule(ruleName);
            rules.add(rule);
        }
        return rules;
    }

    private static Map<String, Set<String>> getResources(Policy policy) throws NameNotFoundException {
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        Set<Rule> rules = PrivilegeUtils.getRules(policy);
        for (Rule rule : rules) {
            Set<String> ruleResources = rule.getResourceNames();
            if (ruleResources == null) continue;
            HashSet<String> resourceNames = (HashSet<String>)results.get(rule.getApplicationName());
            if (resourceNames == null) {
                resourceNames = new HashSet<String>();
                results.put(rule.getApplicationName(), resourceNames);
            }
            resourceNames.addAll(ruleResources);
        }
        return results;
    }

    private static Set<String> getReferrals(Policy policy) throws NameNotFoundException {
        HashSet<String> results = new HashSet<String>();
        Set names = policy.getReferralNames();
        for (String name : names) {
            Referral r = policy.getReferral(name);
            Set values = r.getValues();
            for (String s : values) {
                if (DN.isDN((String)s)) {
                    results.add(DNMapper.orgNameToRealmName(s));
                    continue;
                }
                results.add(s);
            }
        }
        return results;
    }

    private static Set<Entitlement> rulesToEntitlement(Policy policy) throws PolicyException, SSOException, EntitlementException {
        Set<Rule> rules = PrivilegeUtils.getRules(policy);
        HashSet<Entitlement> entitlements = new HashSet<Entitlement>();
        for (Rule rule : rules) {
            String serviceName = rule.getServiceTypeName();
            Map<String, Boolean> actionMap = PrivilegeUtils.pavToPrav(rule.getActionValues(), serviceName);
            String entitlementName = rule.getName();
            HashSet<String> resourceNames = new HashSet<String>();
            Set<String> ruleResources = rule.getResourceNames();
            if (ruleResources != null) {
                resourceNames.addAll(ruleResources);
            }
            Entitlement entitlement = new Entitlement(rule.getApplicationName(), resourceNames, actionMap);
            entitlement.setName(entitlementName);
            Set<String> excludedResourceNames1 = rule.getExcludedResourceNames();
            if (excludedResourceNames1 != null) {
                HashSet<String> excludedResourceNames = new HashSet<String>();
                excludedResourceNames.addAll(excludedResourceNames1);
                entitlement.setExcludedResourceNames(excludedResourceNames);
            }
            entitlements.add(entitlement);
        }
        return entitlements;
    }

    private static EntitlementCondition nConditionsToECondition(Set nConditons) {
        HashSet<EntitlementCondition> ecSet = new HashSet<EntitlementCondition>();
        for (Object nConditionObj : nConditons) {
            Object[] nCondition = (Object[])nConditionObj;
            EntitlementCondition ec = PrivilegeUtils.mapGenericCondition(nCondition);
            ecSet.add(ec);
        }
        if (ecSet.isEmpty()) {
            return null;
        }
        if (ecSet.size() == 1) {
            return (EntitlementCondition)ecSet.iterator().next();
        }
        HashMap<String, HashSet<EntitlementCondition>> cnEntcMap = new HashMap<String, HashSet<EntitlementCondition>>();
        for (EntitlementCondition ec : ecSet) {
            String key = ec instanceof PolicyCondition ? ((PolicyCondition)ec).getClassName() : ec.getClass().getName();
            HashSet<EntitlementCondition> values = (HashSet<EntitlementCondition>)cnEntcMap.get(key);
            if (values == null) {
                values = new HashSet<EntitlementCondition>();
                cnEntcMap.put(key, values);
            }
            values.add(ec);
        }
        Set keySet = cnEntcMap.keySet();
        if (keySet.size() == 1) {
            Set values = (Set)cnEntcMap.get(keySet.iterator().next());
            return values.size() == 1 ? (EntitlementCondition)values.iterator().next() : new OrCondition(values);
        }
        HashSet<EntitlementCondition> andSet = new HashSet<EntitlementCondition>();
        for (String key : keySet) {
            Set values = (Set)cnEntcMap.get(key);
            if (values.size() == 1) {
                andSet.add((EntitlementCondition)values.iterator().next());
                continue;
            }
            andSet.add(new OrCondition(values));
        }
        return new AndCondition(andSet);
    }

    private static EntitlementSubject mapGenericSubject(String subjectName, Subject objSubject, boolean exclusive) {
        try {
            if (objSubject instanceof PrivilegeSubject) {
                PrivilegeSubject pips = (PrivilegeSubject)objSubject;
                Set values = pips.getValues();
                String val = (String)values.iterator().next();
                int idx = val.indexOf("=");
                String className = val.substring(0, idx);
                String state = val.substring(idx + 1);
                EntitlementSubject es = (EntitlementSubject)Class.forName(className).newInstance();
                es.setState(state);
                return es;
            }
            Subject sbj = objSubject;
            Set val = sbj.getValues();
            String className = sbj.getClass().getName();
            return new PolicySubject(subjectName, className, val, exclusive);
        }
        catch (ClassNotFoundException e) {
            PrivilegeManager.debug.error("PrivilegeUtils.mapGenericSubject", (Throwable)e);
        }
        catch (InstantiationException e) {
            PrivilegeManager.debug.error("PrivilegeUtils.mapGenericSubject", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            PrivilegeManager.debug.error("PrivilegeUtils.mapGenericSubject", (Throwable)e);
        }
        return null;
    }

    private static EntitlementCondition mapGenericCondition(Object[] nCondition) {
        try {
            Object objCondition = nCondition[1];
            if (objCondition instanceof PrivilegeCondition) {
                PrivilegeCondition pipc = (PrivilegeCondition)objCondition;
                Map props = pipc.getProperties();
                String className = (String)props.keySet().iterator().next();
                EntitlementCondition ec = (EntitlementCondition)Class.forName(className).newInstance();
                Set setValues = (Set)props.get(className);
                ec.setState((String)setValues.iterator().next());
                return ec;
            }
            if (objCondition instanceof Condition) {
                Condition cond = (Condition)objCondition;
                Map props = cond.getProperties();
                String className = cond.getClass().getName();
                return new PolicyCondition((String)nCondition[0], className, props);
            }
        }
        catch (ClassNotFoundException e) {
            PrivilegeManager.debug.error("PrivilegeUtils.mapGenericCondition", (Throwable)e);
        }
        catch (InstantiationException e) {
            PrivilegeManager.debug.error("PrivilegeUtils.mapGenericCondition", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            PrivilegeManager.debug.error("PrivilegeUtils.mapGenericCondition", (Throwable)e);
        }
        return null;
    }

    public static Object privilegeToPolicyObject(String realm, Privilege privilege) throws PolicyException, SSOException, EntitlementException {
        Object policyObject = null;
        policyObject = PolicyPrivilegeManager.xacmlPrivilegeEnabled() ? XACMLPrivilegeUtils.privilegeToPolicy(privilege) : PrivilegeUtils.privilegeToPolicy(realm, privilege);
        return policyObject;
    }

    public static Policy referralPrivilegeToPolicy(String realm, ReferralPrivilege referralPrivilege) throws PolicyException, SSOException, EntitlementException {
        Policy policy = new Policy(referralPrivilege.getName(), referralPrivilege.getDescription(), true);
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        javax.security.auth.Subject adminSubject = SubjectUtils.createSubject(adminToken);
        PolicyManager pm = new PolicyManager(adminToken, realm);
        ReferralTypeManager rm = pm.getReferralTypeManager();
        policy.setCreatedBy(referralPrivilege.getCreatedBy());
        policy.setCreationDate(referralPrivilege.getCreationDate());
        policy.setLastModifiedBy(referralPrivilege.getLastModifiedBy());
        policy.setLastModifiedDate(referralPrivilege.getLastModifiedDate());
        int count = 1;
        for (String r : referralPrivilege.getRealms()) {
            Referral referral = rm.getReferral("SubOrgReferral");
            HashSet<String> tmp = new HashSet<String>();
            tmp.add(r);
            referral.setValues(tmp);
            policy.addReferral("referral" + count++, referral);
        }
        Map<String, Set<String>> map = referralPrivilege.getOriginalMapApplNameToResources();
        count = 1;
        for (String appName : map.keySet()) {
            Set<String> res = map.get(appName);
            Application appl = ApplicationManager.getApplication(adminSubject, realm, appName);
            if (appl == null) {
                Object[] params = new Object[]{appName, realm};
                throw new EntitlementException(105, params);
            }
            String serviceName = appl.getApplicationType().getName();
            for (String r : res) {
                Rule rule = new Rule("rule" + count++, serviceName, r, Collections.EMPTY_MAP);
                rule.setApplicationName(appName);
                policy.addRule(rule);
            }
        }
        return policy;
    }

    public static Policy privilegeToPolicy(String realm, Privilege privilege) throws PolicyException, SSOException, EntitlementException {
        EntitlementCondition ec;
        EntitlementSubject es;
        Policy policy = new Policy(privilege.getName());
        policy.setDescription(privilege.getDescription());
        if (privilege.getEntitlement() != null) {
            Entitlement entitlement = privilege.getEntitlement();
            Set<Rule> rules = PrivilegeUtils.entitlementToRule(realm, entitlement);
            for (Rule rule : rules) {
                policy.addRule(rule);
            }
        }
        if ((es = privilege.getSubject()) != null && es != Privilege.NOT_SUBJECT) {
            Subject sbj = PrivilegeUtils.eSubjectToEPSubject(es);
            policy.addSubject(PrivilegeUtils.randomName(), sbj, false);
        }
        if ((ec = privilege.getCondition()) != null) {
            Condition cond = PrivilegeUtils.eConditionToEPCondition(ec);
            policy.addCondition(PrivilegeUtils.randomName(), cond);
        }
        if (privilege.getResourceAttributes() != null) {
            Map<String, ResponseProvider> nrps = PrivilegeUtils.resourceAttributesToResponseProviders(privilege.getResourceAttributes());
            for (String rpName : nrps.keySet()) {
                ResponseProvider responseProvider = nrps.get(rpName);
                policy.addResponseProvider(rpName, responseProvider);
            }
        }
        policy.setCreatedBy(privilege.getCreatedBy());
        policy.setCreationDate(privilege.getCreationDate());
        policy.setLastModifiedBy(privilege.getLastModifiedBy());
        policy.setLastModifiedDate(privilege.getLastModifiedDate());
        return policy;
    }

    private static Set<Rule> entitlementToRule(String realm, Entitlement entitlement) throws PolicyException, SSOException, EntitlementException {
        HashSet<Rule> rules = new HashSet<Rule>();
        String appName = entitlement.getApplicationName();
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        Application appl = ApplicationManager.getApplication(SubjectUtils.createSubject(adminToken), realm, appName);
        if (appl == null) {
            Object[] params = new Object[]{appName, realm};
            throw new EntitlementException(105, params);
        }
        String serviceName = appl.getApplicationType().getName();
        Set<String> resourceNames = entitlement.getResourceNames();
        Map<String, Boolean> actionValues = entitlement.getActionValues();
        Map av = PrivilegeUtils.pravToPav(actionValues, serviceName);
        if (resourceNames != null) {
            String entName = entitlement.getName();
            if (entName == null) {
                entName = "entitlement";
            }
            Rule rule = new Rule(entName, serviceName, null, av);
            rule.setResourceNames(resourceNames);
            rule.setExcludedResourceNames(entitlement.getExcludedResourceNames());
            rule.setApplicationName(appName);
            rules.add(rule);
        }
        return rules;
    }

    private static Subject eSubjectToEPSubject(EntitlementSubject es) {
        PrivilegeSubject ps = new PrivilegeSubject();
        HashSet<String> values = new HashSet<String>();
        values.add(es.getClass().getName() + "=" + es.getState());
        ps.setValues(values);
        return ps;
    }

    private static Condition eConditionToEPCondition(EntitlementCondition ec) throws PolicyException {
        PrivilegeCondition pc = new PrivilegeCondition();
        HashMap map = new HashMap();
        HashSet<String> set = new HashSet<String>(2);
        set.add(ec.getState());
        map.put(ec.getClass().getName(), set);
        pc.setProperties(map);
        return pc;
    }

    private static Set<ResourceAttribute> nrpsToResourceAttributes(Set nrps) throws EntitlementException {
        HashSet<ResourceAttribute> resourceAttributesSet = new HashSet<ResourceAttribute>();
        if (nrps != null && !nrps.isEmpty()) {
            for (Object nrpObj : nrps) {
                Object[] nrpa = (Object[])nrpObj;
                String nrpName = (String)nrpa[0];
                ResponseProvider rp = (ResponseProvider)nrpa[1];
                if (!(rp instanceof IDRepoResponseProvider)) continue;
                resourceAttributesSet.addAll(PrivilegeUtils.nrpsToResourceAttributes((IDRepoResponseProvider)rp, nrpName));
            }
        }
        return resourceAttributesSet;
    }

    private static Set<ResourceAttribute> nrpsToResourceAttributes(IDRepoResponseProvider irp, String nrpName) throws EntitlementException {
        HashMap<String, ResourceAttribute> map = new HashMap<String, ResourceAttribute>();
        Map props = irp.getProperties();
        if (props != null && !props.isEmpty()) {
            Set uas;
            Set sas = (Set)props.get("StaticAttribute");
            if (sas != null && !sas.isEmpty()) {
                for (String sat : sas) {
                    int i = sat.indexOf("=");
                    String name = i != -1 ? sat.substring(0, i) : sat;
                    String value = i != -1 ? sat.substring(i + 1) : null;
                    String k = name + "_" + "StaticAttribute";
                    StaticAttributes sa = (StaticAttributes)map.get(k);
                    if (sa == null) {
                        sa = new StaticAttributes();
                        sa.setPropertyName(name);
                        map.put(k, sa);
                    }
                    if (value != null) {
                        sa.getPropertyValues().add(value);
                    }
                    sa.setPResponseProviderName(nrpName);
                }
            }
            if ((uas = (Set)props.get("DynamicAttribute")) != null && !uas.isEmpty()) {
                for (String uat : uas) {
                    int i = uat.indexOf("=");
                    String name = i != -1 ? uat.substring(0, i) : uat;
                    String value = i != -1 ? uat.substring(i + 1) : null;
                    String k = name + "_" + "DynamicAttribute";
                    UserAttributes ua = (UserAttributes)map.get(k);
                    if (ua == null) {
                        ua = new UserAttributes();
                        ua.setPropertyName(name);
                        map.put(k, ua);
                    }
                    if (value != null) {
                        ua.getPropertyValues().add(value);
                    }
                    ua.setPResponseProviderName(nrpName);
                }
            }
        }
        HashSet<ResourceAttribute> results = new HashSet<ResourceAttribute>();
        results.addAll(map.values());
        return results;
    }

    private static Map<String, ResponseProvider> resourceAttributesToResponseProviders(Set<ResourceAttribute> resourceAttributes) throws PolicyException {
        HashMap<String, ResponseProvider> results = new HashMap<String, ResponseProvider>();
        if (resourceAttributes != null) {
            HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>();
            for (ResourceAttribute ra : resourceAttributes) {
                if (ra instanceof StaticAttributes) {
                    PrivilegeUtils.resourceAttributesToResponseProviders((StaticAttributes)ra, map);
                    continue;
                }
                if (!(ra instanceof UserAttributes)) continue;
                PrivilegeUtils.resourceAttributesToResponseProviders((UserAttributes)ra, map);
            }
            for (String n : map.keySet()) {
                IDRepoResponseProvider rp = new IDRepoResponseProvider();
                Map values = (Map)map.get(n);
                Set dynValues = (Set)values.get("DynamicAttribute");
                if (dynValues != null && !dynValues.isEmpty()) {
                    HashMap<String, Set> configParams = new HashMap<String, Set>();
                    configParams.put("sun-am-policy-dynamic-response-attributes", dynValues);
                    rp.initialize(configParams);
                }
                rp.setProperties(values);
                results.put(n, rp);
            }
        }
        return results;
    }

    private static void resourceAttributesToResponseProviders(StaticAttributes sa, Map<String, Map<String, Set<String>>> results) throws PolicyException {
        String pluginName = sa.getPResponseProviderName();
        Map<String, Set<String>> map = results.get(pluginName);
        if (map == null) {
            map = new HashMap<String, Set<String>>();
            results.put(pluginName, map);
        }
        String propertyName = sa.getPropertyName();
        Set<String> propertyValues = sa.getPropertyValues();
        Set<String> values = map.get("StaticAttribute");
        if (values == null) {
            values = new HashSet<String>();
            map.put("StaticAttribute", values);
        }
        PrivilegeUtils.getResponseAttributeValues(propertyName, propertyValues, values);
    }

    private static void resourceAttributesToResponseProviders(UserAttributes ua, Map<String, Map<String, Set<String>>> results) throws PolicyException {
        String pluginName = ua.getPResponseProviderName();
        Map<String, Set<String>> map = results.get(pluginName);
        if (map == null) {
            map = new HashMap<String, Set<String>>();
            results.put(pluginName, map);
        }
        String propertyName = ua.getPropertyName();
        Set<String> propertyValues = ua.getPropertyValues();
        Set<String> values = map.get("DynamicAttribute");
        if (values == null) {
            values = new HashSet<String>();
            map.put("DynamicAttribute", values);
        }
        PrivilegeUtils.getResponseAttributeValues(propertyName, propertyValues, values);
    }

    private static void getResponseAttributeValues(String propertyName, Set<String> propertyValues, Set<String> results) {
        if (propertyValues != null && !propertyValues.isEmpty()) {
            for (String v : propertyValues) {
                results.add(propertyName + "=" + v);
            }
        } else {
            results.add(propertyName);
        }
    }

    private static String randomName() {
        return "" + random.nextInt(10000);
    }

    static Map pravToPav(Map<String, Boolean> actionValues, String serviceName) throws PolicyException, SSOException {
        if (actionValues == null) {
            return null;
        }
        ServiceType st = svcTypeManager.getServiceType(serviceName);
        HashMap av = new HashMap();
        Set<String> keySet = actionValues.keySet();
        for (String action : keySet) {
            try {
                ActionSchema as = st.getActionSchema(action);
                String trueValue = as.getTrueValue();
                String falseValue = as.getFalseValue();
                Boolean value = actionValues.get(action);
                HashSet<String> values = new HashSet<String>();
                if (value.equals(Boolean.TRUE)) {
                    values.add(trueValue);
                } else {
                    values.add(falseValue);
                }
                av.put(action, values);
            }
            catch (InvalidNameException e) {
                Boolean value = actionValues.get(action);
                HashSet<String> values = new HashSet<String>();
                values.add(value.toString());
                av.put(action, values);
            }
        }
        return av;
    }

    static Map<String, Boolean> pavToPrav(Map actionValues, String serviceName) throws PolicyException, SSOException {
        if (actionValues == null) {
            return null;
        }
        ServiceType st = svcTypeManager.getServiceType(serviceName);
        HashMap<String, Boolean> av = new HashMap<String, Boolean>();
        Set keySet = actionValues.keySet();
        for (Object actionObj : keySet) {
            String action = (String)actionObj;
            Set values = (Set)actionValues.get(action);
            if (values == null || values.isEmpty()) {
                av.put(action, Boolean.FALSE);
                continue;
            }
            try {
                ActionSchema as = st.getActionSchema(action);
                if (as.getSyntax().equals(AttributeSchema.Syntax.BOOLEAN)) {
                    String trueValue = as.getTrueValue();
                    if (values.contains(trueValue)) {
                        av.put(action, Boolean.TRUE);
                        continue;
                    }
                    av.put(action, Boolean.FALSE);
                    continue;
                }
                String value = values.iterator().next().toString();
                av.put(action + "_" + value, Boolean.TRUE);
            }
            catch (InvalidNameException e) {
                av.put(action, Boolean.parseBoolean((String)values.iterator().next()));
            }
        }
        return av;
    }

    public static String policyToXML(Object policy) {
        String xmlString = "";
        if (policy instanceof com.sun.identity.entitlement.xacml3.core.Policy) {
            com.sun.identity.entitlement.xacml3.core.Policy xacmlPolicy = (com.sun.identity.entitlement.xacml3.core.Policy)policy;
            xmlString = XACMLPrivilegeUtils.toXML(xacmlPolicy);
        } else if (policy instanceof Policy) {
            xmlString = ((Policy)policy).toXML();
        }
        return xmlString;
    }

    public static String getPolicyName(Object policy) {
        String name = "";
        if (policy instanceof com.sun.identity.entitlement.xacml3.core.Policy) {
            name = ((com.sun.identity.entitlement.xacml3.core.Policy)policy).getPolicyId();
        } else if (policy instanceof Policy) {
            name = ((Policy)policy).getName();
        }
        return name;
    }

    public static Set<IPrivilege> policyObjectToPrivileges(Object policy) throws EntitlementException, PolicyException, SSOException {
        Set<IPrivilege> privileges = null;
        if (policy instanceof com.sun.identity.entitlement.xacml3.core.Policy) {
            Privilege privilege = XACMLPrivilegeUtils.policyToPrivilege((com.sun.identity.entitlement.xacml3.core.Policy)policy);
            privileges = new HashSet<IPrivilege>();
            privileges.add(privilege);
        } else if (policy instanceof Policy) {
            privileges = PrivilegeUtils.policyToPrivileges((Policy)policy);
        }
        return privileges;
    }

    static {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            svcTypeManager = new ServiceTypeManager(adminToken);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("PrivilegeUtils.<init>", (Throwable)((Object)ex));
        }
    }
}

