/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ReaderWriterLock;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.LogConstants;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.messageid.LogMessageProviderBase;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.security.auth.Subject;

public class Logger
extends java.util.logging.Logger {
    public static ThreadLocal token;
    private String currentFileName = new String();
    private static LogManager lm;
    private String logName;
    protected static boolean resolveHostName;
    public static ReaderWriterLock rwLock;

    protected Logger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    private static void processNewLoggerObject(Logger result) {
        Formatter formatter = null;
        String handlerClass = LogManager.HANDLER;
        String formatterClass = LogManager.FORMATTER;
        String levelProp = "iplanet-am-logging." + result.logName + ".level";
        String levelString = lm.getProperty(levelProp);
        if (!(levelString != null && levelString.length() > 0 || (levelString = SystemProperties.get(levelProp)) != null && levelString.length() > 0 || (levelString = lm.getProperty("sun-am-log-level")) != null && levelString.length() > 0)) {
            levelString = "INFO";
        }
        Level logLevel = null;
        try {
            logLevel = Level.parse(levelString);
        }
        catch (IllegalArgumentException iaex) {
            logLevel = LogConstants.DEFAULT_LOGGING_LEVEL;
        }
        result.setLevel(logLevel);
        String logStatus = lm.getProperty("logstatus");
        if (logStatus != null && logStatus.startsWith("INACTIVE")) {
            logLevel = Level.OFF;
        }
        result.setLevel(logLevel);
        Class<?> clz = null;
        Class[] parameters = new Class[]{String.class};
        Object[] parameterObjects = new Object[]{new String(result.logName)};
        Constructor<?> cons = null;
        Handler handler = null;
        if (handlerClass == null) {
            Debug.error("Logger:processNewLoggerObject:HandlerClass not in classpath ");
            return;
        }
        try {
            clz = Class.forName(handlerClass);
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:HandlerClass not in classpath: " + handlerClass, e);
            return;
        }
        try {
            if (clz != null) {
                cons = clz.getDeclaredConstructor(parameters);
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:constructor parameter mismatch ", e);
            return;
        }
        try {
            if (cons != null) {
                handler = (Handler)cons.newInstance(parameterObjects);
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not instantiate handler: " + handlerClass, e);
            return;
        }
        if (formatterClass == null) {
            Debug.error("Logger:processNewLoggerObject:formatterClass not in classpath ");
            return;
        }
        try {
            clz = Thread.currentThread().getContextClassLoader().loadClass(formatterClass);
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not load Formatter Class: " + formatterClass, e);
            return;
        }
        try {
            if (clz != null) {
                formatter = (Formatter)clz.newInstance();
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not get Formatter instance " + formatterClass, e);
            return;
        }
        try {
            handler.setFormatter(formatter);
            result.addHandler(handler);
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Unable to add Handler", e);
            return;
        }
        String filterClassName = lm.getProperty("iplanet-am-logging-filter-class-name");
        try {
            if (filterClassName != null) {
                Filter filter = (Filter)Class.forName(filterClassName).newInstance();
                result.setFilter(filter);
            }
        }
        catch (Exception e) {
            Debug.error("Logger:processNewLoggerObject:Could not set Filter: " + filterClassName, e);
        }
        result.setUseParentHandlers(false);
        resolveHostName = Boolean.valueOf(lm.getProperty("resolveHostName"));
    }

    public void log(java.util.logging.LogRecord record) {
        if (record instanceof ILogRecord) {
            this.log((ILogRecord)((Object)record));
        } else {
            Object obj = token.get();
            this.log(record, obj);
        }
    }

    private boolean validateLogBy(Object cred) {
        if (!LogManager.isLocal) {
            if (cred == null) {
                Debug.error("Logger.validateLogBy:" + this.logName + ": remote logging, ssoToken is null; Will not log");
                return false;
            }
        } else if (!Authorizer.isAuthorized(this.logName, "MODIFY", cred)) {
            Debug.error("Logger.validateLogBy:" + this.logName + ": authorization failed; Will not log");
            throw new AMLogException(this.logName + ":" + "Log write authorization failure");
        }
        return true;
    }

    private void addLogByInfo(ILogRecord record, Object cred) {
        if (cred instanceof SSOToken) {
            SSOToken ssoToken = (SSOToken)cred;
            String loggedBySID = ((Object)ssoToken.getTokenID()).toString();
            record.addLogInfo("LoggedBySid", loggedBySID);
            String clientID = null;
            try {
                clientID = ssoToken.getPrincipal().getName();
            }
            catch (SSOException ssoe) {
                Debug.error("Logger:log:" + this.logName + ": could not get clientID from ssoToken:", (Throwable)((Object)ssoe));
            }
            record.addLogInfo("LoggedBy", clientID);
        }
    }

    private void addModuleName(ILogRecord record) {
        String existModuleName = (String)record.getLogInfoMap().get("ModuleName");
        if (existModuleName == null || existModuleName.length() <= 0) {
            record.addLogInfo("ModuleName", this.getName());
        }
    }

    public void log(ILogRecord record) {
        try {
            Logger.extractInfoFromLogFor(record);
        }
        catch (SSOException e) {
            Debug.error("Logger.log " + e.getMessage());
        }
        if (record instanceof java.util.logging.LogRecord) {
            Object logBy = record.getLogBy();
            Object cred = logBy instanceof Subject ? Logger.getPrivateCred((Subject)logBy) : logBy;
            this.log((java.util.logging.LogRecord)((Object)record), cred);
        } else {
            Debug.error("Logger.log: cannot log non java.util.logging.LogRecord class");
        }
    }

    private static Object getPrivateCred(Subject sbj) {
        Set<Object> privCreds = sbj.getPrivateCredentials();
        return privCreds != null && !privCreds.isEmpty() ? privCreds.iterator().next() : null;
    }

    public void log(java.util.logging.LogRecord record, Object cred) {
        this.validateLogBy(cred);
        if (record instanceof ILogRecord) {
            ILogRecord openssoLogRecord = (ILogRecord)((Object)record);
            this.addLogByInfo(openssoLogRecord, cred);
            this.addModuleName(openssoLogRecord);
        }
        record.setLoggerName(this.getName());
        String rbName = this.getResourceBundleName();
        if (rbName != null) {
            ResourceBundle bundle = ResourceBundle.getBundle(rbName);
            record.setResourceBundle(bundle);
        }
        this.writeToLog(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToLog(java.util.logging.LogRecord record) {
        block9: {
            try {
                rwLock.readRequest();
                if (lm.isSecure()) {
                    Logger logger = this;
                    synchronized (logger) {
                        super.log(record);
                        break block9;
                    }
                }
                super.log(record);
            }
            catch (Exception ex) {
                Debug.error("Logger.writeToLog:" + this.logName + ":" + ex.getMessage());
                throw new AMLogException(this.logName + ":" + ex.getMessage());
            }
            finally {
                rwLock.readDone();
            }
        }
    }

    public void flush() {
        Logger logger = this;
        Handler[] targets = logger.getHandlers();
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                targets[i].flush();
            }
        }
    }

    public static synchronized java.util.logging.Logger getLogger(String name) {
        if (name == null || name.length() == 0 || name.indexOf("..") >= 0) {
            return null;
        }
        boolean loggerExists = false;
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            loggerExists = true;
        }
        if (loggerExists) {
            Logger result = (Logger)lm.getLogger(name);
            return result;
        }
        java.util.logging.Logger newLog = java.util.logging.Logger.getLogger(name);
        lm.addLogger(newLog);
        Logger result = (Logger)lm.getLogger(name);
        result.logName = name;
        Logger.processNewLoggerObject(result);
        if (SystemProperties.isServerMode()) {
            Logger.logStartRecord(result);
        }
        if (!LogManager.isMonitoringInit) {
            lm.updateMonitConfigForLogService();
        }
        return result;
    }

    public static synchronized java.util.logging.Logger getLogger(String name, String rbName) {
        if (name == null || name.length() == 0 || name.indexOf("..") >= 0) {
            return null;
        }
        boolean loggerExists = false;
        Enumeration<String> e = lm.getLoggerNames();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(name)) continue;
            loggerExists = true;
        }
        Logger result = (Logger)java.util.logging.Logger.getLogger(name, rbName);
        result.logName = name;
        if (loggerExists) {
            return result;
        }
        Logger.processNewLoggerObject(result);
        if (SystemProperties.isServerMode()) {
            Logger.logStartRecord(result);
        }
        return result;
    }

    private static void logStartRecord(Logger logger) {
        try {
            LogMessageProviderBase provider = (LogMessageProviderBase)MessageProviderFactory.getProvider("Logging");
            SSOToken ssot = LogManagerUtil.getLoggingSSOToken();
            String location = lm.getProperty("iplanet-am-logging-location");
            String[] s = new String[]{location};
            LogRecord lr = provider.createLogRecord("LOG_START_NEW_LOGGER", s, ssot);
            logger.log(lr, ssot);
        }
        catch (IOException ioex) {
            Debug.error("Logger.logStartRecord:could not log to " + logger.getName() + ":" + ioex.getMessage());
        }
    }

    public String getCurrentFile() {
        return this.currentFileName;
    }

    public void setCurrentFile(String fileName) {
        this.currentFileName = fileName;
    }

    public static boolean resolveHostNameEnabled() {
        return resolveHostName;
    }

    static void extractInfoFromLogFor(ILogRecord rec) throws SSOException {
        Object cred;
        Object logFor = rec.getLogFor();
        Object object = cred = logFor instanceof Subject ? Logger.getPrivateCred((Subject)logFor) : logFor;
        if (!(cred instanceof SSOToken)) {
            return;
        }
        SSOToken ssoToken = (SSOToken)cred;
        rec.addLogInfo("LoginIDSid", ((Object)ssoToken.getTokenID()).toString());
        String ctxID = ssoToken.getProperty("AMCtxId");
        if (ctxID != null && ctxID.length() > 0) {
            rec.addLogInfo("ContextID", ctxID);
        }
        Logger.resolveHostName(rec, ssoToken);
        String clientDomain = ssoToken.getProperty("Organization");
        if (clientDomain == null || clientDomain.length() == 0) {
            clientDomain = ssoToken.getProperty("cdomain");
        }
        rec.addLogInfo("Domain", clientDomain);
        rec.addLogInfo("LoginID", ssoToken.getPrincipal().getName());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rec.addLogInfo("TIME", sdf.format(date));
        if (rec instanceof java.util.logging.LogRecord) {
            java.util.logging.LogRecord jLogRecord = (java.util.logging.LogRecord)((Object)rec);
            rec.addLogInfo("Data", jLogRecord.getMessage());
            rec.addLogInfo("LogLevel", jLogRecord.getLevel().toString());
        }
    }

    static void resolveHostName(ILogRecord rec, SSOToken ssoToken) throws SSOException {
        InetAddress ipAddr;
        String hostName = ssoToken.getHostName();
        String ipAddress = null;
        if (resolveHostName && (ipAddr = ssoToken.getIPAddress()) != null) {
            ipAddress = ipAddr.getHostAddress();
            if (hostName == null || ipAddress != null && ipAddress.equals(hostName)) {
                hostName = ipAddr.getHostName();
            }
        }
        rec.addLogInfo("HostName", hostName);
        rec.addLogInfo("IPAddr", ipAddress);
    }

    static {
        File dir;
        token = new ThreadLocal();
        rwLock = new ReaderWriterLock();
        lm = LogManagerUtil.getLogManager();
        try {
            lm.readConfiguration();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String location = lm.getProperty("iplanet-am-logging-location");
        String type = lm.getProperty("iplanet-am-logging-type");
        if (location != null && type.equals("File") && !(dir = new File(location)).exists() && !dir.mkdirs()) {
            Debug.error("Logger:Creation of Log Directory failed: " + location);
        }
        resolveHostName = Boolean.valueOf(lm.getProperty("resolveHostName"));
    }
}

