/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.sun.identity.monitoring.LinkTrapGenerator;
import com.sun.identity.monitoring.SSOServerInfo;
import com.sun.identity.monitoring.SSOServerMonConfig;
import com.sun.identity.monitoring.SSOServerRealmFedInfo;
import com.sun.identity.monitoring.SSOServerRealmInfo;
import com.sun.identity.monitoring.SUN_OPENSSO_SERVER_MIB;
import com.sun.identity.monitoring.SsoServerAuthModulesEntryImpl;
import com.sun.identity.monitoring.SsoServerAuthSvcImpl;
import com.sun.identity.monitoring.SsoServerFedCOTMemberEntryImpl;
import com.sun.identity.monitoring.SsoServerFedCOTs;
import com.sun.identity.monitoring.SsoServerFedCOTsEntryImpl;
import com.sun.identity.monitoring.SsoServerFedEntities;
import com.sun.identity.monitoring.SsoServerFedEntitiesEntryImpl;
import com.sun.identity.monitoring.SsoServerInstanceImpl;
import com.sun.identity.monitoring.SsoServerPolicy22AgentEntryImpl;
import com.sun.identity.monitoring.SsoServerPolicy22AgentEntryMBean;
import com.sun.identity.monitoring.SsoServerPolicyAgentsImpl;
import com.sun.identity.monitoring.SsoServerPolicyJ2EEAgentEntryImpl;
import com.sun.identity.monitoring.SsoServerPolicyJ2EEAgentEntryMBean;
import com.sun.identity.monitoring.SsoServerPolicyJ2EEGroupEntryImpl;
import com.sun.identity.monitoring.SsoServerPolicyJ2EEGroupEntryMBean;
import com.sun.identity.monitoring.SsoServerPolicyWebAgentEntryImpl;
import com.sun.identity.monitoring.SsoServerPolicyWebGroupEntryImpl;
import com.sun.identity.monitoring.SsoServerRealmEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML1CacheEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML1EndPointEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML1SvcImpl;
import com.sun.identity.monitoring.SsoServerSAML1TrustPrtnrsEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML2IDPEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML2IDPEntryMBean;
import com.sun.identity.monitoring.SsoServerSAML2SPEntryImpl;
import com.sun.identity.monitoring.SsoServerSAML2SPEntryMBean;
import com.sun.identity.monitoring.SsoServerSAML2SvcImpl;
import com.sun.identity.monitoring.SsoServerSiteMapEntryImpl;
import com.sun.identity.monitoring.SsoServerSiteMapEntryMBean;
import com.sun.identity.monitoring.SsoServerSitesEntryImpl;
import com.sun.identity.monitoring.SsoServerSitesEntryMBean;
import com.sun.identity.monitoring.SsoServerTopologyImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsDSCAgentEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsDSCAgentEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsDSCAgtGrpEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsDSCAgtGrpEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsSTSAgentEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsSTSAgentEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsSTSAgtGrpEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsSTSAgtGrpEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSCAgentEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSCAgentEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSCAgtGrpEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSCAgtGrpEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSPAgentEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSPAgentEntryMBean;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSPAgtGrpEntryImpl;
import com.sun.identity.monitoring.SsoServerWSSAgentsWSPAgtGrpEntryMBean;
import com.sun.identity.monitoring.TableSsoServerAuthModulesTable;
import com.sun.identity.monitoring.TableSsoServerFedCOTMemberTable;
import com.sun.identity.monitoring.TableSsoServerFedCOTsTable;
import com.sun.identity.monitoring.TableSsoServerFedEntitiesTable;
import com.sun.identity.monitoring.TableSsoServerPolicy22AgentTable;
import com.sun.identity.monitoring.TableSsoServerPolicyJ2EEAgentTable;
import com.sun.identity.monitoring.TableSsoServerPolicyJ2EEGroupTable;
import com.sun.identity.monitoring.TableSsoServerPolicyWebAgentTable;
import com.sun.identity.monitoring.TableSsoServerPolicyWebGroupTable;
import com.sun.identity.monitoring.TableSsoServerRealmTable;
import com.sun.identity.monitoring.TableSsoServerSAML1CacheTable;
import com.sun.identity.monitoring.TableSsoServerSAML1EndPointTable;
import com.sun.identity.monitoring.TableSsoServerSAML1TrustPrtnrsTable;
import com.sun.identity.monitoring.TableSsoServerSAML2IDPTable;
import com.sun.identity.monitoring.TableSsoServerSAML2SPTable;
import com.sun.identity.monitoring.TableSsoServerSiteMapTable;
import com.sun.identity.monitoring.TableSsoServerSitesTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsDSCAgentTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsDSCAgtGrpTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsSTSAgentTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsSTSAgtGrpTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsWSCAgentTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsWSCAgtGrpTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsWSPAgentTable;
import com.sun.identity.monitoring.TableSsoServerWSSAgentsWSPAgtGrpTable;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMibHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class Agent {
    static SnmpAdaptorServer snmpAdaptor = null;
    private static Debug debug;
    private static int nbTraps;
    private static boolean agentStarted;
    private static boolean webtopConfig;
    private static boolean monitoringConfig;
    private static MBeanServer server;
    private static ObjectName htmlObjName;
    private static ObjectName snmpObjName;
    private static ObjectName mibObjName;
    private static ObjectName trapGeneratorObjName;
    private static int monHtmlPort;
    private static int monSnmpPort;
    private static int monRmiPort;
    private static String ssoProtocol;
    private static String ssoName;
    private static String ssoPort;
    private static String ssoURI;
    private static String ssoSiteID;
    private static String ssoServerID;
    private static boolean dsIsEmbedded;
    private static boolean siteIsEnabled;
    private static Hashtable siteIdTable;
    private static Hashtable serverIDTable;
    private static Hashtable namingTable;
    private static HashMap siteToURL;
    private static HashMap URLToSite;
    private static String startDate;
    private static JMXConnectorServer cs;
    static SUN_OPENSSO_SERVER_MIB mib2;
    private static SSOServerInfo agentSvrInfo;
    private static Map realm2Index;
    private static Map index2Realm;
    private static Map realm2DN;
    private static Map DN2Realm;
    private static Map realmAuthInst;
    private static Map realmSAML2IDPs;
    private static Map realmSAML2SPs;
    private static boolean monitoringEnabled;
    private static boolean monHtmlPortEnabled;
    private static boolean monSnmpPortEnabled;
    private static boolean monRmiPortEnabled;
    private static boolean isSessFOEnabled;
    private static SimpleDateFormat sdf;
    static final String NotAvail = "NotAvailable";
    static final String None = "NONE";

    private Agent() {
    }

    protected static void stopRMI() {
        if (monitoringEnabled && monRmiPortEnabled && cs != null) {
            block9: {
                if (server != null && mibObjName != null) {
                    try {
                        server.unregisterMBean(mibObjName);
                    }
                    catch (InstanceNotFoundException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning("Agent.stopRMI: error unregistering OpenSSO:" + ex.getMessage());
                        }
                    }
                    catch (MBeanRegistrationException ex) {
                        if (!debug.warningEnabled()) break block9;
                        debug.warning("Agent.stopRMI: error unregistering OpenSSO:" + ex.getMessage());
                    }
                }
            }
            try {
                cs.stop();
            }
            catch (Exception ex) {
                debug.error("Agent.stopRMI: error stopping monitoring  agent RMI server: ", (Throwable)ex);
            }
        } else {
            debug.warning("Agent.stopRMI: cs is null, or monitoring or RMI port not enabled.");
        }
    }

    public static int siteAndServerInfo(SSOServerInfo svrInfo) {
        agentSvrInfo = svrInfo;
        return 0;
    }

    public static int startMonitoringAgent(SSOServerInfo svrInfo) {
        agentSvrInfo = svrInfo;
        String serverID = svrInfo.serverID;
        String siteID = svrInfo.siteID;
        String serverProtocol = svrInfo.serverProtocol;
        String serverName = svrInfo.serverName;
        String serverURI = svrInfo.serverURI;
        String serverPort = svrInfo.serverPort;
        boolean isEmbeddedDS = svrInfo.isEmbeddedDS;
        Hashtable siteIDTable = svrInfo.siteIDTable;
        Hashtable serverIDTable = svrInfo.serverIDTable;
        Hashtable namingTable = svrInfo.namingTable;
        String startDate = svrInfo.startDate;
        if (debug.messageEnabled()) {
            StringBuffer sb = new StringBuffer("Agent.startMonitoringAgent:ServerInfo:\n");
            sb.append("  ServerID = ").append(serverID).append("\n").append("  SiteID = ").append(siteID).append("\n").append("  ServerProtocol = ").append(serverProtocol).append("\n").append("  ServerName = ").append(serverName).append("\n").append("  ServerURI = ").append(serverURI).append("\n").append("  IsEmbeddedDS = ").append(isEmbeddedDS).append("\n").append("\n");
            Hashtable tht = siteIDTable;
            Set keySet = tht.keySet();
            sb.append("  SiteID Table:\n");
            for (String key : keySet) {
                String value = (String)tht.get(key);
                sb.append("    key = ").append(key).append(", value = ").append(value).append("\n");
            }
            String svrURL = (String)namingTable.get(serverID);
            sb.append("  Naming table entry for serverID ").append(serverID).append(" is ");
            if (svrURL != null && svrURL.length() > 0) {
                sb.append(svrURL).append("\n");
            } else {
                sb.append("NULL!\n");
            }
            svrURL = (String)namingTable.get(siteID);
            sb.append("  Naming table entry for siteID ").append(siteID).append(" is ");
            if (svrURL != null && svrURL.length() > 0) {
                sb.append(svrURL).append("\n");
            } else {
                sb.append("NULL!\n");
            }
            debug.message(sb.toString());
        }
        return Agent.startMonitoringAgent(serverID, serverProtocol, serverName, serverPort, serverURI, siteID, isEmbeddedDS, siteIDTable, serverIDTable, namingTable, startDate);
    }

    public static int startMonitoringAgent(String openSSOServerID, String svrProtocol, String svrName, String svrPort, String svrURI, String siteID, boolean isEmbeddedDS, Hashtable siteIdTbl, Hashtable serverIdTbl, Hashtable namingTbl, String stDate) {
        String classMethod = "Agent.startMonitoringAgent:";
        ssoServerID = openSSOServerID;
        ssoProtocol = svrProtocol;
        ssoName = svrName;
        ssoPort = svrPort;
        ssoURI = svrURI;
        ssoSiteID = siteID;
        dsIsEmbedded = isEmbeddedDS;
        siteIsEnabled = !ssoServerID.equals(siteID);
        siteIdTable = siteIdTbl;
        serverIDTable = serverIdTbl;
        namingTable = namingTbl;
        startDate = stDate;
        if (debug.messageEnabled()) {
            String svrURL = (String)namingTable.get(ssoServerID);
            StringBuffer sb2 = new StringBuffer("    Naming table entry for serverID ");
            sb2.append(ssoServerID).append(": ");
            if (svrURL != null && svrURL.length() > 0) {
                sb2.append(svrURL).append("\n");
            } else {
                sb2.append("NULL!\n");
            }
            svrURL = (String)namingTable.get(siteID);
            sb2.append("    Naming table entry for siteID ").append(siteID).append(": ");
            if (svrURL != null && svrURL.length() > 0) {
                sb2.append(svrURL).append("\n");
            } else {
                sb2.append("NULL!\n");
            }
            debug.message(classMethod + "parameters are:\n" + "    serverID = " + openSSOServerID + "\n" + "    protocol = " + svrProtocol + "\n" + "    svrName = " + svrName + "\n" + "    port = " + svrPort + "\n" + "    siteID = " + siteID + "\n" + "    isEmbeddedDS = " + isEmbeddedDS + "\n" + "    siteIsEnabled = " + siteIsEnabled + "\n" + sb2.toString() + "\n" + "    start date/time = " + stDate);
        }
        if (debug.messageEnabled()) {
            String svrid;
            StringBuffer sb;
            Set ks;
            if (siteIdTable != null && !siteIdTable.isEmpty()) {
                debug.message(classMethod + "siteIdTable -> " + siteIdTable.toString());
                ks = siteIdTable.keySet();
                sb = new StringBuffer("Site ID Table:\n");
                for (String siteid : ks) {
                    svrid = (String)siteIdTable.get(siteid);
                    String sURL = (String)namingTable.get(siteid);
                    sb.append("  ").append(siteid).append("(").append(sURL).append(")").append(" = ").append(svrid).append("\n");
                }
                debug.message(classMethod + sb.toString());
            } else {
                debug.message(classMethod + "siteIdTable is null or empty");
            }
            if (serverIDTable != null && !serverIDTable.isEmpty()) {
                ks = serverIDTable.keySet();
                sb = new StringBuffer("Server ID Table:\n");
                for (String svr : ks) {
                    svrid = (String)serverIDTable.get(svr);
                    sb.append("  server ").append(svr).append(" ==> svrid ").append(svrid).append("\n");
                }
                debug.message(classMethod + sb.toString());
            } else {
                debug.message(classMethod + "ServerIdTable is null or empty");
            }
            if (namingTable != null && !namingTable.isEmpty()) {
                ks = namingTable.keySet();
                sb = new StringBuffer("Naming Table:\n");
                for (String svr : ks) {
                    svrid = (String)namingTable.get(svr);
                    sb.append("  key ").append(svr).append(" ==> value ").append(svrid).append("\n");
                }
                debug.message(classMethod + sb.toString());
            } else {
                debug.message(classMethod + "NamingTable is null or empty");
            }
        }
        return 0;
    }

    public static int startAgent(SSOServerMonConfig monConfig) {
        boolean monRMIStarted;
        boolean monSNMPStarted;
        boolean monHTMLStarted;
        String classMethod;
        block89: {
            String domain;
            block88: {
                ArrayList<MBeanServer> servers;
                block87: {
                    monHtmlPort = monConfig.htmlPort;
                    monSnmpPort = monConfig.snmpPort;
                    monRmiPort = monConfig.rmiPort;
                    monitoringEnabled = monConfig.monitoringEnabled;
                    monHtmlPortEnabled = monConfig.monHtmlPortEnabled;
                    monSnmpPortEnabled = monConfig.monSnmpPortEnabled;
                    monRmiPortEnabled = monConfig.monRmiPortEnabled;
                    classMethod = "Agent.startAgent:";
                    String serverPort = Agent.agentSvrInfo.serverPort;
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "entry:\n" + "    htmlPort = " + monHtmlPort + "\n" + "    snmpPort = " + monSnmpPort + "\n" + "    rmiPort = " + monRmiPort + "\n" + "    monEna = " + monitoringEnabled + "\n" + "    htmlEna = " + monHtmlPortEnabled + "\n" + "    snmpEna = " + monSnmpPortEnabled + "\n" + "    rmiEna = " + monRmiPortEnabled + "\n" + "    serverPort = " + serverPort + "\n");
                    }
                    if (!monitoringEnabled) {
                        debug.warning(classMethod + "Monitoring configured as disabled.");
                        return -1;
                    }
                    try {
                        int sport = Integer.parseInt(serverPort);
                        if (monRmiPort == sport) {
                            debug.error(classMethod + "RMI port conflicts with OpenSSO server port (" + sport + "); Monitoring disabled.");
                            return -3;
                        }
                        if (monHtmlPort == sport) {
                            monHtmlPortEnabled = false;
                            if (debug.warningEnabled()) {
                                debug.warning(classMethod + "HTML port conflicts with OpenSSO server port (" + sport + "); Monitoring HTML port disabled.");
                            }
                        }
                        if (monSnmpPort == sport) {
                            monSnmpPortEnabled = false;
                            if (debug.warningEnabled()) {
                                debug.warning(classMethod + "SNMP port conflicts with OpenSSO server port (" + sport + "); Monitoring SNMP port disabled.");
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        debug.error(classMethod + "Server port (" + serverPort + " is invalid: " + nfe.getMessage());
                    }
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "config:\n" + "    monitoring Enabled = " + monitoringEnabled + "\n" + "    HTML Port = " + monHtmlPort + ", enabled = " + monHtmlPortEnabled + "\n" + "    SNMP Port = " + monSnmpPort + ", enabled = " + monSnmpPortEnabled + "\n" + "    RMI Port = " + monRmiPort + ", enabled = " + monRmiPortEnabled + "\n");
                    }
                    servers = null;
                    try {
                        servers = MBeanServerFactory.findMBeanServer(null);
                    }
                    catch (SecurityException ex) {
                        if (!debug.warningEnabled()) break block87;
                        debug.warning(classMethod + "findMBeanServer permission error: " + ex.getMessage());
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "MBeanServer list is not empty: " + (servers != null && !servers.isEmpty()));
                }
                if (servers != null && !servers.isEmpty()) {
                    server = servers.get(0);
                } else {
                    try {
                        server = MBeanServerFactory.createMBeanServer();
                    }
                    catch (SecurityException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "createMBeanServer permission error: " + ex.getMessage());
                        }
                        return -2;
                    }
                    catch (JMRuntimeException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "createMBeanServer JMRuntime error: " + ex.getMessage());
                        }
                        return -2;
                    }
                    catch (ClassCastException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "createMBeanServer ClassCast error: " + ex.getMessage());
                        }
                        return -2;
                    }
                }
                if (server == null) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "no MBeanServer");
                    }
                    return -2;
                }
                domain = server.getDefaultDomain();
                try {
                    mibObjName = new ObjectName("snmp:class=SUN_OPENSSO_SERVER_MIB");
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Adding SUN_OPENSSO_SERVER_MIB to MBean server " + "with name '" + mibObjName + "'");
                    }
                }
                catch (MalformedObjectNameException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error getting ObjectName for the MIB: " + ex.getMessage());
                    }
                    return -4;
                }
                mib2 = new SUN_OPENSSO_SERVER_MIB();
                try {
                    server.registerMBean(mib2, mibObjName);
                }
                catch (RuntimeOperationsException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Null parameter or no object name for MIB specified: " + ex.getMessage());
                    }
                    return -4;
                }
                catch (InstanceAlreadyExistsException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error registering MIB MBean: " + ex.getMessage());
                    }
                }
                catch (MBeanRegistrationException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error registering MIB MBean: " + ex.getMessage());
                    }
                    return -4;
                }
                catch (NotCompliantMBeanException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error registering MIB MBean: " + ex.getMessage());
                    }
                    return -4;
                }
                monHTMLStarted = false;
                monSNMPStarted = false;
                monRMIStarted = false;
                if (monHtmlPortEnabled) {
                    try {
                        HtmlAdaptorServer htmlAdaptor;
                        htmlObjName = new ObjectName(domain + ":class=HtmlAdaptorServer,protocol=html,port=" + monHtmlPort);
                        if (debug.messageEnabled()) {
                            debug.message(classMethod + "Adding HTML adaptor to MBean server with name '" + htmlObjName + "'\n    " + "HTML adaptor is bound on TCP port " + monHtmlPort);
                        }
                        if ((htmlAdaptor = new HtmlAdaptorServer(monHtmlPort)) == null) {
                            if (debug.warningEnabled()) {
                                debug.warning(classMethod + "HTTP port " + monHtmlPort + " unavailable or invalid. " + "Monitoring HTML adaptor not started.");
                            }
                            break block88;
                        }
                        server.registerMBean(htmlAdaptor, htmlObjName);
                        htmlAdaptor.start();
                        monHTMLStarted = true;
                    }
                    catch (MalformedObjectNameException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "Error getting ObjectName for HTML adaptor: " + ex.getMessage());
                        }
                        break block88;
                    }
                    catch (NullPointerException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "NPE getting ObjectName for HTML adaptor: " + ex.getMessage());
                        }
                        break block88;
                    }
                    catch (InstanceAlreadyExistsException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "Error registering HTML adaptor MBean: " + ex.getMessage());
                        }
                        break block88;
                    }
                    catch (MBeanRegistrationException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "Error registering HTML adaptor MBean: " + ex.getMessage());
                        }
                        break block88;
                    }
                    catch (NotCompliantMBeanException ex) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "Error registering HTML adaptor MBean: " + ex.getMessage());
                        }
                        break block88;
                    }
                }
                debug.warning(classMethod + "Monitoring HTML port not enabled in configuration.");
            }
            if (monSnmpPortEnabled) {
                try {
                    snmpObjName = new ObjectName(domain + ":class=SnmpAdaptorServer,protocol=snmp,port=" + monSnmpPort);
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Adding SNMP adaptor to MBean server with name '" + snmpObjName + "'\n    " + "SNMP Adaptor is bound on UDP port " + monSnmpPort);
                    }
                    if ((snmpAdaptor = new SnmpAdaptorServer(monSnmpPort)) == null) {
                        if (debug.warningEnabled()) {
                            debug.warning(classMethod + "Unable to get SNMP adaptor.");
                        }
                        break block89;
                    }
                    server.registerMBean(snmpAdaptor, snmpObjName);
                    snmpAdaptor.start();
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Sending a coldStart SNMP trap to each " + "destination defined in the ACL file...");
                    }
                    snmpAdaptor.setTrapPort(new Integer(monSnmpPort + 1));
                    snmpAdaptor.snmpV1Trap(0, 0, null);
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Done sending coldStart.");
                    }
                    mib2.setSnmpAdaptor((SnmpMibHandler)snmpAdaptor);
                    monSNMPStarted = true;
                }
                catch (MalformedObjectNameException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error getting ObjectName for SNMP adaptor: " + ex.getMessage());
                    }
                }
                catch (NullPointerException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "NPE getting ObjectName for SNMP adaptor: " + ex.getMessage());
                    }
                }
                catch (InstanceAlreadyExistsException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error registering SNMP adaptor MBean: " + ex.getMessage());
                    }
                }
                catch (MBeanRegistrationException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error registering SNMP adaptor MBean: " + ex.getMessage());
                    }
                }
                catch (NotCompliantMBeanException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Error registering SNMP adaptor MBean: " + ex.getMessage());
                    }
                }
                catch (IOException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "IO Error from SNMP snmpV1Trap: " + ex.getMessage());
                    }
                    monSNMPStarted = true;
                }
                catch (SnmpStatusException ex) {
                    if (debug.warningEnabled()) {
                        debug.warning(classMethod + "Status error from SNMP snmpV1Trap: " + ex.getMessage());
                    }
                    monSNMPStarted = true;
                }
            } else {
                debug.warning(classMethod + "Monitoring SNMP port not enabled.");
            }
        }
        if (monRmiPortEnabled) {
            try {
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + monRmiPort + "/server");
                cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, server);
                cs.start();
                monRMIStarted = true;
            }
            catch (MalformedURLException ex) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "Error getting JMXServiceURL or JMXConnectorServer " + "for RMI adaptor: " + ex.getMessage());
                }
            }
            catch (NullPointerException ex) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "Error getting JMXServiceURL or JMXConnectorServer " + "for RMI adaptor: " + ex.getMessage());
                }
            }
            catch (IOException ex) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "Error getting JMXConnectorServer for, or starting " + "RMI adaptor: " + ex.getMessage());
                }
            }
            catch (IllegalStateException ex) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "Illegal State Error from JMXConnectorServer for " + "RMI adaptor: " + ex.getMessage());
                }
            }
            catch (Exception ex) {
                debug.error(classMethod + "Error starting RMI: executing rmiregistry " + monRmiPort + ".", (Throwable)ex);
            }
        } else {
            debug.warning(classMethod + "Monitoring RMI port not enabled.");
        }
        if (!(monRMIStarted || monSNMPStarted || monHTMLStarted)) {
            debug.warning(classMethod + "No Monitoring interfaces started; monitoring disabled.");
            return -3;
        }
        agentStarted = true;
        Agent.startMonitoringAgent(agentSvrInfo);
        return 0;
    }

    public static void setWebtopConfig(boolean state) {
        webtopConfig = state;
    }

    public static void setMonitoringConfig(boolean state) {
        monitoringConfig = state;
    }

    public static boolean isRunning() {
        return agentStarted;
    }

    public static Object getAuthSvcMBean() {
        if (mib2 != null) {
            return mib2.getAuthSvcGroup();
        }
        return null;
    }

    public static Object getSessSvcMBean() {
        if (mib2 != null) {
            return mib2.getSessSvcGroup();
        }
        return null;
    }

    public static Object getLoggingSvcMBean() {
        if (mib2 != null) {
            return mib2.getLoggingSvcGroup();
        }
        return null;
    }

    public static Object getPolicySvcMBean() {
        if (mib2 != null) {
            return mib2.getPolicySvcGroup();
        }
        return null;
    }

    public static Object getIdrepoSvcMBean() {
        if (mib2 != null) {
            return mib2.getIdrepoSvcGroup();
        }
        return null;
    }

    public static Object getSmSvcMBean() {
        if (mib2 != null) {
            return mib2.getSmSvcGroup();
        }
        return null;
    }

    public static Object getSaml1SvcMBean() {
        if (mib2 != null) {
            return mib2.getSaml1SvcGroup();
        }
        return null;
    }

    public static Object getSaml2SvcMBean() {
        if (mib2 != null) {
            return mib2.getSaml2SvcGroup();
        }
        return null;
    }

    public static Object getIdffSvcMBean() {
        if (mib2 != null) {
            return mib2.getIdffSvcGroup();
        }
        return null;
    }

    public static Object getTopologyMBean() {
        if (mib2 != null) {
            return mib2.getTopologyGroup();
        }
        return null;
    }

    public static Object getSvrInstanceMBean() {
        if (mib2 != null) {
            return mib2.getSvrInstanceGroup();
        }
        return null;
    }

    public static Object getFedCOTsMBean() {
        if (mib2 != null) {
            return mib2.getFedCotsGroup();
        }
        return null;
    }

    public static Object getFedEntsMBean() {
        if (mib2 != null) {
            return mib2.getFedEntitiesGroup();
        }
        return null;
    }

    public static Object getSAML2SvcGroup() {
        if (mib2 != null) {
            return mib2.getSaml2SvcGroup();
        }
        return null;
    }

    public static String getSsoProtocol() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.serverProtocol;
        }
        return null;
    }

    public static String getSsoName() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.serverName;
        }
        return null;
    }

    public static String getSsoPort() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.serverPort;
        }
        return null;
    }

    public static String getSsoURI() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.serverURI;
        }
        return null;
    }

    public static String getSsoSvrID() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.serverID;
        }
        return null;
    }

    public static Hashtable getSiteIdTable() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.siteIDTable;
        }
        return null;
    }

    public static Hashtable getServerIdTable() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.serverIDTable;
        }
        return null;
    }

    public static Hashtable getNamingTable() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.namingTable;
        }
        return null;
    }

    public static HashMap getSiteToURLTable() {
        return siteToURL;
    }

    public static HashMap getURLToSiteTable() {
        return URLToSite;
    }

    public static boolean getDsIsEmbedded() {
        return dsIsEmbedded;
    }

    public static String getStartDate() {
        return startDate;
    }

    public static String getSiteId() {
        if (agentSvrInfo != null) {
            return Agent.agentSvrInfo.siteID;
        }
        return null;
    }

    public static boolean getWebtopConfig() {
        return webtopConfig;
    }

    public static boolean getMonitoringConfig() {
        return monitoringConfig;
    }

    public static void siteNames(HashMap sNames, HashMap urlSites) {
        String classMethod = "Agent.siteNames:";
        if (sNames.size() == 0) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "no sites");
            }
            return;
        }
        Date startDate = new Date();
        siteToURL = sNames;
        URLToSite = urlSites;
        if (debug.messageEnabled()) {
            Set kset = sNames.keySet();
            StringBuffer sb = new StringBuffer("Site Names and URLs:\n");
            for (String stName : kset) {
                String stURL = (String)sNames.get(stName);
                sb.append("    siteName = ").append(stName).append(", primary URL = ").append(stURL).append("\n");
            }
            debug.message(classMethod + sb.toString());
        }
        Set sidKeys = siteIdTable.keySet();
        int i = 1;
        for (String svrId : sidKeys) {
            Serializable ssse;
            String siteId = (String)siteIdTable.get(svrId);
            String svrURL = (String)namingTable.get(siteId);
            String siteName = (String)urlSites.get(svrURL);
            String escSiteName = Agent.getEscapedString(siteName);
            SsoServerTopologyImpl tg = (SsoServerTopologyImpl)mib2.getTopologyGroup();
            if (siteId.equals(svrId)) {
                ssse = new SsoServerSitesEntryImpl(mib2);
                Integer sid = new Integer(0);
                try {
                    sid = new Integer(siteId);
                }
                catch (NumberFormatException nfe) {
                    debug.error(classMethod + "invalid siteid (" + siteId + "): " + nfe.getMessage(), (Throwable)nfe);
                }
                ((SsoServerSitesEntryImpl)ssse).SsoServerSiteId = sid;
                ((SsoServerSitesEntryImpl)ssse).SsoServerSiteName = escSiteName;
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "doing siteName " + siteName + ", svrURL = " + svrURL);
                }
                ObjectName stName = ((SsoServerSitesEntryImpl)ssse).createSsoServerSitesEntryObjectName(server);
                try {
                    TableSsoServerSitesTable stTbl = tg.accessSsoServerSitesTable();
                    stTbl.addEntry((SsoServerSitesEntryMBean)((Object)ssse), stName);
                    if (server == null || stName == null) continue;
                    server.registerMBean(ssse, stName);
                }
                catch (Exception ex) {
                    debug.error(classMethod + siteId, (Throwable)ex);
                }
                continue;
            }
            ssse = new SsoServerSiteMapEntryImpl(mib2);
            ((SsoServerSiteMapEntryImpl)ssse).SsoServerMapServerURL = (String)namingTable.get(svrId);
            ((SsoServerSiteMapEntryImpl)ssse).SsoServerMapSiteName = escSiteName;
            ((SsoServerSiteMapEntryImpl)ssse).SsoServerMapId = siteId;
            try {
                ((SsoServerSiteMapEntryImpl)ssse).SsoServerSiteMapId = new Integer(svrId);
            }
            catch (NumberFormatException nfe) {
                debug.error(classMethod + "invalid serverID (" + svrId + "): " + nfe.getMessage(), (Throwable)nfe);
            }
            ((SsoServerSiteMapEntryImpl)ssse).SsoServerSiteMapIndex = new Integer(i++);
            ObjectName smName = ((SsoServerSiteMapEntryImpl)ssse).createSsoServerSiteMapEntryObjectName(server);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "doing servermap entry; sitemapid = " + svrId + ", mapid = " + siteId + ", siteName = " + siteName);
            }
            try {
                TableSsoServerSiteMapTable stTbl = tg.accessSsoServerSiteMapTable();
                stTbl.addEntry((SsoServerSiteMapEntryMBean)((Object)ssse), smName);
                if (server == null || smName == null) continue;
                server.registerMBean(ssse, smName);
            }
            catch (Exception ex) {
                debug.error(classMethod + siteId + "/" + svrId, (Throwable)ex);
            }
        }
        Date stopDate = new Date();
        if (debug.messageEnabled()) {
            String stDate = sdf.format(startDate);
            String endDate = sdf.format(stopDate);
            debug.message("Agent.siteNames:\n    Start Time = " + stDate + "\n      End Time = " + endDate);
        }
    }

    public static void realmsConfig(ArrayList realmList) {
        String classMethod = "Agent.realmsConfig:";
        Date startDate = new Date();
        StringBuffer sb = new StringBuffer("receiving list of realms (size = ");
        sb.append(realmList.size()).append("):\n");
        SsoServerInstanceImpl sig = (SsoServerInstanceImpl)mib2.getSvrInstanceGroup();
        TableSsoServerRealmTable rtab = null;
        if (sig != null) {
            try {
                rtab = sig.accessSsoServerRealmTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting realm table: ", (Throwable)ex);
            }
        }
        for (int i = 0; i < realmList.size(); ++i) {
            String ss = (String)realmList.get(i);
            SsoServerRealmEntryImpl rei = new SsoServerRealmEntryImpl(mib2);
            rei.SsoServerRealmIndex = new Integer(i + 1);
            String ss2 = ss;
            rei.SsoServerRealmName = ss2 = Agent.getEscapedString(ss2);
            ObjectName oname = rei.createSsoServerRealmEntryObjectName(server);
            String rlmToDN = DNMapper.orgNameToDN(ss);
            sb.append("  realm #").append(i).append(" = ").append(ss).append(", DN = ").append(rlmToDN).append("\n");
            try {
                rtab.addEntry(rei, oname);
                if (server != null && rei != null) {
                    server.registerMBean(rei, oname);
                }
                realm2Index.put(ss, rei.SsoServerRealmIndex);
                index2Realm.put(rei.SsoServerRealmIndex, ss);
                realm2DN.put(ss, rlmToDN);
                DN2Realm.put(rlmToDN, ss);
                continue;
            }
            catch (JMException ex) {
                debug.error(classMethod + ss, (Throwable)ex);
                continue;
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + ss, (Throwable)ex);
            }
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + sb.toString());
        }
        Date stopDate = new Date();
        if (debug.messageEnabled()) {
            String stDate = sdf.format(startDate);
            String endDate = sdf.format(stopDate);
            debug.message("Agent.realmsConfig:\n    Start Time = " + stDate + "\n      End Time = " + endDate);
        }
    }

    public static int realmConfigMonitoringAgent(SSOServerRealmInfo rlmInfo) {
        String classMethod = "Agent.realmConfigMonitoringAgent:";
        String realm = rlmInfo.realmName;
        HashMap authMods = rlmInfo.authModules;
        Integer realmIndex = (Integer)realm2Index.get(realm);
        if (realmIndex == null) {
            debug.error(classMethod + "could not find realm " + realm + " in realm2Index map");
            return -1;
        }
        SsoServerAuthSvcImpl sig = (SsoServerAuthSvcImpl)mib2.getAuthSvcGroup();
        TableSsoServerAuthModulesTable atab = null;
        if (sig != null) {
            try {
                atab = sig.accessSsoServerAuthModulesTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting auth table: ", (Throwable)ex);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (debug.messageEnabled()) {
            sb.append("receiving config info for realm = ").append(realm).append(":\n  Authentication Modules:\n");
        }
        int i = 1;
        Set authMKeys = authMods.keySet();
        for (String modInst : authMKeys) {
            String modType = (String)authMods.get(modInst);
            if (debug.messageEnabled()) {
                sb.append("    instance = ").append(modInst).append(", value(type) = ").append(modType).append("\n");
            }
            SsoServerAuthModulesEntryImpl aei = new SsoServerAuthModulesEntryImpl(mib2);
            aei.SsoServerRealmIndex = realmIndex;
            aei.SsoServerAuthModuleIndex = new Integer(i++);
            aei.SsoServerAuthModuleName = modInst;
            aei.SsoServerAuthModuleType = Agent.getEscapedString(modType);
            aei.SsoServerAuthModuleSuccessCount = new Long(0L);
            aei.SsoServerAuthModuleFailureCount = new Long(0L);
            ObjectName aname = aei.createSsoServerAuthModulesEntryObjectName(server);
            try {
                atab.addEntry(aei, aname);
                if (server != null && aei != null) {
                    server.registerMBean(aei, aname);
                }
                String rai = realm + "|" + modInst;
                realmAuthInst.put(rai, aei);
            }
            catch (JMException ex) {
                debug.error(classMethod + modInst, (Throwable)ex);
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + modInst, (Throwable)ex);
            }
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + sb.toString());
        }
        return 0;
    }

    public static void configAgentsOnly(String realm, Map agtAttrs) {
        String classMethod = "Agent.configAgentsOnly:";
        if (agtAttrs == null || agtAttrs.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "got null attr map for realm " + realm);
            }
            return;
        }
        SsoServerPolicyAgentsImpl sss = (SsoServerPolicyAgentsImpl)mib2.getPolicyAgentsGroup();
        TableSsoServerPolicy22AgentTable t22tab = null;
        TableSsoServerPolicyJ2EEAgentTable j2eetab = null;
        TableSsoServerPolicyWebAgentTable watab = null;
        SsoServerWSSAgentsImpl ssa = (SsoServerWSSAgentsImpl)mib2.getWssAgentsGroup();
        TableSsoServerWSSAgentsSTSAgentTable ststab = null;
        TableSsoServerWSSAgentsWSPAgentTable wsptab = null;
        TableSsoServerWSSAgentsWSCAgentTable wsctab = null;
        TableSsoServerWSSAgentsDSCAgentTable dsctab = null;
        if (sss != null) {
            try {
                t22tab = sss.accessSsoServerPolicy22AgentTable();
                j2eetab = sss.accessSsoServerPolicyJ2EEAgentTable();
                watab = sss.accessSsoServerPolicyWebAgentTable();
                ststab = ssa.accessSsoServerWSSAgentsSTSAgentTable();
                wsptab = ssa.accessSsoServerWSSAgentsWSPAgentTable();
                wsctab = ssa.accessSsoServerWSSAgentsWSCAgentTable();
                dsctab = ssa.accessSsoServerWSSAgentsDSCAgentTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting Agents tables: ", (Throwable)ex);
                return;
            }
        }
        if (ssa != null) {
            try {
                ststab = ssa.accessSsoServerWSSAgentsSTSAgentTable();
                wsptab = ssa.accessSsoServerWSSAgentsWSPAgentTable();
                wsctab = ssa.accessSsoServerWSSAgentsWSCAgentTable();
                dsctab = ssa.accessSsoServerWSSAgentsDSCAgentTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting WSS Agents tables: ", (Throwable)ex);
                return;
            }
        }
        StringBuffer sb = new StringBuffer(classMethod);
        if (debug.messageEnabled()) {
            sb.append("agents for realm ").append(realm).append(", # = ").append(agtAttrs.size()).append("\n");
        }
        Set ks = agtAttrs.keySet();
        int wai = 1;
        int j2eei = 1;
        int t22i = 1;
        int stsi = 1;
        int wspi = 1;
        int wsci = 1;
        int dsci = 1;
        Integer ri = Agent.getRealmIndexFromName(realm);
        for (String agtname : ks) {
            ObjectName aname;
            String mgrp;
            String wpep;
            String wep;
            Serializable aei;
            ObjectName aname2;
            HashMap hm = (HashMap)agtAttrs.get(agtname);
            String atype = (String)hm.get("AgentType");
            String grpmem = (String)hm.get("groupmembership");
            grpmem = grpmem == null ? None : Agent.getEscapedString(grpmem);
            agtname = Agent.getEscapedString(agtname);
            if (debug.messageEnabled()) {
                sb.append("  agent name = ").append(agtname).append(", type = ").append(atype).append(", membership = ").append(grpmem).append("\n");
            }
            if (atype.equals("WebAgent")) {
                String aurl = (String)hm.get("com.sun.identity.agents.config.agenturi.prefix");
                String lurl = (String)hm.get("com.sun.identity.agents.config.login.url");
                SsoServerPolicyWebAgentEntryImpl aei2 = new SsoServerPolicyWebAgentEntryImpl(mib2);
                aei2.SsoServerRealmIndex = ri;
                aei2.SsoServerPolicyWebAgentIndex = new Integer(wai++);
                aei2.SsoServerPolicyWebAgentName = agtname;
                aei2.SsoServerPolicyWebAgentGroup = grpmem;
                aei2.SsoServerPolicyWebAgentAgentURL = aurl;
                aei2.SsoServerPolicyWebAgentServerURL = lurl;
                aname2 = aei2.createSsoServerPolicyWebAgentEntryObjectName(server);
                try {
                    watab.addEntry(aei2, aname2);
                    if (server == null || aei2 == null) continue;
                    server.registerMBean(aei2, aname2);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("2.2_Agent")) {
                aei = new SsoServerPolicy22AgentEntryImpl(mib2);
                ((SsoServerPolicy22AgentEntryImpl)aei).SsoServerRealmIndex = ri;
                ((SsoServerPolicy22AgentEntryImpl)aei).SsoServerPolicy22AgentIndex = new Integer(t22i++);
                ((SsoServerPolicy22AgentEntryImpl)aei).SsoServerPolicy22AgentName = agtname;
                ObjectName aname3 = ((SsoServerPolicy22AgentEntryImpl)aei).createSsoServerPolicy22AgentEntryObjectName(server);
                try {
                    t22tab.addEntry((SsoServerPolicy22AgentEntryMBean)((Object)aei), aname3);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname3);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("J2EEAgent")) {
                aei = new SsoServerPolicyJ2EEAgentEntryImpl(mib2);
                String aurl = (String)hm.get("com.sun.identity.client.notification.url");
                if (aurl == null) {
                    aurl = None;
                }
                String lurl = (String)hm.get("com.sun.identity.agents.config.login.url");
                ((SsoServerPolicyJ2EEAgentEntryImpl)aei).SsoServerPolicyJ2EEAgentGroup = grpmem;
                ((SsoServerPolicyJ2EEAgentEntryImpl)aei).SsoServerPolicyJ2EEAgentAgentURL = aurl;
                ((SsoServerPolicyJ2EEAgentEntryImpl)aei).SsoServerPolicyJ2EEAgentServerURL = lurl;
                ((SsoServerPolicyJ2EEAgentEntryImpl)aei).SsoServerPolicyJ2EEAgentName = agtname;
                ((SsoServerPolicyJ2EEAgentEntryImpl)aei).SsoServerPolicyJ2EEAgentIndex = new Integer(j2eei++);
                ((SsoServerPolicyJ2EEAgentEntryImpl)aei).SsoServerRealmIndex = ri;
                aname2 = ((SsoServerPolicyJ2EEAgentEntryImpl)aei).createSsoServerPolicyJ2EEAgentEntryObjectName(server);
                try {
                    j2eetab.addEntry((SsoServerPolicyJ2EEAgentEntryMBean)((Object)aei), aname2);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname2);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("WSPAgent")) {
                aei = new SsoServerWSSAgentsWSPAgentEntryImpl(mib2);
                wep = (String)hm.get("wsendpoint");
                if (wep == null) {
                    wep = NotAvail;
                }
                if ((wpep = (String)hm.get("wspproxyendpoint")) == null) {
                    wpep = NotAvail;
                }
                if ((mgrp = (String)hm.get("groupmembership")) == null) {
                    mgrp = None;
                }
                ((SsoServerWSSAgentsWSPAgentEntryImpl)aei).WssAgentsWSPAgentName = agtname;
                ((SsoServerWSSAgentsWSPAgentEntryImpl)aei).WssAgentsWSPAgentSvcEndPoint = wep;
                ((SsoServerWSSAgentsWSPAgentEntryImpl)aei).WssAgentsWSPAgentProxy = wpep;
                ((SsoServerWSSAgentsWSPAgentEntryImpl)aei).WssAgentsWSPAgentIndex = new Integer(wspi++);
                ((SsoServerWSSAgentsWSPAgentEntryImpl)aei).SsoServerRealmIndex = ri;
                aname = ((SsoServerWSSAgentsWSPAgentEntryImpl)aei).createSsoServerWSSAgentsWSPAgentEntryObjectName(server);
                try {
                    if (wsptab != null) {
                        wsptab.addEntry((SsoServerWSSAgentsWSPAgentEntryMBean)((Object)aei), aname);
                        if (server == null || aei == null) continue;
                        server.registerMBean(aei, aname);
                        continue;
                    }
                    debug.error(classMethod + "WSPAgent: agtname = " + agtname + ", wep = " + wep + ", wpep = " + wpep + ", mgrp = " + mgrp + ", realm = " + realm);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("WSCAgent")) {
                aei = new SsoServerWSSAgentsWSCAgentEntryImpl(mib2);
                wep = (String)hm.get("wsendpoint");
                if (wep == null) {
                    wep = None;
                }
                if ((wpep = (String)hm.get("wspproxyendpoint")) == null) {
                    wpep = None;
                }
                if ((mgrp = (String)hm.get("groupmembership")) == null) {
                    mgrp = None;
                }
                ((SsoServerWSSAgentsWSCAgentEntryImpl)aei).WssAgentsWSCAgentName = agtname;
                ((SsoServerWSSAgentsWSCAgentEntryImpl)aei).WssAgentsWSCAgentSvcEndPoint = wep;
                ((SsoServerWSSAgentsWSCAgentEntryImpl)aei).WssAgentsWSCAgentProxy = wpep;
                ((SsoServerWSSAgentsWSCAgentEntryImpl)aei).WssAgentsWSCAgentIndex = new Integer(wsci++);
                ((SsoServerWSSAgentsWSCAgentEntryImpl)aei).SsoServerRealmIndex = ri;
                aname = ((SsoServerWSSAgentsWSCAgentEntryImpl)aei).createSsoServerWSSAgentsWSCAgentEntryObjectName(server);
                try {
                    wsctab.addEntry((SsoServerWSSAgentsWSCAgentEntryMBean)((Object)aei), aname);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("STSAgent")) {
                aei = new SsoServerWSSAgentsSTSAgentEntryImpl(mib2);
                String sep = (String)hm.get("stsendpoint");
                ((SsoServerWSSAgentsSTSAgentEntryImpl)aei).WssAgentsSTSAgentName = agtname;
                ((SsoServerWSSAgentsSTSAgentEntryImpl)aei).WssAgentsSTSAgentSvcTokenEndPoint = sep;
                ((SsoServerWSSAgentsSTSAgentEntryImpl)aei).WssAgentsSTSAgentIndex = new Integer(stsi++);
                ((SsoServerWSSAgentsSTSAgentEntryImpl)aei).WssAgentsSTSAgentSvcMEXEndPoint = NotAvail;
                ((SsoServerWSSAgentsSTSAgentEntryImpl)aei).SsoServerRealmIndex = ri;
                ObjectName aname4 = ((SsoServerWSSAgentsSTSAgentEntryImpl)aei).createSsoServerWSSAgentsSTSAgentEntryObjectName(server);
                try {
                    ststab.addEntry((SsoServerWSSAgentsSTSAgentEntryMBean)((Object)aei), aname4);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname4);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("DiscoveryAgent")) {
                String aep;
                aei = new SsoServerWSSAgentsDSCAgentEntryImpl(mib2);
                String dep = (String)hm.get("discoveryendpoint");
                if (dep == null) {
                    dep = NotAvail;
                }
                if ((aep = (String)hm.get("authnserviceendpoint")) == null) {
                    aep = NotAvail;
                }
                ((SsoServerWSSAgentsDSCAgentEntryImpl)aei).WssAgentsDSCAgentName = agtname;
                ((SsoServerWSSAgentsDSCAgentEntryImpl)aei).WssAgentsDSCAgentWebSvcEndPoint = dep;
                ((SsoServerWSSAgentsDSCAgentEntryImpl)aei).WssAgentsDSCAgentSvcEndPoint = aep;
                ((SsoServerWSSAgentsDSCAgentEntryImpl)aei).WssAgentsDSCAgentIndex = new Integer(dsci++);
                ((SsoServerWSSAgentsDSCAgentEntryImpl)aei).SsoServerRealmIndex = ri;
                aname2 = ((SsoServerWSSAgentsDSCAgentEntryImpl)aei).createSsoServerWSSAgentsDSCAgentEntryObjectName(server);
                try {
                    dsctab.addEntry((SsoServerWSSAgentsDSCAgentEntryMBean)((Object)aei), aname2);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname2);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("SharedAgent")) continue;
            debug.error(classMethod + "agent type = " + atype + ", agent name = " + agtname + " not supported.");
        }
        if (debug.messageEnabled()) {
            debug.message(sb.toString());
        }
    }

    public static void configAgentGroups(String realm, Map agtAttrs) {
        String classMethod = "Agent.configAgentGroups:";
        if (agtAttrs == null || agtAttrs.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "got null attr map for realm " + realm);
            }
            return;
        }
        SsoServerPolicyAgentsImpl sss = (SsoServerPolicyAgentsImpl)mib2.getPolicyAgentsGroup();
        TableSsoServerPolicyJ2EEGroupTable j2eetab = null;
        TableSsoServerPolicyWebGroupTable wgtab = null;
        SsoServerWSSAgentsImpl ssa = (SsoServerWSSAgentsImpl)mib2.getWssAgentsGroup();
        TableSsoServerWSSAgentsSTSAgtGrpTable ststab = null;
        TableSsoServerWSSAgentsWSPAgtGrpTable wsptab = null;
        TableSsoServerWSSAgentsWSCAgtGrpTable wsctab = null;
        TableSsoServerWSSAgentsDSCAgtGrpTable dsctab = null;
        if (sss != null) {
            try {
                j2eetab = sss.accessSsoServerPolicyJ2EEGroupTable();
                wgtab = sss.accessSsoServerPolicyWebGroupTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting Agent Groups tables: ", (Throwable)ex);
                return;
            }
        }
        if (ssa != null) {
            try {
                ststab = ssa.accessSsoServerWSSAgentsSTSAgtGrpTable();
                wsptab = ssa.accessSsoServerWSSAgentsWSPAgtGrpTable();
                wsctab = ssa.accessSsoServerWSSAgentsWSCAgtGrpTable();
                dsctab = ssa.accessSsoServerWSSAgentsDSCAgtGrpTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting WSS Agent Groups tables: ", (Throwable)ex);
                return;
            }
        }
        StringBuffer sb = new StringBuffer(classMethod);
        if (debug.messageEnabled()) {
            sb.append("agents for realm ").append(realm).append(", # = ").append(agtAttrs.size()).append("\n");
        }
        Set ks = agtAttrs.keySet();
        int wai = 1;
        int j2eei = 1;
        int stsi = 1;
        int wspi = 1;
        int wsci = 1;
        int dsci = 1;
        Integer ri = Agent.getRealmIndexFromName(realm);
        for (String agtname : ks) {
            ObjectName aname;
            String wpep;
            String wep;
            Serializable aei;
            ObjectName aname2;
            HashMap hm = (HashMap)agtAttrs.get(agtname);
            String atype = (String)hm.get("AgentType");
            if (debug.messageEnabled()) {
                sb.append("  agent group name = ").append(agtname).append(", type = ").append(atype).append("\n");
            }
            agtname = Agent.getEscapedString(agtname);
            if (atype.equals("WebAgent")) {
                String lurl = (String)hm.get("com.sun.identity.agents.config.login.url");
                SsoServerPolicyWebGroupEntryImpl aei2 = new SsoServerPolicyWebGroupEntryImpl(mib2);
                aei2.SsoServerRealmIndex = ri;
                aei2.SsoServerPolicyWebGroupIndex = new Integer(wai++);
                aei2.SsoServerPolicyWebGroupName = agtname;
                aei2.SsoServerPolicyWebGroupServerURL = lurl;
                aname2 = aei2.createSsoServerPolicyWebGroupEntryObjectName(server);
                try {
                    wgtab.addEntry(aei2, aname2);
                    if (server == null || aei2 == null) continue;
                    server.registerMBean(aei2, aname2);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("J2EEAgent")) {
                String lurl;
                aei = new SsoServerPolicyJ2EEGroupEntryImpl(mib2);
                ((SsoServerPolicyJ2EEGroupEntryImpl)aei).SsoServerPolicyJ2EEGroupServerURL = lurl = (String)hm.get("com.sun.identity.agents.config.login.url");
                ((SsoServerPolicyJ2EEGroupEntryImpl)aei).SsoServerPolicyJ2EEGroupName = agtname;
                ((SsoServerPolicyJ2EEGroupEntryImpl)aei).SsoServerPolicyJ2EEGroupIndex = new Integer(j2eei++);
                ((SsoServerPolicyJ2EEGroupEntryImpl)aei).SsoServerRealmIndex = ri;
                aname2 = ((SsoServerPolicyJ2EEGroupEntryImpl)aei).createSsoServerPolicyJ2EEGroupEntryObjectName(server);
                try {
                    j2eetab.addEntry((SsoServerPolicyJ2EEGroupEntryMBean)((Object)aei), aname2);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname2);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("WSPAgent")) {
                aei = new SsoServerWSSAgentsWSPAgtGrpEntryImpl(mib2);
                wep = (String)hm.get("wsendpoint");
                if (wep == null) {
                    wep = NotAvail;
                }
                if ((wpep = (String)hm.get("wspproxyendpoint")) == null) {
                    wpep = NotAvail;
                }
                ((SsoServerWSSAgentsWSPAgtGrpEntryImpl)aei).WssAgentsWSPAgtGrpName = agtname;
                ((SsoServerWSSAgentsWSPAgtGrpEntryImpl)aei).WssAgentsWSPAgtGrpSvcEndPoint = wep;
                ((SsoServerWSSAgentsWSPAgtGrpEntryImpl)aei).WssAgentsWSPAgtGrpProxy = wpep;
                ((SsoServerWSSAgentsWSPAgtGrpEntryImpl)aei).WssAgentsWSPAgtGrpIndex = new Integer(wspi++);
                ((SsoServerWSSAgentsWSPAgtGrpEntryImpl)aei).SsoServerRealmIndex = ri;
                aname = ((SsoServerWSSAgentsWSPAgtGrpEntryImpl)aei).createSsoServerWSSAgentsWSPAgtGrpEntryObjectName(server);
                try {
                    wsptab.addEntry((SsoServerWSSAgentsWSPAgtGrpEntryMBean)((Object)aei), aname);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("WSCAgent")) {
                aei = new SsoServerWSSAgentsWSCAgtGrpEntryImpl(mib2);
                wep = (String)hm.get("wsendpoint");
                if (wep == null) {
                    wep = NotAvail;
                }
                if ((wpep = (String)hm.get("wspproxyendpoint")) == null) {
                    wpep = NotAvail;
                }
                ((SsoServerWSSAgentsWSCAgtGrpEntryImpl)aei).WssAgentsWSCAgtGrpName = agtname;
                ((SsoServerWSSAgentsWSCAgtGrpEntryImpl)aei).WssAgentsWSCAgtGrpSvcEndPoint = wep;
                ((SsoServerWSSAgentsWSCAgtGrpEntryImpl)aei).WssAgentsWSCAgtGrpProxy = wpep;
                ((SsoServerWSSAgentsWSCAgtGrpEntryImpl)aei).WssAgentsWSCAgtGrpIndex = new Integer(wsci++);
                ((SsoServerWSSAgentsWSCAgtGrpEntryImpl)aei).SsoServerRealmIndex = ri;
                aname = ((SsoServerWSSAgentsWSCAgtGrpEntryImpl)aei).createSsoServerWSSAgentsWSCAgtGrpEntryObjectName(server);
                try {
                    wsctab.addEntry((SsoServerWSSAgentsWSCAgtGrpEntryMBean)((Object)aei), aname);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("STSAgent")) {
                aei = new SsoServerWSSAgentsSTSAgtGrpEntryImpl(mib2);
                String sep = (String)hm.get("stsendpoint");
                if (sep == null) {
                    sep = NotAvail;
                }
                ((SsoServerWSSAgentsSTSAgtGrpEntryImpl)aei).WssAgentsSTSAgtGrpName = agtname;
                ((SsoServerWSSAgentsSTSAgtGrpEntryImpl)aei).WssAgentsSTSAgtGrpSvcEndPoint = sep;
                ((SsoServerWSSAgentsSTSAgtGrpEntryImpl)aei).WssAgentsSTSAgtGrpIndex = new Integer(stsi++);
                ((SsoServerWSSAgentsSTSAgtGrpEntryImpl)aei).WssAgentsSTSAgtGrpSvcMEXEndPoint = NotAvail;
                ((SsoServerWSSAgentsSTSAgtGrpEntryImpl)aei).SsoServerRealmIndex = ri;
                aname2 = ((SsoServerWSSAgentsSTSAgtGrpEntryImpl)aei).createSsoServerWSSAgentsSTSAgtGrpEntryObjectName(server);
                try {
                    ststab.addEntry((SsoServerWSSAgentsSTSAgtGrpEntryMBean)((Object)aei), aname2);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname2);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("DiscoveryAgent")) {
                String aep;
                aei = new SsoServerWSSAgentsDSCAgtGrpEntryImpl(mib2);
                String dep = (String)hm.get("discoveryendpoint");
                if (dep == null) {
                    dep = NotAvail;
                }
                if ((aep = (String)hm.get("authnserviceendpoint")) == null) {
                    aep = NotAvail;
                }
                ((SsoServerWSSAgentsDSCAgtGrpEntryImpl)aei).WssAgentsDSCAgtGrpName = agtname;
                ((SsoServerWSSAgentsDSCAgtGrpEntryImpl)aei).WssAgentsDSCAgtGrpWebSvcEndPoint = dep;
                ((SsoServerWSSAgentsDSCAgtGrpEntryImpl)aei).WssAgentsDSCAgtGrpSvcEndPoint = aep;
                ((SsoServerWSSAgentsDSCAgtGrpEntryImpl)aei).WssAgentsDSCAgtGrpIndex = new Integer(dsci++);
                ((SsoServerWSSAgentsDSCAgtGrpEntryImpl)aei).SsoServerRealmIndex = ri;
                aname = ((SsoServerWSSAgentsDSCAgtGrpEntryImpl)aei).createSsoServerWSSAgentsDSCAgtGrpEntryObjectName(server);
                try {
                    dsctab.addEntry((SsoServerWSSAgentsDSCAgtGrpEntryMBean)((Object)aei), aname);
                    if (server == null || aei == null) continue;
                    server.registerMBean(aei, aname);
                }
                catch (JMException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + agtname + ": " + ex.getMessage());
                }
                continue;
            }
            if (atype.equals("SharedAgent")) continue;
            debug.error(classMethod + "agent group type = " + atype + ", agent group name = " + agtname + " not supported.");
        }
        if (debug.messageEnabled()) {
            debug.message(sb.toString());
        }
    }

    public static int saml1TPConfig(List s1TPInfo) {
        String classMethod = "Agent.saml1TPConfig:";
        StringBuffer sb = new StringBuffer(classMethod);
        int sz = s1TPInfo.size();
        boolean skipSAML1EndPoints = true;
        Date startDate = new Date();
        if (debug.messageEnabled()) {
            sb.append("number of SAML1 Trusted Partners = ").append(sz).append("\n");
        }
        for (int i = 0; i < sz; ++i) {
            String pName = (String)s1TPInfo.get(i);
            if (debug.messageEnabled()) {
                sb.append("    ").append(pName).append("\n");
            }
            SsoServerSAML1TrustPrtnrsEntryImpl sstpe = new SsoServerSAML1TrustPrtnrsEntryImpl(mib2);
            sstpe.SsoServerSAML1TrustPrtnrIndex = new Integer(i + 1);
            sstpe.SsoServerSAML1TrustPrtnrName = Agent.getEscapedString(pName);
            SsoServerSAML1SvcImpl sss = (SsoServerSAML1SvcImpl)mib2.getSaml1SvcGroup();
            TableSsoServerSAML1TrustPrtnrsTable tptab = null;
            if (sss != null) {
                try {
                    tptab = sss.accessSsoServerSAML1TrustPrtnrsTable();
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + "getting SAML1 trusted partner table: ", (Throwable)ex);
                }
            }
            ObjectName aname = sstpe.createSsoServerSAML1TrustPrtnrsEntryObjectName(server);
            try {
                tptab.addEntry(sstpe, aname);
                if (server == null || sstpe == null) continue;
                server.registerMBean(sstpe, aname);
                continue;
            }
            catch (JMException ex) {
                debug.error(classMethod + pName + ": " + ex.getMessage());
                continue;
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + pName + ": " + ex.getMessage());
            }
        }
        if (debug.messageEnabled()) {
            debug.message(sb.toString());
        }
        SsoServerSAML1CacheEntryImpl ssce = new SsoServerSAML1CacheEntryImpl(mib2);
        ssce.SsoServerSAML1CacheIndex = new Integer(1);
        ssce.SsoServerSAML1CacheName = "Assertion_Cache";
        ssce.SsoServerSAML1CacheMisses = new Long(0L);
        ssce.SsoServerSAML1CacheHits = new Long(0L);
        ssce.SsoServerSAML1CacheWrites = new Long(0L);
        ssce.SsoServerSAML1CacheReads = new Long(0L);
        SsoServerSAML1SvcImpl sss = (SsoServerSAML1SvcImpl)mib2.getSaml1SvcGroup();
        TableSsoServerSAML1CacheTable tptab = null;
        if (sss != null) {
            try {
                tptab = sss.accessSsoServerSAML1CacheTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting SAML1 Cache table: ", (Throwable)ex);
            }
        }
        sss.assertCache = ssce;
        ObjectName aname = ssce.createSsoServerSAML1CacheEntryObjectName(server);
        try {
            tptab.addEntry(ssce, aname);
            if (server != null && ssce != null) {
                server.registerMBean(ssce, aname);
            }
        }
        catch (JMException ex) {
            debug.error(classMethod + "SAML1 Assertion Cache table: " + ex.getMessage());
        }
        catch (SnmpStatusException ex) {
            debug.error(classMethod + "SAML1 Assertion Cache table: " + ex.getMessage());
        }
        ssce = new SsoServerSAML1CacheEntryImpl(mib2);
        ssce.SsoServerSAML1CacheIndex = new Integer(2);
        ssce.SsoServerSAML1CacheName = "Artifact_Cache";
        ssce.SsoServerSAML1CacheMisses = new Long(0L);
        ssce.SsoServerSAML1CacheHits = new Long(0L);
        ssce.SsoServerSAML1CacheWrites = new Long(0L);
        ssce.SsoServerSAML1CacheReads = new Long(0L);
        aname = ssce.createSsoServerSAML1CacheEntryObjectName(server);
        try {
            tptab.addEntry(ssce, aname);
            if (server != null && ssce != null) {
                server.registerMBean(ssce, aname);
            }
        }
        catch (JMException ex) {
            debug.error(classMethod + "SAML1 Artifact Cache table: " + ex.getMessage());
        }
        catch (SnmpStatusException ex) {
            debug.error(classMethod + "SAML1 Artifact Cache table: " + ex.getMessage());
        }
        sss.artifactCache = ssce;
        if (!skipSAML1EndPoints) {
            SsoServerSAML1EndPointEntryImpl ssee = new SsoServerSAML1EndPointEntryImpl(mib2);
            ssee.SsoServerSAML1EndPointIndex = new Integer(1);
            ssee.SsoServerSAML1EndPointName = "SOAPReceiver_EndPoint";
            ssee.SsoServerSAML1EndPointRqtFailed = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtOut = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtIn = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtAborted = new Long(0L);
            ssee.SsoServerSAML1EndPointStatus = "operational";
            TableSsoServerSAML1EndPointTable tetab = null;
            if (sss != null) {
                try {
                    tetab = sss.accessSsoServerSAML1EndPointTable();
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + "getting SAML1 EndPoint table: ", (Throwable)ex);
                }
            }
            aname = ssee.createSsoServerSAML1EndPointEntryObjectName(server);
            try {
                tetab.addEntry(ssee, aname);
                if (server != null && ssee != null) {
                    server.registerMBean(ssee, aname);
                }
            }
            catch (JMException ex) {
                debug.error(classMethod + "SAML1 SOAPReceiver EndPoint table: " + ex.getMessage());
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "SAML1 SOAPReceiver EndPoint table: " + ex.getMessage());
            }
            sss.soapEP = ssee;
            ssee = new SsoServerSAML1EndPointEntryImpl(mib2);
            ssee.SsoServerSAML1EndPointIndex = new Integer(2);
            ssee.SsoServerSAML1EndPointName = "POSTProfile_EndPoint";
            ssee.SsoServerSAML1EndPointRqtFailed = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtOut = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtIn = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtAborted = new Long(0L);
            ssee.SsoServerSAML1EndPointStatus = "operational";
            aname = ssee.createSsoServerSAML1EndPointEntryObjectName(server);
            try {
                tetab.addEntry(ssee, aname);
                if (server != null && ssee != null) {
                    server.registerMBean(ssee, aname);
                }
            }
            catch (JMException ex) {
                debug.error(classMethod + "SAML1 POSTProfile EndPoint table: " + ex.getMessage());
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "SAML1 POSTProfile EndPoint table: " + ex.getMessage());
            }
            sss.pprofEP = ssee;
            ssee = new SsoServerSAML1EndPointEntryImpl(mib2);
            ssee.SsoServerSAML1EndPointIndex = new Integer(3);
            ssee.SsoServerSAML1EndPointName = "SAMLAware_EndPoint";
            ssee.SsoServerSAML1EndPointRqtFailed = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtOut = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtIn = new Long(0L);
            ssee.SsoServerSAML1EndPointRqtAborted = new Long(0L);
            ssee.SsoServerSAML1EndPointStatus = "operational";
            aname = ssee.createSsoServerSAML1EndPointEntryObjectName(server);
            try {
                tetab.addEntry(ssee, aname);
                if (server != null && ssee != null) {
                    server.registerMBean(ssee, aname);
                }
            }
            catch (JMException ex) {
                debug.error(classMethod + "SAML1 SAMLAware/ArtifactProfile EndPoint table: " + ex.getMessage());
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "SAML1 SAMLAware/ArtifactProfile EndPoint table: " + ex.getMessage());
            }
            sss.samlAwareEP = ssee;
        }
        Date stopDate = new Date();
        if (debug.messageEnabled()) {
            String stDate = sdf.format(startDate);
            String endDate = sdf.format(stopDate);
            debug.message("Agent.saml1TPConfig:\n    Start Time = " + stDate + "\n      End Time = " + endDate);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static int federationConfig(SSOServerRealmFedInfo srfi) {
        Date startDate;
        String classMethod;
        block94: {
            ObjectName oname;
            SsoServerFedEntitiesEntryImpl cei;
            HashMap hm;
            Set ks;
            classMethod = "Agent.federationConfig:";
            startDate = new Date();
            String realm = srfi.realmName;
            Integer ri = Agent.getRealmIndexFromName(realm);
            Set cots = srfi.cots;
            Map saml2Ents = srfi.samlv2Ents;
            Map wsEnts = srfi.wsEnts;
            Map idffEnts = srfi.idffEnts;
            Map cotMembs = srfi.membEnts;
            StringBuffer sb = new StringBuffer(classMethod);
            if (debug.messageEnabled()) {
                sb.append("fed entities for realm ").append(realm).append(":\n");
                sb.append("  Circle of Trusts set has ");
            }
            SsoServerFedCOTs ssfc = (SsoServerFedCOTs)Agent.getFedCOTsMBean();
            if (cots != null && cots.size() > 0) {
                if (debug.messageEnabled()) {
                    sb.append(cots.size()).append(" entries:\n");
                }
                TableSsoServerFedCOTsTable ftab = null;
                try {
                    ftab = ssfc.accessSsoServerFedCOTsTable();
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + "getting fed COTs table: ", (Throwable)ex);
                }
                int i = 1;
                for (String ss : cots) {
                    ss = Agent.getEscapedString(ss);
                    if (debug.messageEnabled()) {
                        sb.append("  #").append(i).append(": ").append(ss).append("\n");
                    }
                    SsoServerFedCOTsEntryImpl cei2 = new SsoServerFedCOTsEntryImpl(mib2);
                    cei2.SsoServerRealmIndex = ri;
                    cei2.FedCOTName = ss;
                    cei2.FedCOTIndex = new Integer(i++);
                    ObjectName oname2 = cei2.createSsoServerFedCOTsEntryObjectName(server);
                    try {
                        ftab.addEntry(cei2, oname2);
                        if (server == null || cei2 == null) continue;
                        server.registerMBean(cei2, oname2);
                    }
                    catch (JMException ex) {
                        debug.error(classMethod + ss, (Throwable)ex);
                    }
                    catch (SnmpStatusException ex) {
                        debug.error(classMethod + ss, (Throwable)ex);
                    }
                }
            } else if (debug.messageEnabled()) {
                sb.append("no entries\n");
            }
            SsoServerFedEntities ssfe = (SsoServerFedEntities)Agent.getFedEntsMBean();
            TableSsoServerFedEntitiesTable ftab = null;
            try {
                ftab = ssfe.accessSsoServerFedEntitiesTable();
            }
            catch (SnmpStatusException ex) {
                debug.error(classMethod + "getting FederationEntities table: ", (Throwable)ex);
                return -1;
            }
            int tabinx = 1;
            if (debug.messageEnabled()) {
                sb.append("\n  SAML2 entities map has ");
            }
            if (saml2Ents != null && saml2Ents.size() > 0) {
                TableSsoServerSAML2IDPTable iTab = null;
                TableSsoServerSAML2SPTable sTab = null;
                SsoServerSAML2SvcImpl ss2s = (SsoServerSAML2SvcImpl)Agent.getSAML2SvcGroup();
                try {
                    iTab = ss2s.accessSsoServerSAML2IDPTable();
                    sTab = ss2s.accessSsoServerSAML2SPTable();
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + "getting SAML2 IDP and/or SP tables: ", (Throwable)ex);
                    return -1;
                }
                if (debug.messageEnabled()) {
                    sb.append(saml2Ents.size()).append(" entries:\n");
                }
                Set ks2 = saml2Ents.keySet();
                boolean bl = true;
                int spi = 1;
                for (String entname : ks2) {
                    String rai;
                    Serializable sei;
                    HashMap hm2 = (HashMap)saml2Ents.get(entname);
                    String loc = (String)hm2.get("location");
                    String roles = (String)hm2.get("roles");
                    SsoServerFedEntitiesEntryImpl cei3 = new SsoServerFedEntitiesEntryImpl(mib2);
                    cei3.SsoServerRealmIndex = ri;
                    cei3.FedEntityName = Agent.getEscapedString(entname);
                    cei3.FedEntityIndex = new Integer(tabinx++);
                    cei3.FedEntityProto = "SAMLv2";
                    cei3.FedEntityType = roles;
                    cei3.FedEntityLoc = loc;
                    ObjectName oname3 = cei3.createSsoServerFedEntitiesEntryObjectName(server);
                    try {
                        ftab.addEntry(cei3, oname3);
                        if (server != null && cei3 != null) {
                            server.registerMBean(cei3, oname3);
                        }
                    }
                    catch (JMException ex) {
                        debug.error(classMethod + "JMEx adding SAMLv2 entity " + entname + " in realm " + realm, (Throwable)ex);
                    }
                    catch (SnmpStatusException ex) {
                        debug.error(classMethod + "SnmpEx adding SAMLv2 entity " + entname + " in realm " + realm, (Throwable)ex);
                    }
                    if (roles.indexOf("IDP") >= 0 && loc.equalsIgnoreCase("hosted")) {
                        void var19_32;
                        sei = new SsoServerSAML2IDPEntryImpl(mib2);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPArtifactsIssued = new Long(0L);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPAssertionsIssued = new Long(0L);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPInvalRqtsRcvd = new Long(0L);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPRqtsRcvd = new Long(0L);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPArtifactsInCache = new Long(0L);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPAssertionsInCache = new Long(0L);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPIndex = new Integer((int)(++var19_32));
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerSAML2IDPName = Agent.getEscapedString(entname);
                        ((SsoServerSAML2IDPEntryImpl)sei).SsoServerRealmIndex = ri;
                        oname3 = ((SsoServerSAML2IDPEntryImpl)sei).createSsoServerSAML2IDPEntryObjectName(server);
                        ss2s.incHostedIDPCount();
                        try {
                            iTab.addEntry((SsoServerSAML2IDPEntryMBean)((Object)sei), oname3);
                            if (server != null && sei != null) {
                                server.registerMBean(sei, oname3);
                            }
                            rai = realm + "|" + entname;
                            realmSAML2IDPs.put(rai, sei);
                        }
                        catch (JMException ex) {
                            debug.error(classMethod + "JMEx adding SAMLv2 IDP entity " + entname + " in realm " + realm, (Throwable)ex);
                        }
                        catch (SnmpStatusException ex) {
                            debug.error(classMethod + "SnmpEx adding SAMLv2 IDP entity " + entname + " in realm " + realm, (Throwable)ex);
                        }
                    }
                    if (roles.indexOf("IDP") >= 0 && loc.equalsIgnoreCase("remote")) {
                        ss2s.incRemoteIDPCount();
                    }
                    if (roles.indexOf("SP") >= 0 && loc.equalsIgnoreCase("hosted")) {
                        sei = new SsoServerSAML2SPEntryImpl(mib2);
                        ((SsoServerSAML2SPEntryImpl)sei).SsoServerSAML2SPInvalidArtifactsRcvd = new Long(0L);
                        ((SsoServerSAML2SPEntryImpl)sei).SsoServerSAML2SPValidAssertionsRcvd = new Long(0L);
                        ((SsoServerSAML2SPEntryImpl)sei).SsoServerSAML2SPRqtsSent = new Long(0L);
                        ((SsoServerSAML2SPEntryImpl)sei).SsoServerSAML2SPName = Agent.getEscapedString(entname);
                        ((SsoServerSAML2SPEntryImpl)sei).SsoServerRealmIndex = ri;
                        ((SsoServerSAML2SPEntryImpl)sei).SsoServerSAML2SPIndex = new Integer(spi++);
                        oname3 = ((SsoServerSAML2SPEntryImpl)sei).createSsoServerSAML2SPEntryObjectName(server);
                        try {
                            sTab.addEntry((SsoServerSAML2SPEntryMBean)((Object)sei), oname3);
                            if (server != null && sei != null) {
                                server.registerMBean(sei, oname3);
                            }
                            rai = realm + "|" + entname;
                            realmSAML2SPs.put(rai, sei);
                        }
                        catch (JMException ex) {
                            debug.error(classMethod + "JMEx adding SAMLv2 SP entity " + entname + " in realm " + realm, (Throwable)ex);
                        }
                        catch (SnmpStatusException ex) {
                            debug.error(classMethod + "SnmpEx adding SAMLv2 SP entity " + entname + " in realm " + realm, (Throwable)ex);
                        }
                    }
                    if (!debug.messageEnabled()) continue;
                    sb.append("    name=").append(entname).append(", loc=").append(loc).append(", roles=").append(roles).append("\n");
                }
            } else if (debug.messageEnabled()) {
                sb.append("no entries\n");
            }
            if (debug.messageEnabled()) {
                sb.append("\n  WSFed entities map has ");
            }
            if (wsEnts != null && wsEnts.size() > 0) {
                if (debug.messageEnabled()) {
                    sb.append(wsEnts.size()).append(" entries:\n");
                }
                ks = wsEnts.keySet();
                for (String entname : ks) {
                    hm = (HashMap)wsEnts.get(entname);
                    String string = (String)hm.get("location");
                    String roles = (String)hm.get("roles");
                    cei = new SsoServerFedEntitiesEntryImpl(mib2);
                    cei.SsoServerRealmIndex = ri;
                    cei.FedEntityName = Agent.getEscapedString(entname);
                    cei.FedEntityIndex = new Integer(tabinx++);
                    cei.FedEntityProto = "WSFed";
                    cei.FedEntityType = roles;
                    cei.FedEntityLoc = string;
                    oname = cei.createSsoServerFedEntitiesEntryObjectName(server);
                    try {
                        ftab.addEntry(cei, oname);
                        if (server != null && cei != null) {
                            server.registerMBean(cei, oname);
                        }
                    }
                    catch (JMException ex) {
                        debug.error(classMethod + "JMEx adding WSFed entity " + entname + " in realm " + realm, (Throwable)ex);
                    }
                    catch (SnmpStatusException ex) {
                        debug.error(classMethod + "SnmpEx adding WSFed entity " + entname + " in realm " + realm, (Throwable)ex);
                    }
                    sb.append("    name=").append(entname).append(", loc=").append(string).append(", roles=").append(roles).append("\n");
                }
            } else if (debug.messageEnabled()) {
                sb.append("no entries\n");
            }
            if (debug.messageEnabled()) {
                sb.append("\n  IDFF entities map has ");
            }
            if (idffEnts != null && idffEnts.size() > 0) {
                if (debug.messageEnabled()) {
                    sb.append(idffEnts.size()).append(" entries:\n");
                }
                ks = idffEnts.keySet();
                for (String entname : ks) {
                    hm = (HashMap)idffEnts.get(entname);
                    String string = (String)hm.get("location");
                    String roles = (String)hm.get("roles");
                    cei = new SsoServerFedEntitiesEntryImpl(mib2);
                    cei.SsoServerRealmIndex = ri;
                    cei.FedEntityName = Agent.getEscapedString(entname);
                    cei.FedEntityIndex = new Integer(tabinx++);
                    cei.FedEntityProto = "IDFF";
                    cei.FedEntityType = roles;
                    cei.FedEntityLoc = string;
                    oname = cei.createSsoServerFedEntitiesEntryObjectName(server);
                    try {
                        ftab.addEntry(cei, oname);
                        if (server != null && cei != null) {
                            server.registerMBean(cei, oname);
                        }
                    }
                    catch (JMException ex) {
                        debug.error(classMethod + "JMEx adding IDFF entity " + entname + " in realm " + realm, (Throwable)ex);
                    }
                    catch (SnmpStatusException ex) {
                        debug.error(classMethod + "SnmpEx adding IDFF entity " + entname + " in realm " + realm, (Throwable)ex);
                    }
                    if (!debug.messageEnabled()) continue;
                    sb.append("    name=").append(entname).append(", loc=").append(string).append(", roles=").append(roles).append("\n");
                }
            } else if (debug.messageEnabled()) {
                sb.append("no entries\n");
            }
            if (debug.messageEnabled()) {
                sb.append("\n  COT Members map has ");
            }
            if (cotMembs != null && cotMembs.size() > 0) {
                if (debug.messageEnabled()) {
                    sb.append(cotMembs.size()).append(" entries:\n");
                }
                ks = cotMembs.keySet();
                int coti = 1;
                TableSsoServerFedCOTMemberTable mtab = null;
                try {
                    mtab = ssfc.accessSsoServerFedCOTMemberTable();
                }
                catch (SnmpStatusException ex) {
                    debug.error(classMethod + "getting fed COT members table: ", (Throwable)ex);
                }
                for (String string : ks) {
                    ObjectName ceName;
                    SsoServerFedCOTMemberEntryImpl cmi;
                    HashMap hm3 = (HashMap)cotMembs.get(string);
                    String string2 = Agent.getEscapedString(string);
                    if (debug.messageEnabled()) {
                        sb.append("  COT name = ").append(string2).append(", SAML members = ");
                    }
                    Set fset = (Set)hm3.get("SAML");
                    int mi = 1;
                    Integer cotI = new Integer(coti++);
                    if (fset != null && fset.size() > 0) {
                        for (String mbm : fset) {
                            if (debug.messageEnabled()) {
                                sb.append("    ").append(mbm).append("\n");
                            }
                            cmi = new SsoServerFedCOTMemberEntryImpl(mib2);
                            cmi.FedCOTMemberType = "SAMLv2";
                            cmi.FedCOTMemberName = Agent.getEscapedString(mbm);
                            cmi.FedCOTMemberIndex = new Integer(mi++);
                            cmi.SsoServerRealmIndex = ri;
                            cmi.FedCOTIndex = cotI;
                            ceName = cmi.createSsoServerFedCOTMemberEntryObjectName(server);
                            try {
                                mtab.addEntry(cmi, ceName);
                                if (server == null || ceName == null) continue;
                                server.registerMBean(cmi, ceName);
                            }
                            catch (Exception ex) {
                                debug.error(classMethod + "cotmember = " + mbm, (Throwable)ex);
                            }
                        }
                    } else if (debug.messageEnabled()) {
                        sb.append("    NONE\n");
                    }
                    fset = (Set)hm3.get("IDFF");
                    if (debug.messageEnabled()) {
                        sb.append("    IDFF members = ");
                    }
                    if (fset != null && fset.size() > 0) {
                        for (String mbm : fset) {
                            if (debug.messageEnabled()) {
                                sb.append("    ").append(mbm).append("\n");
                            }
                            cmi = new SsoServerFedCOTMemberEntryImpl(mib2);
                            cmi.FedCOTMemberType = "IDFF";
                            cmi.FedCOTMemberName = Agent.getEscapedString(mbm);
                            cmi.FedCOTMemberIndex = new Integer(mi++);
                            cmi.SsoServerRealmIndex = ri;
                            cmi.FedCOTIndex = cotI;
                            ceName = cmi.createSsoServerFedCOTMemberEntryObjectName(server);
                            try {
                                mtab.addEntry(cmi, ceName);
                                if (server == null || ceName == null) continue;
                                server.registerMBean(cmi, ceName);
                            }
                            catch (Exception ex) {
                                debug.error(classMethod + "cotmember = " + mbm, (Throwable)ex);
                            }
                        }
                    } else if (debug.messageEnabled()) {
                        sb.append("    NONE\n");
                    }
                    fset = (Set)hm3.get("WSFed");
                    if (debug.messageEnabled()) {
                        sb.append("    WSFed members = ");
                    }
                    if (fset != null && fset.size() > 0) {
                        for (String mbm : fset) {
                            if (debug.messageEnabled()) {
                                sb.append("    ").append(mbm).append("\n");
                            }
                            cmi = new SsoServerFedCOTMemberEntryImpl(mib2);
                            cmi.FedCOTMemberType = "WSFed";
                            cmi.FedCOTMemberName = Agent.getEscapedString(mbm);
                            cmi.FedCOTMemberIndex = new Integer(mi++);
                            cmi.SsoServerRealmIndex = ri;
                            cmi.FedCOTIndex = cotI;
                            ceName = cmi.createSsoServerFedCOTMemberEntryObjectName(server);
                            try {
                                mtab.addEntry(cmi, ceName);
                                if (server == null || ceName == null) continue;
                                server.registerMBean(cmi, ceName);
                            }
                            catch (Exception ex) {
                                debug.error(classMethod + "cotmember = " + mbm, (Throwable)ex);
                            }
                        }
                        continue;
                    }
                    if (!debug.messageEnabled()) continue;
                    sb.append("    NONE\n");
                }
            }
            if (debug.messageEnabled()) {
                debug.message(sb.toString());
            }
            try {
                DSConfigMgr dscm = DSConfigMgr.getDSConfigMgr();
                ServerGroup sgrp = dscm.getServerGroup("sms");
                Collection slist = sgrp.getServersList();
                StringBuffer sbp1 = new StringBuffer("DSConfigMgr:\n");
                for (Server sobj : slist) {
                    String svr = sobj.getServerName();
                    int port = sobj.getPort();
                    if (!debug.messageEnabled()) continue;
                    sbp1.append("  svrname = ").append(svr).append(", port = ").append(port).append("\n");
                }
                if (debug.messageEnabled()) {
                    debug.error(classMethod + sbp1.toString());
                }
            }
            catch (Exception d) {
                if (!debug.messageEnabled()) break block94;
                debug.error(classMethod + "trying to get Directory Server Config");
            }
        }
        Properties props = SystemProperties.getProperties();
        Set<Object> kset = props.keySet();
        StringBuffer sbp = new StringBuffer("SYSPROPS:\n");
        for (String string : kset) {
            String val = (String)props.get(string);
            if (!debug.messageEnabled()) continue;
            sbp.append("  key = ").append(string).append(", val = ").append(val).append("\n");
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + sbp.toString());
        }
        String dirHost = SystemProperties.get("com.iplanet.am.directory.host");
        String string = SystemProperties.get("com.iplanet.am.directory.port");
        String drSSL = SystemProperties.get("com.iplanet.am.directory.ssl.enabled");
        boolean dirSSL = Boolean.valueOf(SystemProperties.get("com.iplanet.am.directory.ssl.enabled"));
        if (debug.messageEnabled()) {
            debug.message(classMethod + "SMS CONFIG:\n    host = " + dirHost + "\n    port = " + string + "\n    ssl = " + drSSL + "\n    dirSSL = " + dirSSL);
        }
        Date stopDate = new Date();
        if (debug.messageEnabled()) {
            String stDate = sdf.format(startDate);
            String endDate = sdf.format(stopDate);
            debug.message("Agent.federationConfig:\n    Start Time = " + stDate + "\n      End Time = " + endDate);
        }
        return 0;
    }

    private static String getEscapedString(String str) {
        if (str != null && str.indexOf(":") >= 0) {
            str = str.replaceAll(":", "&#58;");
        }
        return str;
    }

    public static String getRealmNameFromIndex(Integer index) {
        return (String)index2Realm.get(index);
    }

    public static String getEscRealmNameFromIndex(Integer index) {
        String ss = (String)index2Realm.get(index);
        return Agent.getEscapedString(ss);
    }

    public static Integer getRealmIndexFromName(String name) {
        return (Integer)realm2Index.get(name);
    }

    public static String getRealmNameFromDN(String rlmDN) {
        return (String)DN2Realm.get(rlmDN);
    }

    public static SsoServerAuthModulesEntryImpl getAuthModuleEntry(String rlmAuthInst) {
        return (SsoServerAuthModulesEntryImpl)realmAuthInst.get(rlmAuthInst);
    }

    public static SSOServerInfo getAgentSvrInfo() {
        return agentSvrInfo;
    }

    public static SsoServerSAML2IDPEntryImpl getSAML2IDPEntry(String rlmSAMLIDP) {
        return (SsoServerSAML2IDPEntryImpl)realmSAML2IDPs.get(rlmSAMLIDP);
    }

    public static SsoServerSAML2SPEntryImpl getSAML2SPEntry(String rlmSAMLSP) {
        return (SsoServerSAML2SPEntryImpl)realmSAML2SPs.get(rlmSAMLSP);
    }

    public static void setSFOStatus(boolean sfoStatus) {
        isSessFOEnabled = sfoStatus;
    }

    public static boolean getSFOStatus() {
        return isSessFOEnabled;
    }

    public static void main(String[] args) {
        int htmlPort = 8082;
        int snmpPort = 11161;
        if (args.length != 0 && args.length != 1) {
            Agent.usage();
            System.exit(1);
        } else if (args.length == 1) {
            try {
                nbTraps = new Integer(args[0]);
                if (nbTraps < 0) {
                    Agent.usage();
                    System.exit(1);
                }
            }
            catch (NumberFormatException e) {
                Agent.usage();
                System.exit(1);
            }
        }
        try {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            MBeanServer server = servers != null && !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
            String domain = server.getDefaultDomain();
            ObjectName htmlObjName = new ObjectName(domain + ":class=HtmlAdaptorServer,protocol=html,port=" + htmlPort);
            Agent.println("Adding HTML adaptor to MBean server with name \n    " + htmlObjName);
            Agent.println("NOTE: HTML adaptor is bound on TCP port " + htmlPort);
            HtmlAdaptorServer htmlAdaptor = new HtmlAdaptorServer(htmlPort);
            server.registerMBean(htmlAdaptor, htmlObjName);
            htmlAdaptor.start();
            snmpPort = 11161;
            ObjectName snmpObjName = new ObjectName(domain + ":class=SnmpAdaptorServer,protocol=snmp,port=" + snmpPort);
            Agent.println("Adding SNMP adaptor to MBean server with name \n    " + snmpObjName);
            Agent.println("NOTE: SNMP Adaptor is bound on UDP port " + snmpPort);
            snmpAdaptor = new SnmpAdaptorServer(snmpPort);
            server.registerMBean(snmpAdaptor, snmpObjName);
            snmpAdaptor.start();
            Agent.print("NOTE: Sending a coldStart SNMP trap to each destination defined in the ACL file...");
            snmpAdaptor.setTrapPort(new Integer(snmpPort + 1));
            snmpAdaptor.snmpV1Trap(0, 0, null);
            Agent.println("Done.");
            try {
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9999/server");
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, server);
                cs.start();
            }
            catch (Exception ex) {
                System.out.println("Error starting RMI : execute rmiregistry 9999; ex=" + ex);
            }
            ObjectName mibObjName = new ObjectName("snmp:class=SUN_OPENSSO_SERVER_MIB");
            Agent.println("Adding SUN_OPENSSO_SERVER_MIB-MIB to MBean server with name\n    " + mibObjName);
            SUN_OPENSSO_SERVER_MIB mib2 = new SUN_OPENSSO_SERVER_MIB();
            server.registerMBean(mib2, mibObjName);
            mib2.setSnmpAdaptor((SnmpMibHandler)snmpAdaptor);
            String trapGeneratorClass = "LinkTrapGenerator";
            int ifIndex = 1;
            ObjectName trapGeneratorObjName = new ObjectName("trapGenerator:class=LinkTrapGenerator,ifIndex=" + ifIndex);
            Agent.println("Adding LinkTrapGenerator to MBean server with name\n    " + trapGeneratorObjName);
            LinkTrapGenerator trapGenerator = new LinkTrapGenerator(nbTraps);
            server.registerMBean(trapGenerator, trapGeneratorObjName);
            Agent.println("\n>> Press <Enter> if you want to start sending traps.");
            Agent.println("   -or-");
            Agent.println(">> Press <Ctrl-C> if you want to stop this agent.");
            System.in.read();
            trapGenerator.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SnmpAdaptorServer getSnmpAdaptor() {
        return snmpAdaptor;
    }

    public static void usage() {
        Agent.println("java Agent <nb_traps>");
        Agent.println("where");
        Agent.println("    -nb_traps: number of traps the SNMP agent will send.");
        Agent.println("              If not specified, the agent will send traps continuously.");
    }

    private static final void println(String msg) {
        System.out.println(msg);
    }

    private static final void print(String msg) {
        System.out.print(msg);
    }

    static {
        nbTraps = -1;
        realm2Index = new HashMap();
        index2Realm = new HashMap();
        realm2DN = new HashMap();
        DN2Realm = new HashMap();
        realmAuthInst = new HashMap();
        realmSAML2IDPs = new HashMap();
        realmSAML2SPs = new HashMap();
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
    }
}

