/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.LinkTrapGeneratorMBean;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class LinkTrapGenerator
extends Thread
implements LinkTrapGeneratorMBean,
MBeanRegistration {
    private int ifIndex = -1;
    private int nbTraps = -1;
    private int interval = 2000;
    private int successes = 0;
    private int errors = 0;

    public LinkTrapGenerator(int nbTraps) {
        this.nbTraps = nbTraps;
        System.out.println("LinkTrapGenerator() called");
        System.out.println("LinkTrapGenerator() returned\n");
    }

    public LinkTrapGenerator(int ifIndex, int nbTraps) {
        System.out.println("LinkTrapGenerator(int ifIndex) called");
        this.ifIndex = ifIndex;
        this.nbTraps = nbTraps;
        System.out.println("LinkTrapGenerator(int ifIndex) returned\n");
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        System.out.println("LinkTrapGenerator.preRegister() called");
        if (name == null) {
            name = new ObjectName("trapGenerator:class=" + this.getClass().getName() + ",ifIndex=" + this.ifIndex);
        }
        try {
            this.ifIndex = new Integer(name.getKeyProperty("ifIndex"));
        }
        catch (Exception e) {
            this.ifIndex = 1;
            System.out.println("Use default ifIndex = " + this.ifIndex);
        }
        System.out.println("LinkTrapGenerator.preRegister() returned\n");
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void postDeregister() {
    }

    public Integer getIfIndex() {
        return new Integer(this.ifIndex);
    }

    public void setIfIndex(Integer x) {
        this.ifIndex = x;
    }

    public Integer getSuccesses() {
        return new Integer(this.successes);
    }

    public Integer getErrors() {
        return new Integer(this.errors);
    }

    public Integer getInterval() {
        return new Integer(this.interval);
    }

    public void setInterval(Integer val) {
        this.interval = val;
    }

    public void run() {
        for (int remainingTraps = this.nbTraps; this.nbTraps == -1 || remainingTraps > 0; --remainingTraps) {
            try {
                LinkTrapGenerator.sleep(this.interval);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.triggerTrap();
        }
    }

    public void triggerTrap() {
        ++this.successes;
    }
}

