/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerSAML2IDPEntry;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SsoServerSAML2IDPEntryImpl
extends SsoServerSAML2IDPEntry {
    private static Debug debug = null;
    private static String myMibName;

    public SsoServerSAML2IDPEntryImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init();
    }

    private void init() {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
    }

    public ObjectName createSsoServerSAML2IDPEntryObjectName(MBeanServer server) {
        String classModule = "SsoServerSAML2IDPEntryImpl.createSsoServerSAML2IDPEntryObjectName: ";
        String prfx = "ssoServerSAML2IDPEntry.";
        String realm = Agent.getEscRealmNameFromIndex(this.SsoServerRealmIndex);
        if (debug.messageEnabled()) {
            debug.message(classModule + "\n    SsoServerRealmIndex = " + this.SsoServerRealmIndex + "\n    SsoServerSAML2IDPIndex = " + this.SsoServerSAML2IDPIndex + "\n    SsoServerSAML2IDPName = " + this.SsoServerSAML2IDPName);
        }
        String objname = myMibName + "/ssoServerSAML2IDPTable:" + prfx + "ssoServerRealmName=" + realm + "," + prfx + "ssoServerSAML2IDPName=" + this.SsoServerSAML2IDPName;
        try {
            if (server == null) {
                return null;
            }
            return new ObjectName(objname);
        }
        catch (Exception ex) {
            debug.error(classModule + objname, (Throwable)ex);
            return null;
        }
    }

    public void incSAML2IDPArtifsIssued() {
        String classModule = "SsoServerSAML2IDPEntryImpl.incSAML2IDPArtifsIssued:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPArtifactsIssued;
        this.SsoServerSAML2IDPArtifactsIssued = ++li;
    }

    public void incSAML2IDPAssertsIssued() {
        String classModule = "SsoServerSAML2IDPEntryImpl.incSAML2IDPAssertsIssued:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPAssertionsIssued;
        this.SsoServerSAML2IDPAssertionsIssued = ++li;
    }

    public void incSAML2IDPInvalRqtsRcvd() {
        String classModule = "SsoServerSAML2IDPEntryImpl.incSAML2IDPInvalRqtsRcvd:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPInvalRqtsRcvd;
        this.SsoServerSAML2IDPInvalRqtsRcvd = ++li;
    }

    public void incSAML2IDPRqtsRcvd() {
        String classModule = "SsoServerSAML2IDPEntryImpl.incSAML2IDPRqtsRcvd:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPRqtsRcvd;
        this.SsoServerSAML2IDPRqtsRcvd = ++li;
    }

    public void incSAML2IDPArtifsInCache() {
        String classModule = "SsoServerSAML2IDPEntryImpl.incSAML2IDPArtifsInCache:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPArtifactsInCache;
        this.SsoServerSAML2IDPArtifactsInCache = ++li;
    }

    public void decSAML2IDPArtifsInCache() {
        String classModule = "SsoServerSAML2IDPEntryImpl.decSAML2IDPArtifsInCache:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPArtifactsInCache;
        this.SsoServerSAML2IDPArtifactsInCache = --li;
    }

    public void incSAML2IDPAssertsInCache() {
        String classModule = "SsoServerSAML2IDPEntryImpl.incSAML2IDPAssertsInCache:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPAssertionsInCache;
        this.SsoServerSAML2IDPAssertionsInCache = ++li;
    }

    public void decSAML2IDPAssertsInCache() {
        String classModule = "SsoServerSAML2IDPEntryImpl.decSAML2IDPAssertsInCache:";
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerSAML2IDPAssertionsInCache;
        this.SsoServerSAML2IDPAssertionsInCache = --li;
    }
}

