/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SMSDataEntry {
    private String dn;
    private Map attributeValues;

    public SMSDataEntry(String dn, Map attributeValues) {
        this.dn = dn;
        this.attributeValues = new HashMap();
        this.parseAttributeValues(attributeValues);
    }

    public String getDN() {
        return this.dn;
    }

    private void parseAttributeValues(Map raw) {
        this.parseAttributeValues((Set)raw.get("sunxmlKeyValue"));
        this.parseAttributeValues((Set)raw.get("sunKeyValue"));
    }

    private void parseAttributeValues(Set raw) {
        for (String s : raw) {
            int idx = s.indexOf(61);
            if (idx == -1) continue;
            String name = s.substring(0, idx);
            String value = s.substring(idx + 1);
            HashSet<String> set = (HashSet<String>)this.attributeValues.get(name);
            if (set == null) {
                set = new HashSet<String>();
                this.attributeValues.put(name, set);
            }
            set.add(value);
        }
    }

    public Set getAttributeValues(String attributeName) {
        return (Set)this.attributeValues.get(attributeName);
    }

    public String getAttributeValue(String attributeName) {
        Set val = (Set)this.attributeValues.get(attributeName);
        return val != null && !val.isEmpty() ? (String)val.iterator().next() : null;
    }
}

