/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ServerIDValidator
implements ServiceAttributeValidator {
    private static final String PLATFORM_SITE_LIST = "iplanet-am-platform-site-list";
    private static Debug debug = Debug.getInstance((String)"amSession");
    private Set siteIdSet = new HashSet();
    private Set siteAddrSet = new HashSet();

    public boolean validate(Set values) {
        if (values.size() == 0) {
            return true;
        }
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> urlSet = new HashSet<String>();
        Iterator it = values.iterator();
        boolean siteLookup = false;
        siteLookup = this.getSiteDetails();
        while (it.hasNext()) {
            String value = (String)it.next();
            StringTokenizer tok = new StringTokenizer(value, "|");
            String url = tok.nextToken();
            StringBuffer buff = new StringBuffer();
            int count = 0;
            while (tok.hasMoreTokens()) {
                String lbid = tok.nextToken();
                if (lbid.getBytes().length != 2) {
                    return false;
                }
                switch (count) {
                    case 0: {
                        if (!siteLookup || !this.siteIdSet.contains(lbid)) break;
                        return false;
                    }
                    default: {
                        if (count > 0) {
                            int idx = buff.toString().indexOf(lbid);
                            if (idx > -1) {
                                return false;
                            }
                            if (siteLookup) {
                                if (this.validateID(lbid)) break;
                                return false;
                            }
                            if (!debug.messageEnabled()) break;
                            debug.message("Unable to get site list information. Site validation cannot be performed");
                            break;
                        }
                        return false;
                    }
                }
                buff.append(lbid);
                if (tok.hasMoreTokens()) {
                    buff.append("|");
                    ++count;
                }
                if (idSet.contains(lbid) && count < 1) {
                    return false;
                }
                idSet.add(lbid);
            }
            if (urlSet.contains(url)) {
                return false;
            }
            urlSet.add(url);
            if (!this.siteAddrSet.contains(url)) continue;
            return false;
        }
        return true;
    }

    private boolean validateID(String sId) {
        if (this.siteIdSet.isEmpty()) {
            return false;
        }
        return this.siteIdSet.contains(sId);
    }

    private boolean getSiteDetails() {
        block7: {
            if (!this.siteAddrSet.isEmpty()) {
                return true;
            }
            try {
                Map attrs;
                Set siteList;
                ServiceSchema ss;
                SSOToken stoken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceSchemaManager ssm = new ServiceSchemaManager("iPlanetAMPlatformService", stoken);
                if (ssm != null && (ss = ssm.getGlobalSchema()) != null && (siteList = (Set)(attrs = ss.getAttributeDefaults()).get(PLATFORM_SITE_LIST)) != null && !siteList.isEmpty()) {
                    for (String siteVal : siteList) {
                        if (siteVal == null) continue;
                        StringTokenizer tk = new StringTokenizer(siteVal, "|");
                        String siteUrl = tk.nextToken();
                        String siteID = tk.nextToken();
                        this.siteAddrSet.add(siteUrl);
                        this.siteIdSet.add(siteID);
                    }
                }
                return true;
            }
            catch (SMSException se) {
                if (debug.messageEnabled()) {
                    debug.message("Server List validator. Unable to get global config: SMSException", (Throwable)se);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.messageEnabled()) break block7;
                debug.message("Server List validator. Unable to get global config: SSOException", (Throwable)((Object)ssoe));
            }
        }
        return false;
    }
}

