/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class ServiceConfigManagerImpl
implements SMSObjectListener {
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private String listenerId;
    private HashMap listenerObjects;
    private String orgNotificationSearchString;
    private String glbNotificationSearchString;
    private String schemaNotificationSearchString;
    private CachedSubEntries instances;
    private CachedSubEntries groups;
    Cache globalConfigs;
    Cache orgConfigs;
    private boolean valid = true;
    private static Map configMgrImpls = Collections.synchronizedMap(new HashMap());
    private static Map userPrincipals = Collections.synchronizedMap(new HashMap());
    private static int PRINCIPALS_CACHE_SIZE = 20;
    private static Debug debug = SMSEntry.debug;

    private ServiceConfigManagerImpl(SSOToken token, String serviceName, String version) throws SMSException, SSOException {
        this.serviceName = serviceName;
        this.version = version;
        if (SMSEntry.cacheSMSEntries) {
            this.globalConfigs = new Cache(10);
            this.orgConfigs = new Cache(10);
        }
    }

    ServiceSchemaManagerImpl getServiceSchemaManagerImpl(SSOToken token) throws SMSException, SSOException {
        if (this.ssm == null || !this.ssm.isValid()) {
            this.ssm = ServiceSchemaManagerImpl.getInstance(token, this.serviceName, this.version);
        }
        return this.ssm;
    }

    String getName() {
        return this.serviceName;
    }

    String getVersion() {
        return this.version;
    }

    Set getInstanceNames(SSOToken t) throws SMSException, SSOException {
        if (this.instances == null) {
            String dn = "ou=Instances," + ServiceManager.getServiceNameDN(this.serviceName, this.version);
            this.instances = CachedSubEntries.getInstance(t, dn);
        }
        return this.instances.getSubEntries(t);
    }

    Set getGroupNames(SSOToken t) throws SMSException, SSOException {
        if (this.groups == null) {
            String dn = "ou=GlobalConfig," + ServiceManager.getServiceNameDN(this.serviceName, this.version);
            this.groups = CachedSubEntries.getInstance(t, dn);
        }
        return this.groups.getSubEntries(t);
    }

    ServiceInstanceImpl getInstance(SSOToken token, String instanceName) throws SMSException, SSOException {
        return ServiceInstanceImpl.getInstance(token, this.serviceName, this.version, instanceName);
    }

    ServiceConfigImpl getGlobalConfig(SSOToken token, String instanceName) throws SMSException, SSOException {
        ServiceSchemaImpl ss;
        StringBuffer sb;
        String groupName = instanceName == null || instanceName.equals("default") ? "default" : this.getInstance(token, instanceName).getGroup();
        String cacheName = null;
        ServiceConfigImpl answer = null;
        if (SMSEntry.cacheSMSEntries && (answer = (ServiceConfigImpl)this.globalConfigs.get(cacheName = (sb = new StringBuffer(50)).append(((Object)token.getTokenID()).toString()).append(groupName).toString().toLowerCase())) != null) {
            return answer;
        }
        if (this.ssm == null || !this.ssm.isValid()) {
            this.ssm = ServiceSchemaManagerImpl.getInstance(token, this.serviceName, this.version);
        }
        if ((ss = this.ssm.getSchema(SchemaType.GLOBAL)) == null) {
            return null;
        }
        String gdn = this.constructServiceConfigDN(groupName, "ou=GlobalConfig,", null);
        answer = ServiceConfigImpl.getInstance(token, this, ss, gdn, null, groupName, "", true);
        if (SMSEntry.cacheSMSEntries) {
            this.globalConfigs.put(cacheName, answer);
        }
        return answer;
    }

    ServiceConfigImpl getOrganizationConfig(SSOToken token, String orgName, String instanceName) throws SMSException, SSOException {
        ServiceSchemaImpl ss;
        String groupName = instanceName == null || instanceName.equals("default") ? "default" : this.getInstance(token, instanceName).getGroup();
        String cacheName = null;
        ServiceConfigImpl answer = null;
        String orgdn = DNMapper.orgNameToDN(orgName);
        if (SMSEntry.cacheSMSEntries) {
            StringBuffer sb = new StringBuffer(50);
            cacheName = sb.append(((Object)token.getTokenID()).toString()).append(groupName).append(orgdn).toString().toLowerCase();
            answer = (ServiceConfigImpl)this.orgConfigs.get(cacheName);
            if (answer != null && answer.isValid() && !answer.isNewEntry()) {
                return answer;
            }
            this.orgConfigs.remove(cacheName);
            answer = null;
        }
        if (this.ssm == null || !this.ssm.isValid()) {
            this.ssm = ServiceSchemaManagerImpl.getInstance(token, this.serviceName, this.version);
        }
        if ((ss = this.ssm.getSchema(SchemaType.ORGANIZATION)) == null) {
            return null;
        }
        String orgDN = this.constructServiceConfigDN(groupName, "ou=OrganizationConfig,", orgdn);
        answer = ServiceConfigImpl.getInstance(token, this, ss, orgDN, orgName, groupName, "", false);
        if (answer == null) {
            return null;
        }
        if (SMSEntry.cacheSMSEntries) {
            this.orgConfigs.put(cacheName, answer);
        }
        return answer;
    }

    PluginConfigImpl getPluginConfig(SSOToken token, String name, String schemaName, String interfaceName, String orgName) throws SMSException, SSOException {
        PluginSchemaImpl psi = PluginSchemaImpl.getInstance(token, this.serviceName, this.version, schemaName, interfaceName, orgName);
        if (psi == null) {
            throw new SMSException("amSDK", "sms-invalid-plugin-schema-name", null);
        }
        StringBuffer groupName = new StringBuffer(100);
        groupName.append(name).append(",ou=").append(schemaName).append(",ou=").append(interfaceName);
        String dn = this.constructServiceConfigDN(groupName.toString(), "ou=PluginConfig,", DNMapper.orgNameToDN(orgName));
        return PluginConfigImpl.getInstance(token, psi, dn, orgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String addListener(SSOToken token, ServiceListener listener) {
        this.registerListener(token);
        String id = SMSUtils.getUniqueID();
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            this.listenerObjects.put(id, listener);
        }
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigManagerImpl(" + this.serviceName + "):addListener Class: " + listener.getClass().getName() + " Listener ID: " + id);
        }
        return id;
    }

    private synchronized void registerListener(SSOToken token) {
        if (this.listenerId == null) {
            this.listenerId = SMSNotificationManager.getInstance().registerCallbackHandler(this);
            DN notifyDN = new DN("ou=" + this.version + ",ou=" + this.serviceName + "," + "ou=services");
            String sdn = notifyDN.toRFCString().toLowerCase();
            this.orgNotificationSearchString = "ou=OrganizationConfig,".toLowerCase() + sdn;
            this.glbNotificationSearchString = "ou=GlobalConfig,".toLowerCase() + sdn + "," + SMSEntry.getRootSuffix();
            this.schemaNotificationSearchString = sdn + "," + SMSEntry.getRootSuffix();
            this.listenerObjects = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(String listenerID) {
        if (this.listenerObjects != null) {
            HashMap hashMap = this.listenerObjects;
            synchronized (hashMap) {
                this.listenerObjects.remove(listenerID);
                if (this.listenerObjects.isEmpty()) {
                    this.deregisterListener();
                }
            }
            if (debug.messageEnabled()) {
                debug.message("ServiceConfigManagerImpl(" + this.serviceName + "):removeListener ListenerId: " + listenerID);
            }
        }
    }

    private synchronized void deregisterListener() {
        if (this.listenerId != null) {
            SMSNotificationManager.getInstance().removeCallbackHandler(this.listenerId);
            this.listenerId = null;
        }
    }

    boolean containsGroup(SSOToken token, String groupName) throws SMSException, SSOException {
        if (this.groups == null) {
            String dn = "ou=GlobalConfig," + ServiceManager.getServiceNameDN(this.serviceName, this.version);
            this.groups = CachedSubEntries.getInstance(token, dn);
        }
        return this.groups.contains(token, groupName);
    }

    public void allObjectsChanged() {
        if (SMSEntry.eventDebug.messageEnabled()) {
            SMSEntry.eventDebug.message("ServiceConfigManagerImpl:allObjectsChanged called. Ignoring the notification");
        }
    }

    public void objectChanged(String dn, int type) {
        if (this.listenerObjects == null || this.listenerObjects.isEmpty()) {
            return;
        }
        if (SMSEntry.eventDebug.messageEnabled()) {
            SMSEntry.eventDebug.message("ServiceConfigManagerImpl(" + this.serviceName + "):objectChanged Received notification for " + "DN: " + dn);
        }
        boolean globalConfig = false;
        boolean orgConfig = false;
        int index = 0;
        int orgIndex = 0;
        index = (dn = DNUtils.normalizeDN(dn)).indexOf(this.orgNotificationSearchString);
        if (index != -1) {
            orgConfig = true;
            if (index == 0) {
                return;
            }
            orgIndex = this.orgNotificationSearchString.length();
        } else {
            index = dn.indexOf(this.glbNotificationSearchString);
            if (index != -1) {
                globalConfig = true;
            } else {
                index = dn.indexOf(this.schemaNotificationSearchString);
                if (index != -1) {
                    globalConfig = true;
                    orgConfig = true;
                } else if (this.serviceName.equalsIgnoreCase("sunidentityrepositoryservice") && (dn.startsWith("o=") || dn.equalsIgnoreCase(DNMapper.serviceDN))) {
                    orgConfig = true;
                } else {
                    return;
                }
            }
        }
        String groupName = "";
        String compName = "";
        if (index > 1) {
            String[] rdns = LDAPDN.explodeDN((String)dn.substring(0, index - 1), (boolean)true);
            groupName = rdns[rdns.length - 1];
            for (int i = rdns.length - 2; i > -1; --i) {
                compName = compName + "/" + rdns[i];
            }
        }
        switch (type) {
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            default: {
                type = 4;
            }
        }
        String orgName = dn;
        if (globalConfig && orgConfig) {
            orgName = ServiceManager.getBaseDN();
        } else if (index >= 0 && orgConfig) {
            orgName = dn.substring(index + orgIndex + 1);
        }
        if (globalConfig) {
            this.notifyGlobalConfigChange(groupName, compName, type);
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("ServiceConfigManagerImpl(" + this.serviceName + "):entryChanged Sending global config change " + "notifications for DN " + dn);
            }
        }
        if (orgConfig) {
            this.notifyOrgConfigChange(orgName, groupName, compName, type);
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("ServiceConfigManagerImpl(" + this.serviceName + "):entryChanged Sending org config change " + "notifications for DN " + dn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyGlobalConfigChange(String groupName, String comp, int type) {
        HashSet lObject = new HashSet();
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            lObject.addAll(this.listenerObjects.values());
        }
        for (ServiceListener sl : lObject) {
            try {
                sl.globalConfigChanged(this.serviceName, this.version, groupName, comp, type);
            }
            catch (Throwable t) {
                SMSEntry.eventDebug.error("ServiceConfigManagerImpl(:" + this.serviceName + ") notifyGlobalConfigChange Error " + "sending notification to ServiceListener: " + sl.getClass().getName(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOrgConfigChange(String orgName, String groupName, String comp, int type) {
        HashSet lObject = new HashSet();
        HashMap hashMap = this.listenerObjects;
        synchronized (hashMap) {
            lObject.addAll(this.listenerObjects.values());
        }
        for (ServiceListener sl : lObject) {
            try {
                sl.organizationConfigChanged(this.serviceName, this.version, orgName, groupName, comp, type);
            }
            catch (Throwable t) {
                SMSEntry.eventDebug.error("ServiceConfigManagerImpl(:" + this.serviceName + ") notifyOrgConfigChange Error " + "sending notification to ServiceListener: " + sl.getClass().getName(), t);
            }
        }
    }

    String constructServiceConfigDN(String groupName, String configName, String orgName) throws SMSException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("ou=").append(groupName).append(",").append(configName).append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",");
        if (orgName == null || orgName.length() == 0) {
            orgName = SMSEntry.baseDN;
        } else if (!DN.isDN((String)orgName)) {
            if (orgName.startsWith("/")) {
                orgName = DNMapper.orgNameToDN(orgName);
            } else {
                Object[] args = new String[]{orgName};
                throw new SMSException("amSDK", "sms-invalid-org-name", args);
            }
        }
        sb.append(orgName);
        return sb.toString();
    }

    protected boolean isValid() {
        return this.valid;
    }

    private void clear() {
        this.valid = false;
        if (this.listenerObjects == null || this.listenerObjects.isEmpty()) {
            this.deregisterListener();
        }
        this.ssm = null;
        this.orgConfigs.clear();
        this.globalConfigs.clear();
    }

    public int hashCode() {
        int hash = 4;
        hash = 29 * hash + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        hash = 29 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceConfigManager) {
            ServiceConfigManagerImpl oscm = (ServiceConfigManagerImpl)o;
            if (this.serviceName.equals(oscm.serviceName) && this.version.equals(oscm.version)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ServiceConfigManagerImpl: ").append(this.serviceName).append(" Version: ").append(this.version);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ServiceConfigManagerImpl getInstance(SSOToken token, String serviceName, String version) throws SSOException, SMSException {
        String cName;
        ServiceConfigManagerImpl answer;
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigMgrImpl::getInstance: called: " + serviceName + "(" + version + ")");
        }
        if ((answer = ServiceConfigManagerImpl.getFromCache(cName = ServiceManager.getCacheIndex(serviceName, version), serviceName, version, token)) != null) {
            return answer;
        }
        ServiceConfigManagerImpl.checkAndUpdatePermission(cName, serviceName, version, token);
        Map map = configMgrImpls;
        synchronized (map) {
            answer = ServiceConfigManagerImpl.getFromCache(cName, serviceName, version, token);
            if (answer == null) {
                answer = new ServiceConfigManagerImpl(token, serviceName, version);
                configMgrImpls.put(cName, answer);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigMgrImpl::getInstance: success: " + serviceName + "(" + version + ")");
        }
        return answer;
    }

    private static ServiceConfigManagerImpl getFromCache(String cacheName, String sName, String version, SSOToken t) throws SMSException, SSOException {
        ServiceConfigManagerImpl answer = (ServiceConfigManagerImpl)configMgrImpls.get(cacheName);
        if (answer != null && t != null) {
            if (!answer.isValid()) {
                configMgrImpls.remove(cacheName);
                answer = null;
            } else {
                Set principals = (Set)userPrincipals.get(cacheName);
                if (principals == null || !principals.contains(((Object)t.getTokenID()).toString())) {
                    if (debug.messageEnabled()) {
                        debug.message("ServiceConfigMgrImpl:getFromCache SN: " + sName + " found in cache. " + "Check permission");
                    }
                    ServiceConfigManagerImpl.checkAndUpdatePermission(cacheName, sName, version, t);
                }
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkAndUpdatePermission(String cacheName, String sName, String version, SSOToken t) throws SMSException, SSOException {
        String dn = ServiceManager.getServiceNameDN(sName, version);
        if (SMSEntry.backendProxyEnabled) {
            CachedSMSEntry.getInstance(t, dn);
        } else {
            SMSEntry.getDelegationPermission(t, dn, SMSEntry.readActionSet);
        }
        Map map = userPrincipals;
        synchronized (map) {
            Iterator items;
            LinkedHashSet<String> sudoPrincipals = (LinkedHashSet<String>)userPrincipals.get(cacheName);
            if (sudoPrincipals == null) {
                sudoPrincipals = new LinkedHashSet<String>(20);
                userPrincipals.put(cacheName, sudoPrincipals);
            }
            sudoPrincipals.add(((Object)t.getTokenID()).toString());
            if (sudoPrincipals.size() > PRINCIPALS_CACHE_SIZE && (items = sudoPrincipals.iterator()).hasNext()) {
                items.next();
                items.remove();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map map = configMgrImpls;
        synchronized (map) {
            for (ServiceConfigManagerImpl sc : configMgrImpls.values()) {
                sc.clear();
            }
        }
        userPrincipals.clear();
    }
}

