/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.base;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.intr.TuneFAM;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

public abstract class AMTuneFAMBase
extends TuneFAM {
    protected String famPassFilePath;
    protected String famCmdPath;
    protected AMTuneConfigInfo configInfo;
    protected AMTuneLogger pLogger;
    protected MessageWriter mWriter;
    protected String famadmCommonParamsNoServer;

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        this.configInfo = configInfo;
        this.famPassFilePath = AMTuneUtil.TMP_DIR + "ssoadmpassfile";
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
        this.setFAMAdmCmd();
        this.famadmCommonParamsNoServer = " --adminid " + configInfo.getFAMAdmUser() + " --password-file " + this.famPassFilePath;
    }

    private void setFAMAdmCmd() throws AMTuneException {
        this.famCmdPath = AMTuneUtil.isWindows() ? this.configInfo.getFAMAdmLocation() + "/" + "ssoadm.bat " : this.configInfo.getFAMAdmLocation() + "/" + "ssoadm ";
        File famAdmF = new File(this.famCmdPath.trim());
        if (!famAdmF.exists()) {
            AMTuneUtil.printErrorMsg("SSOADM_LOCATION");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-fam-tool-not-found"));
        }
    }

    protected void deletePasswordFile() {
        AMTuneUtil.deleteFile(this.famPassFilePath);
    }

    protected void writePasswordToFile() {
    }

    protected void updateFAMServiceCfg(List attrs) {
        StringBuffer resultBuffer = new StringBuffer();
        try {
            StringBuffer updateCmd = new StringBuffer(this.famCmdPath);
            updateCmd.append("update-server-cfg");
            updateCmd.append(this.famadmCommonParamsNoServer);
            updateCmd.append(" ");
            updateCmd.append("--servername");
            updateCmd.append(" ");
            updateCmd.append(this.configInfo.getFAMServerUrl());
            updateCmd.append(" ");
            updateCmd.append("--attributevalues");
            if (!AMTuneUtil.isWindows()) {
                updateCmd.append(" ");
            } else {
                updateCmd.append(" \"");
            }
            Iterator itr = attrs.iterator();
            while (itr.hasNext()) {
                int retVal;
                String args = itr.next().toString();
                String cmd = updateCmd.toString() + args;
                if (AMTuneUtil.isWindows()) {
                    cmd = cmd + "\"";
                }
                this.pLogger.log(Level.FINEST, "updateServiceCfg", "Executing cmd " + cmd);
                try {
                    retVal = !AMTuneUtil.isWindows() ? AMTuneUtil.executeScriptCmd(cmd, this.configInfo.getFamAdminPassword(), this.famPassFilePath, resultBuffer) : AMTuneUtil.executeCommand(cmd, this.configInfo.getFamAdminPassword(), this.famPassFilePath, resultBuffer);
                }
                catch (AMTuneException ex) {
                    retVal = -1;
                }
                if (retVal != -1) continue;
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-updating-opensso-config"));
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "updateServiceCfg", ex.getMessage());
        }
    }

    protected List getDataStoreList(String realmName) throws AMTuneException {
        ArrayList<String> dataStoreList = new ArrayList<String>();
        try {
            this.pLogger.log(Level.INFO, "getDataStoreList", "Getting datastore list. ");
            StringBuffer dataStoreListCmd = new StringBuffer(this.famCmdPath);
            dataStoreListCmd.append("list-datastores");
            dataStoreListCmd.append(" -e ");
            dataStoreListCmd.append(realmName);
            dataStoreListCmd.append(this.famadmCommonParamsNoServer);
            StringBuffer rBuff = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(dataStoreListCmd.toString(), this.configInfo.getFamAdminPassword(), this.famPassFilePath, rBuff);
            if (extVal == -1) {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-datastore-list"));
            }
            if (rBuff.indexOf("There were no datastores") != -1) {
                this.pLogger.log(Level.SEVERE, "getDataStoreList", "No datastore for the realm:" + realmName);
            } else {
                String reqStr = rBuff.toString().trim().replace("Datastore:", "");
                StringTokenizer str = new StringTokenizer(reqStr, "\n");
                while (str.hasMoreTokens()) {
                    String dsName = str.nextToken();
                    if (dsName == null || dsName.trim().length() <= 0) continue;
                    dataStoreList.add(dsName.trim());
                }
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "getDataStoreList", "Error getting data store list. ");
            throw new AMTuneException(ex.getMessage());
        }
        this.pLogger.log(Level.FINEST, "getDataStoreList", "Returning datastore list. " + ((Object)dataStoreList).toString());
        return dataStoreList;
    }

    protected Map getFAMServerConfig() throws AMTuneException {
        HashMap<String, String> famCfgInfo = new HashMap<String, String>();
        StringBuffer listSerCfgCmd = new StringBuffer(this.famCmdPath);
        listSerCfgCmd.append("list-server-cfg");
        listSerCfgCmd.append(" ");
        listSerCfgCmd.append("--servername");
        listSerCfgCmd.append(" ");
        listSerCfgCmd.append(this.configInfo.getFAMServerUrl());
        listSerCfgCmd.append(this.famadmCommonParamsNoServer);
        listSerCfgCmd.append(" -w");
        StringBuffer rBuff = new StringBuffer();
        int extVal = AMTuneUtil.executeCommand(listSerCfgCmd.toString(), this.configInfo.getFamAdminPassword(), this.famPassFilePath, rBuff);
        if (rBuff.toString().indexOf("Login failed") != -1) {
            this.mWriter.writelnLocaleMsg("pt-error-opensso-check-user-password-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-login-failed"));
        }
        if (extVal != -1) {
            StringTokenizer str = new StringTokenizer(rBuff.toString(), "\n");
            while (str.hasMoreTokens()) {
                String line = str.nextToken();
                if (line == null || line.length() <= 0) continue;
                StringTokenizer lStr = new StringTokenizer(line, "=");
                lStr.hasMoreTokens();
                String key = lStr.nextToken();
                if (lStr.hasMoreTokens()) {
                    String val = lStr.nextToken();
                    famCfgInfo.put(key, val);
                    continue;
                }
                famCfgInfo.put(key, "");
            }
        } else {
            this.pLogger.log(Level.WARNING, "getServerConfig", "Error while getting server configuration.");
        }
        this.pLogger.log(Level.FINEST, "getServerConfig", "Returning OpenSSO configuration Map " + ((Object)famCfgInfo).toString());
        return famCfgInfo;
    }

    protected boolean isFAMServerUp() {
        boolean isUp = false;
        try {
            URL u = new URL(this.configInfo.getFAMServerUrl());
            int responseCode = 0;
            this.pLogger.log(Level.INFO, "isServerUp", "Connecting to OpenSSO URL : " + u.toString());
            URLConnection famConn = u.openConnection();
            if (u.getProtocol().equalsIgnoreCase("http")) {
                HttpURLConnection testConnect = (HttpURLConnection)famConn;
                testConnect.connect();
                responseCode = testConnect.getResponseCode();
            } else if (u.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection testConnect = (HttpsURLConnection)famConn;
                testConnect.connect();
                responseCode = testConnect.getResponseCode();
            }
            if (responseCode == 404 || responseCode == 404) {
                this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
                this.mWriter.writeLocaleMsg("pt-fam-server-unreachable-error-msg");
                return isUp;
            }
            isUp = true;
        }
        catch (UnknownHostException uhx) {
            this.pLogger.logException("isFAMServerUp", uhx);
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-fam-server-unreachable-error-msg");
        }
        catch (ConnectException cone) {
            this.pLogger.logException("isFAMServerUp", cone);
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-fam-server-down-msg");
        }
        catch (SSLException ssle) {
            this.pLogger.logException("isFAMServerUp", ssle);
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-fam-server-ssl-error-msg");
        }
        catch (Exception ex) {
            this.pLogger.logException("isFAMServerUp", ex);
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-fam-server-down-msg");
        }
        return isUp;
    }
}

