/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.intr.TuneOS;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class TuneLinuxOS
extends TuneOS {
    private AMTuneConfigInfo confInfo;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        this.confInfo = configInfo;
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
    }

    public void startTuning() throws AMTuneException {
        try {
            this.mWriter.writelnLocaleMsg("pt-lnx-tuning");
            this.tuneKernel();
            this.tuneRcLocal();
            this.tuneSecurityLimits();
            if (!this.confInfo.isReviewMode()) {
                this.mWriter.writelnLocaleMsg("pt-lnx-reboot-msg");
            }
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error tuning linux system.");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writelnLocaleMsg("pt-os-tuning-error-msg");
            this.mWriter.writelnLocaleMsg("pt-manual-msg");
            this.pLogger.logException("startTuning", ex);
        }
    }

    protected void tuneKernel() throws AMTuneException {
        FileHandler sysOutHdlr = null;
        File outFile = null;
        FileHandler tuneFileFh = null;
        try {
            String tuneFile = "/etc/sysctl.conf";
            ArrayList<String> recVals = new ArrayList<String>();
            tuneFileFh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-lnx-kernel-tuning-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-file-max");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("fs.file-max = ");
            String reqLine = tuneFileFh.getLine("fs.file-max");
            this.mWriter.writeln(AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            String recVal = "fs.file-max = 65536";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            String sysCtlCmd = "/sbin/sysctl ";
            StringBuffer rBuff = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(sysCtlCmd + "-a", rBuff);
            if (extVal == -1) {
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-sysctl-cmd"));
            }
            String sysOutTempFile = AMTuneUtil.TMP_DIR + "sysctlout";
            AMTuneUtil.writeResultBufferToTempFile(rBuff, sysOutTempFile);
            sysOutHdlr = new FileHandler(sysOutTempFile);
            outFile = new File(sysOutTempFile);
            this.mWriter.writelnLocaleMsg("pt-lnx-ip-local-port-range");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.ip_local_port_range");
            this.mWriter.writeln("net.ipv4.ip_local_port_range = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.ip_local_port_range = 1204 65000";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-core-rmem-max-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.core.rmem_max");
            this.mWriter.writeln("net.core.rmem_max = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.core.rmem_max = 8388608";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-rmem-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_rmem");
            this.mWriter.writeln("net.ipv4.tcp_rmem = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_rmem = 4096 131072 8388608";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-wmem-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_wmem");
            this.mWriter.writeln("net.ipv4.tcp_wmem = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_wmem = 4096 131072 8388608";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-sack-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_sack");
            this.mWriter.writeln("net.ipv4.tcp_sack = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_sack = 0";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-timestamps-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_timestamps");
            this.mWriter.writeln("net.ipv4.tcp_timestamps = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_timestamps = 0";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-window-scaling-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_window_scaling");
            this.mWriter.writeln("net.ipv4.tcp_window_scaling = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_window_scaling = 0";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-keepalive-time-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_keepalive_time");
            this.mWriter.writeln("net.ipv4.tcp_keepalive_time = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_keepalive_time = 60";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-keepalive-intvl-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_keepalive_intvl");
            this.mWriter.writeln("net.ipv4.tcp_keepalive_intvl = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_keepalive_intvl = 75";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-fin-timeout-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_fin_timeout");
            this.mWriter.writeln("net.ipv4.tcp_fin_timeout = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_fin_timeout = 30";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            String[] delLines = new String[]{"Start: OpenSSO Tuning", "fs.file-max", "net.ipv4.ip_local_port_range", "net.core.rmem_max", "net.core.rmem_default", "net.ipv4.tcp_rmem", "net.ipv4.tcp_wmem", "net.ipv4.tcp_sack", "net.ipv4.tcp_timestamps", "net.ipv4.tcp_window_scaling", "net.ipv4.tcp_keepalive_time", "net.ipv4.tcp_keepalive_intvl", "net.ipv4.tcp_fin_timeout", "End: OpenSSO Tuning"};
            AMTuneUtil.backupConfigFile(tuneFile);
            this.pLogger.log(Level.FINEST, "tuneKernel", "Removing existing configuration values from " + tuneFile);
            tuneFileFh.removeMatchingLines(delLines);
            tuneFileFh.appendLine("# Start: OpenSSO Tuning " + AMTuneUtil.getTodayDateStr());
            Iterator itr = recVals.iterator();
            while (itr.hasNext()) {
                tuneFileFh.appendLine((String)itr.next());
            }
            tuneFileFh.appendLine("# End: OpenSSO Tuning " + AMTuneUtil.getTodayDateStr());
            tuneFileFh.close();
            this.mWriter.writeLocaleMsg("pt-lnx-load-vals-msg");
            this.mWriter.writeln(" " + tuneFile);
            rBuff.setLength(0);
            extVal = AMTuneUtil.executeCommand(sysCtlCmd + " -p", rBuff);
            if (extVal != -1) {
                this.pLogger.log(Level.INFO, "tuneKernel", "Linux kernel tuning successful.");
            } else {
                this.mWriter.writelnLocaleMsg("pt-lnx-kernel-tuning-error-msg");
            }
        }
        catch (AMTuneException amex) {
            throw amex;
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneKernel", ex);
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-lnx-kernel-tuning-error-msg"));
        }
        finally {
            try {
                if (sysOutHdlr != null) {
                    sysOutHdlr.close();
                }
                if (outFile != null) {
                    outFile.delete();
                }
                if (tuneFileFh != null) {
                    tuneFileFh.close();
                }
            }
            catch (Exception ex) {
                this.pLogger.log(Level.WARNING, "tuneKernel", ex.getMessage());
            }
        }
    }

    protected void tuneTCP() throws AMTuneException {
    }

    private void tuneRcLocal() throws AMTuneException {
        try {
            String tuneFile = "/etc/rc.local";
            String recVal = "";
            ArrayList<String> recVals = new ArrayList<String>();
            FileHandler fh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-lnx-boot-script-tuning-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeln("1.   /proc/sys/net/ipv4/tcp_fin_timeout");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_fin_timeout"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 30 > /proc/sys/net/ipv4/tcp_fin_timeout";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("2.   /proc/sys/net/ipv4/tcp_keepalive_time");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_keepalive_time"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 60 > /proc/sys/net/ipv4/tcp_keepalive_time";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("3.   /proc/sys/net/ipv4/tcp_keepalive_intvl");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_keepalive_intvl"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 75 > /proc/sys/net/ipv4/tcp_keepalive_intvl";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("4.   /proc/sys/net/ipv4/tcp_window_scaling");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_window_scaling"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 0 > /proc/sys/net/ipv4/tcp_window_scaling";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-lnx-loading-kernel-msg");
            this.mWriter.writeln("sysctl -p /etc/sysctl.conf");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("sysctl -p /etc/sysctl.conf"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("sysctl -p /etc/sysctl.conf");
            recVals.add("sysctl -p /etc/sysctl.conf");
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            this.pLogger.log(Level.FINEST, "tuneRcLocal", "Removing existing configuration from " + tuneFile);
            String[] delLines = new String[]{"Start: OpenSSO Tuning", "/proc/sys/net/ipv4/tcp_fin_timeout", "/proc/sys/net/ipv4/tcp_keepalive_time", "/proc/sys/net/ipv4/tcp_keepalive_intvl", "/proc/sys/net/ipv4/tcp_window_scaling", "sysctl -p /etc/sysctl.conf", "End: OpenSSO Tuning"};
            fh.removeMatchingLines(delLines);
            this.pLogger.log(Level.FINEST, "tuneRcLocal", "Adding recomendations to the " + tuneFile);
            fh.appendLine("# Start: OpenSSO Tuning " + AMTuneUtil.getTodayDateStr());
            Iterator itr = recVals.iterator();
            while (itr.hasNext()) {
                fh.appendLine((String)itr.next());
            }
            fh.appendLine("# End: OpenSSO Tuning " + AMTuneUtil.getTodayDateStr());
            fh.close();
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneRcLocal", ex);
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-lnx-boot-file-error"));
        }
    }

    protected void tuneSecurityLimits() throws AMTuneException {
        try {
            String tuneFile = "/etc/security/limits.conf";
            FileHandler tuneFileFh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-lnx-open-file-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            String curNoFileSoftDomain = "";
            String newNoFileSoftString = "";
            String[] matLines = tuneFileFh.getMattchingLines("^#", true);
            String[] sofTlines = AMTuneUtil.getMatchedLines(matLines, "soft");
            String[] reqLns = AMTuneUtil.getMatchedLines(sofTlines, "nofile");
            if (reqLns.length > 0) {
                curNoFileSoftDomain = reqLns[0].substring(0, reqLns[0].indexOf(" "));
                newNoFileSoftString = curNoFileSoftDomain + "               soft    nofile          " + 65536;
            } else {
                newNoFileSoftString = "*               soft    nofile          65536";
            }
            String[] hardLines = AMTuneUtil.getMatchedLines(matLines, "hard");
            String[] noFLines = AMTuneUtil.getMatchedLines(hardLines, "nofile");
            String curNoFileHardDomain = "";
            String newNoFileHardString = "";
            if (noFLines.length > 0) {
                curNoFileHardDomain = noFLines[0].substring(0, noFLines[0].indexOf(" "));
                newNoFileHardString = curNoFileHardDomain.trim() + "               hard    nofile          " + 65536;
            } else {
                newNoFileHardString = "*               hard    nofile          65536";
            }
            this.mWriter.writelnLocaleMsg("pt-lnx-soft-file-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            if (reqLns.length > 0) {
                this.mWriter.writeln(reqLns[0]);
            } else {
                this.mWriter.writeln(" ");
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(newNoFileSoftString);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-hard-file-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            if (noFLines.length > 0) {
                this.mWriter.writeln(noFLines[0]);
            } else {
                this.mWriter.writeln(" ");
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(newNoFileHardString);
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            this.pLogger.log(Level.FINEST, "tuneSecurityLimits", "Deleting configuration from " + tuneFile);
            String[] delLines = new String[]{"Start: OpenSSO Tuning", "End: OpenSSO Tuning"};
            tuneFileFh.removeMatchingLines(delLines);
            if (reqLns.length > 0) {
                tuneFileFh.removeMatchingLines(reqLns);
            }
            if (noFLines.length > 0) {
                tuneFileFh.removeMatchingLines(noFLines);
            }
            this.pLogger.log(Level.FINEST, "tuneSecurityLimits", "Modifying configuration file " + tuneFile);
            tuneFileFh.appendLine("# Start: OpenSSO Tuning " + AMTuneUtil.getTodayDateStr());
            tuneFileFh.appendLine(newNoFileSoftString);
            tuneFileFh.appendLine(newNoFileHardString);
            tuneFileFh.appendLine("# End: OpenSSO Tuning " + AMTuneUtil.getTodayDateStr());
            tuneFileFh.close();
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneSecurityLimits", ex);
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-lnx-limits-conf-error"));
        }
    }
}

