/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.sasl.callback.VerifyPasswordCallback;

public class UserLdapCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    public static final String SERVICE_SUFFIX = "ldap";
    public static final String DEFAULT_USER_DN = "dn";
    private final InjectedValue<ConnectionManager> connectionManager = new InjectedValue();
    private final String baseDn;
    private final String usernameAttribute;
    private final String advancedFilter;
    private final boolean recursive;
    private final String userDn;
    private final boolean allowEmptyPassword;
    protected final int searchTimeLimit = 10000;

    public UserLdapCallbackHandler(String baseDn, String userNameAttribute, String advancedFilter, boolean recursive, String userDn, boolean allowEmptyPassword) {
        this.baseDn = baseDn;
        if (userNameAttribute == null && advancedFilter == null) {
            throw DomainManagementMessages.MESSAGES.oneOfRequired("username-attribute", "advanced-filter");
        }
        this.usernameAttribute = userNameAttribute;
        this.advancedFilter = advancedFilter;
        this.recursive = recursive;
        this.userDn = userDn;
        this.allowEmptyPassword = allowEmptyPassword;
    }

    @Override
    public AuthenticationMechanism getPreferredMechanism() {
        return AuthenticationMechanism.PLAIN;
    }

    @Override
    public Set<AuthenticationMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
            AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
            String authenticationId = acb.getAuthenticationID();
            String authorizationId = acb.getAuthorizationID();
            acb.setAuthorized(authenticationId.equals(authorizationId));
            return;
        }
        ConnectionManager connectionManager = (ConnectionManager)this.connectionManager.getValue();
        String username = null;
        VerifyPasswordCallback verifyPasswordCallback = null;
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                username = ((NameCallback)current).getDefaultName();
                continue;
            }
            if (current instanceof RealmCallback) continue;
            if (current instanceof VerifyPasswordCallback) {
                verifyPasswordCallback = (VerifyPasswordCallback)current;
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
        if (username == null || username.length() == 0) {
            throw DomainManagementMessages.MESSAGES.noUsername();
        }
        if (verifyPasswordCallback == null) {
            throw DomainManagementMessages.MESSAGES.noPassword();
        }
        String password = verifyPasswordCallback.getPassword();
        if (password == null || !this.allowEmptyPassword && password.length() == 0) {
            throw DomainManagementMessages.MESSAGES.noPassword();
        }
        InitialDirContext searchContext = null;
        InitialDirContext userContext = null;
        NamingEnumeration<SearchResult> searchEnumeration = null;
        try {
            Attribute dn;
            searchContext = (InitialDirContext)connectionManager.getConnection();
            SearchControls searchControls = new SearchControls();
            if (this.recursive) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            searchControls.setReturningAttributes(new String[]{this.userDn});
            searchControls.setTimeLimit(10000);
            Object[] filterArguments = new Object[]{username};
            String filter = this.usernameAttribute != null ? "(" + this.usernameAttribute + "={0})" : this.advancedFilter;
            searchEnumeration = searchContext.search(this.baseDn, filter, filterArguments, searchControls);
            if (!searchEnumeration.hasMore()) {
                throw DomainManagementMessages.MESSAGES.userNotFoundInDirectory(username);
            }
            String distinguishedUserDN = null;
            SearchResult result = searchEnumeration.next();
            Attributes attributes = result.getAttributes();
            if (attributes != null && (dn = attributes.get(this.userDn)) != null) {
                distinguishedUserDN = (String)dn.get();
            }
            if (distinguishedUserDN == null) {
                if (result.isRelative()) {
                    distinguishedUserDN = result.getName() + ("".equals(this.baseDn) ? "" : "," + this.baseDn);
                } else {
                    throw DomainManagementMessages.MESSAGES.nameNotFound(result.getName());
                }
            }
            if ((userContext = (InitialDirContext)connectionManager.getConnection(distinguishedUserDN, password)) != null) {
                verifyPasswordCallback.setVerified(true);
            }
            this.safeClose(searchEnumeration);
            this.safeClose(searchContext);
            this.safeClose(userContext);
        }
        catch (Exception e) {
            try {
                throw DomainManagementMessages.MESSAGES.cannotPerformVerification(e);
            }
            catch (Throwable throwable) {
                this.safeClose(searchEnumeration);
                this.safeClose(searchContext);
                this.safeClose(userContext);
                throw throwable;
            }
        }
    }

    private void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void safeClose(NamingEnumeration ne) {
        if (ne != null) {
            try {
                ne.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

