/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2009, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.gatein.common.i18n;

import junit.framework.Assert;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.MalformedURLException;
import java.io.File;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 630 $
 */
public class BundleClassLoader
{

   private static ClassLoader instance;

   public synchronized static ClassLoader assertExists()
   {
      if (instance == null)
      {
         URL bundleURL = Thread.currentThread().getContextClassLoader().getResource("bundle");
         Assert.assertNotNull(bundleURL);
         File f = new File(bundleURL.getFile());
         Assert.assertTrue(f.exists());
         Assert.assertTrue(f.isDirectory());

         //
         try
         {
            URL url = f.toURI().toURL();;
            instance = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
         }
         catch (MalformedURLException e)
         {
            Assert.fail("Cannot get URL value " + e.getMessage());
         }
      }

      //
      return instance;
   }

}
