
/*
 * JBoss, a division of Red Hat
 * Copyright 2010, Red Hat Middleware, LLC, and individual
 * contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of
 * individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.oasis.wsrp.v1;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.0
 * 
 */
@WebService(name = "WSRP_v1_Markup_PortType", targetNamespace = "urn:oasis:names:tc:wsrp:v1:intf")
public interface WSRPV1MarkupPortType {


    /**
     * 
     * @param sessionContext
     * @param runtimeContext
     * @param markupContext
     * @param registrationContext
     * @param markupParams
     * @param portletContext
     * @param userContext
     * @param extensions
     * @throws V1InvalidCookie
     * @throws V1InvalidRegistration
     * @throws V1UnsupportedWindowState
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1UnsupportedMimeType
     * @throws V1InvalidUserCategory
     * @throws V1UnsupportedMode
     * @throws V1UnsupportedLocale
     * @throws V1OperationFailed
     * @throws V1AccessDenied
     * @throws V1MissingParameters
     * @throws V1InvalidSession
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:getMarkup")
    @RequestWrapper(localName = "getMarkup", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1GetMarkup")
    @ResponseWrapper(localName = "getMarkupResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1MarkupResponse")
    public void getMarkup(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "runtimeContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RuntimeContext runtimeContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "markupParams", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1MarkupParams markupParams,
        @WebParam(name = "markupContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1MarkupContext> markupContext,
        @WebParam(name = "sessionContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1SessionContext> sessionContext,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidCookie, V1InvalidHandle, V1InvalidRegistration, V1InvalidSession, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed, V1UnsupportedLocale, V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState
    ;

    /**
     * 
     * @param runtimeContext
     * @param registrationContext
     * @param redirectURL
     * @param updateResponse
     * @param markupParams
     * @param portletContext
     * @param interactionParams
     * @param userContext
     * @param extensions
     * @throws V1InvalidCookie
     * @throws V1InvalidRegistration
     * @throws V1UnsupportedWindowState
     * @throws V1InvalidHandle
     * @throws V1InconsistentParameters
     * @throws V1UnsupportedMimeType
     * @throws V1InvalidUserCategory
     * @throws V1UnsupportedMode
     * @throws V1OperationFailed
     * @throws V1UnsupportedLocale
     * @throws V1AccessDenied
     * @throws V1PortletStateChangeRequired
     * @throws V1MissingParameters
     * @throws V1InvalidSession
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:performBlockingInteraction")
    @RequestWrapper(localName = "performBlockingInteraction", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1PerformBlockingInteraction")
    @ResponseWrapper(localName = "performBlockingInteractionResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1BlockingInteractionResponse")
    public void performBlockingInteraction(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "portletContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1PortletContext portletContext,
        @WebParam(name = "runtimeContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RuntimeContext runtimeContext,
        @WebParam(name = "userContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1UserContext userContext,
        @WebParam(name = "markupParams", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1MarkupParams markupParams,
        @WebParam(name = "interactionParams", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1InteractionParams interactionParams,
        @WebParam(name = "updateResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<V1UpdateResponse> updateResponse,
        @WebParam(name = "redirectURL", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<String> redirectURL,
        @WebParam(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", mode = WebParam.Mode.OUT)
        Holder<List<V1Extension>> extensions)
        throws V1AccessDenied, V1InconsistentParameters, V1InvalidCookie, V1InvalidHandle, V1InvalidRegistration, V1InvalidSession, V1InvalidUserCategory, V1MissingParameters, V1OperationFailed, V1PortletStateChangeRequired, V1UnsupportedLocale, V1UnsupportedMimeType, V1UnsupportedMode, V1UnsupportedWindowState
    ;

    /**
     * 
     * @param registrationContext
     * @param sessionIDs
     * @return
     *     returns java.util.List<org.oasis.wsrp.v1.V1Extension>
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     * @throws V1MissingParameters
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:releaseSessions")
    @WebResult(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
    @RequestWrapper(localName = "releaseSessions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1ReleaseSessions")
    @ResponseWrapper(localName = "releaseSessionsResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1ReturnAny")
    public List<V1Extension> releaseSessions(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext,
        @WebParam(name = "sessionIDs", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        List<String> sessionIDs)
        throws V1AccessDenied, V1InvalidRegistration, V1MissingParameters, V1OperationFailed
    ;

    /**
     * 
     * @param registrationContext
     * @return
     *     returns java.util.List<org.oasis.wsrp.v1.V1Extension>
     * @throws V1OperationFailed
     * @throws V1InvalidRegistration
     * @throws V1AccessDenied
     */
    @WebMethod(action = "urn:oasis:names:tc:wsrp:v1:initCookie")
    @WebResult(name = "extensions", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
    @RequestWrapper(localName = "initCookie", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1InitCookie")
    @ResponseWrapper(localName = "initCookieResponse", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types", className = "org.oasis.wsrp.v1.V1ReturnAny")
    public List<V1Extension> initCookie(
        @WebParam(name = "registrationContext", targetNamespace = "urn:oasis:names:tc:wsrp:v1:types")
        V1RegistrationContext registrationContext)
        throws V1AccessDenied, V1InvalidRegistration, V1OperationFailed
    ;

}
