/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMEventListener;
import com.iplanet.am.sdk.AMObject;
import com.sun.identity.authentication.config.AMConfiguration;
import com.sun.identity.shared.debug.Debug;
import javax.security.auth.login.Configuration;

public class AMSDKEventListener
implements AMEventListener {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private String configName = null;
    private AMObject amObject = null;

    public AMSDKEventListener(String name) {
        this.configName = name;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void objectChanged(AMEvent event) {
        if (event == null) {
            debug.error("AMConfiguration.objectChanged, event null");
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("objectChanged, type=" + event.getEventType() + ", sDN=" + event.getSourceDN() + ", sType=" + event.getSourceType());
        }
        this.processSDKNotification();
    }

    public void objectRemoved(AMEvent event) {
        if (event == null) {
            debug.error("AMConfiguration.objectChanged, event null");
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("objectRemoved, type=" + event.getEventType() + ", sDN=" + event.getSourceDN() + ", sType=" + event.getSourceType());
        }
        this.processSDKNotification();
    }

    public void objectRenamed(AMEvent event) {
        if (event == null) {
            debug.error("AMConfiguration.objectChanged, event null");
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("objectRenamed, type=" + event.getEventType() + ", sDN=" + event.getSourceDN() + ", sType=" + event.getSourceType());
        }
        this.processSDKNotification();
    }

    private void processSDKNotification() {
        try {
            if (debug.messageEnabled()) {
                debug.message("processSDKNotification name=" + this.configName);
            }
            ((AMConfiguration)Configuration.getConfiguration()).processListenerEvent(this.configName);
        }
        catch (Exception e) {
            debug.error("processSDKNotification", (Throwable)e);
        }
    }

    public AMObject getListenedObject() {
        return this.amObject;
    }

    public void setListenedObject(AMObject object) {
        this.amObject = object;
    }
}

