/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class AddSubConfiguration
extends SchemaCommand {
    private static final String OPTION_PRIORITY = "priority";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String subConfigName = this.getStringOptionValue("subconfigname");
        String realmName = this.getStringOptionValue("realm");
        String subConfigId = this.getStringOptionValue("subconfigid");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        int priority = 0;
        String strPriority = this.getStringOptionValue(OPTION_PRIORITY);
        if (strPriority != null && strPriority.length() > 0) {
            try {
                priority = Integer.parseInt(strPriority);
            }
            catch (NumberFormatException ex) {
                throw new CLIException(this.getResourceString("add-sub-configuration-priority-no-integer"), 23);
            }
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        if (realmName == null || realmName.length() == 0) {
            this.addSubConfigToRoot(serviceName, subConfigName, subConfigId, attributeValues, priority);
        } else {
            this.addSubConfigToRealm(realmName, serviceName, subConfigName, subConfigId, attributeValues, priority);
        }
    }

    private void addSubConfigToRealm(String realmName, String serviceName, String subConfigName, String subConfigId, Map attrValues, int priority) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{realmName, subConfigName, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_ADD_SUB_CONFIGURATION_TO_REALM", params);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            ServiceConfig sc = scm.getOrganizationConfig(realmName, null);
            if (sc == null) {
                sc = scm.createOrganizationConfig(realmName, null);
            }
            this.addSubConfig(sc, subConfigName, subConfigId, attrValues, priority);
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_SUB_CONFIGURATION_TO_REALM", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-sub-configuration-to-realm-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{realmName, subConfigName, serviceName, e.getMessage()};
            this.debugError("AddSubConfiguration.addSubConfigToRealm", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_CONFIGURATIONT_TO_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realmName, subConfigName, serviceName, e.getMessage()};
            this.debugError("AddSubConfiguration.addSubConfigToRealm", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_CONFIGURATIONT_TO_REALM", args);
            throw new CLIException(e, 127);
        }
    }

    private void addSubConfigToRoot(String serviceName, String subConfigName, String subConfigId, Map attrValues, int priority) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{subConfigName, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_ADD_SUB_CONFIGURATION", params);
        try {
            ServiceConfigManager scm = new ServiceConfigManager(serviceName, adminSSOToken);
            ServiceConfig sc = scm.getGlobalConfig(null);
            if (sc == null) {
                String[] args = new String[]{subConfigName, serviceName, "no global configiration"};
                this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_CONFIGURATION", args);
                Object[] ar = new String[]{serviceName};
                String message = MessageFormat.format(this.getResourceString("add-sub-configuration-no-global-config"), ar);
                throw new CLIException(message, 127);
            }
            this.addSubConfig(sc, subConfigName, subConfigId, attrValues, priority);
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_SUB_CONFIGURATION", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-sub-configuration-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{subConfigName, serviceName, e.getMessage()};
            this.debugError("AddSubConfiguration.addSubConfigToRoot", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_CONFIGURATION", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            e.printStackTrace();
            String[] args = new String[]{subConfigName, serviceName, e.getMessage()};
            this.debugError("AddSubConfiguration.addSubConfigToRoot", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SUB_CONFIGURATION", args);
            throw new CLIException(e, 127);
        }
    }

    private void addSubConfig(ServiceConfig sc, String subConfigName, String subConfigId, Map attrValues, int priority) throws SSOException, SMSException {
        StringTokenizer st = new StringTokenizer(subConfigName, "/");
        int tokenCount = st.countTokens();
        for (int i = 1; i <= tokenCount; ++i) {
            String scn = SMSSchema.unescapeName(st.nextToken());
            if (i != tokenCount) {
                sc = sc.getSubConfig(scn);
                continue;
            }
            if (subConfigId == null) {
                subConfigId = subConfigName;
            }
            sc.addSubConfig(scn, subConfigId, priority, attrValues);
        }
    }
}

