/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.realm.IDRepoEditViewBean;
import com.sun.identity.console.realm.IDRepoSelectTypeViewBean;
import com.sun.identity.console.realm.RealmPropertiesBase;
import com.sun.identity.console.realm.model.IDRepoModel;
import com.sun.identity.console.realm.model.IDRepoModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class IDRepoViewBean
extends RealmPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/IDRepo.jsp";
    private static final String PAGETITLE = "pgtitle";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private static final String TBL_COL_TYPE = "tblColType";
    private static final String TBL_DATA_TYPE = "tblDataType";
    private CCActionTableModel tblModel = null;

    public IDRepoViewBean() {
        super("IDRepo");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createTableModel();
        this.createPageTitleModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(TBL_BUTTON_DELETE);
        this.getIDRepoNames();
        this.setPageTitle(this.getModel(), "page.title.realms.idrepo");
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new IDRepoModelImpl(req, this.getPageSessionAttributes());
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/oneBtnPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)this.getBackButtonLabel());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblRMIDRepo.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.idrepo.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.idrepo.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.idrepo.name.column.name");
        this.tblModel.setActionValue(TBL_COL_TYPE, (Object)"table.idrepo.name.column.type");
    }

    private void getIDRepoNames() {
        IDRepoModel model = (IDRepoModel)this.getModel();
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            this.populateTableModel(model.getIDRepoNames(curRealm));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            CCButton btnAdd = (CCButton)this.getChild(TBL_BUTTON_ADD);
            btnAdd.setDisabled(true);
        }
    }

    private void populateTableModel(Collection idRepoNames) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        if (idRepoNames != null && !idRepoNames.isEmpty()) {
            ArrayList<String> cache = new ArrayList<String>(idRepoNames.size());
            IDRepoModel model = (IDRepoModel)this.getModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            Map mapTypeToDisplayName = null;
            try {
                mapTypeToDisplayName = model.getIDRepoTypesMap();
            }
            catch (AMConsoleException e) {
                mapTypeToDisplayName = Collections.EMPTY_MAP;
            }
            boolean firstEntry = true;
            Iterator iter = idRepoNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String name = (String)iter.next();
                this.tblModel.setValue(TBL_DATA_NAME, (Object)name);
                try {
                    String type = model.getIDRepoType(curRealm, name);
                    String displayName = (String)mapTypeToDisplayName.get(type);
                    if (displayName == null) {
                        displayName = type;
                    }
                    this.tblModel.setValue(TBL_DATA_TYPE, (Object)displayName);
                }
                catch (AMConsoleException e) {
                    this.tblModel.setValue(TBL_DATA_TYPE, (Object)"");
                }
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)IDRepoViewBean.stringToHex(name));
                cache.add(name);
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        IDRepoModel model = (IDRepoModel)this.getModel();
        try {
            Map map = model.getIDRepoTypesMap();
            IDRepoSelectTypeViewBean vb = (IDRepoSelectTypeViewBean)this.getViewBean(IDRepoSelectTypeViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) {
        String idRepoName = IDRepoViewBean.hexToString((String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF));
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        try {
            IDRepoModel model = (IDRepoModel)this.getModel();
            this.setPageSessionAttribute("tfIdRepoName", (Serializable)((Object)idRepoName));
            this.setPageSessionAttribute("idRepoTypeName", (Serializable)((Object)model.getIDRepoType(curRealm, idRepoName)));
            IDRepoEditViewBean vb = (IDRepoEditViewBean)this.getViewBean(IDRepoEditViewBean.class);
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    public void handleTblButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
        table.restoreStateData();
        Integer[] selected = this.tblModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        HashSet names = new HashSet(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            names.add(list.get(selected[i]));
        }
        try {
            IDRepoModel model = (IDRepoModel)this.getModel();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            model.deleteIDRepos(curRealm, names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "idRepo.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "idRepo.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToRealmView(event);
    }
}

