/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.sun.identity.console.base.AMPostViewBean;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.realm.ServicesNoAttributeViewBean;
import com.sun.identity.console.service.SCServiceProfileViewBean;
import com.sun.identity.console.service.model.SCConfigModel;
import com.sun.identity.console.service.model.SCConfigModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.propertysheet.CCPropertySheet;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class SCConfigViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String PAGETITLE = "pgtitle";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME_PREFIX = "tblDataName";
    private static final String PROPERTY_SHEET_NAME = "psSections";
    protected static final String TBL_HREF_PREFIX = "tblHref";
    private CCPageTitleModel ptModel;
    protected CCPropertySheetModel psModel;

    public SCConfigViewBean(String name, String url) {
        super(name);
        this.setDefaultDisplayURL(url);
    }

    protected void initialize() {
        if (!this.initialized) {
            super.initialize();
            this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/simplePageTitle.xml"));
            this.createPropertyModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(PROPERTY_SHEET_NAME, CCPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.psModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        if (PROPERTY_SHEET_NAME.equals(name)) {
            return new CCPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.psModel, name);
        }
        if (PAGETITLE.equals(name)) {
            return new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        }
        if (this.psModel.isChildSupported(name)) {
            return this.psModel.createChild((View)this, name);
        }
        if (this.ptModel.isChildSupported(name)) {
            return this.ptModel.createChild((View)this, name);
        }
        return super.createChild(name);
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new SCConfigModelImpl(req, this.getPageSessionAttributes());
    }

    protected void populateTableModel(CCActionTableModel tblModel, List serviceNames, String section) {
        tblModel.setTitleLabel("label.items");
        tblModel.setActionValue(TBL_COL_NAME, (Object)"service.name");
        SCConfigModel model = (SCConfigModel)this.getModel();
        if (serviceNames != null && !serviceNames.isEmpty()) {
            int size = serviceNames.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    tblModel.appendRow();
                }
                String name = (String)serviceNames.get(i);
                tblModel.setValue(TBL_DATA_NAME_PREFIX + section, (Object)model.getLocalizedServiceName(name));
                tblModel.setValue(TBL_HREF_PREFIX + section, (Object)name);
            }
        }
    }

    protected void forwardToProfile(String serviceName) {
        SCConfigModel model = (SCConfigModel)this.getModel();
        this.setPageSessionAttribute("serviceName", (Serializable)((Object)serviceName));
        this.unlockPageTrail();
        String url = model.getServicePropertiesViewBeanURL(serviceName);
        if (url != null && url.length() != 0) {
            AMPostViewBean vb = (AMPostViewBean)this.getViewBean(AMPostViewBean.class);
            this.passPgSessionMap((ViewBean)vb);
            vb.setTargetViewBeanURL(url);
            vb.forwardTo(this.getRequestContext());
        } else if (model.hasConfigAttributes(serviceName)) {
            SCServiceProfileViewBean vb = (SCServiceProfileViewBean)this.getViewBean(SCServiceProfileViewBean.class);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        } else {
            this.setPageSessionAttribute("returnToViewBean", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
            ServicesNoAttributeViewBean vb = (ServicesNoAttributeViewBean)this.getViewBean(ServicesNoAttributeViewBean.class);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.services.config";
    }

    protected abstract void createPropertyModel();

    protected abstract void createTableModels();
}

