/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.util;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ProxyPolicyEvaluator;
import com.sun.identity.policy.ProxyPolicyEvaluatorFactory;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolicyDecisionUtils {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String ALLOW = "allow";
    private static final String WEB_AGENT_SERVICE_NAME = "iPlanetAMWebAgentService";
    public static final String AUTH_USER_ADVICE = "AuthUserConditionAdvice";
    public static final String AUTH_ROLE_ADVICE = "AuthRoleConditionAdvice";
    public static final String AUTH_REDIRECTION_ADVICE = "AuthRedirectionConditionAdvice";
    private static Debug debug = Debug.getInstance((String)"amPolicy");
    private static ProxyPolicyEvaluator pe;
    private static String errorMsg;
    private static Set actionNames;

    public static List doResourceIPEnvAuth(String resourceUrl, String realm, Map envParameters) throws PolicyException {
        ActionDecision decision = null;
        if (resourceUrl != null) {
            decision = PolicyDecisionUtils.getActionDecision(resourceUrl, envParameters);
            return PolicyDecisionUtils.getPolicyAdvice(decision, realm);
        }
        return Collections.EMPTY_LIST;
    }

    private static ActionDecision getActionDecision(String url, Map envParameters) throws PolicyException {
        ActionDecision ad = null;
        if (pe != null) {
            PolicyDecision pd = null;
            try {
                pd = pe.getPolicyDecisionIgnoreSubjects(url, actionNames, envParameters);
            }
            catch (PolicyException e) {
                debug.error("PolicyDecisionUtils.getActionDecision()", (Throwable)e);
                return null;
            }
            catch (SSOException ssoe) {
                debug.error("PolicyDecisionUtils.getActionDecision()", (Throwable)((Object)ssoe));
                return null;
            }
            Map actionDecisions = pd.getActionDecisions();
            if (actionDecisions != null && (ad = (ActionDecision)actionDecisions.get(GET)) == null) {
                ad = (ActionDecision)actionDecisions.get(POST);
            }
        } else {
            throw new PolicyException(errorMsg);
        }
        return ad;
    }

    private static List getPolicyAdvice(ActionDecision ad, String realm) {
        if (ad == null) {
            return Collections.EMPTY_LIST;
        }
        Set values = ad.getValues();
        if (values.contains(ALLOW)) {
            return Collections.EMPTY_LIST;
        }
        Map advices = ad.getAdvices();
        if (advices != null) {
            StringBuffer sb;
            ArrayList<Object> answer = new ArrayList<Object>();
            if (debug.messageEnabled()) {
                debug.message("PolicyDecisionUtils: processActionDecision : " + advices.values().toString() + ", realm=" + realm);
            }
            if (realm == null) {
                realm = "/";
            }
            if (!realm.startsWith("/")) {
                realm = DNMapper.orgNameToRealmName(realm);
            }
            if (PolicyDecisionUtils.findAdviceValue(advices, AUTH_USER_ADVICE, realm, sb = new StringBuffer())) {
                answer.add(AuthContext.IndexType.USER);
                answer.add(sb.toString());
            } else if (PolicyDecisionUtils.findAdviceValue(advices, AUTH_ROLE_ADVICE, realm, sb)) {
                answer.add(AuthContext.IndexType.ROLE);
                answer.add(sb.toString());
            } else if (PolicyDecisionUtils.findAdviceValue(advices, "AuthenticateToServiceConditionAdvice", realm, sb)) {
                answer.add(AuthContext.IndexType.SERVICE);
                answer.add(sb.toString());
            } else if (PolicyDecisionUtils.findAdviceValue(advices, "AuthSchemeConditionAdvice", realm, sb)) {
                answer.add(AuthContext.IndexType.MODULE_INSTANCE);
                answer.add(sb.toString());
            } else if (PolicyDecisionUtils.findAdviceValue(advices, "AuthLevelConditionAdvice", realm, sb)) {
                answer.add(AuthContext.IndexType.LEVEL);
                answer.add(sb.toString());
            } else if (PolicyDecisionUtils.findAdviceValue(advices, AUTH_REDIRECTION_ADVICE, realm, sb)) {
                answer.add(sb.toString());
            } else {
                String url = PolicyDecisionUtils.getOneAdviceAsRedirectURL(advices);
                if (url != null) {
                    answer.add(url);
                }
            }
            return answer;
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean findAdviceValue(Map advices, String adviceType, String realm, StringBuffer adviceValue) {
        String value = "";
        Set advice = (Set)advices.get(adviceType);
        if (advice != null) {
            for (String item : advice) {
                if (debug.messageEnabled()) {
                    debug.message("PolicyDecisionUtils.findAdviceValue: advice=" + item + ", realm=" + realm + ", type=" + adviceType);
                }
                if (item.startsWith("/")) {
                    int col = item.indexOf(":");
                    if (col != -1) {
                        String tmp = item.substring(0, col);
                        if (!tmp.equals(realm) || col == item.length() - 1) continue;
                        value = item.substring(col + 1);
                        break;
                    }
                    value = item;
                    break;
                }
                value = item;
                break;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyUtils:findAdviceValue, return value=" + value);
        }
        if (value.length() != 0) {
            adviceValue.append(value);
            return true;
        }
        return false;
    }

    private static String getOneAdviceAsRedirectURL(Map advices) {
        if (advices == null || advices.isEmpty()) {
            return null;
        }
        boolean found = false;
        String adviceType2 = null;
        String paramName = null;
        for (String adviceType2 : advices.keySet()) {
            if ("AuthenticateToRealmConditionAdvice".equals(adviceType2)) {
                found = true;
                break;
            }
            if (AUTH_USER_ADVICE.equals(adviceType2)) {
                paramName = "user";
                found = true;
                break;
            }
            if (AUTH_ROLE_ADVICE.equals(adviceType2)) {
                paramName = "role";
                found = true;
                break;
            }
            if ("AuthenticateToServiceConditionAdvice".equals(adviceType2)) {
                paramName = "service";
                found = true;
                break;
            }
            if ("AuthSchemeConditionAdvice".equals(adviceType2)) {
                paramName = "module";
                found = true;
                break;
            }
            if (!"AuthLevelConditionAdvice".equals(adviceType2)) continue;
            paramName = "authlevel";
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        Set advice = (Set)advices.get(adviceType2);
        if (advice != null) {
            String item = (String)advice.iterator().next();
            String realm = AMAuthUtils.getRealmFromRealmQualifiedData(item);
            String value = AMAuthUtils.getDataFromRealmQualifiedData(item);
            if (debug.messageEnabled()) {
                debug.message("PolicyDecisionUtils.getOneAdvice: advice=" + item + ", type=" + adviceType2 + ", realm=" + realm + ", indexName=" + value);
            }
            if (value == null || value.length() == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer("/UI/Login");
            if ("AuthenticateToRealmConditionAdvice".equals(adviceType2)) {
                sb.append("?realm=").append(value);
            } else {
                sb.append("?realm=").append(realm).append("&").append(paramName).append("=").append(value);
            }
            return sb.toString();
        }
        return null;
    }

    static {
        actionNames = new HashSet();
        try {
            SSOToken defToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            actionNames.add(GET);
            actionNames.add(POST);
            pe = ProxyPolicyEvaluatorFactory.getInstance().getProxyPolicyEvaluator(defToken, WEB_AGENT_SERVICE_NAME);
        }
        catch (PolicyException p) {
            debug.error("PolicyDecisionUtils: Unable to get PolicyEvaluator", (Throwable)p);
            errorMsg = p.getMessage();
        }
        catch (SSOException ssoe) {
            debug.error("PolicyDecisionUtils: Unable to get PolicyEvaluator", (Throwable)((Object)ssoe));
            errorMsg = ssoe.getMessage();
        }
    }
}

