/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.sun.identity.common.LDAPUtils;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.InstallLog;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.RDN;
import com.sun.identity.sm.SMSSchema;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class AMSetupDSConfig {
    private String dsManager;
    private String suffix;
    private String dsHostName;
    private String dsPort;
    private String dsAdminPwd;
    private static LDAPConnection ld = null;
    private String basedir;
    private String deployuri;
    private static AMSetupDSConfig dsConfigInstance = null;
    private Locale locale = null;

    private AMSetupDSConfig() {
        Map map = ServicesDefaultValues.getDefaultValues();
        this.dsManager = (String)map.get("DS_DIRMGRDN");
        this.suffix = (String)map.get("ROOT_SUFFIX");
        this.dsHostName = (String)map.get("DIRECTORY_SERVER");
        this.dsPort = (String)map.get("DIRECTORY_PORT");
        this.dsAdminPwd = (String)map.get("DS_DIRMGRPASSWD");
        this.basedir = (String)map.get("BASE_DIR");
        this.deployuri = (String)map.get("SERVER_URI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMSetupDSConfig getInstance() {
        Class<AMSetupDSConfig> clazz = AMSetupDSConfig.class;
        synchronized (AMSetupDSConfig.class) {
            if (dsConfigInstance == null) {
                dsConfigInstance = new AMSetupDSConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return dsConfigInstance;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    boolean isDServerUp(boolean ssl) {
        LDAPConnection ldc = this.getLDAPConnection(ssl);
        return ldc != null && ldc.isConnected();
    }

    boolean isDServerUp() {
        return this.isDServerUp(false);
    }

    private int getPort() {
        try {
            return Integer.parseInt(this.dsPort);
        }
        catch (NumberFormatException e) {
            throw new ConfiguratorException("configurator.invalidport", null, this.locale);
        }
    }

    public void setDSValues() {
        Map map = ServicesDefaultValues.getDefaultValues();
        if (this.suffix != null && this.suffix.length() > 0) {
            this.suffix = this.suffix.trim();
            String normalizedDN = LDAPDN.normalize((String)this.suffix);
            String canonicalizedDN = this.canonicalize(normalizedDN);
            String escapedDN = SMSSchema.escapeSpecialCharacters(normalizedDN);
            String peopleNMDN = "People_" + canonicalizedDN;
            map.put("People_NM_ORG_ROOT_SUFFIX", this.replaceDNDelimiter(peopleNMDN, "_"));
            map.put("SM_ROOT_SUFFIX_HAT", this.replaceDNDelimiter(escapedDN, "^"));
            map.put("NORMALIZED_RS", escapedDN);
            map.put("NORMALIZED_ORGBASE", escapedDN);
            map.put("ORG_ROOT_SUFFIX", this.suffix);
            String rdn = this.getRDNfromDN(normalizedDN);
            map.put("RS_RDN", LDAPDN.escapeRDN((String)rdn));
            map.put("DEFAULT_ORG", canonicalizedDN);
            map.put("ORG_BASE", canonicalizedDN);
            map.put("SM_CONFIG_ROOT_SUFFIX", this.suffix);
            map.put("SM_CONFIG_BASEDN", canonicalizedDN);
            map.put("SM_ROOT_SUFFIX_HAT", this.replaceDNDelimiter(escapedDN, "^"));
            String nstr = this.getRDNfromDN(canonicalizedDN);
            map.put("SM_CONFIG_BASEDN_RDNV", nstr);
        }
    }

    private String getRDNfromDN(String nSuffix) {
        String[] doms = LDAPDN.explodeDN((String)nSuffix, (boolean)true);
        return doms[0];
    }

    private String canonicalize(String nSuffix) {
        StringBuffer buff = new StringBuffer(1024);
        DN dn = new DN(nSuffix);
        Vector rdns = dn.getRDNs();
        int sz = rdns.size();
        for (int i = 0; i < sz; ++i) {
            RDN rdn = (RDN)rdns.get(i);
            buff.append(LDAPDN.escapeRDN((String)rdn.toString()));
            if (i >= sz - 1) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private String replaceDNDelimiter(String nSuffix, String replaceWith) {
        return nSuffix.replaceAll(",", replaceWith).trim();
    }

    public boolean connectDSwithDN(boolean ssl) {
        String filter = "cn=\"" + this.suffix + "\"";
        String[] attrs = new String[]{""};
        LDAPSearchResults results = null;
        boolean isValidSuffix = true;
        try {
            results = this.getLDAPConnection(ssl).search(this.suffix, 0, filter, attrs, false);
        }
        catch (LDAPException e) {
            isValidSuffix = false;
            this.disconnectDServer();
        }
        return isValidSuffix;
    }

    String isDITLoaded(boolean ssl) {
        String isLoaded;
        block3: {
            String baseDN = "ou=services," + this.suffix;
            String filter = "(|(ou=DAI) (ou=sunIdentityRepositoryService))";
            String[] attrs = new String[]{"dn"};
            LDAPSearchResults results = null;
            isLoaded = "false";
            try {
                results = this.getLDAPConnection(ssl).search(baseDN, 2, filter, attrs, false);
                if (results.getCount() > 0) {
                    isLoaded = "true";
                }
            }
            catch (LDAPException e) {
                if (!Debug.getInstance((String)"amSetupServlet").messageEnabled()) break block3;
                Debug.getInstance((String)"amSetupServlet").message("AMSetupDSConfig.isDITLoaded: LDAP Operation return code: " + e.getLDAPResultCode());
            }
        }
        return isLoaded;
    }

    public void loadSchemaFiles(List schemaFiles) throws ConfiguratorException {
        try {
            for (String file : schemaFiles) {
                int idx = file.lastIndexOf("/");
                String schemaFile = idx != -1 ? file.substring(idx + 1) : file;
                Object[] params = new Object[]{schemaFile};
                SetupProgress.reportStart("emb.loadingschema", params);
                LDAPUtils.createSchemaFromLDIF(this.basedir + "/" + schemaFile, ld);
                SetupProgress.reportEnd("emb.success", null);
            }
        }
        catch (IOException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupDSConfig.loadSchemaFiles:failed", (Throwable)e);
            SetupProgress.reportEnd("emb.failed", null);
            InstallLog.getInstance().write("AMSetupDSConfig.loadSchemaFiles:failed", e);
            throw new ConfiguratorException("configurator.ldiferror", null, this.locale);
        }
        catch (LDAPException e) {
            Debug.getInstance((String)"amSetupServlet").error("AMSetupDSConfig.loadSchemaFiles:failed", (Throwable)e);
            SetupProgress.reportEnd("emb.failed", null);
            InstallLog.getInstance().write("AMSetupDSConfig.loadSchemaFiles:failed", (Exception)((Object)e));
            throw new ConfiguratorException(e.getMessage());
        }
    }

    private void disconnectDServer() {
        block3: {
            if (ld != null && ld.isConnected()) {
                try {
                    ld.disconnect();
                    ld = null;
                    dsConfigInstance = null;
                }
                catch (LDAPException e) {
                    if (!Debug.getInstance((String)"amSetupServlet").messageEnabled()) break block3;
                    Debug.getInstance((String)"amSetupServlet").message("AMSetupDSConfig.disconnectDServer: LDAP Operation return code: " + e.getLDAPResultCode());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized LDAPConnection getLDAPConnection(boolean ssl) {
        block7: {
            if (ld == null) {
                try {
                    ShutdownManager shutdownMan = ShutdownManager.getInstance();
                    if (!shutdownMan.acquireValidLock()) break block7;
                    try {
                        ld = ssl ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
                        ld.setConnectTimeout(300);
                        ld.connect(3, this.dsHostName, this.getPort(), this.dsManager, this.dsAdminPwd);
                        shutdownMan.addShutdownListener(new ShutdownListener(){

                            public void shutdown() {
                                AMSetupDSConfig.this.disconnectDServer();
                            }
                        });
                    }
                    finally {
                        shutdownMan.releaseLockAndNotify();
                    }
                }
                catch (LDAPException e) {
                    this.disconnectDServer();
                    dsConfigInstance = null;
                    ld = null;
                }
                catch (Exception e) {
                    dsConfigInstance = null;
                    ld = null;
                }
            }
        }
        return ld;
    }
}

