/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AuthenticationServiceNameProvider;
import com.sun.identity.sm.AuthenticationServiceNameProviderFactory;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.OrganizationConfigManagerImpl;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceManager {
    private static boolean initialized;
    private static boolean loadedAuthServices;
    protected static final String serviceDN;
    protected static final String COEXISTENCE_ATTR_NAME = "coexistenceMode";
    protected static HashMap serviceNameDefaultVersion;
    protected static final String REALM_ATTR_NAME = "realmMode";
    public static final String REALM_SERVICE = "sunidentityrepositoryservice";
    protected static final String DEFAULT_SERVICES_FOR_REALMS = "serviceNamesForAutoAssignment";
    protected static final String SERVICE_VERSION = "1.0";
    protected static final String REALM_ENTRY;
    protected static final String PLATFORM_SERVICE = "iPlanetAMPlatformService";
    protected static final String ATTR_SERVER_LIST = "iplanet-am-platform-server-list";
    private static boolean realmCache;
    private static boolean coexistenceCache;
    private static boolean ditUpgradedCache;
    protected static Set requiredServices;
    protected static Set defaultServicesToLoad;
    private static final String SERVICE_OC_ATTR_NAME = "serviceObjectClasses";
    private static final String ALL_SERVICES = "null";
    private static Map serviceNameAndOCs;
    protected static SMSEntry smsEntry;
    protected static CachedSubEntries serviceNames;
    protected static HashMap serviceVersions;
    protected static Set accessManagerServers;
    private SSOToken token;
    private CachedSubEntries subEntries = null;
    private static Debug debug;
    private static boolean amsdkChecked;
    private static boolean isAMSDKEnabled;

    public ServiceManager(SSOToken token) throws SSOException, SMSException {
        ServiceManager.initialize(token);
        SSOTokenManager.getInstance().validateToken(token);
        this.token = token;
    }

    public ServiceSchemaManager getSchemaManager(String serviceName, String version) throws SMSException, SSOException {
        return new ServiceSchemaManager(this.token, serviceName, version);
    }

    public ServiceConfigManager getConfigManager(String serviceName, String version) throws SMSException, SSOException {
        return new ServiceConfigManager(this.token, serviceName, version);
    }

    public OrganizationConfigManager getOrganizationConfigManager(String orgName) throws SMSException, SSOException {
        return new OrganizationConfigManager(this.token, orgName);
    }

    public Set getServiceNames() throws SMSException {
        try {
            if (serviceNames == null) {
                serviceNames = CachedSubEntries.getInstance(this.token, serviceDN);
            }
            return serviceNames.getSubEntries(this.token);
        }
        catch (SSOException s) {
            debug.error("ServiceManager: Unable to get service names", (Throwable)((Object)s));
            throw new SMSException((Throwable)((Object)s), "sms-service-not-found");
        }
    }

    public Map getServiceNamesAndOCs(String schemaType) {
        HashMap answer;
        block12: {
            if (schemaType == null) {
                schemaType = ALL_SERVICES;
            } else if (schemaType.equalsIgnoreCase("realm")) {
                schemaType = "filteredrole";
            }
            answer = (HashMap)serviceNameAndOCs.get(schemaType);
            if (answer == null) {
                try {
                    answer = new HashMap();
                    Set sNames = this.getServiceNames();
                    if (sNames != null && !sNames.isEmpty()) {
                        Iterator it = sNames.iterator();
                        while (it.hasNext()) {
                            try {
                                Map attrs;
                                ServiceSchemaImpl ss;
                                String service = (String)it.next();
                                ServiceSchemaManagerImpl ssm = ServiceManager.isCoexistenceMode() ? ServiceSchemaManagerImpl.getInstance(this.token, service, ServiceManager.serviceDefaultVersion(this.token, service)) : ServiceSchemaManagerImpl.getInstance(this.token, service, ServiceManager.getVersion(service));
                                if (ssm == null || schemaType != null && ssm.getSchema(new SchemaType(schemaType)) == null && (schemaType.equalsIgnoreCase("User") && ssm.getSchema(SchemaType.DYNAMIC) == null || schemaType.toLowerCase().indexOf("role") != -1 && ssm.getSchema(SchemaType.DYNAMIC) == null) || (ss = ssm.getSchema(SchemaType.GLOBAL)) == null || !(attrs = ss.getAttributeDefaults()).containsKey(SERVICE_OC_ATTR_NAME)) continue;
                                answer.put(service, attrs.get(SERVICE_OC_ATTR_NAME));
                            }
                            catch (SMSException smse) {
                                if (!debug.messageEnabled()) continue;
                                debug.message("ServiceManager.getServiceNamesandOCs caught SMSException ", (Throwable)smse);
                            }
                        }
                    }
                    serviceNameAndOCs.put(schemaType, answer);
                }
                catch (SMSException smse) {
                    if (debug.messageEnabled()) {
                        debug.message("ServiceManager.getServiceNamesandOCs caught SMSException ", (Throwable)smse);
                    }
                }
                catch (SSOException ssoe) {
                    if (!debug.messageEnabled()) break block12;
                    debug.message("ServiceManager.getServiceNamesandOCs caught SSOException ", (Throwable)((Object)ssoe));
                }
            }
        }
        return SMSUtils.copyAttributes(answer);
    }

    public Set getServiceVersions(String serviceName) throws SMSException {
        try {
            return ServiceManager.getVersions(this.token, serviceName);
        }
        catch (SSOException s) {
            debug.error("ServiceManager: Unable to get service versions", (Throwable)((Object)s));
            throw new SMSException((Throwable)((Object)s), "sms-version-not-found");
        }
    }

    public Set registerServices(InputStream xmlServiceSchema) throws SMSException, SSOException {
        return this.registerServices(xmlServiceSchema, null);
    }

    public Set registerServices(InputStream xmlServiceSchema, AMEncryption decryptObj) throws SMSException, SSOException {
        String version;
        String name;
        SMSEntry.validateToken(this.token);
        HashSet<String> sNames = new HashSet<String>();
        ArrayList<Node> serviceNodes = new ArrayList<Node>();
        Document doc = SMSSchema.getXMLDocument(xmlServiceSchema);
        if (!this.validSMSDtdDocType(doc)) {
            throw new SMSException("amSDK", "sms-invalid-doctype", null);
        }
        ServiceManager.checkAndEncryptPasswordSyntax(doc, true, decryptObj);
        NodeList nodes = doc.getElementsByTagName("Service");
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node serviceNode = nodes.item(i);
            name = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"name");
            version = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"version");
            SMSSchema smsSchema = new SMSSchema(name, version, doc);
            if (XMLUtils.getChildNode((Node)serviceNode, (String)"Schema") != null) {
                ServiceManager.validateServiceSchema(serviceNode);
                ServiceSchemaManager.createService(this.token, smsSchema);
                if (serviceNames == null) {
                    serviceNames = CachedSubEntries.getInstance(this.token, serviceDN);
                }
                serviceNames.add(name);
                CachedSubEntries sVersions = (CachedSubEntries)serviceVersions.get(name);
                if (sVersions == null) {
                    sVersions = CachedSubEntries.getInstance(this.token, ServiceManager.getServiceNameDN(name));
                    serviceVersions.put(name, sVersions);
                }
                sVersions.add(version);
                sNames.add(name);
            }
            for (Node pluginNode : XMLUtils.getChildNodes((Node)serviceNode, (String)"PluginSchema")) {
                PluginSchema.createPluginSchema(this.token, pluginNode, smsSchema);
            }
            if (XMLUtils.getChildNode((Node)serviceNode, (String)"Configuration") == null) continue;
            serviceNodes.add(serviceNode);
        }
        if (serviceNodes.size() > 0) {
            this.clearCache();
        }
        for (Node svcNode : serviceNodes) {
            name = XMLUtils.getNodeAttributeValue((Node)svcNode, (String)"name");
            version = XMLUtils.getNodeAttributeValue((Node)svcNode, (String)"version");
            Node configNode = XMLUtils.getChildNode((Node)svcNode, (String)"Configuration");
            CreateServiceConfig.createService(this, name, version, configNode, true, decryptObj);
        }
        return sNames;
    }

    private boolean validSMSDtdDocType(Document doc) {
        String dtdPath;
        boolean valid = false;
        DocumentType docType = doc.getDoctype();
        if (docType != null && (dtdPath = docType.getSystemId()) != null) {
            int idx = dtdPath.lastIndexOf(47);
            if (idx != -1) {
                dtdPath = dtdPath.substring(idx + 1);
            }
            valid = dtdPath.equals("sms.dtd");
        }
        return valid;
    }

    public void removeService(String serviceName, String version) throws SMSException, SSOException {
        if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService") || serviceName.equalsIgnoreCase("iPlanetAMAuthService")) {
            Object[] args = new Object[]{serviceName};
            throw new SMSException("amSDK", "sms-SERVICE_CORE_CANNOT_DELETE", args);
        }
        SMSEntry.validateToken(this.token);
        String[] objs = new String[]{serviceName};
        for (String dn : SMSEntry.search(MessageFormat.format("(&(objectclass=top)(ou={0}))", objs))) {
            SMSEntry e;
            Iterator versions;
            CachedSMSEntry smse;
            SMSEntry confige;
            String configdn = "ou=" + version + "," + dn;
            CachedSMSEntry configsmse = CachedSMSEntry.getInstance(this.token, configdn);
            if (configsmse.isDirty()) {
                configsmse.refresh();
            }
            if (!(confige = configsmse.getClonedSMSEntry()).isNewEntry()) {
                confige.delete(this.token);
                configsmse.refresh(confige);
            }
            if ((smse = CachedSMSEntry.getInstance(this.token, dn)).isDirty()) {
                smse.refresh();
            }
            if ((versions = (e = smse.getSMSEntry()).subEntries(this.token, "*", 0, false, false).iterator()).hasNext()) continue;
            e.delete(this.token);
            smse.refresh(e);
        }
    }

    public void deleteService(String serviceName) throws SMSException, SSOException {
        if (serviceName.equalsIgnoreCase("sunIdentityRepositoryService") || serviceName.equalsIgnoreCase("iPlanetAMAuthService")) {
            Object[] args = new Object[]{serviceName};
            throw new SMSException("amSDK", "sms-SERVICE_CORE_CANNOT_DELETE", args);
        }
        for (String version : this.getServiceVersions(serviceName)) {
            CachedSMSEntry ce = CachedSMSEntry.getInstance(this.token, ServiceManager.getServiceNameDN(serviceName, version));
            if (ce.isDirty()) {
                ce.refresh();
            }
            SMSEntry e = ce.getClonedSMSEntry();
            String[] values = new String[]{SMSSchema.getDummyXML(serviceName, version)};
            e.setAttribute("sunServiceSchema", values);
            e.save(this.token);
            ce.refresh(e);
        }
    }

    public static String getBaseDN() {
        return SMSEntry.baseDN;
    }

    public static Set getAMServerInstances() {
        block6: {
            if (accessManagerServers == null) {
                try {
                    SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    accessManagerServers = ServerConfiguration.getServers(token);
                    if (debug.messageEnabled()) {
                        debug.message("ServiceManager.getAMServerInstances: server list: " + accessManagerServers);
                    }
                }
                catch (SMSException e) {
                    if (debug.warningEnabled()) {
                        debug.warning("ServiceManager.getAMServerInstances: Unable to get server list", (Throwable)e);
                    }
                }
                catch (SSOException e) {
                    if (!debug.warningEnabled()) break block6;
                    debug.warning("ServiceManager.getAMServerInstances: Unable to get server list", (Throwable)((Object)e));
                }
            }
        }
        return accessManagerServers == null ? new HashSet() : new HashSet(accessManagerServers);
    }

    public Set searchOrganizationNames(String serviceName, String attrName, Set values) throws SMSException, SSOException {
        try {
            if (this.subEntries == null) {
                this.subEntries = CachedSubEntries.getInstance(this.token, "ou=services," + SMSEntry.baseDN);
            }
            return this.subEntries.searchOrgNames(this.token, serviceName.toLowerCase(), attrName, values);
        }
        catch (SSOException ssoe) {
            debug.error("OrganizationConfigManagerImpl: Unable to get sub organization names", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    public synchronized void clearCache() {
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        serviceVersions = new CaseInsensitiveHashMap();
        serviceNameDefaultVersion = new CaseInsensitiveHashMap();
        accessManagerServers = null;
        amsdkChecked = false;
        CachedSMSEntry.clearCache();
        CachedSubEntries.clearCache();
        ServiceSchemaManagerImpl.clearCache();
        PluginSchemaImpl.clearCache();
        ServiceInstanceImpl.clearCache();
        ServiceConfigImpl.clearCache();
        ServiceConfigManagerImpl.clearCache();
        OrganizationConfigManagerImpl.clearCache();
        OrgConfigViaAMSDK.clearCache();
        try {
            ServiceManager.checkFlags(this.token);
            OrganizationConfigManager.initializeFlags();
            DNMapper.clearCache();
        }
        catch (Exception e) {
            debug.error("ServiceManager::clearCache unable to re-initialize global flags", (Throwable)e);
        }
    }

    public static boolean isCoexistenceMode() {
        ServiceManager.isRealmEnabled();
        return coexistenceCache;
    }

    protected static String getVersion(String serviceName) {
        if ("iPlanetAMProviderConfigService".equals(serviceName)) {
            return "1.1";
        }
        return SERVICE_VERSION;
    }

    public static boolean isRealmEnabled() {
        if (!initialized) {
            try {
                ServiceManager.initialize((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
            }
            catch (Exception ssme) {
                debug.error("ServiceManager::isRealmEnabled unable to initialize", (Throwable)ssme);
            }
        }
        return realmCache;
    }

    public static boolean isAMSDKConfigured() throws SMSException {
        if (!ServiceManager.isRealmEnabled() || OrgConfigViaAMSDK.isAMSDKConfigured("/")) {
            return true;
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        Set realms = new OrganizationConfigManager(token, "/").getSubOrganizationNames("*", true);
        Iterator items = realms.iterator();
        while (items.hasNext()) {
            String realm = items.next().toString();
            if (!OrgConfigViaAMSDK.isAMSDKConfigured(realm)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfigMigratedTo70() {
        ServiceManager.isRealmEnabled();
        return ditUpgradedCache;
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    protected static String getCacheIndex(String serviceName, String version) {
        StringBuffer sb = new StringBuffer(20);
        return sb.append(serviceName).append(version).toString().toLowerCase();
    }

    protected static String getServiceNameDN(String serviceName) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou").append("=").append(serviceName).append(",").append(serviceDN);
        return sb.toString();
    }

    protected static String getServiceNameDN(String serviceName, String version) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou").append("=").append(version).append(",").append(ServiceManager.getServiceNameDN(serviceName));
        return sb.toString();
    }

    protected static Set getVersions(SSOToken token, String serviceName) throws SMSException, SSOException {
        CachedSubEntries sVersions = (CachedSubEntries)serviceVersions.get(serviceName);
        if (sVersions == null) {
            sVersions = CachedSubEntries.getInstance(token, ServiceManager.getServiceNameDN(serviceName));
            if (sVersions == null || sVersions.getSMSEntry().isNewEntry() || sVersions.getSubEntries(token).isEmpty()) {
                Object[] msgs = new String[]{serviceName};
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", msgs);
            }
            serviceVersions.put(serviceName, sVersions);
        }
        return sVersions.getSubEntries(token);
    }

    protected static void checkAndEncryptPasswordSyntax(Document doc, boolean encrypt) throws SMSException {
        ServiceManager.checkAndEncryptPasswordSyntax(doc, encrypt, null);
    }

    protected static void checkAndEncryptPasswordSyntax(Document doc, boolean encrypt, AMEncryption encryptObj) throws SMSException {
        NodeList nl = doc.getElementsByTagName("AttributeSchema");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node defaultNode;
            Node node = nl.item(i);
            String syntax = XMLUtils.getNodeAttributeValue((Node)node, (String)"syntax");
            if (!syntax.equals(AttributeSchema.Syntax.PASSWORD.toString())) continue;
            if (debug.messageEnabled()) {
                debug.message("ServiceManager: encrypting password syntax");
            }
            if ((defaultNode = XMLUtils.getChildNode((Node)node, (String)"DefaultValues")) == null) continue;
            for (Node valueNode : XMLUtils.getChildNodes((Node)defaultNode, (String)"Value")) {
                String encValue;
                byte[] b;
                String value = XMLUtils.getValueOfValueNode((Node)valueNode);
                if (encrypt) {
                    if (encryptObj != null && (value = (String)AccessController.doPrivileged(new DecodeAction(value, encryptObj))).equals("&amp;#160;")) {
                        try {
                            b = new byte[]{-96};
                            value = new String(b, "ISO-8859-1");
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                    }
                    encValue = (String)AccessController.doPrivileged(new EncodeAction(value));
                } else {
                    encValue = (String)AccessController.doPrivileged(new DecodeAction(value));
                    try {
                        b = encValue.getBytes("ISO-8859-1");
                        if (b.length == 1 && b[0] == -96) {
                            encValue = "&amp;#160;";
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    if (encryptObj != null) {
                        encValue = (String)AccessController.doPrivileged(new EncodeAction(encValue, encryptObj));
                    }
                }
                StringBuffer sb = new StringBuffer(100);
                sb.append("<Value>").append(encValue).append("</Value>");
                Document newDoc = SMSSchema.getXMLDocument(sb.toString(), false);
                Node newValueNode = XMLUtils.getRootNode((Document)newDoc, (String)"Value");
                Node nValueNode = doc.importNode(newValueNode, true);
                defaultNode.replaceChild(nValueNode, valueNode);
            }
        }
    }

    protected static boolean validateServiceSchema(Node serviceNode) throws SMSException {
        Node schemaRoot = XMLUtils.getChildNode((Node)serviceNode, (String)"Schema");
        String[] schemaNames = new String[]{"Global", "Organization", "Dynamic", "User", "Policy", "Group", "Domain"};
        for (int i = 0; i < schemaNames.length; ++i) {
            Node childNode = XMLUtils.getChildNode((Node)schemaRoot, (String)schemaNames[i]);
            if (childNode == null) continue;
            ServiceSchemaImpl ssi = new ServiceSchemaImpl(null, childNode);
            Map attrs = ssi.getAttributeDefaults();
            ssi.validateAttributes(attrs, false);
        }
        return true;
    }

    protected static void schemaChanged() {
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        serviceNames = null;
    }

    protected static String serviceDefaultVersion(SSOToken token, String serviceName) throws SMSException, SSOException {
        String version = (String)serviceNameDefaultVersion.get(serviceName);
        if (version == null) {
            Iterator iter = ServiceManager.getVersions(token, serviceName).iterator();
            if (!iter.hasNext()) {
                Object[] msgs = new String[]{serviceName};
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", msgs);
            }
            version = (String)iter.next();
            serviceNameDefaultVersion.put(serviceName, version);
        }
        return version;
    }

    public static Set servicesAssignedByDefault() {
        if (!loadedAuthServices) {
            AuthenticationServiceNameProvider provider = AuthenticationServiceNameProviderFactory.getProvider();
            defaultServicesToLoad.addAll(provider.getAuthenticationServiceNames());
            if (debug.messageEnabled()) {
                debug.message("ServiceManager::servicesAssignedByDefault:defaultServicesToLoad = " + defaultServicesToLoad);
            }
            loadedAuthServices = true;
            defaultServicesToLoad = Collections.unmodifiableSet(defaultServicesToLoad);
        }
        return defaultServicesToLoad;
    }

    static Set requiredServices() {
        return requiredServices;
    }

    static void initialize(SSOToken token) throws SMSException, SSOException {
        SMSEntry.validateToken(token);
        if (initialized) {
            return;
        }
        try {
            serviceNames = CachedSubEntries.getInstance(token, serviceDN);
            if (serviceNames.getSMSEntry().isNewEntry()) {
                if (debug.warningEnabled()) {
                    debug.warning("SeviceManager:: Root service node does not exists: " + serviceDN);
                }
                Object[] msgs = new String[]{serviceDN};
                throw new SMSException("amSDK", "sms-services_node_does_not_exist", msgs);
            }
        }
        catch (SMSException e) {
            debug.error("ServiceManager::unable to get services node: " + serviceDN, (Throwable)e);
            throw e;
        }
        ServiceManager.checkFlags(token);
        initialized = true;
    }

    static void checkFlags(SSOToken token) throws SMSException, SSOException {
        try {
            CachedSMSEntry entry = CachedSMSEntry.getInstance(token, REALM_ENTRY);
            if (entry.isDirty()) {
                entry.refresh();
            }
            if (!entry.isNewEntry()) {
                Set realmEntry;
                ditUpgradedCache = true;
                ServiceConfigManagerImpl ssm = ServiceConfigManagerImpl.getInstance(token, REALM_SERVICE, SERVICE_VERSION);
                ServiceConfigImpl sc = null;
                Map map = null;
                if (ssm == null || (sc = ssm.getGlobalConfig(token, null)) == null || (map = sc.getAttributes()) == null) {
                    return;
                }
                Set coexistEntry = (Set)map.get(COEXISTENCE_ATTR_NAME);
                if (coexistEntry != null && coexistEntry.contains("false")) {
                    coexistenceCache = false;
                }
                if ((realmEntry = (Set)map.get(REALM_ATTR_NAME)) != null && realmEntry.contains("true")) {
                    realmCache = true;
                }
                requiredServices = (Set)map.get(DEFAULT_SERVICES_FOR_REALMS);
                defaultServicesToLoad = new HashSet();
                defaultServicesToLoad.addAll(requiredServices);
                loadedAuthServices = false;
            }
            if (debug.messageEnabled()) {
                debug.message("ServiceManager::checkFlags:realmEnabled=" + realmCache);
                debug.message("ServiceManager::checkFlags:coexistenceMode=" + coexistenceCache);
            }
        }
        catch (SMSException e) {
            debug.error("ServiceManager::unable to check if Realm is enabled: ", (Throwable)e);
            throw e;
        }
    }

    public String toXML(AMEncryption encryptObj) throws SMSException, SSOException {
        StringBuffer buff = new StringBuffer();
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("\n").append("<!DOCTYPE ServicesConfiguration\n").append("PUBLIC \"=//iPlanet//Service Management Services (SMS) 1.0 DTD//EN\"\n").append("\"jar://com/sun/identity/sm/sms.dtd\">\n\n");
        buff.append("<ServicesConfiguration>\n");
        Set serviceNames = this.getServiceNames();
        for (String serviceName : serviceNames) {
            Set versions = this.getServiceVersions(serviceName);
            for (String version : versions) {
                ServiceSchemaManager ssm = new ServiceSchemaManager(this.token, serviceName, version);
                String xml = ssm.toXML(encryptObj);
                ServiceConfigManager scm = new ServiceConfigManager(serviceName, this.token);
                int idx = xml.lastIndexOf("</Service>");
                xml = xml.substring(0, idx) + scm.toXML(encryptObj) + "</" + "Service" + ">";
                buff.append(xml).append("\n");
            }
        }
        buff.append("</ServicesConfiguration>\n");
        return buff.toString().replaceAll("&amp;#160;", "&#160;");
    }

    public static boolean isAMSDKEnabled() {
        if (amsdkChecked) {
            return isAMSDKEnabled;
        }
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            if (!ServiceManager.isRealmEnabled()) {
                amsdkChecked = true;
                isAMSDKEnabled = true;
            } else {
                ServiceSchemaManager ssm = new ServiceSchemaManager("sunIdentityRepositoryService", adminToken);
                ServiceSchema idRepoSubSchema = ssm.getOrganizationSchema();
                Set idRepoPlugins = idRepoSubSchema.getSubSchemaNames();
                if (idRepoPlugins.contains("amSDK")) {
                    isAMSDKEnabled = true;
                }
                amsdkChecked = true;
            }
        }
        catch (Exception e) {
            debug.error("IdUtils.isAMSDKEnabled() Error in checking AM.SDK being configured", (Throwable)e);
        }
        amsdkChecked = true;
        return isAMSDKEnabled;
    }

    static {
        serviceDN = "ou=services," + SMSEntry.baseDN;
        serviceNameDefaultVersion = new CaseInsensitiveHashMap();
        REALM_ENTRY = "ou=1.0,ou=sunidentityrepositoryservice," + serviceDN;
        coexistenceCache = true;
        serviceNameAndOCs = new CaseInsensitiveHashMap();
        serviceVersions = new CaseInsensitiveHashMap();
        debug = SMSEntry.debug;
    }
}

