/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPControl;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModificationSet;
import com.sun.identity.shared.ldap.LDAPRebind;
import com.sun.identity.shared.ldap.LDAPRebindAuth;
import com.sun.identity.shared.ldap.LDAPReferralException;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.LDAPSocketFactory;
import com.sun.identity.shared.ldap.controls.LDAPPasswordExpiringControl;
import com.sun.identity.shared.ldap.factory.JSSESocketFactory;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class LDAPAuthUtils {
    private boolean returnUserDN;
    private String authDN = "";
    private Set userSearchAttrs = null;
    private String searchFilter = "";
    private String userNamingValue = null;
    private String userNamingAttr = null;
    private String ssl;
    private String baseDN;
    private String serverHost;
    private String secServerHost;
    private int serverPort = 389;
    private int secServerPort;
    private String userDN;
    private String userPassword;
    private String userId;
    private String authPassword = "";
    private String expiryTime;
    private int searchScope = 2;
    private int screenState;
    private int version = 3;
    private Debug debug = null;
    private boolean ldapSSL = false;
    private ResourceBundle bundle;
    public static final int USER_NOT_FOUND = 1;
    static final int CONFIG_ERROR = 4;
    static final int CANNOT_CONTACT_SERVER = 5;
    static final int PASSWORD_EXPIRED_STATE = 20;
    public static final int PASSWORD_EXPIRING = 21;
    static final int PASSWORD_MISMATCH = 23;
    static final int PASSWORD_USERNAME_SAME = 24;
    static final int PASSWORD_NOT_UPDATE = 25;
    public static final int SUCCESS = 26;
    static final int WRONG_PASSWORD_ENTERED = 27;
    static final int PASSWORD_UPDATED_SUCCESSFULLY = 28;
    static final int USER_PASSWORD_SAME = 29;
    static final int PASSWORD_MIN_CHARACTERS = 30;
    public static final int SERVER_DOWN = 31;
    static final int PASSWORD_RESET_STATE = 32;
    public static final int USER_FOUND = 33;
    public static final String STATUS_UP = "UP";
    public static final String STATUS_DOWN = "DOWN";
    static HashMap connectionPools;
    static HashMap adminConnectionPools;
    static HashMap connectionPoolsStatus;
    private LDAPConnectionPool cPool = null;
    private LDAPConnectionPool acPool = null;
    private static final int NO_PASSWORD_CONTROLS = 0;
    private static final int PASSWORD_EXPIRED = -1;
    private static final int MIN_CONNECTION_POOL_SIZE = 1;
    private static final int MAX_CONNECTION_POOL_SIZE = 10;
    private static final String CONNECTION_POOL_SIZE_ATTR = "iplanet-am-auth-ldap-connection-pool-size";
    private static final String CONNECTION_POOL_DEFAULT_SIZE_ATTR = "iplanet-am-auth-ldap-connection-pool-default-size";
    private static int minDefaultPoolSize;
    private static int maxDefaultPoolSize;
    private static Set poolSize;
    private Set userAttributes = new HashSet();
    private Map userAttributeValues = new HashMap();
    private boolean isDynamicUSerEnabled;
    String[] attrs = null;
    private static Debug debug2;

    public LDAPAuthUtils() throws LDAPUtilException {
    }

    public LDAPAuthUtils(String host, int port, boolean ssl, ResourceBundle bundle, Debug debug) throws LDAPUtilException {
        this.bundle = bundle;
        this.serverHost = host;
        this.serverPort = port;
        this.ldapSSL = ssl;
        this.debug = debug;
        if (this.serverHost == null || this.serverHost.length() < 1) {
            debug.message("Invalid host name");
            throw new LDAPUtilException("HostInvalid", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LDAPConnectionPool createConnectionPool(HashMap connectionPools, HashMap aConnectionPoolsStatus, String hostName, int portNumber, int verNum, boolean isSSL, String bindingUser, String bindingPwd) throws LDAPException {
        LDAPConnectionPool conPool;
        block23: {
            conPool = null;
            LDAPConnection ldc = null;
            try {
                int max;
                int min;
                String key = hostName + ":" + portNumber + ":" + bindingUser;
                conPool = (LDAPConnectionPool)connectionPools.get(key);
                if (conPool != null) break block23;
                if (debug2.messageEnabled()) {
                    debug2.message("Create LDAPConnectionPool: " + hostName + ":" + portNumber);
                }
                if ((min = minDefaultPoolSize / 2 + 1) >= (max = maxDefaultPoolSize / 2)) {
                    min = max - 1;
                }
                if (poolSize != null && !poolSize.isEmpty()) {
                    String tmpmin = null;
                    String tmpmax = null;
                    for (String val : poolSize) {
                        StringTokenizer stz = new StringTokenizer(val, ":");
                        if (stz.countTokens() != 4) continue;
                        String h = stz.nextToken();
                        String p = stz.nextToken();
                        if (!key.equals(h + ":" + p)) continue;
                        tmpmin = stz.nextToken();
                        tmpmax = stz.nextToken();
                        break;
                    }
                    if (tmpmin != null) {
                        try {
                            min = Integer.parseInt(tmpmin);
                            max = Integer.parseInt(tmpmax);
                            if (max < min) {
                                debug2.error("ldap connection pool max size is less than min size");
                                min = minDefaultPoolSize;
                                max = maxDefaultPoolSize;
                            }
                        }
                        catch (NumberFormatException ex) {
                            debug2.error("Invalid ldap connection pool size", (Throwable)ex);
                            min = minDefaultPoolSize;
                            max = maxDefaultPoolSize;
                        }
                    }
                }
                if (debug2.messageEnabled()) {
                    debug2.message("LDAPAuthUtils.LDAPAuthUtils: min=" + min + ", max=" + max);
                }
                HashMap hashMap = connectionPools;
                synchronized (hashMap) {
                    conPool = (LDAPConnectionPool)connectionPools.get(key);
                    if (conPool == null) {
                        ldc = isSSL ? new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null)) : new LDAPConnection();
                        ldc.connect(hostName, portNumber);
                        ldc.authenticate(verNum, bindingUser, bindingPwd);
                        ShutdownManager shutdownMan = ShutdownManager.getInstance();
                        if (shutdownMan.acquireValidLock()) {
                            try {
                                final LDAPConnectionPool tempConPool = conPool = new LDAPConnectionPool(key + "-AuthLDAP", min, max, ldc);
                                shutdownMan.addShutdownListener(new ShutdownListener(){

                                    public void shutdown() {
                                        tempConPool.destroy();
                                    }
                                });
                            }
                            finally {
                                shutdownMan.releaseLockAndNotify();
                            }
                        }
                        connectionPools.put(key, conPool);
                        if (aConnectionPoolsStatus != null) {
                            aConnectionPoolsStatus.put(key, STATUS_UP);
                        }
                    }
                }
            }
            catch (LDAPException e) {
                if (ldc != null) {
                    ldc.disconnect();
                }
                throw e;
            }
            catch (Exception e) {
                if (debug2.messageEnabled()) {
                    debug2.message("Unable to create LDAPConnectionPool", (Throwable)e);
                }
                throw new LDAPUtilException(e);
            }
        }
        return conPool;
    }

    public LDAPAuthUtils(String host, int port, boolean ssl, ResourceBundle bundle, String searchBaseDN, Debug debug) throws LDAPUtilException {
        this(host, port, ssl, bundle, debug);
        this.baseDN = searchBaseDN;
        if (this.baseDN.length() < 1) {
            debug.message("Invalid  search Base");
            throw new LDAPUtilException("SchBaseInvalid", null);
        }
    }

    public void authenticateUser(String user, String password) throws LDAPUtilException {
        if (password == null) {
            throw new LDAPUtilException("PwdInvalid", 49, null);
        }
        this.userId = user;
        this.userPassword = password;
        this.searchForUser();
        if (this.screenState == 31 || this.screenState == 1) {
            return;
        }
        this.authenticate();
    }

    private LDAPConnection getConnection() throws LDAPException {
        if (this.cPool == null) {
            this.cPool = LDAPAuthUtils.createConnectionPool(connectionPools, null, this.serverHost, this.serverPort, this.version, this.ldapSSL, this.authDN, this.authPassword);
        }
        LDAPConnection ldc = this.cPool.getConnection();
        return ldc;
    }

    private void releaseConnection(LDAPConnection conn) {
        if (conn == null) {
            return;
        }
        this.cPool.close(conn);
    }

    private LDAPConnection getAdminConnection() throws LDAPException {
        if (this.acPool == null) {
            this.acPool = LDAPAuthUtils.createConnectionPool(adminConnectionPools, connectionPoolsStatus, this.serverHost, this.serverPort, this.version, this.ldapSSL, this.authDN, this.authPassword);
        }
        LDAPConnection ldc = this.acPool.getConnection();
        return ldc;
    }

    private void releaseAdminConnection(LDAPConnection conn) {
        if (conn == null) {
            return;
        }
        this.acPool.close(conn);
    }

    public void authenticateSuperAdmin(String user, String password) throws LDAPUtilException {
        if (password == null || password.length() == 0) {
            throw new LDAPUtilException("PwdInvalid", 49, null);
        }
        this.userDN = user;
        this.userPassword = password;
        this.authenticate();
        this.userId = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String oldPwd, String password, String confirmPassword) throws LDAPUtilException {
        if (password.equals(oldPwd)) {
            this.setState(27);
            return;
        }
        if (!password.equals(confirmPassword)) {
            this.setState(23);
            return;
        }
        if (password.equals(this.userId)) {
            this.setState(29);
            return;
        }
        LDAPConnection modCtx = null;
        try {
            modCtx = this.getConnection();
            modCtx.authenticate(this.version, this.userDN, oldPwd);
            this.setDefaultReferralCredentials(modCtx);
            LDAPModificationSet mods = new LDAPModificationSet();
            LDAPAttribute attrPwd = new LDAPAttribute("userpassword", password);
            mods.add(2, attrPwd);
            modCtx.modify(this.userDN, mods);
            this.setState(28);
        }
        catch (LDAPException le) {
            if (le.getLDAPResultCode() == 19) {
                this.setState(30);
            } else {
                if (le.getLDAPResultCode() == 91 || le.getLDAPResultCode() == 81 || le.getLDAPResultCode() == 52) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("changepassword:Cannot connect to " + this.serverHost + ": ", (Throwable)le);
                    }
                    this.setState(31);
                    return;
                }
                this.setState(25);
            }
            this.debug.error("Cannot update : ", (Throwable)le);
        }
        finally {
            this.releaseConnection(modCtx);
        }
    }

    private String buildUserFilter() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("(");
        if (this.userSearchAttrs.size() == 1) {
            buf.append((String)this.userSearchAttrs.iterator().next());
            buf.append("=");
            buf.append(this.userId);
        } else {
            buf.append("|");
            Iterator iter = this.userSearchAttrs.iterator();
            while (iter.hasNext()) {
                buf.append("(");
                buf.append((String)iter.next());
                buf.append("=");
                buf.append(this.userId);
                buf.append(")");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchForUser() throws LDAPUtilException {
        int userMatches;
        LDAPConnection ldc;
        block38: {
            block37: {
                if (this.searchScope == 0) {
                    if (this.userSearchAttrs.size() == 1) {
                        this.userDN = (String)this.userSearchAttrs.iterator().next() + "=" + this.userId + "," + this.baseDN;
                        if (this.debug.messageEnabled()) {
                            this.debug.message("searchForUser, searchScope = BASE,userDN =" + this.userDN);
                        }
                        if (!this.isDynamicUSerEnabled && this.userSearchAttrs.contains(this.userNamingAttr)) {
                            return;
                        }
                        if (this.isDynamicUSerEnabled && (this.userAttributes == null || this.userAttributes.isEmpty())) {
                            this.debug.message("user creation attribute list is empty ");
                            return;
                        }
                        this.baseDN = this.userDN;
                    } else {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("cannot find user entry using scope=0setting scope=1");
                        }
                        this.searchScope = 1;
                    }
                }
                if (this.searchFilter == null || this.searchFilter.length() == 0) {
                    this.searchFilter = this.buildUserFilter();
                } else {
                    StringBuffer bindFilter = new StringBuffer(200);
                    if (this.userId != null) {
                        bindFilter.append("(&");
                        bindFilter.append(this.buildUserFilter());
                        bindFilter.append(this.searchFilter);
                        bindFilter.append(")");
                    } else {
                        bindFilter.append(this.searchFilter);
                    }
                    this.searchFilter = bindFilter.toString();
                }
                Object res = null;
                this.userDN = null;
                ldc = null;
                if (this.debug.messageEnabled()) {
                    this.debug.message("Connecting to " + this.serverHost + ":" + this.serverPort + "\nSearching " + this.baseDN + " for " + this.searchFilter + "\nscope = " + this.searchScope);
                }
                ldc = this.getAdminConnection();
                int userAttrSize = 0;
                if (this.attrs == null) {
                    if (this.userAttributes == null || this.userAttributes.isEmpty()) {
                        userAttrSize = 2;
                        this.attrs = new String[userAttrSize];
                        this.attrs[0] = "dn";
                        this.attrs[1] = this.userNamingAttr;
                    } else {
                        userAttrSize = this.userAttributes.size();
                        this.attrs = new String[userAttrSize + 2];
                        this.attrs[0] = "dn";
                        this.attrs[1] = this.userNamingAttr;
                        Iterator attrItr = this.userAttributes.iterator();
                        for (int i = 2; i < userAttrSize + 2; ++i) {
                            this.attrs[i] = (String)attrItr.next();
                        }
                    }
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("userAttrSize is : " + userAttrSize);
                }
                LDAPSearchResults results = ldc.search(this.baseDN, this.searchScope, this.searchFilter, this.attrs, false);
                userMatches = 0;
                LDAPEntry entry = null;
                boolean userNamingValueSet = false;
                while (results.hasMoreElements()) {
                    try {
                        entry = results.next();
                        this.userDN = entry.getDN();
                        ++userMatches;
                    }
                    catch (LDAPReferralException refe) {
                        this.debug.message("LDAPReferral Detected.");
                        continue;
                    }
                    if (this.attrs == null || this.attrs.length <= 1) continue;
                    userNamingValueSet = true;
                    LDAPAttribute attr = entry.getAttribute(this.userNamingAttr);
                    if (attr != null) {
                        this.userNamingValue = attr.getStringValueArray()[0];
                    }
                    if (!this.isDynamicUSerEnabled || this.attrs.length <= 2) continue;
                    for (int i = 2; i < userAttrSize + 2; ++i) {
                        attr = entry.getAttribute(this.attrs[i]);
                        if (attr == null) continue;
                        HashSet<String> s = new HashSet<String>();
                        for (int j = 0; j < attr.size(); ++j) {
                            s.add(attr.getStringValueArray()[j]);
                        }
                        this.userAttributeValues.put(this.attrs[i], s);
                    }
                }
                if (!userNamingValueSet || this.userDN != null && this.userNamingValue != null) break block37;
                if (this.debug.messageEnabled()) {
                    this.debug.message("Cannot find entries for " + this.searchFilter);
                }
                this.setState(1);
                this.releaseAdminConnection(ldc);
                return;
            }
            if (this.userDN != null) break block38;
            if (this.debug.messageEnabled()) {
                this.debug.message("Cannot find entries for " + this.searchFilter);
            }
            this.setState(1);
            this.releaseAdminConnection(ldc);
            return;
        }
        try {
            this.setState(33);
            if (userMatches > 1) {
                this.debug.error("searchForUser : Multiple matches found for user '" + this.userId + "'. Please modify search start DN/filter/scope " + "to make sure unique match returned. Contact your " + "administrator to fix the problem");
                throw new LDAPUtilException("multipleUserMatchFound", null);
            }
            this.releaseAdminConnection(ldc);
        }
        catch (LDAPException e) {
            block39: {
                try {
                    this.debug.message("Search for User error: ", (Throwable)e);
                    this.debug.message("resultCode: " + e.getLDAPResultCode());
                    if (e.getLDAPResultCode() != 91 && e.getLDAPResultCode() != 81 && e.getLDAPResultCode() != 52) break block39;
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Cannot connect to " + this.serverHost + ": ", (Throwable)e);
                    }
                    this.setState(31);
                    this.releaseAdminConnection(ldc);
                    return;
                }
                catch (Throwable throwable) {
                    this.releaseAdminConnection(ldc);
                    throw throwable;
                }
            }
            if (e.getLDAPResultCode() == 49) {
                this.debug.message("Cannot authenticate ");
                throw new LDAPUtilException("FConnect", 49, null);
            }
            if (e.getLDAPResultCode() == 53) {
                this.debug.message("Account Inactivated or Locked ");
                throw new LDAPUtilException("FConnect", 53, null);
            }
            if (e.getLDAPResultCode() == 32) {
                throw new LDAPUtilException("noUserMatchFound", 32, null);
            }
            this.debug.message("Exception while searching", (Throwable)e);
            this.setState(1);
            this.releaseAdminConnection(ldc);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void authenticate() throws LDAPUtilException {
        LDAPConnection ldc = null;
        try {
            ldc = this.getConnection();
            ldc.authenticate(this.version, this.userDN, this.userPassword);
            if (ldc == null) return;
            int seconds = this.checkControls(ldc);
            switch (seconds) {
                case 0: {
                    this.debug.message("No controls returned");
                    this.setState(26);
                    return;
                }
                case -1: {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Password expired and must be reset");
                    }
                    this.setState(32);
                    return;
                }
                default: {
                    this.setExpTime(seconds);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Password expires in " + seconds + " seconds");
                    }
                    this.setState(21);
                    return;
                }
            }
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 49) {
                if (this.checkControls(ldc) == -1) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Password expired and must be reset");
                    }
                    this.setState(20);
                    return;
                }
                this.debug.message("Failed auth due to invalid credentials");
                throw new LDAPUtilException("CredInvalid", 49, null);
            }
            if (e.getLDAPResultCode() == 32) {
                this.debug.message("user does not exist");
                throw new LDAPUtilException("UsrNotExist", 32, null);
            }
            if (e.getLDAPResultCode() == 91 || e.getLDAPResultCode() == 81 || e.getLDAPResultCode() == 52) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("Cannot connect to " + this.serverHost + ": ", (Throwable)e);
                }
                this.setState(31);
                return;
            }
            if (e.getLDAPResultCode() == 53) {
                this.debug.message("Account Inactivated or Locked ");
                throw new LDAPUtilException("FConnect", 53, null);
            }
            if (e.getLDAPResultCode() == 48) {
                this.debug.message("Failed auth due to inappropriate authentication");
                throw new LDAPUtilException("InappAuth", 48, null);
            }
            if (e.getLDAPResultCode() == 19) {
                this.debug.message("Exceed password retry limit.");
                throw new LDAPUtilException("ExceedRetryLimit", 19, null);
            }
            if (!this.debug.messageEnabled()) throw new LDAPUtilException("FAuth", null);
            this.debug.message("Cannot authenticate to " + this.serverHost + ": ", (Throwable)e);
            throw new LDAPUtilException("FAuth", null);
        }
        finally {
            this.releaseConnection(ldc);
        }
    }

    private int checkControls(LDAPConnection ld) {
        block6: {
            LDAPControl[] controls = ld.getResponseControls();
            boolean status = false;
            if (controls != null && controls.length >= 1) {
                LDAPPasswordExpiringControl expgControl = null;
                for (int i = 0; i < controls.length; ++i) {
                    if (controls[i].getType() == 9) {
                        return -1;
                    }
                    if (controls[i].getType() != 10) continue;
                    expgControl = (LDAPPasswordExpiringControl)controls[i];
                }
                if (expgControl != null) {
                    try {
                        return expgControl.getSecondsToExpiration();
                    }
                    catch (NumberFormatException e) {
                        if (!this.debug.messageEnabled()) break block6;
                        this.debug.message("Unexpected message <" + expgControl.getMessage() + "> in password expiring control");
                    }
                }
            }
        }
        return 0;
    }

    public String getUserId() {
        if (this.returnUserDN) {
            return this.userDN;
        }
        return this.userNamingValue;
    }

    public String getUserId(String name) {
        String uid = this.getUserId();
        if (uid != null) {
            return uid;
        }
        return name;
    }

    public void setUserNamingAttribute(String s) throws LDAPUtilException {
        if (s == null || s.length() < 1) {
            throw new LDAPUtilException("UNAttr", null);
        }
        this.userNamingAttr = s;
    }

    public void setUserSearchAttribute(Set attr) throws LDAPUtilException {
        if (attr == null || attr.isEmpty()) {
            throw new LDAPUtilException("USchAttr", null);
        }
        this.userSearchAttrs = attr;
    }

    public void setFilter(String filter) {
        this.searchFilter = filter;
    }

    public void setBase(String basedn) {
        this.baseDN = basedn;
    }

    private void setAuthProtocol(String protocol) {
        this.ssl = protocol;
    }

    public void setAuthDN(String authdn) {
        this.authDN = authdn;
    }

    public void setAuthPassword(String authpassword) {
        this.authPassword = authpassword;
    }

    public void setScope(int scope) {
        this.searchScope = scope;
    }

    public int getState() {
        return this.screenState;
    }

    public void setState(int code) {
        this.screenState = code;
    }

    private void setExpTime(int sec) {
        this.expiryTime = null;
        int days = sec / 86400;
        int hours = sec % 86400 / 3600;
        int minutes = sec % 3600 / 60;
        int seconds = sec % 60;
        if (hours <= 0 && minutes <= 0 && seconds <= 0) {
            this.expiryTime = days + " days: ";
            return;
        }
        String DAYS = this.bundle.getString("days");
        String HRS = this.bundle.getString("hours");
        String MIN = this.bundle.getString("minutes");
        String SEC = this.bundle.getString("seconds");
        this.expiryTime = days + " " + DAYS + ": " + hours + " " + HRS + ": " + minutes + " " + MIN + ": " + seconds + " " + SEC;
    }

    public String getExpTime() {
        return this.expiryTime;
    }

    public boolean isServerRunning(String host, int port) {
        LDAPConnection ldapCon = null;
        boolean running = false;
        try {
            ldapCon = this.ldapSSL ? new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null)) : new LDAPConnection();
            ldapCon.connect(host, port);
            running = ldapCon.isConnected();
            ldapCon.disconnect();
        }
        catch (Exception ldapEx) {
            this.debug.message("Primary Server is not running");
        }
        return running;
    }

    public void setReturnUserDN(String s) {
        this.returnUserDN = s.equalsIgnoreCase("true");
    }

    public void setUserAttributes(Set attributeNames) {
        this.userAttributes = attributeNames;
    }

    public Map getUserAttributeValues() {
        return this.userAttributeValues;
    }

    public void setDynamicProfileCreationEnabled(boolean isEnable) {
        this.isDynamicUSerEnabled = isEnable;
    }

    public void setUserAttrs(String[] attrs) {
        this.attrs = attrs;
    }

    protected void setDefaultReferralCredentials(LDAPConnection conn) {
        final LDAPConnection mConn = conn;
        LDAPRebind reBind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                return new LDAPRebindAuth(mConn.getAuthenticationDN(), mConn.getAuthenticationPassword());
            }
        };
        LDAPSearchConstraints cons = conn.getSearchConstraints();
        cons.setReferrals(true);
        cons.setRebindProc(reBind);
        conn.setSearchConstraints(cons);
    }

    static {
        block8: {
            connectionPools = new HashMap();
            adminConnectionPools = new HashMap();
            connectionPoolsStatus = new HashMap();
            minDefaultPoolSize = 1;
            maxDefaultPoolSize = 10;
            poolSize = null;
            debug2 = Debug.getInstance((String)"amAuthLDAP");
            SSOToken dUserToken = null;
            try {
                dUserToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAuthService", dUserToken);
                ServiceSchema schema = scm.getGlobalSchema();
                Map attrs = schema.getAttributeDefaults();
                poolSize = (Set)attrs.get(CONNECTION_POOL_SIZE_ATTR);
                String defaultPoolSize = CollectionHelper.getMapAttr((Map)attrs, (String)CONNECTION_POOL_DEFAULT_SIZE_ATTR, (String)"");
                int index = defaultPoolSize.indexOf(":");
                if (index != -1) {
                    try {
                        minDefaultPoolSize = Integer.parseInt(defaultPoolSize.substring(0, index));
                    }
                    catch (NumberFormatException ex) {
                        debug2.error("Invalid ldap connection pool min size", (Throwable)ex);
                    }
                    try {
                        maxDefaultPoolSize = Integer.parseInt(defaultPoolSize.substring(index + 1));
                    }
                    catch (NumberFormatException ex) {
                        debug2.error("Invalid ldap connection pool max size", (Throwable)ex);
                    }
                    if (maxDefaultPoolSize < minDefaultPoolSize) {
                        debug2.error("ldap connection pool max size is less than min size");
                        minDefaultPoolSize = 1;
                        maxDefaultPoolSize = 10;
                    }
                    break block8;
                }
                debug2.error("Invalid ldap connection pool size");
            }
            catch (Exception ex) {
                debug2.error("Unable to get ldap connection pool size", (Throwable)ex);
            }
        }
        Object var0 = null;
    }
}

