/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.HttpCallback;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.authentication.spi.RedirectCallback;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

class AMModuleProperties {
    private String moduleName;
    private String order;
    private int p = 0;
    private List page = new ArrayList();
    private List attribute;
    private List require;
    private Hashtable rtable = new Hashtable();
    private Callback[] callbacks = null;
    private static Map moduleProps = new HashMap();
    private static final String amAuth = "amAuth";
    private static Debug debug = Debug.getInstance((String)"amAuth");

    AMModuleProperties(String fileName, ServletContext servletContext) throws AuthLoginException {
        InputStream in = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)new XMLHandler());
            in = servletContext == null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName.substring(1)) : servletContext.getResourceAsStream(fileName);
            Document doc = builder.parse(in);
            in.close();
            this.walk(doc);
            for (int i = 1; i <= this.rtable.size(); ++i) {
                Callback[] cb = (Callback[])this.rtable.get(Integer.toString(i));
                this.page.add(cb);
            }
        }
        catch (Exception e) {
            debug.error("AMModuleProperties, parse file :" + fileName);
            debug.error("AMModuleProperties, parser error :", (Throwable)e);
            throw new AuthLoginException(amAuth, "getModulePropertiesError", null);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ee) {}
        }
    }

    private List getCallbacks() {
        return this.page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getModuleProperties(String fileName) throws AuthLoginException {
        ServletContext servletContext;
        List list;
        block22: {
            list = (ArrayList)moduleProps.get(fileName);
            if (list != null) {
                return list;
            }
            servletContext = AuthD.getAuth().getServletContext();
            InputStream resStream = null;
            try {
                resStream = servletContext == null ? Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName.substring(1)) : servletContext.getResourceAsStream(fileName);
                if (resStream == null || resStream.read() != -1) break block22;
                if (debug.messageEnabled()) {
                    debug.message(fileName + " is empty");
                }
                list = new ArrayList();
                Object object = moduleProps;
                synchronized (object) {
                    moduleProps.put(fileName, list);
                }
                object = list;
                return object;
            }
            catch (Exception e) {
                debug.message("getModuleProperties: Error: ", (Throwable)e);
            }
            finally {
                try {
                    resStream.close();
                }
                catch (Exception ee) {
                    debug.message("Error closing input stream");
                }
            }
        }
        AMModuleProperties prop = new AMModuleProperties(fileName, servletContext);
        list = prop.getCallbacks();
        if (list != null && !list.isEmpty()) {
            Map map = moduleProps;
            synchronized (map) {
                moduleProps.put(fileName, list);
            }
        }
        return list;
    }

    private void walk(Node node) {
        short type = node.getNodeType();
        String nodeName = node.getNodeName();
        debug.message("Callback type: " + nodeName);
        switch (type) {
            case 1: {
                String tmp;
                Node sub;
                if (nodeName.equals("ModuleProperties")) {
                    this.moduleName = this.getAttribute(node, "moduleName");
                    break;
                }
                if (nodeName.equals("Callbacks")) {
                    String image;
                    this.p = 0;
                    String timeout = this.getAttribute(node, "timeout");
                    String template = this.getAttribute(node, "template");
                    if (template == null) {
                        template = "";
                    }
                    if ((image = this.getAttribute(node, "image")) == null) {
                        image = "";
                    }
                    String header = this.getAttribute(node, "header");
                    boolean error = Boolean.valueOf(this.getAttribute(node, "error"));
                    int size = Integer.parseInt(this.getAttribute(node, "length")) + 1;
                    int t = 0;
                    if (timeout != null) {
                        t = Integer.parseInt(timeout);
                    }
                    this.order = this.getAttribute(node, "order");
                    this.callbacks = new Callback[size];
                    this.callbacks[this.p] = new PagePropertiesCallback(this.moduleName, header, image, t, template, error, this.order);
                    ++this.p;
                    this.attribute = new ArrayList();
                    this.require = new ArrayList();
                    break;
                }
                if (nodeName.equals("NameCallback")) {
                    sub = node.getFirstChild();
                    sub = sub.getNextSibling();
                    String prompt = sub.getFirstChild().getNodeValue();
                    String dftName = null;
                    if ((sub = sub.getNextSibling().getNextSibling()) != null) {
                        sub = sub.getFirstChild();
                        dftName = sub.getNodeValue();
                        this.callbacks[this.p] = new NameCallback(prompt, dftName);
                    } else {
                        this.callbacks[this.p] = new NameCallback(prompt);
                    }
                    tmp = this.getAttribute(node, "isRequired");
                    if (tmp != null) {
                        if (tmp.equals("true")) {
                            this.require.add("true");
                        } else {
                            this.require.add("");
                        }
                    } else {
                        this.require.add("");
                    }
                    tmp = this.getAttribute(node, "attribute");
                    if (tmp != null) {
                        this.attribute.add(tmp);
                    } else {
                        this.attribute.add("");
                    }
                    ++this.p;
                    break;
                }
                if (nodeName.equals("PasswordCallback")) {
                    String echo = this.getAttribute(node, "echoPassword");
                    sub = node.getFirstChild();
                    sub = sub.getNextSibling().getFirstChild();
                    String prompt = sub.getNodeValue();
                    boolean b = Boolean.valueOf(echo);
                    this.callbacks[this.p] = new PasswordCallback(prompt, b);
                    tmp = this.getAttribute(node, "isRequired");
                    if (tmp != null) {
                        if (tmp.equals("true")) {
                            this.require.add("true");
                        } else {
                            this.require.add("");
                        }
                    } else {
                        this.require.add("");
                    }
                    tmp = this.getAttribute(node, "attribute");
                    if (tmp != null) {
                        this.attribute.add(tmp);
                    } else {
                        this.attribute.add("");
                    }
                    ++this.p;
                    break;
                }
                if (nodeName.equals("ChoiceCallback")) {
                    String multiple = this.getAttribute(node, "multipleSelectionsAllowed");
                    String prompt = null;
                    String[] choices = null;
                    int defaultChoice = 0;
                    boolean mch = Boolean.valueOf(multiple);
                    for (sub = node.getFirstChild(); sub != null; sub = sub.getNextSibling()) {
                        Node ss;
                        if (sub.getNodeName().equals("Prompt")) {
                            prompt = sub.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!sub.getNodeName().equals("ChoiceValues")) continue;
                        int len = 0;
                        Node count = ss = sub.getFirstChild().getNextSibling();
                        while (count != null) {
                            ++len;
                            count = count.getNextSibling().getNextSibling();
                        }
                        choices = new String[len];
                        for (int i = 0; i < len; ++i) {
                            choices[i] = ss.getFirstChild().getNextSibling().getFirstChild().getNodeValue();
                            if (Boolean.valueOf(this.getAttribute(ss, "isDefault")).booleanValue()) {
                                defaultChoice = i;
                            }
                            ss = ss.getNextSibling().getNextSibling();
                        }
                        break;
                    }
                    this.callbacks[this.p] = new ChoiceCallback(prompt, choices, defaultChoice, mch);
                    tmp = this.getAttribute(node, "isRequired");
                    if (tmp != null) {
                        if (tmp.equals("true")) {
                            this.require.add("true");
                        } else {
                            this.require.add("");
                        }
                    } else {
                        this.require.add("");
                    }
                    tmp = this.getAttribute(node, "attribute");
                    if (tmp != null) {
                        this.attribute.add(tmp);
                    } else {
                        this.attribute.add("");
                    }
                    ++this.p;
                    break;
                }
                if (nodeName.equals("ConfirmationCallback")) {
                    int messageType = 0;
                    int defaultOption = 0;
                    String[] options = null;
                    for (sub = node.getFirstChild(); sub != null; sub = sub.getNextSibling()) {
                        Node ss;
                        if (!sub.getNodeName().equals("OptionValues")) continue;
                        int len = 0;
                        Node count = ss = sub.getFirstChild().getNextSibling();
                        while (count != null) {
                            ++len;
                            count = count.getNextSibling().getNextSibling();
                        }
                        options = new String[len];
                        for (int i = 0; i < len; ++i) {
                            options[i] = ss.getFirstChild().getNextSibling().getFirstChild().getNodeValue();
                            ss = ss.getNextSibling().getNextSibling();
                        }
                        break;
                    }
                    this.callbacks[this.p] = new ConfirmationCallback(messageType, options, defaultOption);
                    ++this.p;
                    break;
                }
                if (nodeName.equals("TextInputCallback")) {
                    sub = node.getFirstChild();
                    sub = sub.getNextSibling().getFirstChild();
                    String prompt = sub.getNodeValue();
                    this.callbacks[this.p] = new TextInputCallback(prompt);
                    ++this.p;
                    break;
                }
                if (nodeName.equals("TextOutputCallback")) {
                    int messageType = 2;
                    String s = this.getAttribute(node, "messageType");
                    if (s.equals("error")) {
                        messageType = 2;
                    } else if (s.equals("information")) {
                        messageType = 0;
                    } else if (s.equals("warning")) {
                        messageType = 1;
                    }
                    sub = node.getFirstChild();
                    sub = sub.getNextSibling().getFirstChild();
                    String value = sub.getNodeValue();
                    this.callbacks[this.p] = new TextOutputCallback(messageType, value);
                    ++this.p;
                    break;
                }
                if (nodeName.equals("LanguageCallback")) {
                    for (sub = node.getFirstChild(); sub != null; sub = sub.getNextSibling()) {
                        if (!sub.getNodeName().equals("ChoiceValue")) continue;
                        String isdefault = this.getAttribute(sub, "isDefault");
                    }
                    this.callbacks[this.p] = new LanguageCallback();
                    ++this.p;
                    break;
                }
                if (nodeName.equals("HttpCallback")) {
                    String header = null;
                    String negotiation = null;
                    String code = null;
                    for (sub = node.getFirstChild(); sub != null; sub = sub.getNextSibling()) {
                        String tmpStr = sub.getNodeName();
                        if (tmpStr.equals("HttpHeader")) {
                            header = sub.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (tmpStr.equals("Negotiation")) {
                            negotiation = sub.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (!tmpStr.equals("HttpErrorCode")) continue;
                        code = sub.getFirstChild().getNodeValue();
                    }
                    this.callbacks[this.p] = new HttpCallback(header, negotiation, code);
                    ++this.p;
                    break;
                }
                if (!nodeName.equals("RedirectCallback")) break;
                String redirectUrl = null;
                String statusParameter = null;
                String redirectBackUrlCookie = null;
                HashMap<String, String> redirectData = new HashMap<String, String>();
                String method = this.getAttribute(node, "method");
                for (sub = node.getFirstChild(); sub != null; sub = sub.getNextSibling()) {
                    String tmpStrValue;
                    String tmpStr = sub.getNodeName();
                    if (tmpStr.equals("RedirectUrl")) {
                        redirectUrl = sub.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (tmpStr.equals("RedirectStatusParam")) {
                        statusParameter = sub.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (tmpStr.equals("RedirectBackUrlCookie")) {
                        redirectBackUrlCookie = sub.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (!tmpStr.equals("RedirectData")) continue;
                    String name = null;
                    String value = null;
                    Node ss = sub.getFirstChild().getNextSibling();
                    String tmpStrName = ss.getNodeName();
                    if (tmpStrName.equals("Name")) {
                        name = ss.getFirstChild().getNodeValue();
                    }
                    if ((tmpStrValue = (ss = ss.getNextSibling().getNextSibling()).getNodeName()).equals("Value")) {
                        value = ss.getFirstChild().getNodeValue();
                    }
                    redirectData.put(name, value);
                }
                if (debug.messageEnabled()) {
                    debug.message("redirectUrl : " + redirectUrl);
                    debug.message("statusParameter : " + statusParameter);
                    debug.message("redirectBackUrlCookie : " + redirectBackUrlCookie);
                    debug.message("redirectData : " + redirectData);
                    debug.message("method : " + method);
                }
                this.callbacks[this.p] = new RedirectCallback(redirectUrl, redirectData, method);
                ++this.p;
                break;
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.walk(child);
        }
        if (type == 1 && nodeName.equals("Callbacks")) {
            ((PagePropertiesCallback)this.callbacks[0]).setAttribute(this.attribute);
            ((PagePropertiesCallback)this.callbacks[0]).setRequire(this.require);
            this.rtable.put(this.order, this.callbacks);
        }
    }

    private String getAttribute(Node node, String name) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            int len = nnm.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)nnm.item(i);
                if (!attr.getNodeName().equals(name)) continue;
                return attr.getNodeValue();
            }
        }
        return null;
    }
}

