/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.RuleOpViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.Rule;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;

public class RuleEditViewBean
extends RuleOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/RuleEdit.jsp";
    public static final String EDIT_RULE_NAME = "editRuleName";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";

    RuleEditViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public RuleEditViewBean() {
        super("RuleEdit", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_THREE_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (!this.submitCycle) {
            try {
                Rule rule = this.getRule();
                this.propertySheetModel.setValue("tfRuleName", rule.getName());
                String serviceType = rule.getServiceTypeName();
                this.propertySheetModel.setValue("tfServiceType", serviceType);
                PolicyModel model = (PolicyModel)this.getModel();
                Map map = model.getServiceTypeNames();
                String i18nName = (String)map.get(serviceType);
                this.propertySheetModel.setValue("serviceTypeName", i18nName);
                this.propertySheetModel.setValue("tfServiceTypeName", i18nName);
                this.propertySheetModel.setValue("tfResourceName", rule.getResourceName());
            }
            catch (NameNotFoundException e) {
                debug.error("RuleEditViewBean.beginDisplay: rule not found.");
            }
            catch (AMConsoleException e) {
                debug.warning("RuleEditViewBean.beginDisplay", (Throwable)e);
            }
        } else {
            String i18nName = (String)this.propertySheetModel.getValue("tfServiceTypeName");
            this.propertySheetModel.setValue("serviceTypeName", i18nName);
        }
        try {
            this.populateActionsTable(this.submitCycle);
        }
        catch (AMConsoleException e) {
            debug.warning("RuleEditViewBean.beginDisplay", (Throwable)e);
        }
    }

    public Set getDefaultActionValues(ActionSchema as) {
        Set values = null;
        try {
            Rule rule = this.getRule();
            values = rule.getActionValues(as.getName());
            if (values == null) {
                values = as.getDefaultValues();
            }
        }
        catch (NameNotFoundException e) {
            values = as.getDefaultValues();
        }
        catch (AMConsoleException e) {
            debug.warning("RuleEditViewBean.getDefaultActionValues", (Throwable)e);
            values = as.getDefaultValues();
        }
        return values;
    }

    public boolean isActionSelected(ActionSchema as) {
        boolean selected = false;
        if (this.actionValues != null) {
            Set values = (Set)this.actionValues.get(as.getName());
            selected = values != null && !values.isEmpty();
        } else {
            try {
                Rule rule = this.getRule();
                Set actionNames = rule.getActionNames();
                selected = actionNames != null && actionNames.contains(as.getName());
            }
            catch (NameNotFoundException e) {
                selected = false;
            }
            catch (AMConsoleException e) {
                debug.warning("RuleEditViewBean.isActionSelected", (Throwable)e);
                selected = false;
            }
        }
        return selected;
    }

    protected Rule getRule() throws NameNotFoundException, AMConsoleException {
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        String ruleName = (String)this.getPageSessionAttribute(EDIT_RULE_NAME);
        return policy.getRule(ruleName);
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected String getPropertyXMLFileName(boolean readonly) {
        if (!this.isReferralPolicy()) {
            return readonly ? "com/sun/identity/console/propertyPMRuleAdd_Readonly.xml" : "com/sun/identity/console/propertyPMRuleAdd.xml";
        }
        return readonly ? "com/sun/identity/console/propertyPMRuleAddNoAction_Readonly.xml" : "com/sun/identity/console/propertyPMRuleAddNoAction.xml";
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        boolean forwarded = false;
        Rule rule = this.createRule();
        if (rule != null) {
            try {
                CachedPolicy cachedPolicy = this.getCachedPolicy();
                Policy policy = cachedPolicy.getPolicy();
                String origRuleName = (String)this.getPageSessionAttribute(EDIT_RULE_NAME);
                policy.removeRule(origRuleName);
                policy.addRule(rule);
                this.setInlineAlertMessage("info", "message.information", "policy.rule.updated");
                cachedPolicy.setPolicyModified(true);
            }
            catch (NameAlreadyExistsException e) {
                this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
            }
            catch (InvalidNameException e) {
                this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
            }
            catch (AMConsoleException e) {
                debug.warning("RuleEditViewBean.handleButton1Request", (Throwable)e);
                this.redirectToStartURL();
                forwarded = true;
            }
        }
        if (!forwarded) {
            this.forwardTo();
        }
    }

    protected String getBreadCrumbDisplayName() {
        PolicyModel model = (PolicyModel)this.getModel();
        String origRuleName = (String)this.getPageSessionAttribute(EDIT_RULE_NAME);
        String[] arg = new String[]{origRuleName};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.editRule"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }
}

