/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPReferralException;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.util.DN;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LDAPUsers
implements Subject {
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedUserDNs = Collections.EMPTY_SET;
    private Set selectedRFCUserDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private LDAPConnectionPool connPool;
    private boolean localDS;
    private String ldapServer;
    private boolean aliasEnabled;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map configParams) throws PolicyException {
        if (configParams == null) {
            throw new PolicyException("amPolicy", "ldapusers_initialization_failed", null, null);
        }
        String configuredLdapServer = (String)configParams.get("iplanet-am-policy-config-ldap-server");
        if (configuredLdapServer == null) {
            debug.error("LDAPUsers.initialize(): failed to get LDAP server name. If you enter more than one server name in the policy config service's Primary LDAP Server field, please make sure the ldap server name is preceded with the local server name.");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        this.ldapServer = configuredLdapServer.toLowerCase();
        this.localDS = PolicyUtils.isLocalDS(this.ldapServer);
        this.aliasEnabled = Boolean.valueOf((String)configParams.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)configParams.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)configParams.get("iplanet-am-policy-config-ldap-bind-password");
        if (this.authpw != null) {
            this.authpw = PolicyUtils.decrypt(this.authpw);
        }
        this.baseDN = (String)configParams.get("iplanet-am-policy-config-ldap-users-base-dn");
        this.userSearchFilter = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-filter");
        String scope = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException nfe) {
            throw new PolicyException(nfe);
        }
        String ssl = (String)configParams.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = ssl.equalsIgnoreCase("true");
        Set orgNameSet = (Set)configParams.get("OrganizationName");
        if (orgNameSet != null && orgNameSet.size() != 0) {
            Iterator items = orgNameSet.iterator();
            this.orgName = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.initialize(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.authid, this.authpw, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken token) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldapusers_subject_not_yet_initialized", null, null);
        }
        String searchFilter = this.getSearchFilter(pattern);
        String[] attrs = new String[]{this.userRDNAttrName};
        HashSet<String> validUserDNs = new HashSet<String>();
        LDAPConnection ld = this.connPool.getConnection();
        LDAPSearchConstraints constraints = ld.getSearchConstraints();
        constraints.setMaxResults(this.maxResults);
        constraints.setServerTimeLimit(this.timeLimit);
        int status = 0;
        try {
            ld.authenticate(this.authid, this.authpw);
            LDAPSearchResults res = ld.search(this.baseDN, this.userSearchScope, searchFilter, attrs, false, constraints);
            while (res.hasMoreElements()) {
                try {
                    LDAPEntry entry = res.next();
                    if (entry == null) continue;
                    validUserDNs.add(entry.getDN());
                    if (!debug.messageEnabled()) continue;
                    debug.message("LDAPUsers.getValidValues(): found user name=" + entry.getDN());
                }
                catch (LDAPReferralException lre) {
                }
                catch (LDAPException le) {
                    String[] objs = new String[]{this.orgName};
                    int resultCode = le.getLDAPResultCode();
                    if (resultCode == 4) {
                        debug.warning("LDAPUsers.getValidValues(): exceeded the size limit");
                        status = 1;
                        continue;
                    }
                    if (resultCode != 3) throw new PolicyException(le);
                    debug.warning("LDAPUsers.getValidValues(): exceeded the time limit");
                    status = 2;
                    continue;
                    return new ValidValues(status, validUserDNs);
                }
            }
        }
        catch (LDAPException lde) {
            int ldapErrorCode = lde.getLDAPResultCode();
            if (ldapErrorCode == 49) {
                throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
            }
            if (ldapErrorCode == 32) {
                Object[] objs = new String[]{this.baseDN};
                throw new PolicyException("amPolicy", "no_such_ldap_users_base_dn", objs, null);
            }
            String errorMsg = lde.getLDAPErrorMessage();
            String additionalMsg = lde.errorCodeToString();
            if (additionalMsg == null) throw new PolicyException(errorMsg);
            throw new PolicyException(errorMsg + ": " + additionalMsg);
        }
        finally {
            this.connPool.close(ld);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidValues getValidEntries(SSOToken token, String pattern, String[] attributeNames) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldapusers_subject_not_yet_initialized", null, null);
        }
        HashSet results = new HashSet();
        String searchFilter = this.getSearchFilter(pattern);
        LDAPConnection ld = this.connPool.getConnection();
        LDAPSearchConstraints constraints = ld.getSearchConstraints();
        constraints.setMaxResults(this.maxResults);
        constraints.setServerTimeLimit(this.timeLimit);
        int status = 0;
        try {
            ld.authenticate(this.authid, this.authpw);
            LDAPSearchResults res = ld.search(this.baseDN, this.userSearchScope, searchFilter, attributeNames, false, constraints);
            HashMap<String, Map> map = new HashMap<String, Map>();
            results.add(map);
            while (res.hasMoreElements()) {
                try {
                    LDAPEntry entry = res.next();
                    if (entry == null) continue;
                    String userDN = entry.getDN();
                    map.put(userDN, this.getUserAttributeValues(entry, attributeNames));
                }
                catch (LDAPReferralException lre) {
                }
                catch (LDAPException le) {
                    String[] objs = new String[]{this.orgName};
                    int resultCode = le.getLDAPResultCode();
                    if (resultCode == 4) {
                        debug.warning("LDAPUsers.getValidEntries(): exceeded the size limit");
                        status = 1;
                        continue;
                    }
                    if (resultCode != 3) throw new PolicyException(le);
                    debug.warning("LDAPUsers.getValidEntries(): exceeded the time limit");
                    status = 2;
                    continue;
                    return new ValidValues(status, results);
                }
            }
        }
        catch (LDAPException lde) {
            int ldapErrorCode = lde.getLDAPResultCode();
            if (ldapErrorCode == 49) {
                throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
            }
            if (ldapErrorCode == 32) {
                Object[] objs = new String[]{this.baseDN};
                throw new PolicyException("amPolicy", "no_such_ldap_users_base_dn", objs, null);
            }
            String errorMsg = lde.getLDAPErrorMessage();
            String additionalMsg = lde.errorCodeToString();
            if (additionalMsg == null) throw new PolicyException(errorMsg);
            throw new PolicyException(errorMsg + ": " + additionalMsg);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        finally {
            this.connPool.close(ld);
        }
    }

    private Map getUserAttributeValues(LDAPEntry entry, String[] attributeNames) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (attributeNames != null && attributeNames.length > 0) {
            for (int i = 0; i < attributeNames.length; ++i) {
                String attrName = attributeNames[i];
                LDAPAttribute lAttr = entry.getAttribute(attrName);
                if (lAttr == null) continue;
                map.put(attrName, lAttr.getStringValueArray());
            }
        }
        return map;
    }

    private String getSearchFilter(String pattern) {
        String searchFilter = null;
        searchFilter = pattern != null && pattern.trim().length() > 0 ? "(&" + this.userSearchFilter + "(" + this.userRDNAttrName + "=" + pattern + "))" : this.userSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.getSearchFilter(): user search filter is: " + searchFilter);
        }
        return searchFilter;
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        return PolicyUtils.getDNDisplayString(value);
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.getValues() gets called");
        }
        return this.selectedUserDNs;
    }

    public void setValues(Set names) throws InvalidNameException {
        if (names == null) {
            debug.error("LDAPUsers.setValues(): Invalid names");
            throw new InvalidNameException("amPolicy", "ldapusers_subject_invalid_user_names", null, "null", 5);
        }
        this.selectedUserDNs = new HashSet();
        this.selectedUserDNs.addAll(names);
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.setValues(): selected user names=" + this.selectedUserDNs);
        }
        this.selectedRFCUserDNs = new HashSet();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.selectedRFCUserDNs.add(new DN((String)it.next()).toRFCString().toLowerCase());
        }
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        boolean userMatch = false;
        boolean listenerAdded = false;
        DN userDN = null;
        String userLocalDN = token.getPrincipal().getName();
        String tokenID = ((Object)token.getTokenID()).toString();
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.isMember(): user local DN is " + userLocalDN);
        }
        if (this.selectedRFCUserDNs.size() > 0) {
            for (String valueDN : this.selectedRFCUserDNs) {
                Boolean matchFound = null;
                matchFound = SubjectEvaluationCache.isMember(tokenID, this.ldapServer, valueDN);
                if (matchFound != null) {
                    boolean result;
                    if (debug.messageEnabled()) {
                        debug.message("LDAPUsers.isMember():Got membership from cache of " + userLocalDN + " in subject user " + valueDN + " :" + matchFound);
                    }
                    if (!(result = matchFound.booleanValue())) continue;
                    return result;
                }
                if (debug.messageEnabled()) {
                    debug.message("LDAPUsers:isMember():entry for " + valueDN + " not in subject evaluation cache, fetching from " + "directory server.");
                }
                if (userDN == null && (userDN = this.getUserDN(token)) == null) {
                    if (debug.messageEnabled()) {
                        debug.message("LDAPUsers.isMember(): User " + token.getPrincipal().getName() + " is not found in the directory");
                    }
                    return false;
                }
                if (userDN.equals(new DN(valueDN))) {
                    userMatch = true;
                }
                if (debug.messageEnabled()) {
                    debug.message("LDAPUsers.isMember:adding entry " + tokenID + " " + this.ldapServer + " " + valueDN + " " + userMatch + " in subject evaluation cache.");
                }
                SubjectEvaluationCache.addEntry(tokenID, this.ldapServer, valueDN, userMatch);
                if (!listenerAdded && !PolicyEvaluator.ssoListenerRegistry.containsKey(tokenID)) {
                    token.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(tokenID, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPUsers.isMember(): sso listener added .\n");
                    }
                    listenerAdded = true;
                }
                if (!userMatch) continue;
                break;
            }
        }
        if (debug.messageEnabled()) {
            if (!userMatch) {
                debug.message("LDAPUsers.isMember(): User " + userLocalDN + " is not a member of this LDAPUsers object");
            } else {
                debug.message("LDAPUsers.isMember(): User " + userLocalDN + " is a member of this LDAPUsers object");
            }
        }
        return userMatch;
    }

    public int hashCode() {
        return ((Object)this.selectedUserDNs).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LDAPUsers) {
            LDAPUsers g = (LDAPUsers)o;
            if (this.selectedUserDNs != null && g.selectedUserDNs != null && ((Object)this.selectedUserDNs).equals(g.selectedUserDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPUsers theClone = null;
        try {
            theClone = (LDAPUsers)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.selectedRFCUserDNs != null) {
            theClone.selectedRFCUserDNs = new HashSet();
            theClone.selectedRFCUserDNs.addAll(this.selectedRFCUserDNs);
        }
        return theClone;
    }

    /*
     * Exception decompiling
     */
    private DN getUserDN(SSOToken token) throws SSOException, PolicyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

