/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.portletbridge.bridge.factory;

import javax.faces.FacesWrapper;

/**
 * This abstract class is inspired by the factory pattern found in the JSF API like
 * {@link javax.faces.context.FacesContextFactory} and {@link javax.faces.context.ExternalContextFactory}. By
 * implementing the {@link javax.faces.FacesWrapper} interface, the class provides implementations with the opportunity
 * to wrap another factory (participate in a chain-of-responsibility pattern). If an implementation wraps a factory,
 * then it should provide a one-arg constructor so that the wrappable factory can be passed at initialization time.
 */
public abstract class BridgeFactory<T> implements FacesWrapper<BridgeFactory<T>> {
    public BridgeFactory() {
    }

    public BridgeFactory<T> getWrapped() {
        return null;
    }

}
