/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ListsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testArraysAsList() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testArraysAsList();
}

public void testAsList1Small() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testAsList1Small();
}

public void testAsList2() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testAsList2();
}

public void testCartesianProductTooBig() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProductTooBig();
}

public void testCartesianProduct_2x2x2() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_2x2x2();
}

public void testCartesianProduct_binary1x1() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_binary1x1();
}

public void testCartesianProduct_binary1x2() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_binary1x2();
}

public void testCartesianProduct_binary2x2() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_binary2x2();
}

public void testCartesianProduct_contains() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_contains();
}

public void testCartesianProduct_indexOf() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_indexOf();
}

public void testCartesianProduct_unrelatedTypes() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCartesianProduct_unrelatedTypes();
}

public void testCharactersOfIsView() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testCharactersOfIsView();
}

public void testComputeArrayListCapacity() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testComputeArrayListCapacity();
}

public void testNewArrayListEmpty() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListEmpty();
}

public void testNewArrayListFromCollection() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListFromCollection();
}

public void testNewArrayListFromIterable() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListFromIterable();
}

public void testNewArrayListFromIterator() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListFromIterator();
}

public void testNewArrayListVarArgs() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListVarArgs();
}

public void testNewArrayListWithCapacity() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListWithCapacity();
}

public void testNewArrayListWithCapacity_negative() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListWithCapacity_negative();
}

public void testNewArrayListWithExpectedSize() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListWithExpectedSize();
}

public void testNewArrayListWithExpectedSize_negative() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewArrayListWithExpectedSize_negative();
}

public void testNewLinkedListEmpty() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewLinkedListEmpty();
}

public void testNewLinkedListFromCollection() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewLinkedListFromCollection();
}

public void testNewLinkedListFromIterable() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testNewLinkedListFromIterable();
}

public void testPartitionRandomAccessFalse() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartitionRandomAccessFalse();
}

public void testPartitionSize_1() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartitionSize_1();
}

public void testPartition_1_1() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_1_1();
}

public void testPartition_1_2() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_1_2();
}

public void testPartition_2_1() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_2_1();
}

public void testPartition_3_2() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_3_2();
}

public void testPartition_badSize() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_badSize();
}

public void testPartition_empty() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_empty();
}

public void testPartition_view() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testPartition_view();
}

public void testReverseViewRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testReverseViewRandomAccess();
}

public void testReverseViewSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testReverseViewSequential();
}

public void testTransformHashCodeRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformHashCodeRandomAccess();
}

public void testTransformHashCodeSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformHashCodeSequential();
}

public void testTransformIteratorRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformIteratorRandomAccess();
}

public void testTransformIteratorSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformIteratorSequential();
}

public void testTransformListIteratorRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformListIteratorRandomAccess();
}

public void testTransformListIteratorSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformListIteratorSequential();
}

public void testTransformModifiableRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformModifiableRandomAccess();
}

public void testTransformModifiableSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformModifiableSequential();
}

public void testTransformPreservesIOOBEsThrownByFunction() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformPreservesIOOBEsThrownByFunction();
}

public void testTransformRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformRandomAccess();
}

public void testTransformSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformSequential();
}

public void testTransformViewRandomAccess() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformViewRandomAccess();
}

public void testTransformViewSequential() throws Exception {
  com.google.common.collect.ListsTest testCase = new com.google.common.collect.ListsTest();
  testCase.testTransformViewSequential();
}
}
