---
name: "Maven :: JavaEE 8 WebProfile"
description: |
  Demo project for Jakarta EE 8 WebProfile, IBM WebSphere Liberty is used as a Jakarta EE implementation.
  On Windows or Mac if VirtualBox is used, run the tests using:
  $ mvn clean verify -DtestProxyHost=192.168.99.100
---
## A WebSphere Liberty Java EE 8 based application prepared for development using Eclipse JKube Kubernetes Maven Plugin

**WebSphere Liberty** is a fast, dynamic, and easy-to-use Java application server, built on the open source 
[Open Liberty][openliberty] project. Ideal for developers but also ready for production, on-premise or in the cloud.

### The application structure

The demo application is divided into two modules:

#### javaee8-webprofile-liberty-app
A web-application, which leverages Java EE 8 WebProfile and exposes a JAR-RS based RESTful web-service. The application 
also contains a Java servlet that puts into the output stream the information about on which JVM it  works.
This information will be important when we try to publish the application on different JVMs within the cloud platform.

#### javaee8-webprofile-liberty-app-it
A set of integration tests for the application. The [*kubernetes maven plugin*][k-m-p] is leveraged to deploy the application on
a WebSphere Liberty based docker container running inside a Kubernetes cluster and run  the integration tests dependent
on the containerized application. 


### Deploy the application on a Kubernetes cluster

The demo application uses the [*kubernetes maven plugin*][k-m-p] as an access point to Kubernetes: the application can be
deployed on a WebSphere Liberty based docker container running inside a Kubernetes cluster and the integration tests run
dependent on the containerized application.

To run the integration tests do the following commands:

1. If you use [*minikube*][minikube], the cluster must be started. To start the cluster use the following command:

```
$ minikube start
```

2. All environment variables must be set before using this plugin, see the instruction generated by:

```
$  eval $(minikube docker-env)

```  

3. Build a docker image for `javaee8-webprofile-liberty-app`, deploy the image to Kubernetes and run the integration
tests:

```
$ cd quickstarts/maven/ibm-javaee8-webprofile-liberty

$ mvn -P'integration-tests' clean verify -DtestProxyHost=$(minikube ip)
```

(The `kubectl` program must be declared in the environment variable `$PATH`.)

```shell script
[INFO] Scanning for projects...
[INFO] ------------------------------------------------------------------------
[INFO] Reactor Build Order:
[INFO] 
[INFO] Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile       [pom]
[INFO] Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile :: Application [war]
[INFO] Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile :: IT [jar]
[INFO] 
[INFO] ---< org.eclipse.jkube.quickstarts.maven:javaee8-webprofile-liberty >---
[INFO] Building Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile 1.0.0-SNAPSHOT [1/3]
[INFO] --------------------------------[ pom ]---------------------------------
[INFO] 
[INFO] --- maven-clean-plugin:2.5:clean (default-clean) @ javaee8-webprofile-liberty ---
[INFO] 
[INFO] --< org.eclipse.jkube.quickstarts.maven:javaee8-webprofile-liberty-app >--
[INFO] Building Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile :: Application 1.0.0-SNAPSHOT [2/3]
[INFO] --------------------------------[ war ]---------------------------------
[INFO] 
[INFO] --- maven-clean-plugin:2.5:clean (default-clean) @ javaee8-webprofile-liberty-app ---
[INFO] Deleting /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/target
[INFO] 
[INFO] --- maven-resources-plugin:2.6:resources (default-resources) @ javaee8-webprofile-liberty-app ---
[INFO] Using 'UTF-8' encoding to copy filtered resources.
[INFO] Copying 2 resources to /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/target/wlp
[INFO] 
[INFO] --- maven-compiler-plugin:3.1:compile (default-compile) @ javaee8-webprofile-liberty-app ---
[INFO] Changes detected - recompiling the module!
[INFO] Compiling 3 source files to /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/target/classes
[INFO] 
[INFO] --- maven-resources-plugin:2.6:testResources (default-testResources) @ javaee8-webprofile-liberty-app ---
[INFO] Using 'UTF-8' encoding to copy filtered resources.
[INFO] skip non existing resourceDirectory /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/src/test/resources
[INFO] 
[INFO] --- maven-compiler-plugin:3.1:testCompile (default-testCompile) @ javaee8-webprofile-liberty-app ---
[INFO] No sources to compile
[INFO] 
[INFO] --- maven-surefire-plugin:2.20:test (default-test) @ javaee8-webprofile-liberty-app ---
[INFO] No tests to run.
[INFO] 
[INFO] --- maven-war-plugin:3.2.0:war (default-war) @ javaee8-webprofile-liberty-app ---
[INFO] Packaging webapp
[INFO] Assembling webapp [javaee8-webprofile-liberty-app] in [/home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/target/javaee8-webprofile-liberty-app-1.0.0-SNAPSHOT]
[INFO] Processing war project
[INFO] Copying webapp resources [/home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/src/main/webapp]
[INFO] Webapp assembled in [88 msecs]
[INFO] Building war: /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app/target/javaee8-webprofile-liberty-app.war
[INFO] 
[INFO] --- kubernetes-maven-plugin:1.0.0-SNAPSHOT:build (build-images) @ javaee8-webprofile-liberty-app ---
[INFO] k8s: Building Docker image in Kubernetes mode
[INFO] k8s: [jkube/javaee8-webprofile-liberty-app:1.0.0-SNAPSHOT] "meeting-reservation-service": Created docker-build.tar in 57 milliseconds
[INFO] k8s: [jkube/javaee8-webprofile-liberty-app:1.0.0-SNAPSHOT] "meeting-reservation-service": Built image sha256:b53cf
[INFO] k8s: [jkube/javaee8-webprofile-liberty-app:1.0.0-SNAPSHOT] "meeting-reservation-service": Removed old image sha256:871fe
[INFO] k8s: [jkube/javaee8-webprofile-liberty-app:1.0.0-SNAPSHOT] "meeting-reservation-service": Tag with latest,1.0.0-SNAPSHOT
[INFO] 
[INFO] --< org.eclipse.jkube.quickstarts.maven:javaee8-webprofile-liberty-app-it >--
[INFO] Building Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile :: IT 1.0.0-SNAPSHOT [3/3]
[INFO] --------------------------------[ jar ]---------------------------------
[INFO] 
[INFO] --- maven-clean-plugin:2.5:clean (default-clean) @ javaee8-webprofile-liberty-app-it ---
[INFO] Deleting /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/target
[INFO] 
[INFO] --- maven-resources-plugin:2.6:resources (default-resources) @ javaee8-webprofile-liberty-app-it ---
[INFO] Using 'UTF-8' encoding to copy filtered resources.
[INFO] skip non existing resourceDirectory /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/src/main/resources
[INFO] 
[INFO] --- kubernetes-maven-plugin:1.0.0-SNAPSHOT:resource (build-images) @ javaee8-webprofile-liberty-app-it ---
[INFO] k8s: jkube-controller: Adding a default Deployment
[INFO] k8s: jkube-service: Adding a default service 'javaee8-webprofile-liberty-app' with ports [9080]
[INFO] k8s: jkube-namespace: Adding a default Namespace:jkube
[INFO] k8s: jkube-revision-history: Adding revision history limit to 2
[INFO] 
[INFO] --- maven-compiler-plugin:3.1:compile (default-compile) @ javaee8-webprofile-liberty-app-it ---
[INFO] No sources to compile
[INFO] 
[INFO] --- maven-resources-plugin:2.6:testResources (default-testResources) @ javaee8-webprofile-liberty-app-it ---
[INFO] Using 'UTF-8' encoding to copy filtered resources.
[INFO] skip non existing resourceDirectory /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/src/test/resources
[INFO] 
[INFO] --- maven-compiler-plugin:3.1:testCompile (default-testCompile) @ javaee8-webprofile-liberty-app-it ---
[INFO] Changes detected - recompiling the module!
[INFO] Compiling 1 source file to /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/target/test-classes
[INFO] 
[INFO] --- maven-surefire-plugin:2.20:test (default-test) @ javaee8-webprofile-liberty-app-it ---
[INFO] Tests are skipped.
[INFO] 
[INFO] --- maven-jar-plugin:2.4:jar (default-jar) @ javaee8-webprofile-liberty-app-it ---
[INFO] Building jar: /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/target/javaee8-webprofile-liberty-app-it-1.0.0-SNAPSHOT.jar
[INFO] 
[INFO] --- kubernetes-maven-plugin:1.0.0-SNAPSHOT:build (build-images) @ javaee8-webprofile-liberty-app-it ---
[INFO] k8s: Building Docker image in Kubernetes mode
[INFO] 
[INFO] --- kubernetes-maven-plugin:1.0.0-SNAPSHOT:apply (integration-test) @ javaee8-webprofile-liberty-app-it ---
[INFO] k8s: Using Kubernetes at https://172.17.0.3:8443/ in namespace default with manifest /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/target/classes/META-INF/jkube/kubernetes.yml 
[INFO] k8s: Using namespace: jkube
[INFO] k8s: Creating a Service from kubernetes.yml namespace jkube name javaee8-webprofile-liberty-app
[INFO] k8s: Created Service: javaee8-webprofile-liberty-app-it/target/jkube/applyJson/jkube/service-javaee8-webprofile-liberty-app.json
[INFO] k8s: Creating a Deployment from kubernetes.yml namespace jkube name javaee8-webprofile-liberty-app-it
[INFO] k8s: Created Deployment: javaee8-webprofile-liberty-app-it/target/jkube/applyJson/jkube/deployment-javaee8-webprofile-liberty-app-it.json
[INFO] k8s: HINT: Use the command `kubectl get pods -w` to watch your pods start up
[INFO] 
[INFO] --- groovy-maven-plugin:2.0:execute (integration-test-get-proxy-port) @ javaee8-webprofile-liberty-app-it ---
testProxyHttpPort = 30954
Server was started
[INFO] 
[INFO] --- maven-failsafe-plugin:2.20:integration-test (integration-test) @ javaee8-webprofile-liberty-app-it ---
[INFO] 
[INFO] -------------------------------------------------------
[INFO]  T E S T S
[INFO] -------------------------------------------------------
[INFO] Running org.eclipse.jkube.maven.sample.javaee.webprofile.integration.test.MeetingBookingServiceIT
[INFO] Tests run: 1, Failures: 0, Errors: 0, Skipped: 0, Time elapsed: 1.127 s - in org.eclipse.jkube.maven.sample.javaee.webprofile.integration.test.MeetingBookingServiceIT
[INFO] 
[INFO] Results:
[INFO] 
[INFO] Tests run: 1, Failures: 0, Errors: 0, Skipped: 0
[INFO] 
[INFO] 
[INFO] --- kubernetes-maven-plugin:1.0.0-SNAPSHOT:undeploy (post-integration-test) @ javaee8-webprofile-liberty-app-it ---
[INFO] k8s: Using Kubernetes at https://172.17.0.3:8443/ in namespace default with manifest /home/user/00-MN/projects/forks/jkube/quickstarts/maven/ibm-javaee8-webprofile-liberty/javaee8-webprofile-liberty-app-it/target/classes/META-INF/jkube/kubernetes.yml 
[INFO] k8s: Using namespace: jkube
[INFO] k8s: Deleting resource Deployment jkube/javaee8-webprofile-liberty-app-it
[INFO] k8s: Deleting resource Service jkube/javaee8-webprofile-liberty-app
[INFO] k8s: HINT: Use the command `kubectl get pods -w` to watch your pods start up
[INFO] 
[INFO] --- maven-failsafe-plugin:2.20:verify (verify-results) @ javaee8-webprofile-liberty-app-it ---
[INFO] ------------------------------------------------------------------------
[INFO] Reactor Summary for Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile 1.0.0-SNAPSHOT:
[INFO] 
[INFO] Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile SUCCESS [  0.222 s]
[INFO] Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile :: Application SUCCESS [  5.297 s]
[INFO] Eclipse JKube :: Quickstarts :: Maven :: JavaEE 8 WebProfile :: IT SUCCESS [ 59.916 s]
[INFO] ------------------------------------------------------------------------
[INFO] BUILD SUCCESS
[INFO] ------------------------------------------------------------------------
[INFO] Total time:  01:05 min
[INFO] Finished at: 2020-07-06T17:08:49+02:00
[INFO] ------------------------------------------------------------------------
```

[openliberty]: http://openliberty.io/
[k-m-p]: https://www.eclipse.org/jkube
[minikube]: https://github.com/kubernetes/minikube
