/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.knative.springboot;

import java.util.Map;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.spi.KnativeConsumerFactory;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeProducerFactory;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Send and receive events from Knative.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.knative")
public class KnativeComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the knative component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * CloudEvent headers to override
     */
    private Map<String, String> ceOverride;
    /**
     * Set the version of the cloudevents spec.
     */
    private String cloudEventsSpecVersion = "1.0";
    /**
     * Set the event-type information of the produced events.
     */
    private String cloudEventsType = "org.apache.camel.event";
    /**
     * Set the configuration. The option is a
     * org.apache.camel.component.knative.KnativeConfiguration type.
     */
    private KnativeConfiguration configuration;
    /**
     * The protocol consumer factory. The option is a
     * org.apache.camel.component.knative.spi.KnativeConsumerFactory type.
     */
    private KnativeConsumerFactory consumerFactory;
    /**
     * The environment. The option is a
     * org.apache.camel.component.knative.spi.KnativeEnvironment type.
     */
    private KnativeEnvironment environment;
    /**
     * The path ot the environment definition
     */
    private String environmentPath;
    /**
     * Set the filters.
     */
    private Map<String, String> filters;
    /**
     * The protocol producer factory. The option is a
     * org.apache.camel.component.knative.spi.KnativeProducerFactory type.
     */
    private KnativeProducerFactory producerFactory;
    /**
     * Set the transport options.
     */
    private Map<String, Object> transportOptions;
    /**
     * The name of the service to lookup from the KnativeEnvironment.
     */
    private String typeId;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Transforms the reply into a cloud event that will be processed by the
     * caller. When listening to events from a Knative Broker, if this flag is
     * enabled, replies will be published to the same Broker where the request
     * comes from (beware that if you don't change the type of the received
     * message, you may create a loop and receive your same reply). When this
     * flag is disabled, CloudEvent headers are removed from the reply.
     */
    private Boolean replyWithCloudEvent = false;
    /**
     * If the consumer should construct a full reply to knative request.
     */
    private Boolean reply = true;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * The version of the k8s resource referenced by the endpoint.
     */
    private String apiVersion;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * The type of the k8s resource referenced by the endpoint.
     */
    private String kind;
    /**
     * The name of the k8s resource referenced by the endpoint.
     */
    private String name;

    public Map<String, String> getCeOverride() {
        return ceOverride;
    }

    public void setCeOverride(Map<String, String> ceOverride) {
        this.ceOverride = ceOverride;
    }

    public String getCloudEventsSpecVersion() {
        return cloudEventsSpecVersion;
    }

    public void setCloudEventsSpecVersion(String cloudEventsSpecVersion) {
        this.cloudEventsSpecVersion = cloudEventsSpecVersion;
    }

    public String getCloudEventsType() {
        return cloudEventsType;
    }

    public void setCloudEventsType(String cloudEventsType) {
        this.cloudEventsType = cloudEventsType;
    }

    public KnativeConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(KnativeConfiguration configuration) {
        this.configuration = configuration;
    }

    public KnativeConsumerFactory getConsumerFactory() {
        return consumerFactory;
    }

    public void setConsumerFactory(KnativeConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public KnativeEnvironment getEnvironment() {
        return environment;
    }

    public void setEnvironment(KnativeEnvironment environment) {
        this.environment = environment;
    }

    public String getEnvironmentPath() {
        return environmentPath;
    }

    public void setEnvironmentPath(String environmentPath) {
        this.environmentPath = environmentPath;
    }

    public Map<String, String> getFilters() {
        return filters;
    }

    public void setFilters(Map<String, String> filters) {
        this.filters = filters;
    }

    public KnativeProducerFactory getProducerFactory() {
        return producerFactory;
    }

    public void setProducerFactory(KnativeProducerFactory producerFactory) {
        this.producerFactory = producerFactory;
    }

    public Map<String, Object> getTransportOptions() {
        return transportOptions;
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.transportOptions = transportOptions;
    }

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getReplyWithCloudEvent() {
        return replyWithCloudEvent;
    }

    public void setReplyWithCloudEvent(Boolean replyWithCloudEvent) {
        this.replyWithCloudEvent = replyWithCloudEvent;
    }

    public Boolean getReply() {
        return reply;
    }

    public void setReply(Boolean reply) {
        this.reply = reply;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}